/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.AbstractBinaryOutput;
import com.caucho.quercus.lib.file.BinaryStream;
import com.caucho.quercus.lib.file.ProtocolWrapper;
import com.caucho.util.L10N;
import java.io.IOException;

public class PhpProtocolWrapper
extends ProtocolWrapper {
    private static final L10N L = new L10N(PhpProtocolWrapper.class);

    public BinaryStream fopen(Env env, StringValue path, StringValue mode, LongValue options) {
        if (path.toString().equals("php://output")) {
            return new PhpBinaryOutput(env);
        }
        env.warning(L.l("{0} is an unsupported or unknown path for this protocol", (Object)path.toString()));
        return null;
    }

    public Value opendir(Env env, StringValue path, LongValue flags) {
        env.warning(L.l("opendir not supported by protocol"));
        return BooleanValue.FALSE;
    }

    public boolean unlink(Env env, StringValue path) {
        env.warning(L.l("unlink not supported by protocol"));
        return false;
    }

    public boolean rename(Env env, StringValue path_from, StringValue path_to) {
        env.warning(L.l("rename not supported by protocol"));
        return false;
    }

    public boolean mkdir(Env env, StringValue path, LongValue mode, LongValue options) {
        env.warning(L.l("mkdir not supported by protocol"));
        return false;
    }

    public boolean rmdir(Env env, StringValue path, LongValue options) {
        env.warning(L.l("rmdir not supported by protocol"));
        return false;
    }

    public Value url_stat(Env env, StringValue path, LongValue flags) {
        env.warning(L.l("stat not supported by protocol"));
        return BooleanValue.FALSE;
    }

    private class PhpBinaryOutput
    extends AbstractBinaryOutput {
        private Env _env;

        public PhpBinaryOutput(Env env) {
            this._env = env;
        }

        public void write(byte[] buffer, int offset, int length) throws IOException {
            this._env.getOut().write(buffer, offset, length);
        }

        public void write(int b) throws IOException {
            this._env.getOut().write(b);
        }
    }
}

