/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.file.AbstractBinaryInputOutput;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.SocketStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketInputOutput
extends AbstractBinaryInputOutput {
    private static final Logger log = Logger.getLogger(SocketInputOutput.class.getName());
    private int _lastError;
    private Domain _domain;
    private Socket _socket;

    public SocketInputOutput(Env env, Socket socket, Domain domain) {
        super(env);
        env.addClose(this);
        this._socket = socket;
        this._domain = domain;
    }

    public void bind(SocketAddress address) throws IOException {
        this._socket.bind(address);
    }

    public void connect(SocketAddress address) throws IOException {
        this._socket.connect(address);
        this.init();
    }

    public void setError(int error) {
        this._lastError = error;
    }

    public void init() {
        SocketStream sock = new SocketStream(this._socket);
        WriteStream os = new WriteStream((StreamImpl)sock);
        ReadStream is = new ReadStream((StreamImpl)sock, os);
        this.init(is, os);
    }

    public void setTimeout(long timeout) {
        try {
            if (this._socket != null) {
                this._socket.setSoTimeout((int)timeout);
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    public void close() {
        super.close();
        Socket s = this._socket;
        this._socket = null;
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        if (this._socket != null) {
            return "SocketInputOutput[" + this._socket.getInetAddress() + "," + this._socket.getPort() + "]";
        }
        return "SocketInputOutput[closed]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Domain {
        AF_INET,
        AF_INET6,
        AF_UNIX;

    }
}

