/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.AbstractBinaryInputOutput;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.BinaryOutput;
import com.caucho.quercus.lib.file.BinaryStream;
import com.caucho.quercus.lib.file.ProtocolWrapper;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.resources.StreamContextResource;
import com.caucho.util.L10N;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(StreamModule.class);
    private static final Logger log = Logger.getLogger(StreamModule.class.getName());
    public static final int STREAM_FILTER_READ = 1;
    public static final int STREAM_FILTER_WRITE = 2;
    public static final int STREAM_FILTER_ALL = 3;
    public static final int PSFS_PASS_ON = 2;
    public static final int PSFS_FEED_ME = 1;
    public static final int PSFS_ERR_FATAL = 0;
    public static final int STREAM_USE_PATH = 1;
    public static final int STREAM_REPORT_ERRORS = 8;
    public static final int STREAM_CLIENT_ASYNC_CONNECT = 2;
    public static final int STREAM_CLIENT_CONNECT = 4;
    public static final int STREAM_CLIENT_PERSISTENT = 1;
    public static final int STREAM_SERVER_BIND = 4;
    public static final int STREAM_SERVER_LISTEN = 8;
    public static final int STREAM_URL_STAT_LINK = 1;
    public static final int STREAM_URL_STAT_QUIET = 2;
    private static final HashMap<String, Value> _constMap = new HashMap();
    private static final HashMap<String, ProtocolWrapper> _wrapperMap = new HashMap();
    private static final HashMap<String, ProtocolWrapper> _unregisteredWrapperMap = new HashMap();
    private static final ArrayValue _wrapperArray = new ArrayValueImpl();

    @Override
    public Map<String, Value> getConstMap() {
        return _constMap;
    }

    public static Value stream_context_create(Env env, @Optional ArrayValue options) {
        return new StreamContextResource(options);
    }

    public static Value stream_context_get_options(Env env, Value resource) {
        if (resource instanceof StreamContextResource) {
            return ((StreamContextResource)resource).getOptions();
        }
        env.warning(L.l("expected resource at '{0}'", (Object)resource));
        return BooleanValue.FALSE;
    }

    public static Value stream_context_get_default(Env env, @Optional ArrayValue options) {
        StreamContextResource context = env.getDefaultStreamContext();
        if (options != null) {
            context.setOptions(options);
        }
        return context;
    }

    public static boolean stream_context_set_option(Env env, Value resource, String wrapper, String option, Value value) {
        if (resource instanceof StreamContextResource) {
            StreamContextResource context = (StreamContextResource)resource;
            context.setOption(wrapper, option, value);
            return true;
        }
        env.warning(L.l("expected resource at '{0}'", (Object)resource));
        return false;
    }

    public static boolean stream_context_set_params(Env env, Value resource, ArrayValue value) {
        if (resource instanceof StreamContextResource) {
            StreamContextResource context = (StreamContextResource)resource;
            context.setParameters(value);
            return true;
        }
        env.warning(L.l("expected resource at '{0}'", (Object)resource));
        return false;
    }

    public static long stream_copy_to_stream(Env env, @NotNull BinaryInput in, @NotNull BinaryOutput out, @Optional(value="-1") int length, @Optional int offset) {
        try {
            if (in == null) {
                return -1L;
            }
            if (out == null) {
                return -1L;
            }
            TempBuffer temp = TempBuffer.allocate();
            byte[] buffer = temp.getBuffer();
            while (offset-- > 0) {
                in.read();
            }
            if (length < 0) {
                length = Integer.MAX_VALUE;
            }
            long bytesWritten = 0L;
            while (length > 0) {
                int sublen = buffer.length;
                if (length < sublen) {
                    sublen = length;
                }
                if ((sublen = in.read(buffer, 0, sublen)) < 0) {
                    return bytesWritten;
                }
                out.write(buffer, 0, sublen);
                bytesWritten += (long)sublen;
                length -= sublen;
            }
            TempBuffer.free((TempBuffer)temp);
            return bytesWritten;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static Value stream_get_contents(Env env, @NotNull BinaryInput in, @Optional(value="-1") long maxLen, @Optional long offset) {
        try {
            int ch;
            if (in == null) {
                return BooleanValue.FALSE;
            }
            StringBuilder sb = new StringBuilder();
            if (maxLen < 0L) {
                maxLen = Integer.MAX_VALUE;
            }
            while (offset-- > 0L) {
                in.read();
            }
            while (maxLen-- > 0L && (ch = in.read()) >= 0) {
                sb.append((char)ch);
            }
            return env.createString(sb.toString());
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static Value stream_get_line(Env env, @NotNull BinaryInput file, @Optional(value="-1") long length) {
        try {
            StringValue line;
            if (file == null) {
                return BooleanValue.FALSE;
            }
            if (length < 0L) {
                length = Integer.MAX_VALUE;
            }
            if ((line = file.readLine(length)) == null) {
                return BooleanValue.FALSE;
            }
            int lineLength = line.length();
            if (lineLength == 0) {
                return line;
            }
            char tail = line.charAt(lineLength - 1);
            if (tail == '\n') {
                return line.substring(0, line.length() - 1);
            }
            if (tail == '\r') {
                return line.substring(0, line.length() - 1);
            }
            return line;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static Value stream_get_meta_data(Env env, BinaryStream stream) {
        if (stream == null) {
            return BooleanValue.FALSE;
        }
        env.stub("stream_get_meta_data");
        ArrayValueImpl array = new ArrayValueImpl();
        ((ArrayValue)array).put(env.createString("timed_out"), BooleanValue.FALSE);
        return array;
    }

    public static Value stream_get_transports(Env env) {
        ArrayValueImpl value = new ArrayValueImpl();
        value.append(env.createString("tcp"));
        value.append(env.createString("udp"));
        return value;
    }

    public static Value stream_get_wrappers(Env env) {
        return _wrapperArray;
    }

    public static boolean stream_register_wrapper(Env env, StringValue protocol, String className) {
        return StreamModule.stream_wrapper_register(env, protocol, className);
    }

    public static boolean stream_set_blocking(Env env, @NotNull Value stream, int mode) {
        if (stream == null) {
            return false;
        }
        env.stub("stream_set_blocking");
        return false;
    }

    public static boolean stream_set_timeout(Env env, @NotNull Value stream, int seconds, @Optional(value="-1") int milliseconds) {
        if (stream == null) {
            return false;
        }
        Object obj = stream.toJavaObject();
        if (obj instanceof AbstractBinaryInputOutput) {
            ((AbstractBinaryInputOutput)obj).setTimeout(1000L * (long)seconds);
        }
        return true;
    }

    public static boolean stream_set_blocking(@NotNull Value stream, int mode) {
        return stream != null;
    }

    public static int stream_set_write_buffer(Env env, BinaryOutput stream, int bufferSize) {
        return 0;
    }

    static void stream_wrapper_register(StringValue protocol, ProtocolWrapper wrapper) {
        _wrapperMap.put(protocol.toString(), wrapper);
        _wrapperArray.append(protocol);
    }

    public static boolean stream_wrapper_register(Env env, StringValue protocol, String className) {
        if (_wrapperMap.containsKey(protocol.toString())) {
            return false;
        }
        QuercusClass qClass = env.getClass(className);
        StreamModule.stream_wrapper_register(protocol, new ProtocolWrapper(qClass));
        return true;
    }

    public static boolean stream_wrapper_restore(Env env, StringValue protocol) {
        if (!_unregisteredWrapperMap.containsKey(protocol.toString())) {
            return false;
        }
        ProtocolWrapper oldWrapper = _unregisteredWrapperMap.remove(protocol.toString());
        StreamModule.stream_wrapper_register(protocol, oldWrapper);
        return true;
    }

    public static boolean stream_wrapper_unregister(Env env, StringValue protocol) {
        if (!_wrapperMap.containsKey(protocol.toString())) {
            return false;
        }
        _unregisteredWrapperMap.put(protocol.toString(), _wrapperMap.remove(protocol.toString()));
        _wrapperArray.remove(protocol);
        return true;
    }

    public static ProtocolWrapper getWrapper(String protocol) {
        return _wrapperMap.get(protocol);
    }

    static {
        _wrapperArray.append(new StringBuilderValue("quercus"));
        _wrapperArray.append(new StringBuilderValue("file"));
        _wrapperArray.append(new StringBuilderValue("http"));
        _wrapperArray.append(new StringBuilderValue("ftp"));
        _constMap.put("STREAM_URL_STAT_LINK", new LongValue(1L));
        _constMap.put("STREAM_URL_STAT_QUIET", new LongValue(2L));
        _constMap.put("STREAM_FILTER_READ", new LongValue(1L));
        _constMap.put("STREAM_FILTER_WRITE", new LongValue(2L));
        _constMap.put("STREAM_FILTER_ALL", new LongValue(3L));
        _constMap.put("PSFS_PASS_ON", new LongValue(2L));
        _constMap.put("PSFS_FEED_ME", new LongValue(1L));
        _constMap.put("PSFS_ERR_FATAL", new LongValue(0L));
        _constMap.put("STREAM_USE_PATH", new LongValue(1L));
        _constMap.put("STREAM_REPORT_ERRORS", new LongValue(8L));
        _constMap.put("STREAM_CLIENT_ASYNC_CONNECT", new LongValue(2L));
        _constMap.put("STREAM_CLIENT_CONNECT", new LongValue(4L));
        _constMap.put("STREAM_CLIENT_PERSISTENT", new LongValue(1L));
        _constMap.put("STREAM_SERVER_BIND", new LongValue(4L));
        _constMap.put("STREAM_SERVER_LISTEN", new LongValue(8L));
    }
}

