/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.DirectoryValue;

public class WrappedDirectoryValue
extends DirectoryValue {
    private static final UnicodeBuilderValue DIR_CLOSEDIR = new UnicodeBuilderValue("dir_closedir");
    private static final UnicodeBuilderValue DIR_OPENDIR = new UnicodeBuilderValue("dir_opendir");
    private static final UnicodeBuilderValue DIR_READDIR = new UnicodeBuilderValue("dir_readdir");
    private static final UnicodeBuilderValue DIR_REWINDDIR = new UnicodeBuilderValue("dir_rewinddir");
    private Env _env;
    private Value _wrapper;

    public WrappedDirectoryValue(Env env, QuercusClass qClass) {
        super(env);
        this._env = env;
        this._wrapper = qClass.callNew(this._env, new Value[0]);
    }

    public boolean opendir(StringValue path, LongValue flags) {
        return this._wrapper.callMethod(this._env, DIR_OPENDIR, path, flags).toBoolean();
    }

    public Value readdir() {
        return this._wrapper.callMethod(this._env, DIR_READDIR);
    }

    public void rewinddir() {
        this._wrapper.callMethod(this._env, DIR_REWINDDIR);
    }

    public void close() {
        this._wrapper.callMethod(this._env, DIR_CLOSEDIR);
    }

    public String toString() {
        return "Directory[]";
    }
}

