/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.BinaryOutput;
import com.caucho.quercus.lib.file.LineReader;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class WrappedStream
implements BinaryInput,
BinaryOutput {
    private static final UnicodeBuilderValue STREAM_CLOSE = new UnicodeBuilderValue("stream_close");
    private static final UnicodeBuilderValue STREAM_EOF = new UnicodeBuilderValue("stream_eof");
    private static final UnicodeBuilderValue STREAM_FLUSH = new UnicodeBuilderValue("stream_flush");
    private static final UnicodeBuilderValue STREAM_OPEN = new UnicodeBuilderValue("stream_open");
    private static final UnicodeBuilderValue STREAM_READ = new UnicodeBuilderValue("stream_read");
    private static final UnicodeBuilderValue STREAM_SEEK = new UnicodeBuilderValue("stream_seek");
    private static final UnicodeBuilderValue STREAM_TELL = new UnicodeBuilderValue("stream_tell");
    private static final UnicodeBuilderValue STREAM_WRITE = new UnicodeBuilderValue("stream_write");
    private byte[] printBuffer = new byte[1];
    private Env _env;
    private Value _wrapper;
    private LineReader _lineReader;
    private InputStream _is;
    private OutputStream _os;
    private int _buffer;
    private boolean _doUnread = false;
    private int _writeLength;

    private WrappedStream(Env env, Value wrapper) {
        this._env = env;
        this._wrapper = wrapper;
        this._lineReader = new LineReader(env);
    }

    public WrappedStream(Env env, QuercusClass qClass, StringValue path, StringValue mode, LongValue options) {
        this._env = env;
        this._lineReader = new LineReader(env);
        this._wrapper = qClass.callNew(this._env, new Value[0]);
        this._wrapper.callMethod(this._env, STREAM_OPEN, path, mode, (Value)options, (Value)NullValue.NULL);
    }

    public InputStream getInputStream() {
        if (this._is == null) {
            this._is = new WrappedInputStream();
        }
        return this._is;
    }

    public OutputStream getOutputStream() {
        if (this._os == null) {
            this._os = new WrappedOutputStream();
        }
        return this._os;
    }

    public BinaryInput openCopy() throws IOException {
        return new WrappedStream(this._env, this._wrapper);
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
    }

    public void closeRead() {
        this.close();
    }

    public void closeWrite() {
        this.close();
    }

    public void close() {
        this._wrapper.callMethod(this._env, STREAM_CLOSE);
    }

    public int read() throws IOException {
        if (this._doUnread) {
            this._doUnread = false;
            return this._buffer;
        }
        Value output = this._wrapper.callMethod(this._env, (StringValue)STREAM_READ, LongValue.ONE);
        this._buffer = (int)output.toLong();
        return this._buffer;
    }

    public void unread() throws IOException {
        this._doUnread = true;
    }

    public int read(byte[] buffer, int offset, int length) {
        Value output = this._wrapper.callMethod(this._env, (StringValue)STREAM_READ, LongValue.create(length));
        if (!output.toBoolean()) {
            return -1;
        }
        byte[] outputBytes = output.toString().getBytes();
        if (outputBytes.length < length) {
            length = outputBytes.length;
        }
        System.arraycopy(outputBytes, 0, buffer, offset, length);
        return length;
    }

    public int read(char[] buffer, int offset, int length) {
        Value output = this._wrapper.callMethod(this._env, (StringValue)STREAM_READ, LongValue.create(length));
        if (!output.toBoolean()) {
            return -1;
        }
        byte[] outputBytes = output.toString().getBytes();
        if (outputBytes.length < length) {
            length = outputBytes.length;
        }
        System.arraycopy(outputBytes, 0, buffer, offset, length);
        return length;
    }

    public StringValue appendTo(StringValue builder) {
        try {
            int ch;
            while ((ch = this.read()) >= 0) {
                builder.append((char)ch);
            }
            return builder;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public StringValue read(int length) throws IOException {
        Value output = this._wrapper.callMethod(this._env, (StringValue)STREAM_READ, LongValue.create(length));
        return output.toBinaryValue(this._env);
    }

    public boolean readOptionalLinefeed() throws IOException {
        int ch = this.read();
        if (ch == 10) {
            return true;
        }
        this.unread();
        return false;
    }

    public StringValue readLine(long length) throws IOException {
        return this._lineReader.readLine(this._env, this, length);
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        StringValue bb = this._env.createBinaryBuilder(buffer, offset, length);
        Value output = this._wrapper.callMethod(this._env, (StringValue)STREAM_WRITE, bb);
        this._writeLength = (int)output.toLong();
    }

    public int write(InputStream is, int length) {
        int writeLength = 0;
        TempBuffer tb = TempBuffer.allocate();
        byte[] buffer = tb.getBuffer();
        try {
            int sublen;
            while (length > 0) {
                sublen = length < buffer.length ? length : buffer.length;
                if ((sublen = is.read(buffer, 0, sublen)) < 0) break;
                for (int offset = 0; offset < sublen; offset += this._writeLength) {
                    this.write(buffer, offset, sublen);
                    if (this._writeLength > 0) {
                        continue;
                    }
                    int n = writeLength;
                    return n;
                }
                writeLength += sublen;
                length -= sublen;
            }
            sublen = writeLength;
            return sublen;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        finally {
            TempBuffer.free((TempBuffer)tb);
        }
    }

    public void print(char v) throws IOException {
        this.printBuffer[0] = (byte)v;
        this.write(this.printBuffer, 0, 1);
    }

    public void print(String v) throws IOException {
        for (int i = 0; i < v.length(); ++i) {
            this.print(v.charAt(i));
        }
    }

    public boolean isEOF() {
        return this._wrapper.callMethod(this._env, STREAM_EOF).toBoolean();
    }

    public long getPosition() {
        return this._wrapper.callMethod(this._env, STREAM_TELL).toLong();
    }

    public boolean setPosition(long offset) {
        LongValue offsetValue = LongValue.create(offset);
        LongValue whenceValue = LongValue.create(0L);
        return this._wrapper.callMethod(this._env, STREAM_SEEK, offsetValue, whenceValue).toBoolean();
    }

    public long seek(long offset, int whence) {
        LongValue offsetValue = LongValue.create(offset);
        LongValue whenceValue = LongValue.create(whence);
        return this._wrapper.callMethod(this._env, STREAM_SEEK, offsetValue, whenceValue).toLong();
    }

    public void flush() throws IOException {
        if (!this._wrapper.callMethod(this._env, STREAM_FLUSH).toBoolean()) {
            throw new IOException();
        }
    }

    public Value stat() {
        return this._wrapper.callMethod(this._env, STREAM_FLUSH);
    }

    private class WrappedOutputStream
    extends OutputStream {
        private WrappedOutputStream() {
        }

        public void write(int b) throws IOException {
            WrappedStream.this._wrapper.callMethod(WrappedStream.this._env, (StringValue)STREAM_WRITE, LongValue.create(b));
        }
    }

    private class WrappedInputStream
    extends InputStream {
        private WrappedInputStream() {
        }

        public int read() throws IOException {
            return WrappedStream.this.read();
        }
    }
}

