/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.i18n;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.VariableArguments;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.lib.MailModule;
import com.caucho.quercus.lib.i18n.IconvUtility;
import com.caucho.quercus.lib.regexp.RegexpModule;
import com.caucho.quercus.lib.string.StringModule;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.module.IniDefinition;
import com.caucho.quercus.module.IniDefinitions;
import com.caucho.util.L10N;
import com.caucho.vfs.Encoding;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.logging.Logger;

public class MbstringModule
extends AbstractQuercusModule {
    private static final IniDefinitions _iniDefinitions = new IniDefinitions();
    private static final Logger log = Logger.getLogger(MbstringModule.class.getName());
    private static final L10N L = new L10N(MbstringModule.class);
    public static final int MB_CASE_UPPER = 0;
    public static final int MB_CASE_LOWER = 1;
    public static final int MB_CASE_TITLE = 2;
    static final IniDefinition INI_MBSTRING_HTTP_INPUT = _iniDefinitions.add("mbstring.http_input", "pass", 7);
    static final IniDefinition INI_MBSTRING_HTTP_OUTPUT = _iniDefinitions.add("mbstring.http_output", "pass", 7);

    public String[] getLoadedExtensions() {
        return new String[]{"mbstring"};
    }

    public IniDefinitions getIniDefinitions() {
        return _iniDefinitions;
    }

    public static StringValue mb_convert_case(Env env, StringValue str, int mode, @Optional(value="") String encoding) {
        if (mode == 2) {
            encoding = MbstringModule.getEncoding(env, encoding);
            StringValue unicodeStr = str.convertToUnicode(env, encoding);
            unicodeStr = MbstringModule.toUpperCaseTitle(env, unicodeStr);
            return str.create(env, unicodeStr, encoding);
        }
        if (mode == 1) {
            return MbstringModule.mb_strtolower(env, str, encoding);
        }
        if (mode == 0) {
            return MbstringModule.mb_strtoupper(env, str, encoding);
        }
        return str;
    }

    public static StringValue mb_convert_encoding(Env env, StringValue str, String destEncoding, @Optional String fromEncodings) {
        int tail = fromEncodings.indexOf(44, 1);
        String srcEncoding = tail < 0 ? fromEncodings : MbstringModule.getEncoding(env, fromEncodings.substring(0, tail).trim());
        return MbstringModule.decodeEncode(env, str, srcEncoding, destEncoding);
    }

    public static StringValue mb_convert_kana(Env env, StringValue str, @Optional(value="") String option, @Optional(value="") String encoding) {
        throw new UnimplementedException("mb_convert_kana");
    }

    @VariableArguments
    public static StringValue mb_convert_variables(Env env, String toEncoding, String fromEncodings, @Reference Value vars) {
        int tail = fromEncodings.indexOf(44, 1);
        if (tail < 0) {
            tail = fromEncodings.length();
        }
        String srcEncoding = tail < 0 ? fromEncodings : MbstringModule.getEncoding(env, fromEncodings.substring(0, tail).trim());
        Value decoded = MbstringModule.decodeAll(env, vars, srcEncoding);
        vars.set(MbstringModule.encodeAll(env, decoded, toEncoding));
        return env.createString(srcEncoding);
    }

    public static Value mb_decode_mimeheader(Env env, StringValue str) {
        String encoding = MbstringModule.getEncoding(env);
        try {
            return IconvUtility.decodeMime(env, str, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new QuercusModuleException(e.getMessage());
        }
    }

    public static StringValue mb_decode_numericentity(Env env, StringValue str, ArrayValue convmap, @Optional String encoding) {
        throw new UnimplementedException("mb_decode_numericentity");
    }

    public static StringValue mb_detect_encoding(Env env, StringValue str, @Optional Value encoding_list, @Optional boolean strict) {
        throw new UnimplementedException("mb_detect_encoding");
    }

    public static Value mb_detect_order(Env env, Value encoding_list) {
        throw new UnimplementedException("mb_detect_order");
    }

    public static StringValue mb_encode_mimeheader(Env env, StringValue str, @Optional(value="") String charset, @Optional(value="B") String transfer_encoding, @Optional(value="") String linefeed) {
        charset = MbstringModule.getEncoding(env, charset);
        try {
            String mime = IconvUtility.encodeMimeWord(str.toString(), charset, transfer_encoding, linefeed, 76);
            return env.createString(mime);
        }
        catch (UnsupportedEncodingException e) {
            throw new QuercusModuleException(e.getMessage());
        }
    }

    public static StringValue mb_encode_numericentity(Env env, StringValue str, ArrayValue convmap, @Optional String encoding) {
        throw new UnimplementedException();
    }

    public static BooleanValue mb_ereg_match(Env env, StringValue pattern, StringValue string, @Optional String option) {
        String encoding = MbstringModule.getEncoding(env);
        Value val = RegexpModule.ereg(env, pattern = pattern.convertToUnicode(env, encoding), string = string.convertToUnicode(env, encoding), null);
        if (val == BooleanValue.FALSE) {
            return BooleanValue.FALSE;
        }
        return BooleanValue.TRUE;
    }

    public static Value mb_ereg_replace(Env env, StringValue pattern, StringValue replacement, StringValue subject, @Optional String option) {
        String encoding = MbstringModule.getEncoding(env);
        pattern = pattern.convertToUnicode(env, encoding);
        replacement = replacement.convertToUnicode(env, encoding);
        subject = subject.convertToUnicode(env, encoding);
        Value val = RegexpModule.ereg_replace(env, pattern, replacement, subject);
        return MbstringModule.encodeAll(env, val, encoding);
    }

    public static Value mb_ereg(Env env, StringValue pattern, StringValue string, @Optional ArrayValue regs) {
        return MbstringModule.eregImpl(env, pattern, string, regs, true);
    }

    public static Value mb_eregi_replace(Env env, StringValue pattern, StringValue replacement, StringValue subject, @Optional String option) {
        String encoding = MbstringModule.getEncoding(env);
        pattern = pattern.convertToUnicode(env, encoding);
        replacement = replacement.convertToUnicode(env, encoding);
        subject = subject.convertToUnicode(env, encoding);
        Value val = RegexpModule.eregi_replace(env, pattern, replacement, subject);
        return MbstringModule.encodeAll(env, val, encoding);
    }

    public static Value mb_eregi(Env env, StringValue pattern, StringValue string, @Optional ArrayValue regs) {
        return MbstringModule.eregImpl(env, pattern, string, regs, false);
    }

    private static Value eregImpl(Env env, StringValue pattern, StringValue string, ArrayValue regs, boolean isCaseSensitive) {
        String encoding = MbstringModule.getEncoding(env);
        pattern = pattern.convertToUnicode(env, encoding);
        string = string.convertToUnicode(env, encoding);
        if (regs == null) {
            if (isCaseSensitive) {
                return RegexpModule.ereg(env, pattern, string, null);
            }
            return RegexpModule.eregi(env, pattern, string, null);
        }
        Var regVar = new Var();
        Value val = isCaseSensitive ? RegexpModule.ereg(env, pattern, string, regVar) : RegexpModule.eregi(env, pattern, string, regVar);
        if (regVar.isset()) {
            regs.clear();
            ArrayValue results = regVar.toArrayValue(env);
            for (Map.Entry<Value, Value> entry : results.entrySet()) {
                Value bytes = MbstringModule.encodeAll(env, entry.getValue(), encoding);
                regs.put(entry.getKey(), bytes);
            }
            val = LongValue.create(regs.get(LongValue.ZERO).toStringValue().length());
        }
        return val;
    }

    public static LongValue mb_ereg_search_getpos(Env env) {
        EregSearch ereg = MbstringModule.getEreg(env);
        if (ereg == null) {
            return LongValue.ZERO;
        }
        return LongValue.create(ereg._position);
    }

    public static Value mb_ereg_search_getregs(Env env) {
        EregSearch ereg = MbstringModule.getEreg(env);
        if (ereg == null || ereg._lastMatch == null) {
            return BooleanValue.FALSE;
        }
        return ereg._lastMatch;
    }

    public static BooleanValue mb_ereg_search_init(Env env, StringValue string, @Optional Value pattern, @Optional Value option) {
        EregSearch ereg = new EregSearch(env, string, pattern, option);
        env.setSpecialValue("mb.search", ereg);
        return BooleanValue.TRUE;
    }

    public static Value mb_ereg_search_pos(Env env, @Optional Value pattern, @Optional Value option) {
        EregSearch ereg = MbstringModule.getEreg(env, pattern, option);
        if (ereg == null) {
            env.warning(L.l("Regular expression not set"));
            return BooleanValue.FALSE;
        }
        return ereg.search(env, true);
    }

    public static Value mb_ereg_search_regs(Env env, @Optional Value pattern, @Optional Value option) {
        EregSearch ereg = MbstringModule.getEreg(env, pattern, option);
        if (ereg == null) {
            env.warning(L.l("Regular expression not set"));
            return BooleanValue.FALSE;
        }
        if (ereg.search(env, false) == BooleanValue.FALSE) {
            return BooleanValue.FALSE;
        }
        return ereg._lastMatch;
    }

    public static BooleanValue mb_ereg_search_setpos(Env env, int position) {
        EregSearch ereg = MbstringModule.getEreg(env);
        if (ereg == null) {
            return BooleanValue.FALSE;
        }
        ereg._position = position;
        return BooleanValue.TRUE;
    }

    public static BooleanValue mb_ereg_search(Env env, @Optional Value pattern, @Optional Value option) {
        EregSearch ereg = MbstringModule.getEreg(env, pattern, option);
        if (ereg == null) {
            env.warning(L.l("Regular expression not set"));
            return BooleanValue.FALSE;
        }
        Value result = ereg.search(env, false);
        return BooleanValue.create(result.toBoolean());
    }

    private static EregSearch getEreg(Env env) {
        Object obj = env.getSpecialValue("mb.search");
        if (obj == null) {
            return null;
        }
        return (EregSearch)obj;
    }

    private static EregSearch getEreg(Env env, Value pattern, Value option) {
        Object obj = env.getSpecialValue("mb.search");
        if (obj != null) {
            EregSearch ereg = (EregSearch)obj;
            ereg.init(env, pattern, option);
            if (ereg._isValidRegexp) {
                return ereg;
            }
            return null;
        }
        return null;
    }

    public static Value mb_get_info(Env env, @Optional(value="") String type) {
        if (type.length() == 0) {
            ArrayValueImpl array = new ArrayValueImpl();
            ((ArrayValue)array).put(env.createString("internal_encoding"), env.createString(MbstringModule.getEncoding(env)));
            return array;
        }
        if (type.equals("internal_encoding")) {
            return env.createString(MbstringModule.getEncoding(env));
        }
        throw new UnimplementedException("mb_get_info");
    }

    public static Value mb_http_input(Env env, @Optional String type) {
        throw new UnimplementedException("mb_http_input");
    }

    public static Value mb_http_output(Env env, @Optional String encoding) {
        throw new UnimplementedException("mb_http_output");
    }

    public static Value mb_internal_encoding(Env env, @Optional String encoding) {
        if (encoding.length() == 0) {
            return env.createString(MbstringModule.getEncoding(env));
        }
        MbstringModule.setEncoding(env, encoding);
        return BooleanValue.TRUE;
    }

    public static Value mb_language(Env env, @Optional String language) {
        String encoding = MbstringModule.getEncoding(env);
        if (language.length() == 0) {
            if (encoding.equalsIgnoreCase("ISO-2022-JP")) {
                return env.createString("Japanese");
            }
            if (encoding.equalsIgnoreCase("ISO-8859-1")) {
                return env.createString("English");
            }
            if (encoding.equalsIgnoreCase("UTF-8")) {
                return env.createString("uni");
            }
        } else if (language.equals("Japanese") || language.equals("ja")) {
            MbstringModule.setEncoding(env, "ISO-2022-JP");
        } else if (language.equals("English") || language.equals("en")) {
            MbstringModule.setEncoding(env, "ISO-8859-1");
        } else if (language.equals("uni")) {
            MbstringModule.setEncoding(env, "UTF-8");
        } else {
            return BooleanValue.FALSE;
        }
        return BooleanValue.TRUE;
    }

    public static ArrayValue mb_list_encodings(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        ((ArrayValue)array).put(env.createString("ASCII"));
        ((ArrayValue)array).put(env.createString("UTF-8"));
        ((ArrayValue)array).put(env.createString("UTF-16"));
        ((ArrayValue)array).put(env.createString("ISO-8859-1"));
        ((ArrayValue)array).put(env.createString("ISO-8859-2"));
        ((ArrayValue)array).put(env.createString("ISO-8859-15"));
        ((ArrayValue)array).put(env.createString("ISO-2022-JP"));
        ((ArrayValue)array).put(env.createString("EUC-KR"));
        ((ArrayValue)array).put(env.createString("EUC-CN"));
        ((ArrayValue)array).put(env.createString("EUC-TW"));
        ((ArrayValue)array).put(env.createString("EUC-JP"));
        ((ArrayValue)array).put(env.createString("JIS"));
        return array;
    }

    public static StringValue mb_output_handler(Env env, StringValue contents, int value) {
        throw new UnimplementedException("mb_output_handler");
    }

    public static BooleanValue mb_parse_str(Env env, StringValue strValue, @Optional @Reference Value result) {
        String encoding = MbstringModule.getEncoding(env);
        StringModule.parse_str(env, strValue.toString(), result);
        if (result == null) {
            return BooleanValue.TRUE;
        }
        Value array = MbstringModule.encodeAll(env, result, encoding);
        result.set(array);
        return BooleanValue.TRUE;
    }

    public static StringValue mb_preferred_mime_name(Env env, StringValue encoding) {
        String mimeName = Encoding.getMimeName((String)encoding.toString());
        return env.createString(mimeName);
    }

    public static Value mb_regex_encoding(Env env, @Optional(value="") String encoding) {
        return MbstringModule.mb_internal_encoding(env, encoding);
    }

    public static StringValue mb_regex_set_options(Env env, @Optional String options) {
        throw new UnimplementedException("mb_regex_set_options");
    }

    public static BooleanValue mb_send_mail(Env env, StringValue to, StringValue subject, StringValue message, @Optional StringValue additionalHeaders, @Optional StringValue additionalParameters) {
        String encoding = MbstringModule.getEncoding(env);
        subject = subject.toBinaryValue(env, encoding);
        message = message.toBinaryValue(env, encoding);
        additionalHeaders = additionalHeaders.toBinaryValue(env, encoding);
        boolean result = MailModule.mail(env, to.toString(), subject.toString(), message, additionalHeaders.toString(), additionalParameters.toString());
        return BooleanValue.create(result);
    }

    public static Value mb_split(Env env, StringValue pattern, StringValue string, @Optional(value="-1") long limit) {
        String encoding = MbstringModule.getEncoding(env);
        pattern = pattern.convertToUnicode(env, encoding);
        string = string.convertToUnicode(env, encoding);
        Value val = RegexpModule.split(env, pattern, string, limit);
        return MbstringModule.encodeAll(env, val, encoding);
    }

    public static StringValue mb_strcut(Env env, StringValue str, int start, @Optional(value="7fffffff") int length, @Optional String encoding) {
        int end = start + length;
        int len = (str = str.convertToUnicode(env, encoding = MbstringModule.getEncoding(env, encoding))).length();
        if (end > len) {
            end = len;
        }
        if (start < 0 || start > end) {
            return StringValue.EMPTY;
        }
        if (Character.isHighSurrogate(str.charAt(start))) {
            --start;
        }
        str = str.substring(start, end);
        return str.toBinaryValue(env, encoding);
    }

    public static StringValue mb_strimwidth(Env env, StringValue str, int start, int width, @Optional StringValue trimmarker, @Optional(value="") String encoding) {
        int end = start + width;
        StringValue unicodeStr = str.convertToUnicode(env, encoding = MbstringModule.getEncoding(env, encoding));
        int len = unicodeStr.length();
        if (end > len) {
            end = len;
        }
        if (start < 0 || start > end) {
            return str.getEmptyString();
        }
        unicodeStr = unicodeStr.substring(start, end);
        if (end < len && trimmarker.length() > 0) {
            StringValue sb = env.createUnicodeBuilder();
            sb.append(unicodeStr);
            sb.append(trimmarker.convertToUnicode(env, encoding));
            unicodeStr = sb;
        }
        return str.create(env, unicodeStr, encoding);
    }

    public static LongValue mb_strlen(Env env, StringValue str, @Optional(value="") String encoding) {
        encoding = MbstringModule.getEncoding(env, encoding);
        str = str.convertToUnicode(env, encoding);
        return LongValue.create(str.length());
    }

    public static Value mb_strpos(Env env, StringValue haystack, StringValue needle, @Optional(value="0") int offset, @Optional(value="") String encoding) {
        encoding = MbstringModule.getEncoding(env, encoding);
        haystack = haystack.convertToUnicode(env, encoding);
        needle = needle.convertToUnicode(env, encoding);
        return StringModule.strpos(haystack, needle, offset);
    }

    public static Value mb_strrpos(Env env, StringValue haystack, StringValue needle, @Optional Value offsetV, @Optional(value="") String encoding) {
        encoding = MbstringModule.getEncoding(env, encoding);
        haystack = haystack.convertToUnicode(env, encoding);
        needle = needle.convertToUnicode(env, encoding);
        return StringModule.strrpos(haystack, needle, offsetV);
    }

    public static StringValue mb_strtolower(Env env, StringValue str, @Optional(value="") String encoding) {
        encoding = MbstringModule.getEncoding(env, encoding);
        StringValue unicodeStr = str.convertToUnicode(env, encoding);
        unicodeStr = StringModule.strtolower(str);
        return str.create(env, unicodeStr, encoding);
    }

    public static StringValue mb_strtoupper(Env env, StringValue str, @Optional(value="") String encoding) {
        encoding = MbstringModule.getEncoding(env, encoding);
        StringValue unicodeStr = str.convertToUnicode(env, encoding);
        unicodeStr = StringModule.strtoupper(str);
        return str.create(env, unicodeStr, encoding);
    }

    public static LongValue mb_strwidth(Env env, StringValue str, @Optional(value="") String encoding) {
        encoding = MbstringModule.getEncoding(env, encoding);
        str = str.convertToUnicode(env, encoding);
        return LongValue.create(str.length());
    }

    public static Value mb_substitute_character(Value substrchar) {
        throw new UnimplementedException("mb_substitute_character");
    }

    public static LongValue mb_substr_count(Env env, StringValue haystack, StringValue needle, @Optional(value="") String encoding) {
        encoding = MbstringModule.getEncoding(env, encoding);
        haystack = haystack.convertToUnicode(env, encoding);
        needle = needle.convertToUnicode(env, encoding);
        int count = 0;
        int sublen = needle.length();
        int i = haystack.indexOf(needle);
        while (i >= 0) {
            i = haystack.indexOf(needle, i + sublen);
            ++count;
        }
        return LongValue.create(count);
    }

    public static StringValue mb_substr(Env env, StringValue str, int start, @Optional Value lengthV, @Optional String encoding) {
        Value val = StringModule.substr(env, str = str.convertToUnicode(env, encoding = MbstringModule.getEncoding(env, encoding)), start, lengthV);
        if (val == BooleanValue.FALSE) {
            return StringValue.EMPTY;
        }
        return val.toStringValue().toBinaryValue(env, encoding);
    }

    private static StringValue toUpperCaseTitle(Env env, StringValue string) {
        StringValue sb = string.createEmptyStringBuilder();
        int strLen = string.length();
        boolean isWordStart = true;
        block3: for (int i = 0; i < strLen; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    isWordStart = true;
                    sb.append(ch);
                    continue block3;
                }
                default: {
                    if (isWordStart) {
                        sb.append(Character.toUpperCase(ch));
                        isWordStart = false;
                        continue block3;
                    }
                    sb.append(Character.toLowerCase(ch));
                }
            }
        }
        return sb;
    }

    private static String getEncoding(Env env) {
        return env.getRuntimeEncoding().toString();
    }

    private static String getEncoding(Env env, String encoding) {
        if (encoding == null || encoding.length() == 0) {
            return MbstringModule.getEncoding(env);
        }
        return encoding;
    }

    private static void setEncoding(Env env, String encoding) {
        env.setRuntimeEncoding(encoding);
    }

    private static Value decodeAll(Env env, Value val, String encoding) {
        if ((val = val.toValue()) instanceof StringValue) {
            return ((StringValue)val).convertToUnicode(env, encoding);
        }
        if (val instanceof ArrayValue) {
            ArrayValueImpl array = new ArrayValueImpl();
            for (Map.Entry<Value, Value> entry : ((ArrayValue)val).entrySet()) {
                ((ArrayValue)array).put(entry.getKey(), MbstringModule.decodeAll(env, entry.getValue(), encoding));
            }
            return array;
        }
        if (val instanceof ObjectValue) {
            ObjectValue obj = (ObjectValue)val;
            for (Map.Entry<String, Value> entry : obj.entrySet()) {
                obj.putField(env, entry.getKey(), MbstringModule.decodeAll(env, entry.getValue(), encoding));
            }
            return obj;
        }
        return val;
    }

    private static Value encodeAll(Env env, Value val, String encoding) {
        if ((val = val.toValue()) instanceof StringValue) {
            StringValue sb = env.createBinaryBuilder();
            sb.append(env, (StringValue)val, encoding);
            return sb;
        }
        if (val instanceof ArrayValue) {
            ArrayValueImpl array = new ArrayValueImpl();
            for (Map.Entry<Value, Value> entry : ((ArrayValue)val).entrySet()) {
                ((ArrayValue)array).put(entry.getKey(), MbstringModule.encodeAll(env, entry.getValue(), encoding));
            }
            return array;
        }
        if (val instanceof ObjectValue) {
            ObjectValue obj = (ObjectValue)val;
            for (Map.Entry<String, Value> entry : obj.entrySet()) {
                obj.putField(env, entry.getKey(), MbstringModule.encodeAll(env, entry.getValue(), encoding));
            }
            return obj;
        }
        return val;
    }

    private static StringValue decodeEncode(Env env, StringValue val, String srcEncoding, String destEncoding) {
        try {
            return IconvUtility.decodeEncode(env, val, srcEncoding, destEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new QuercusModuleException(e.getMessage());
        }
    }

    static class EregSearch {
        private StringValue _string;
        private StringValue _pattern;
        private Value _option;
        private int _length;
        ArrayValue _lastMatch;
        int _position;
        boolean _isValidRegexp;

        EregSearch(Env env, StringValue string, Value pattern, Value option) {
            this._string = string.convertToUnicode(env, MbstringModule.getEncoding(env));
            this._position = 0;
            this._length = this._string.length();
            this.init(env, pattern, option);
        }

        void init(Env env, Value pattern, Value option) {
            this._option = option;
            this.initPattern(env, pattern);
        }

        void initPattern(Env env, Value pattern) {
            if (pattern instanceof StringValue) {
                this._pattern = pattern.toStringValue();
                this._isValidRegexp = true;
            } else {
                this._isValidRegexp = this._pattern != null;
            }
        }

        StringValue getString(Env env) {
            if (this._position == 0) {
                return this._string;
            }
            if (this._position < this._length) {
                return this._string.substring(this._position);
            }
            return StringValue.EMPTY;
        }

        Value search(Env env, boolean isArrayReturn) {
            ArrayValueImpl regs;
            StringValue string = this.getString(env);
            Value val = MbstringModule.eregImpl(env, this._pattern, string, regs = new ArrayValueImpl(), true);
            if (val == BooleanValue.FALSE) {
                return BooleanValue.FALSE;
            }
            StringValue match = ((ArrayValue)regs).get(LongValue.ZERO).toStringValue();
            int matchIndex = this._string.indexOf(match, this._position);
            int matchLength = match.length();
            this._position = matchIndex + matchLength;
            this._lastMatch = regs;
            if (isArrayReturn) {
                ArrayValueImpl array = new ArrayValueImpl();
                ((ArrayValue)array).put(LongValue.create(matchIndex));
                ((ArrayValue)array).put(LongValue.create(matchLength));
                return array;
            }
            return BooleanValue.TRUE;
        }
    }
}

