/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.i18n;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.BytesValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.i18n.IconvUtility;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.module.IniDefinition;
import com.caucho.quercus.module.IniDefinitions;
import com.caucho.util.L10N;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;

public class UnicodeModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(UnicodeModule.class.getName());
    private static final L10N L = new L10N(UnicodeModule.class);
    public static final int U_INVALID_STOP = 0;
    public static final int U_INVALID_SKIP = 1;
    public static final int U_INVALID_SUBSTITUTE = 2;
    public static final int U_INVALID_ESCAPE = 3;
    public static final String ICONV_IMPL = "QuercusIconv";
    public static final String ICONV_VERSION = "1.0";
    public static final int ICONV_MIME_DECODE_STRICT = 1;
    public static final int ICONV_MIME_DECODE_CONTINUE_ON_ERROR = 2;
    private static final IniDefinitions _iniDefinitions = new IniDefinitions();
    static final IniDefinition INI_ICONV_INPUT_ENCODING = _iniDefinitions.add("iconv.input_encoding", "utf-8", 7);
    static final IniDefinition INI_ICONV_OUTPUT_ENCODING = _iniDefinitions.add("iconv.output_encoding", "utf-8", 7);
    static final IniDefinition INI_ICONV_INTERNAL_ENCODING = _iniDefinitions.add("iconv.internal_encoding", "utf-8", 7);

    public IniDefinitions getIniDefinitions() {
        return _iniDefinitions;
    }

    public static BooleanValue unicode_semantics(Env env) {
        return env.isUnicodeSemantics() ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    public static StringValue unicode_decode(Env env, BytesValue str, String encoding) {
        return str.convertToUnicode(env, encoding);
    }

    public static StringValue unicode_encode(Env env, UnicodeValue str, String encoding) {
        return str.toBinaryValue(env, encoding);
    }

    public static Value iconv_get_encoding(Env env, @Optional(value="all") String type) {
        if ("all".equals(type = type.toLowerCase())) {
            ArrayValueImpl array = new ArrayValueImpl();
            array.put(env, "input_encoding", env.getIniString("iconv.input_encoding"));
            array.put(env, "output_encoding", env.getIniString("iconv.output_encoding"));
            array.put(env, "internal_encoding", env.getIniString("iconv.internal_encoding"));
            return array;
        }
        if ("input_encoding".equals(type)) {
            return env.createString(env.getIniString("iconv.input_encoding"));
        }
        if ("output_encoding".equals(type)) {
            return env.createString(env.getIniString("iconv.output_encoding"));
        }
        if ("internal_encoding".equals(type)) {
            return env.createString(env.getIniString("iconv.internal_encoding"));
        }
        return BooleanValue.FALSE;
    }

    public static Value iconv_mime_decode_headers(Env env, StringValue encoded_headers, @Optional int mode, @Optional String charset) {
        if (charset.length() == 0) {
            charset = env.getIniString("iconv.internal_encoding");
        }
        try {
            return UnicodeModule.decodeMimeHeaders(env, encoded_headers, charset);
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(L.l(e.getMessage()));
        }
        catch (MessagingException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(L.l(e.getMessage()));
        }
        return BooleanValue.FALSE;
    }

    private static Value decodeMimeHeaders(Env env, StringValue encodedHeaders, String charset) throws MessagingException, UnsupportedEncodingException {
        ArrayValueImpl headers = new ArrayValueImpl();
        Enumeration enumeration = new InternetHeaders(encodedHeaders.toInputStream()).getAllHeaders();
        while (enumeration.hasMoreElements()) {
            ArrayValue inner;
            Header header = (Header)enumeration.nextElement();
            StringValue name = IconvUtility.decodeMime(env, header.getName(), charset);
            StringValue val = IconvUtility.decodeMime(env, header.getValue(), charset);
            Value headerName = ((ArrayValue)headers).containsKey(name);
            if (headerName == null) {
                ((ArrayValue)headers).put(name, val);
                continue;
            }
            if (headerName.isArray()) {
                inner = headerName.toArrayValue(env);
            } else {
                inner = new ArrayValueImpl();
                inner.put(headerName);
            }
            inner.put(val);
            ((ArrayValue)headers).put(name, inner);
        }
        return headers;
    }

    public static Value iconv_mime_decode(Env env, StringValue encoded_header, @Optional(value="1") int mode, @Optional(value="") String charset) {
        if (charset.length() == 0) {
            charset = env.getIniString("iconv.internal_encoding");
        }
        try {
            Enumeration enumeration = new InternetHeaders(encoded_header.toInputStream()).getAllHeaderLines();
            if (!enumeration.hasMoreElements()) {
                env.warning(L.l("Error parsing header."));
                return BooleanValue.FALSE;
            }
            return IconvUtility.decodeMime(env, (CharSequence)enumeration.nextElement(), charset);
        }
        catch (MessagingException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(L.l(e.getMessage()));
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(L.l(e.getMessage()));
        }
        return BooleanValue.FALSE;
    }

    public static Value iconv_mime_encode(Env env, StringValue field_name, StringValue field_value, @Optional ArrayValue preferences) {
        try {
            String inCharset;
            String scheme = "B";
            String lineBreakChars = "\r\n";
            String outCharset = inCharset = env.getIniString("iconv.internal_encoding");
            int lineLength = 76;
            if (preferences != null) {
                Value tmp = env.createString("scheme");
                if ((tmp = preferences.get(tmp)).isset()) {
                    scheme = tmp.toString();
                }
                tmp = env.createString("line-break-chars");
                if ((tmp = preferences.get(tmp)).isset()) {
                    lineBreakChars = tmp.toString();
                }
                tmp = env.createString("input-charset");
                if ((tmp = preferences.get(tmp)).isset()) {
                    inCharset = tmp.toString();
                }
                tmp = env.createString("output-charset");
                if ((tmp = preferences.get(tmp)).isset()) {
                    outCharset = tmp.toString();
                }
                tmp = env.createString("line-length");
                if ((tmp = preferences.get(tmp)).isset() && tmp.isLongConvertible()) {
                    lineLength = (int)tmp.toLong();
                }
            }
            return IconvUtility.encodeMime(env, field_name, field_value, inCharset, outCharset, scheme, lineBreakChars, lineLength);
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(L.l(e.getMessage()));
            return BooleanValue.FALSE;
        }
    }

    public static BooleanValue iconv_set_encoding(Env env, String type, StringValue charset) {
        if ("input_encoding".equals(type = type.toLowerCase())) {
            env.setIni("iconv.input_encoding", charset);
            return BooleanValue.TRUE;
        }
        if ("output_encoding".equals(type)) {
            env.setIni("iconv.output_encoding", charset);
            return BooleanValue.TRUE;
        }
        if ("internal_encoding".equals(type)) {
            env.setIni("iconv.internal_encoding", charset);
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    public static Value iconv_strlen(Env env, StringValue str, @Optional(value="") String charset) {
        if (charset.length() == 0) {
            charset = env.getIniString("iconv.internal_encoding");
        }
        return LongValue.create(str.convertToUnicode(env, charset).length());
    }

    public static Value iconv_strpos(Env env, StringValue haystack, StringValue needle, @Optional(value="0") int offset, @Optional(value="") String charset) {
        int index;
        if (charset.length() == 0) {
            charset = env.getIniString("iconv.internal_encoding");
        }
        if ((index = (haystack = haystack.convertToUnicode(env, charset)).indexOf(needle = needle.convertToUnicode(env, charset), offset)) < 0) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(index);
    }

    public static Value iconv_strrpos(Env env, StringValue haystack, StringValue needle, @Optional(value="") String charset) {
        int index;
        if (charset.length() == 0) {
            charset = env.getIniString("iconv.internal_encoding");
        }
        if ((index = (haystack = haystack.convertToUnicode(env, charset)).lastIndexOf(needle = needle.convertToUnicode(env, charset))) < 0) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(index);
    }

    public static Value iconv_substr(Env env, StringValue str, int offset, @Optional(value="7fffffff") int length, @Optional(value="") String charset) {
        if (charset.length() == 0) {
            charset = env.getIniString("iconv.internal_encoding");
        }
        StringValue unicodeStr = str.convertToUnicode(env, charset);
        int strlen = unicodeStr.length();
        if (offset < 0) {
            offset = strlen + offset;
        }
        int tail = length < 0 ? strlen + length : (length > strlen - offset ? strlen : offset + length);
        if (offset < 0 || tail < offset) {
            return str.getEmptyString();
        }
        unicodeStr = unicodeStr.substring(offset, tail);
        return str.create(env, unicodeStr, charset);
    }

    public static Value iconv(Env env, String in_charset, String out_charset, StringValue str) {
        if (out_charset.endsWith("//TRANSLIT")) {
            env.stub("Iconv TRANSLIT option not supported");
            int length = out_charset.length() - "//TRANSLIT".length();
            out_charset = out_charset.substring(0, length);
        }
        try {
            return IconvUtility.decodeEncode(env, str, in_charset, out_charset);
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(L.l("error converting {1} to {2}", (Object)in_charset, (Object)out_charset));
            return BooleanValue.FALSE;
        }
    }

    public static StringValue ob_iconv_handler(StringValue contents, int status) {
        throw new UnimplementedException("ob_iconv_handler");
    }
}

