/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.regexp;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.DefaultValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.lib.regexp.IllegalRegexpException;
import com.caucho.quercus.lib.regexp.Regexp;
import com.caucho.quercus.lib.regexp.RegexpModule;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CauchoRegexpModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(RegexpModule.class.getName());
    private static final L10N L = new L10N(RegexpModule.class);
    public static final int PREG_REPLACE_EVAL = 1;
    public static final int PCRE_UTF8 = 2;
    public static final int PREG_PATTERN_ORDER = 1;
    public static final int PREG_SET_ORDER = 2;
    public static final int PREG_OFFSET_CAPTURE = 4;
    public static final int PREG_SPLIT_NO_EMPTY = 1;
    public static final int PREG_SPLIT_DELIM_CAPTURE = 2;
    public static final int PREG_SPLIT_OFFSET_CAPTURE = 4;
    public static final int PREG_GREP_INVERT = 1;
    public static final boolean[] PREG_QUOTE = new boolean[256];
    private static final LruCache<StringValue, Regexp> _regexpCache = new LruCache(1024);
    private static final LruCache<StringValue, ArrayList<Replacement>> _replacementCache = new LruCache(1024);
    private static final HashMap<String, Value> _constMap = new HashMap();

    @Override
    public String[] getLoadedExtensions() {
        return new String[]{"pcre"};
    }

    public static Value ereg(Env env, StringValue pattern, StringValue string, @Optional @Reference Value regsV) {
        return CauchoRegexpModule.eregImpl(env, pattern, string, regsV, false);
    }

    public static Value eregi(Env env, StringValue pattern, StringValue string, @Optional @Reference Value regsV) {
        return CauchoRegexpModule.eregImpl(env, pattern, string, regsV, true);
    }

    protected static Value eregImpl(Env env, StringValue rawPattern, StringValue string, Value regsV, boolean isCaseInsensitive) {
        StringValue cleanPattern = CauchoRegexpModule.cleanEregRegexp(env, rawPattern, false);
        cleanPattern = isCaseInsensitive ? CauchoRegexpModule.addDelimiters(env, cleanPattern, "/", "/i") : CauchoRegexpModule.addDelimiters(env, cleanPattern, "/", "/");
        try {
            Regexp regexp = CauchoRegexpModule.getRegexp(env, cleanPattern, string);
            if (!regexp.find()) {
                return BooleanValue.FALSE;
            }
            if (regsV != null && !(regsV instanceof NullValue)) {
                ArrayValueImpl regs = new ArrayValueImpl();
                regsV.set(regs);
                ((ArrayValue)regs).put(LongValue.ZERO, regexp.group(env));
                int count = regexp.groupCount();
                for (int i = 1; i <= count; ++i) {
                    StringValue group = regexp.group(env, i);
                    Value value = group == null || group.length() == 0 ? BooleanValue.FALSE : group;
                    ((ArrayValue)regs).put(new LongValue(i), value);
                }
                int len = regexp.end() - regexp.start();
                if (len == 0) {
                    return LongValue.ONE;
                }
                return new LongValue(len);
            }
            return LongValue.ONE;
        }
        catch (IllegalRegexpException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return BooleanValue.FALSE;
        }
    }

    public static Value preg_match(Env env, StringValue regexpValue, StringValue subject, @Optional @Reference Value matchRef, @Optional int flags, @Optional int offset) {
        try {
            boolean isOffsetCapture;
            if (regexpValue.length() < 2) {
                env.warning(L.l("Regexp pattern must have opening and closing delimiters"));
                return LongValue.ZERO;
            }
            StringValue empty = subject.getEmptyString();
            Regexp regexp = CauchoRegexpModule.getRegexp(env, regexpValue, subject);
            ArrayValueImpl regs = matchRef instanceof DefaultValue ? null : new ArrayValueImpl();
            if (regexp == null || !regexp.find(offset)) {
                matchRef.set(regs);
                return LongValue.ZERO;
            }
            boolean bl = isOffsetCapture = (flags & 4) != 0;
            if (regs != null) {
                if (isOffsetCapture) {
                    ArrayValueImpl part = new ArrayValueImpl();
                    part.append(regexp.group(env));
                    part.append(LongValue.create(regexp.start()));
                    ((ArrayValue)regs).put(LongValue.ZERO, part);
                } else {
                    ((ArrayValue)regs).put(LongValue.ZERO, regexp.group(env));
                }
                int count = regexp.groupCount();
                for (int i = 1; i <= count; ++i) {
                    if (!regexp.isMatchedGroup(i)) continue;
                    StringValue group = regexp.group(env, i);
                    if (isOffsetCapture) {
                        for (int j = ((ArrayValue)regs).getSize(); j < i; ++j) {
                            ArrayValueImpl part = new ArrayValueImpl();
                            part.append(empty);
                            part.append(LongValue.MINUS_ONE);
                            ((ArrayValue)regs).put(LongValue.create(j), part);
                        }
                        ArrayValueImpl part = new ArrayValueImpl();
                        part.append(group);
                        part.append(LongValue.create(regexp.start(i)));
                        StringValue name = regexp.getGroupName(i);
                        if (name != null) {
                            ((ArrayValue)regs).put(name, part);
                        }
                        ((ArrayValue)regs).put(LongValue.create(i), part);
                        continue;
                    }
                    for (int j = ((ArrayValue)regs).getSize(); j < i; ++j) {
                        ((ArrayValue)regs).put(LongValue.create(j), empty);
                    }
                    StringValue name = regexp.getGroupName(i);
                    if (name != null) {
                        ((ArrayValue)regs).put(name, group);
                    }
                    ((ArrayValue)regs).put(LongValue.create(i), group);
                }
                matchRef.set(regs);
            }
            return LongValue.ONE;
        }
        catch (IllegalRegexpException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return BooleanValue.FALSE;
        }
    }

    public static Value preg_match_all(Env env, StringValue rawRegexp, StringValue subject, @Reference Value matchRef, @Optional(value="PREG_PATTERN_ORDER") int flags, @Optional int offset) {
        try {
            if (rawRegexp.length() < 2) {
                env.warning(L.l("Pattern must have at least opening and closing delimiters"));
                return BooleanValue.FALSE;
            }
            if ((flags & 1) == 0) {
                if ((flags & 2) == 0) {
                    flags |= 1;
                }
            } else if ((flags & 2) != 0) {
                env.warning(L.l("Cannot combine PREG_PATTER_ORDER and PREG_SET_ORDER"));
                return BooleanValue.FALSE;
            }
            Regexp regexp = CauchoRegexpModule.getRegexp(env, rawRegexp, subject);
            ArrayValue matches = matchRef instanceof ArrayValue ? (ArrayValue)matchRef : new ArrayValueImpl();
            matches.clear();
            matchRef.set(matches);
            if ((flags & 1) != 0) {
                return CauchoRegexpModule.pregMatchAllPatternOrder(env, regexp, subject, matches, flags, offset);
            }
            if ((flags & 2) != 0) {
                return CauchoRegexpModule.pregMatchAllSetOrder(env, regexp, subject, matches, flags, offset);
            }
            throw new UnsupportedOperationException();
        }
        catch (IllegalRegexpException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return BooleanValue.FALSE;
        }
    }

    public static LongValue pregMatchAllPatternOrder(Env env, Regexp regexp, StringValue subject, ArrayValue matches, int flags, int offset) {
        int groupCount = regexp == null ? 0 : regexp.groupCount();
        ArrayValue[] matchList = new ArrayValue[groupCount + 1];
        StringValue emptyStr = subject.getEmptyString();
        for (int j = 0; j <= groupCount; ++j) {
            ArrayValueImpl values = new ArrayValueImpl();
            StringValue patternName = regexp.getGroupName(j);
            if (patternName != null) {
                matches.put(patternName, values);
            }
            matches.put(values);
            matchList[j] = values;
        }
        if (regexp == null || !regexp.find()) {
            return LongValue.ZERO;
        }
        int count = 0;
        do {
            ++count;
            for (int j = 0; j <= groupCount; ++j) {
                ArrayValue values = matchList[j];
                if (!regexp.isMatchedGroup(j)) {
                    if (j == groupCount || (flags & 4) == 0) {
                        values.put(emptyStr);
                        continue;
                    }
                    ArrayValueImpl result = new ArrayValueImpl();
                    ((Value)result).put(emptyStr);
                    ((Value)result).put(LongValue.MINUS_ONE);
                    values.put(result);
                    continue;
                }
                StringValue groupValue = regexp.group(env, j);
                Value result = NullValue.NULL;
                if (groupValue != null) {
                    if ((flags & 4) != 0) {
                        result = new ArrayValueImpl();
                        result.put(groupValue);
                        result.put(LongValue.create(regexp.getBegin(j)));
                    } else {
                        result = groupValue;
                    }
                }
                values.put(result);
            }
        } while (regexp.find());
        return LongValue.create(count);
    }

    private static LongValue pregMatchAllSetOrder(Env env, Regexp regexp, StringValue subject, ArrayValue matches, int flags, int offset) {
        if (regexp == null || !regexp.find()) {
            return LongValue.ZERO;
        }
        StringValue empty = subject.getEmptyString();
        int count = 0;
        do {
            ++count;
            ArrayValueImpl matchResult = new ArrayValueImpl();
            matches.put(matchResult);
            for (int i = 0; i <= regexp.groupCount(); ++i) {
                int start = regexp.start(i);
                int end = regexp.end(i);
                if (end - start <= 0) continue;
                StringValue groupValue = subject.substring(start, end);
                Value result = NullValue.NULL;
                if (groupValue != null) {
                    int j;
                    if ((flags & 4) != 0) {
                        for (j = ((ArrayValue)matchResult).getSize(); j < i; ++j) {
                            ArrayValueImpl part = new ArrayValueImpl();
                            part.append(empty);
                            part.append(LongValue.MINUS_ONE);
                            ((ArrayValue)matchResult).put(LongValue.create(j), part);
                        }
                        result = new ArrayValueImpl();
                        result.put(groupValue);
                        result.put(LongValue.create(start));
                    } else {
                        for (j = ((ArrayValue)matchResult).getSize(); j < i; ++j) {
                            ((ArrayValue)matchResult).put(LongValue.create(j), empty);
                        }
                        result = groupValue;
                    }
                }
                ((ArrayValue)matchResult).put(result);
            }
        } while (regexp.find());
        return LongValue.create(count);
    }

    public static String preg_quote(StringValue string, @Optional String delim) {
        StringBuilder sb = new StringBuilder();
        boolean[] extra = null;
        if (delim != null && !delim.equals("")) {
            extra = new boolean[256];
            for (int i = 0; i < delim.length(); ++i) {
                extra[delim.charAt((int)i)] = true;
            }
        }
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            if (ch >= '\u0100') {
                sb.append(ch);
                continue;
            }
            if (PREG_QUOTE[ch]) {
                sb.append('\\');
                sb.append(ch);
                continue;
            }
            if (extra != null && extra[ch]) {
                sb.append('\\');
                sb.append(ch);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static Value preg_replace(Env env, Value pattern, Value replacement, Value subject, @Optional(value="-1") long limit, @Optional @Reference Value count) {
        try {
            if (subject instanceof ArrayValue) {
                ArrayValueImpl result = new ArrayValueImpl();
                for (Value value : ((ArrayValue)subject).values()) {
                    ((ArrayValue)result).put(CauchoRegexpModule.pregReplace(env, pattern, replacement, value.toStringValue(), limit, count));
                }
                return result;
            }
            if (subject.isset()) {
                return CauchoRegexpModule.pregReplace(env, pattern, replacement, subject.toStringValue(), limit, count);
            }
            return subject.toStringValue().getEmptyString();
        }
        catch (IllegalRegexpException e) {
            e.printStackTrace();
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return BooleanValue.FALSE;
        }
    }

    private static Value pregReplace(Env env, Value patternValue, Value replacement, StringValue subject, @Optional(value="-1") long limit, Value countV) throws IllegalRegexpException {
        StringValue string = subject;
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        if (patternValue.isArray() && replacement.isArray()) {
            ArrayValue patternArray = (ArrayValue)patternValue;
            ArrayValue replacementArray = (ArrayValue)replacement;
            Iterator<Value> patternIter = patternArray.values().iterator();
            Iterator<Value> replacementIter = replacementArray.values().iterator();
            while (patternIter.hasNext() && replacementIter.hasNext()) {
                string = CauchoRegexpModule.pregReplaceString(env, patternIter.next().toStringValue(), replacementIter.next().toStringValue(), string, limit, countV);
            }
        } else if (patternValue.isArray()) {
            ArrayValue patternArray = (ArrayValue)patternValue;
            for (Value value : patternArray.values()) {
                string = CauchoRegexpModule.pregReplaceString(env, value.toStringValue(), replacement.toStringValue(), string, limit, countV);
            }
        } else {
            return CauchoRegexpModule.pregReplaceString(env, patternValue.toStringValue(), replacement.toStringValue(), string, limit, countV);
        }
        return string;
    }

    private static StringValue pregReplaceCallbackImpl(Env env, StringValue patternString, Callback fun, StringValue subject, long limit, Value countV) throws IllegalRegexpException {
        StringValue empty = subject.getEmptyString();
        long numberOfMatches = 0L;
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        Regexp regexp = CauchoRegexpModule.getRegexp(env, patternString, subject);
        StringValue result = patternString.createEmptyStringBuilder();
        int tail = 0;
        while (regexp.find() && numberOfMatches < limit) {
            if (countV != null && countV instanceof Var) {
                long count = ((Var)countV).getRawValue().toLong();
                countV.set(LongValue.create(count + 1L));
            }
            if (tail < regexp.start()) {
                result = result.append(regexp.substring(env, tail, regexp.start()));
            }
            ArrayValueImpl regs = new ArrayValueImpl();
            for (int i = 0; i <= regexp.groupCount(); ++i) {
                StringValue group = regexp.group(env, i);
                if (group != null) {
                    ((ArrayValue)regs).put(group);
                    continue;
                }
                ((ArrayValue)regs).put(empty);
            }
            Value replacement = fun.call(env, regs);
            result = result.append(replacement);
            tail = regexp.end();
            ++numberOfMatches;
        }
        if (tail < subject.length()) {
            result = result.append(regexp.substring(env, tail));
        }
        return result;
    }

    private static StringValue pregReplaceString(Env env, StringValue patternString, StringValue replacement, StringValue subject, long limit, Value countV) throws IllegalRegexpException {
        Regexp regexp = CauchoRegexpModule.getRegexp(env, patternString, subject);
        boolean isEval = regexp.isEval();
        ArrayList<Replacement> replacementProgram = (ArrayList<Replacement>)_replacementCache.get((Object)replacement);
        if (replacementProgram == null) {
            replacementProgram = CauchoRegexpModule.compileReplacement(env, replacement, isEval);
            _replacementCache.put((Object)replacement, replacementProgram);
        }
        return CauchoRegexpModule.pregReplaceStringImpl(env, regexp, replacementProgram, subject, limit, countV, isEval);
    }

    public static Value ereg_replace(Env env, StringValue patternString, StringValue replacement, StringValue subject) {
        try {
            patternString = CauchoRegexpModule.cleanEregRegexp(env, patternString, false);
            patternString = CauchoRegexpModule.addDelimiters(env, patternString, "/", "/");
            Regexp regexp = CauchoRegexpModule.getRegexp(env, patternString, subject);
            ArrayList<Replacement> replacementProgram = (ArrayList<Replacement>)_replacementCache.get((Object)replacement);
            if (replacementProgram == null) {
                replacementProgram = CauchoRegexpModule.compileReplacement(env, replacement, false);
                _replacementCache.put((Object)replacement, replacementProgram);
            }
            return CauchoRegexpModule.pregReplaceStringImpl(env, regexp, replacementProgram, subject, -1L, NullValue.NULL, false);
        }
        catch (IllegalRegexpException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return BooleanValue.FALSE;
        }
    }

    public static Value eregi_replace(Env env, StringValue patternString, StringValue replacement, StringValue subject) {
        try {
            patternString = CauchoRegexpModule.cleanEregRegexp(env, patternString, false);
            patternString = CauchoRegexpModule.addDelimiters(env, patternString, "/", "/i");
            Regexp regexp = CauchoRegexpModule.getRegexp(env, patternString, subject);
            ArrayList<Replacement> replacementProgram = (ArrayList<Replacement>)_replacementCache.get((Object)replacement);
            if (replacementProgram == null) {
                replacementProgram = CauchoRegexpModule.compileReplacement(env, replacement, false);
                _replacementCache.put((Object)replacement, replacementProgram);
            }
            return CauchoRegexpModule.pregReplaceStringImpl(env, regexp, replacementProgram, subject, -1L, NullValue.NULL, false);
        }
        catch (IllegalRegexpException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return BooleanValue.FALSE;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static StringValue pregReplaceStringImpl(Env env, Regexp regexp, ArrayList<Replacement> replacementProgram, StringValue subject, long limit, Value countV, boolean isEval) {
        if (limit < 0L) {
            limit = 0x7FFFFFFFFFFFFFFFL;
        }
        length = subject.length();
        result = subject.createEmptyStringBuilder();
        tail = 0;
        isMatched = false;
        replacementLen = replacementProgram.size();
        while (limit-- > 0L && regexp.find()) {
            isMatched = true;
            if (countV != null && countV instanceof Var) {
                countV.set(LongValue.create(countV.toLong() + 1L));
            }
            if (tail < regexp.start()) {
                result = result.append(regexp.substring(env, tail, regexp.start()));
            }
            if (isEval) {
                evalString = subject.createEmptyStringBuilder();
                for (i = 0; i < replacementLen; ++i) {
                    replacement = replacementProgram.get(i);
                    evalString = replacement.eval(env, evalString, regexp);
                }
                try {
                    if (evalString.length() <= 0) ** GOTO lbl31
                    result = result.append(env.evalCode(evalString.toString()));
                }
                catch (IOException e) {
                    throw new QuercusException(e);
                }
            } else {
                for (i = 0; i < replacementLen; ++i) {
                    replacement = replacementProgram.get(i);
                    result = replacement.eval(env, result, regexp);
                }
            }
lbl31:
            // 3 sources

            tail = regexp.end();
        }
        if (!isMatched) {
            return subject;
        }
        if (tail < length) {
            result = result.append(regexp.substring(env, tail));
        }
        return result;
    }

    public static Value preg_replace_callback(Env env, Value pattern, Callback fun, Value subject, @Optional(value="-1") long limit, @Optional @Reference Value count) {
        try {
            if (subject instanceof ArrayValue) {
                ArrayValueImpl result = new ArrayValueImpl();
                for (Value value : ((ArrayValue)subject).values()) {
                    ((ArrayValue)result).put(CauchoRegexpModule.pregReplaceCallback(env, pattern.toStringValue(), fun, value.toStringValue(), limit, count));
                }
                return result;
            }
            if (subject instanceof StringValue) {
                return CauchoRegexpModule.pregReplaceCallback(env, pattern.toStringValue(), fun, subject.toStringValue(), limit, count);
            }
            return NullValue.NULL;
        }
        catch (IllegalRegexpException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return BooleanValue.FALSE;
        }
    }

    private static Value pregReplaceCallback(Env env, Value patternValue, Callback fun, StringValue subject, @Optional(value="-1") long limit, @Optional @Reference Value countV) throws IllegalRegexpException {
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        if (patternValue.isArray()) {
            ArrayValue patternArray = (ArrayValue)patternValue;
            for (Value value : patternArray.values()) {
                subject = CauchoRegexpModule.pregReplaceCallbackImpl(env, value.toStringValue(), fun, subject, limit, countV);
            }
            return subject;
        }
        if (patternValue instanceof StringValue) {
            return CauchoRegexpModule.pregReplaceCallbackImpl(env, patternValue.toStringValue(), fun, subject, limit, countV);
        }
        return NullValue.NULL;
    }

    public static Value preg_split(Env env, StringValue patternString, StringValue string, @Optional(value="-1") long limit, @Optional int flags) {
        try {
            if (limit <= 0L) {
                limit = Long.MAX_VALUE;
            }
            StringValue empty = patternString.getEmptyString();
            Regexp regexp = CauchoRegexpModule.getRegexp(env, patternString, string);
            ArrayValueImpl result = new ArrayValueImpl();
            int head = 0;
            long count = 0L;
            boolean allowEmpty = (flags & 1) == 0;
            boolean isCaptureOffset = (flags & 4) != 0;
            boolean isCaptureDelim = (flags & 2) != 0;
            GroupNeighborMap neighborMap = new GroupNeighborMap(regexp.getPattern(), regexp.groupCount());
            while (regexp.find()) {
                StringValue unmatched;
                int startPosition = head;
                if (count == limit - 1L) {
                    unmatched = string.substring(head);
                    head = string.length();
                } else {
                    unmatched = string.substring(head, regexp.start());
                    head = regexp.end();
                }
                if (unmatched.length() != 0 || allowEmpty) {
                    if (isCaptureOffset) {
                        ArrayValueImpl part = new ArrayValueImpl();
                        ((ArrayValue)part).put(unmatched);
                        ((ArrayValue)part).put(LongValue.create(startPosition));
                        ((ArrayValue)result).put(part);
                    } else {
                        ((ArrayValue)result).put(unmatched);
                    }
                    ++count;
                }
                if (count == limit) break;
                if (!isCaptureDelim) continue;
                for (int i = 1; i <= regexp.groupCount(); ++i) {
                    ArrayValueImpl part;
                    int start = regexp.start(i);
                    int end = regexp.end(i);
                    if (!regexp.isMatchedGroup(i)) continue;
                    if (allowEmpty) {
                        int group = i;
                        while (neighborMap.hasNeighbor(group) && !regexp.isMatchedGroup(group = neighborMap.getNeighbor(group))) {
                            if (isCaptureOffset) {
                                part = new ArrayValueImpl();
                                ((ArrayValue)part).put(empty);
                                ((ArrayValue)part).put(LongValue.create(startPosition));
                                ((ArrayValue)result).put(part);
                                continue;
                            }
                            ((ArrayValue)result).put(empty);
                        }
                    }
                    if (end - start <= 0 && !allowEmpty) continue;
                    StringValue groupValue = string.substring(start, end);
                    if (isCaptureOffset) {
                        part = new ArrayValueImpl();
                        ((ArrayValue)part).put(groupValue);
                        ((ArrayValue)part).put(LongValue.create(startPosition));
                        ((ArrayValue)result).put(part);
                        continue;
                    }
                    ((ArrayValue)result).put(groupValue);
                }
            }
            if (count < limit && (head < string.length() || allowEmpty)) {
                if (isCaptureOffset) {
                    ArrayValueImpl part = new ArrayValueImpl();
                    ((ArrayValue)part).put(string.substring(head));
                    ((ArrayValue)part).put(LongValue.create(head));
                    ((ArrayValue)result).put(part);
                } else {
                    ((ArrayValue)result).put(string.substring(head));
                }
            }
            return result;
        }
        catch (IllegalRegexpException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return BooleanValue.FALSE;
        }
    }

    public static String sql_regcase(String string) {
        StringBuilder sb = new StringBuilder();
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            if (Character.isLowerCase(ch)) {
                sb.append('[');
                sb.append(Character.toUpperCase(ch));
                sb.append(ch);
                sb.append(']');
                continue;
            }
            if (Character.isUpperCase(ch)) {
                sb.append('[');
                sb.append(ch);
                sb.append(Character.toLowerCase(ch));
                sb.append(']');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static Value split(Env env, StringValue patternString, StringValue string, @Optional(value="-1") long limit) {
        try {
            long count;
            if (limit < 0L) {
                limit = Long.MAX_VALUE;
            }
            patternString = CauchoRegexpModule.addDelimiters(env, patternString, "/", "/");
            Regexp regexp = CauchoRegexpModule.getRegexp(env, patternString, string);
            ArrayValueImpl result = new ArrayValueImpl();
            int head = 0;
            for (count = 0L; regexp.find() && count < limit; ++count) {
                StringValue value;
                if (count == limit - 1L) {
                    value = regexp.substring(env, head);
                    head = string.length();
                } else {
                    value = regexp.substring(env, head, regexp.start());
                    head = regexp.end();
                }
                ((ArrayValue)result).put(value);
            }
            if (head <= string.length() && count != limit) {
                ((ArrayValue)result).put(regexp.substring(env, head));
            }
            return result;
        }
        catch (IllegalRegexpException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return BooleanValue.FALSE;
        }
    }

    public static Value preg_grep(Env env, StringValue patternString, ArrayValue input, @Optional(value="0") int flag) {
        try {
            if (input == null) {
                return NullValue.NULL;
            }
            Regexp regexp = CauchoRegexpModule.getRegexp(env, patternString);
            ArrayValueImpl matchArray = new ArrayValueImpl();
            for (Map.Entry<Value, Value> entry : input.entrySet()) {
                Value entryValue = entry.getValue();
                Value entryKey = entry.getKey();
                regexp.init(env, entryValue.toStringValue());
                boolean found = regexp.find();
                if (!found && flag == 1) {
                    matchArray.append(entryKey, entryValue);
                    continue;
                }
                if (!found || flag == 1) continue;
                matchArray.append(entryKey, entryValue);
            }
            return matchArray;
        }
        catch (IllegalRegexpException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return BooleanValue.FALSE;
        }
    }

    public static Value spliti(Env env, StringValue patternString, StringValue string, @Optional(value="-1") long limit) {
        try {
            long count;
            if (limit < 0L) {
                limit = Long.MAX_VALUE;
            }
            patternString = CauchoRegexpModule.addDelimiters(env, patternString, "/", "/i");
            Regexp regexp = CauchoRegexpModule.getRegexp(env, patternString, string);
            ArrayValueImpl result = new ArrayValueImpl();
            int head = 0;
            for (count = 0L; regexp.find() && count < limit; ++count) {
                StringValue value;
                if (count == limit - 1L) {
                    value = string.substring(head);
                    head = string.length();
                } else {
                    value = string.substring(head, regexp.start());
                    head = regexp.end();
                }
                ((ArrayValue)result).put(value);
            }
            if (head <= string.length() && count != limit) {
                ((ArrayValue)result).put(string.substring(head));
            }
            return result;
        }
        catch (IllegalRegexpException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e);
            return BooleanValue.FALSE;
        }
    }

    private static Regexp getRegexp(Env env, StringValue rawRegexp, StringValue subject) throws IllegalRegexpException {
        Regexp regexp = CauchoRegexpModule.getRegexp(env, rawRegexp);
        regexp.init(env, subject);
        return regexp;
    }

    private static Regexp getRegexp(Env env, StringValue rawRegexp) throws IllegalRegexpException {
        Regexp regexp = (Regexp)_regexpCache.get((Object)rawRegexp);
        if (regexp != null) {
            return regexp.clone();
        }
        regexp = new Regexp(env, rawRegexp);
        _regexpCache.put((Object)rawRegexp, (Object)regexp);
        return regexp;
    }

    private static StringValue addDelimiters(Env env, StringValue str, String startDelim, String endDelim) {
        StringValue sb = str.createEmptyStringBuilder();
        sb = sb.appendBytes(startDelim);
        sb = sb.append(str);
        sb = sb.appendBytes(endDelim);
        return sb;
    }

    private static ArrayList<Replacement> compileReplacement(Env env, StringValue replacement, boolean isEval) {
        ArrayList<Replacement> program = new ArrayList<Replacement>();
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < replacement.length(); ++i) {
            char ch = replacement.charAt(i);
            if ((ch == '\\' || ch == '$') && i + 1 < replacement.length()) {
                int group;
                char digit = replacement.charAt(i + 1);
                if ('0' <= digit && digit <= '9') {
                    group = digit - 48;
                    if (++i + 1 < replacement.length() && '0' <= (digit = replacement.charAt(i + 1)) && digit <= '9') {
                        group = 10 * group + digit - 48;
                        ++i;
                    }
                    if (text.length() > 0) {
                        program.add(new TextReplacement(text));
                    }
                    if (isEval) {
                        program.add(new GroupEscapeReplacement(group));
                    } else {
                        program.add(new GroupReplacement(group));
                    }
                    text.setLength(0);
                    continue;
                }
                if (ch == '\\') {
                    ++i;
                    if (digit != '\\') {
                        text.append('\\');
                    }
                    text.append(digit);
                    continue;
                }
                if (digit == '{') {
                    i += 2;
                    group = 0;
                    while (i < replacement.length() && '0' <= (digit = replacement.charAt(i)) && digit <= '9') {
                        group = 10 * group + digit - 48;
                        ++i;
                    }
                    if (digit != '}') {
                        env.warning(L.l("bad regexp {0}", (Object)replacement));
                        throw new QuercusException("bad regexp");
                    }
                    if (text.length() > 0) {
                        program.add(new TextReplacement(text));
                    }
                    if (isEval) {
                        program.add(new GroupEscapeReplacement(group));
                    } else {
                        program.add(new GroupReplacement(group));
                    }
                    text.setLength(0);
                    continue;
                }
                text.append(ch);
                continue;
            }
            text.append(ch);
        }
        if (text.length() > 0) {
            program.add(new TextReplacement(text));
        }
        return program;
    }

    private static StringValue cleanEregRegexp(Env env, StringValue regexp, boolean isComments) {
        int len = regexp.length();
        StringValue sb = regexp.createEmptyStringBuilder();
        int quote = 0;
        boolean sawVerticalBar = false;
        block12: for (int i = 0; i < len; ++i) {
            char ch = regexp.charAt(i);
            if (sawVerticalBar && !Character.isWhitespace(ch) && ch != '#' && ch != '|') {
                sawVerticalBar = false;
            }
            switch (ch) {
                case '\\': {
                    if (quote == 91) {
                        sb = sb.appendByte(92);
                        sb = sb.appendByte(92);
                        continue block12;
                    }
                    if (i + 1 < len) {
                        if ((ch = regexp.charAt(++i)) == '0' || '1' <= ch && ch <= '3' && i + 1 < len && '0' <= regexp.charAt(i + 1) && ch <= '7') {
                            sb = sb.appendByte(92);
                            sb = sb.appendByte(48);
                            sb = sb.appendByte(ch);
                            continue block12;
                        }
                        if (ch == 'x' && i + 1 < len && regexp.charAt(i + 1) == '{') {
                            sb = sb.appendByte(92);
                            int tail = regexp.indexOf('}', i + 1);
                            if (tail > 0) {
                                StringValue hex = regexp.substring(i + 2, tail);
                                int length = hex.length();
                                if (length == 1) {
                                    sb = sb.appendBytes("x0" + hex);
                                } else if (length == 2) {
                                    sb = sb.appendBytes("x" + hex);
                                } else if (length == 3) {
                                    sb = sb.appendBytes("u0" + hex);
                                } else if (length == 4) {
                                    sb = sb.appendBytes("u" + hex);
                                } else {
                                    throw new QuercusRuntimeException(L.l("illegal hex escape"));
                                }
                                i = tail;
                                continue block12;
                            }
                            sb = sb.appendByte(92);
                            sb = sb.appendByte(120);
                            continue block12;
                        }
                        if (Character.isLetter(ch)) {
                            switch (ch) {
                                case 'A': 
                                case 'B': 
                                case 'D': 
                                case 'G': 
                                case 'P': 
                                case 'S': 
                                case 'W': 
                                case 'X': 
                                case 'Z': 
                                case 'a': 
                                case 'b': 
                                case 'c': 
                                case 'd': 
                                case 'e': 
                                case 'f': 
                                case 'n': 
                                case 'p': 
                                case 'r': 
                                case 's': 
                                case 't': 
                                case 'w': 
                                case 'x': 
                                case 'z': {
                                    sb = sb.appendByte(92);
                                    sb = sb.appendByte(ch);
                                    continue block12;
                                }
                            }
                            sb = sb.appendByte(ch);
                            continue block12;
                        }
                        sb = sb.appendByte(92);
                        sb = sb.appendByte(ch);
                        continue block12;
                    }
                    sb = sb.appendByte(92);
                    continue block12;
                }
                case '[': {
                    if (quote == 91) {
                        if (i + 1 < len && regexp.charAt(i + 1) == ':') {
                            sb = sb.appendByte(91);
                        } else {
                            sb = sb.appendByte(92);
                            sb = sb.appendByte(91);
                        }
                    } else if (i + 1 < len && regexp.charAt(i + 1) == '[' && (i + 2 >= len || regexp.charAt(i + 2) != ':')) {
                        sb = sb.appendByte(91);
                        sb = sb.appendByte(92);
                        sb = sb.appendByte(91);
                        ++i;
                    } else {
                        sb = sb.appendByte(91);
                    }
                    if (quote != 0) continue block12;
                    quote = 91;
                    continue block12;
                }
                case '#': {
                    if (quote == 91) {
                        sb = sb.appendByte(92);
                        sb = sb.appendByte(35);
                        continue block12;
                    }
                    if (isComments) {
                        sb = sb.appendByte(ch);
                        ++i;
                        while (i < len) {
                            ch = regexp.charAt(i);
                            sb = sb.appendByte(ch);
                            if (ch == '\n' || ch == '\r') continue block12;
                            ++i;
                        }
                        continue block12;
                    }
                    sb = sb.appendByte(ch);
                    continue block12;
                }
                case ']': {
                    sb = sb.appendByte(ch);
                    if (quote != 91) continue block12;
                    quote = 0;
                    continue block12;
                }
                case '{': {
                    if (i + 1 < len && ('0' <= (ch = regexp.charAt(i + 1)) && ch <= '9' || ch == ',')) {
                        sb = sb.appendByte(123);
                        ++i;
                        while (i < len && ('0' <= (ch = regexp.charAt(i)) && ch <= '9' || ch == ',')) {
                            sb = sb.appendByte(ch);
                            ++i;
                        }
                        if (i >= len) continue block12;
                        sb = sb.appendByte(regexp.charAt(i));
                        continue block12;
                    }
                    sb = sb.appendByte(92);
                    sb = sb.appendByte(123);
                    continue block12;
                }
                case '}': {
                    sb = sb.appendByte(92);
                    sb = sb.appendByte(125);
                    continue block12;
                }
                case '|': {
                    if (sawVerticalBar) continue block12;
                    sb = sb.appendByte(124);
                    sawVerticalBar = true;
                    continue block12;
                }
                default: {
                    sb = sb.appendByte(ch);
                }
            }
        }
        return sb;
    }

    static {
        CauchoRegexpModule.PREG_QUOTE[92] = true;
        CauchoRegexpModule.PREG_QUOTE[43] = true;
        CauchoRegexpModule.PREG_QUOTE[42] = true;
        CauchoRegexpModule.PREG_QUOTE[63] = true;
        CauchoRegexpModule.PREG_QUOTE[91] = true;
        CauchoRegexpModule.PREG_QUOTE[94] = true;
        CauchoRegexpModule.PREG_QUOTE[93] = true;
        CauchoRegexpModule.PREG_QUOTE[36] = true;
        CauchoRegexpModule.PREG_QUOTE[40] = true;
        CauchoRegexpModule.PREG_QUOTE[41] = true;
        CauchoRegexpModule.PREG_QUOTE[123] = true;
        CauchoRegexpModule.PREG_QUOTE[125] = true;
        CauchoRegexpModule.PREG_QUOTE[61] = true;
        CauchoRegexpModule.PREG_QUOTE[33] = true;
        CauchoRegexpModule.PREG_QUOTE[60] = true;
        CauchoRegexpModule.PREG_QUOTE[62] = true;
        CauchoRegexpModule.PREG_QUOTE[124] = true;
        CauchoRegexpModule.PREG_QUOTE[58] = true;
        CauchoRegexpModule.PREG_QUOTE[46] = true;
    }

    static class GroupNeighborMap {
        private int[] _neighborMap;
        private static int UNSET = -1;

        public GroupNeighborMap(CharSequence regexp, int groups) {
            this._neighborMap = new int[groups + 1];
            for (int i = 1; i <= groups; ++i) {
                this._neighborMap[i] = UNSET;
            }
            boolean sawEscape = false;
            boolean sawVerticalBar = false;
            boolean isLiteral = false;
            int group = 0;
            int parent = UNSET;
            int length = regexp.length();
            ArrayList<Boolean> openParenStack = new ArrayList<Boolean>(groups);
            for (int i = 0; i < length; ++i) {
                char ch = regexp.charAt(i);
                if (ch == ' ' || ch == '\t' || ch == '\n' || ch == 'r' || ch == '\f') continue;
                if (ch == '\\') {
                    sawEscape = !sawEscape;
                    continue;
                }
                if (ch == '[' && !sawEscape) {
                    isLiteral = true;
                    continue;
                }
                if (ch == ']' && !sawEscape) {
                    isLiteral = false;
                    continue;
                }
                if (isLiteral || sawEscape) {
                    sawEscape = false;
                    continue;
                }
                if (ch == '(') {
                    if (i + 1 < length && regexp.charAt(i + 1) == '?') {
                        openParenStack.add(true);
                        continue;
                    }
                    openParenStack.add(false);
                    ++group;
                    if (sawVerticalBar) {
                        sawVerticalBar = false;
                        this._neighborMap[group] = group - 1;
                        continue;
                    }
                    this._neighborMap[group] = parent;
                    parent = group;
                    continue;
                }
                if (ch == ')') {
                    if (((Boolean)openParenStack.remove(openParenStack.size() - 1)).booleanValue()) continue;
                    sawVerticalBar = false;
                    continue;
                }
                if (ch != '|') continue;
                sawVerticalBar = true;
            }
        }

        public boolean hasNeighbor(int group) {
            return this._neighborMap[group] != UNSET;
        }

        public int getNeighbor(int group) {
            return this._neighborMap[group];
        }
    }

    static class GroupEscapeReplacement
    extends Replacement {
        private int _group;

        GroupEscapeReplacement(int group) {
            this._group = group;
        }

        StringValue eval(Env env, StringValue sb, Regexp regexp) {
            if (this._group <= regexp.groupCount()) {
                StringValue group = regexp.group(env, this._group);
                int len = group.length();
                for (int i = 0; i < len; ++i) {
                    char ch = group.charAt(i);
                    if (ch == '\'') {
                        sb = sb.appendByte(92);
                        sb = sb.appendByte(39);
                        continue;
                    }
                    if (ch == '\"') {
                        sb = sb.appendByte(92);
                        sb = sb.appendByte(34);
                        continue;
                    }
                    sb = sb.appendByte(ch);
                }
            }
            return sb;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._group + "]";
        }
    }

    static class GroupReplacement
    extends Replacement {
        private int _group;

        GroupReplacement(int group) {
            this._group = group;
        }

        StringValue eval(Env env, StringValue sb, Regexp regexp) {
            if (this._group <= regexp.groupCount()) {
                sb = sb.append(regexp.group(env, this._group));
            }
            return sb;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._group + "]";
        }
    }

    static class TextReplacement
    extends Replacement {
        private char[] _text;

        TextReplacement(StringBuilder text) {
            int length = text.length();
            this._text = new char[length];
            text.getChars(0, length, this._text, 0);
        }

        StringValue eval(Env env, StringValue sb, Regexp regexp) {
            return sb.appendBytes(this._text, 0, this._text.length);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName());
            sb.append('[');
            for (char ch : this._text) {
                sb.append(ch);
            }
            sb.append(']');
            return sb.toString();
        }
    }

    static abstract class Replacement {
        Replacement() {
        }

        abstract StringValue eval(Env var1, StringValue var2, Regexp var3);

        public String toString() {
            return this.getClass().getSimpleName() + "[]";
        }
    }
}

