/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.regexp;

import com.caucho.quercus.lib.regexp.RegexpSet;
import com.caucho.util.CharBuffer;

class Node {
    static final int RC_END = 0;
    static final int RC_NULL = 1;
    static final int RC_STRING = 2;
    static final int RC_SET = 3;
    static final int RC_NSET = 4;
    static final int RC_BEG_GROUP = 5;
    static final int RC_END_GROUP = 6;
    static final int RC_GROUP_REF = 7;
    static final int RC_LOOP = 8;
    static final int RC_LOOP_INIT = 9;
    static final int RC_LOOP_SHORT = 10;
    static final int RC_LOOP_UNIQUE = 11;
    static final int RC_LOOP_SHORT_UNIQUE = 12;
    static final int RC_LOOP_LONG = 13;
    static final int RC_OR = 64;
    static final int RC_OR_UNIQUE = 65;
    static final int RC_POS_LOOKAHEAD = 66;
    static final int RC_NEG_LOOKAHEAD = 67;
    static final int RC_POS_LOOKBEHIND = 68;
    static final int RC_NEG_LOOKBEHIND = 69;
    static final int RC_LOOKBEHIND_OR = 70;
    static final int RC_WORD = 73;
    static final int RC_NWORD = 74;
    static final int RC_BLINE = 75;
    static final int RC_ELINE = 76;
    static final int RC_BSTRING = 77;
    static final int RC_ESTRING = 78;
    static final int RC_ENSTRING = 79;
    static final int RC_GSTRING = 80;
    static final int RC_COND = 81;
    static final int RC_STRING_I = 128;
    static final int RC_SET_I = 129;
    static final int RC_NSET_I = 130;
    static final int RC_GROUP_REF_I = 131;
    static final int RC_LEXEME = 256;
    static final int RC_UNICODE = 512;
    static final int RC_NUNICODE = 513;
    static final int RC_C = 1024;
    static final int RC_L = 1025;
    static final int RC_M = 1026;
    static final int RC_N = 1027;
    static final int RC_P = 1028;
    static final int RC_S = 1029;
    static final int RC_Z = 1030;
    static final int RC_NC = 1031;
    static final int RC_NL = 1032;
    static final int RC_NM = 1033;
    static final int RC_NN = 1034;
    static final int RC_NP = 1035;
    static final int RC_NS = 1036;
    static final int RC_NZ = 1037;
    static final int RC_CHAR_CLASS = 2048;
    static final int RC_ALNUM = 1;
    static final int RC_ALPHA = 2;
    static final int RC_BLANK = 3;
    static final int RC_CNTRL = 4;
    static final int RC_DIGIT = 5;
    static final int RC_GRAPH = 6;
    static final int RC_LOWER = 7;
    static final int RC_PRINT = 8;
    static final int RC_PUNCT = 9;
    static final int RC_SPACE = 10;
    static final int RC_UPPER = 11;
    static final int RC_XDIGIT = 12;
    static Node END = new Node(0);
    Node _rest = END;
    int _code;
    CharBuffer _string;
    RegexpSet _set;
    int _index;
    int _min;
    int _max;
    Node _branch;
    Node _condition;
    Node _nBranch;
    int _length;
    boolean _mark;
    boolean _printMark;
    byte _unicodeCategory;
    static int _count = 0;
    int _id = -1;

    public static String code(Node node) {
        if (node == null) {
            return "null";
        }
        return Node.code(node._code) + node._id;
    }

    public static String code(int code) {
        switch (code) {
            case 0: {
                return "RC_END";
            }
            case 1: {
                return "RC_NULL";
            }
            case 2: {
                return "RC_STRING";
            }
            case 3: {
                return "RC_SET";
            }
            case 4: {
                return "RC_NSET";
            }
            case 5: {
                return "RC_BEG_GROUP";
            }
            case 6: {
                return "RC_END_GROUP";
            }
            case 7: {
                return "RC_GROUP_REF";
            }
            case 8: {
                return "RC_LOOP";
            }
            case 9: {
                return "RC_LOOP_INIT";
            }
            case 10: {
                return "RC_LOOP_SHORT";
            }
            case 11: {
                return "RC_LOOP_UNIQUE";
            }
            case 12: {
                return "RC_LOOP_SHORT_UNIQUE";
            }
            case 13: {
                return "RC_LOOP_LONG";
            }
            case 64: {
                return "RC_OR";
            }
            case 65: {
                return "RC_OR_UNIQUE";
            }
            case 66: {
                return "RC_POS_PEEK";
            }
            case 67: {
                return "RC_NEG_PEEK";
            }
            case 73: {
                return "RC_WORD";
            }
            case 74: {
                return "RC_NWORD";
            }
            case 75: {
                return "RC_BLINE";
            }
            case 76: {
                return "RC_ELINE";
            }
            case 77: {
                return "RC_BSTRING";
            }
            case 78: {
                return "RC_ESTRING";
            }
            case 79: {
                return "RC_ENSTRING";
            }
            case 80: {
                return "RC_GSTRING";
            }
            case 81: {
                return "RC_COND";
            }
            case 68: {
                return "RC_POS_LOOKBEHIND";
            }
            case 69: {
                return "RC_NEG_LOOKBEHIND";
            }
            case 70: {
                return "RC_LOOKBEHIND_OR";
            }
            case 128: {
                return "RC_STRING_I";
            }
            case 129: {
                return "RC_SET_I";
            }
            case 130: {
                return "RC_NSET_I";
            }
            case 131: {
                return "RC_GROUP_REF_I";
            }
            case 256: {
                return "RC_LEXEME";
            }
        }
        return "unknown(" + code + ")";
    }

    Node(int code) {
        this._code = code;
        this._id = _count++;
    }

    Node(int code, int index) {
        this(code);
        this._index = index;
    }

    Node(int code, Node branch) {
        this(code);
        this._branch = branch;
    }

    Node(int code, int index, int min, int max) {
        this(code);
        this._index = index;
        this._min = min;
        this._max = max;
    }

    Node(int code, RegexpSet set) {
        this(code);
        this._set = set;
        this._length = 1;
    }

    Node(CharBuffer buf) {
        this(2);
        this._string = buf;
    }

    static Node removeTail(Node head) {
        Node tail = head._rest;
        if (head == null || tail == null) {
            return null;
        }
        if (tail._rest == null) {
            head._rest = null;
            return tail;
        }
        return Node.removeTail(tail);
    }

    static Node spliceNonNullTail(Node head) {
        Node tail = head._rest;
        if (head == null || tail == null) {
            return null;
        }
        if (tail._rest == null || tail._code == 0 || tail._code == 1) {
            head._rest = null;
            tail._rest = null;
            return tail;
        }
        return Node.spliceNonNullTail(tail);
    }

    static Node replaceTail(Node node, Node tail) {
        if (node == null || node._code == 0 || node == tail) {
            return tail;
        }
        if (node._code == 64) {
            node._branch = Node.replaceTail(node._branch, tail);
        }
        node._rest = Node.replaceTail(node._rest, tail);
        return node;
    }

    static Node concat(Node head, Node tail) {
        if (head == null || head._code == 0) {
            return tail;
        }
        Node node = head;
        while (node._rest != null && node._rest._code != 0) {
            node = node._rest;
        }
        node._rest = tail;
        return head;
    }

    public Object clone() {
        Node node = new Node(this._code);
        node._rest = this._rest;
        node._string = this._string;
        node._set = this._set;
        node._index = this._index;
        node._min = this._min;
        node._max = this._max;
        node._branch = this._branch;
        node._length = this._length;
        node._unicodeCategory = this._unicodeCategory;
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this._printMark) {
            return "...";
        }
        this._printMark = true;
        try {
            switch (this._code) {
                case 0: {
                    String string = "";
                    return string;
                }
                case 2: {
                    String string = this._string.toString() + (this._rest == null ? "" : this._rest.toString());
                    return string;
                }
                case 64: {
                    String string = "(?:" + this._branch + "|" + this._rest + ")";
                    return string;
                }
                case 65: {
                    String string = "(?:" + this._branch + "|!" + this._rest + ")";
                    return string;
                }
                case 78: {
                    String string = "\\Z" + (this._rest == null ? "" : this._rest.toString());
                    return string;
                }
                case 9: {
                    String string = this._rest.toString();
                    return string;
                }
                case 8: {
                    String string = "(?:" + this._branch + "){" + this._min + "," + this._max + "}" + (this._rest == null ? "" : this._rest.toString());
                    return string;
                }
                case 11: {
                    String string = "(?:" + this._branch + ")!{" + this._min + "," + this._max + "}" + (this._rest == null ? "" : this._rest.toString());
                    return string;
                }
                case 5: {
                    String string = "(" + (this._rest == null ? "" : this._rest.toString());
                    return string;
                }
                case 6: {
                    String string = ")" + (this._rest == null ? "" : this._rest.toString());
                    return string;
                }
                case 3: {
                    String string = "[" + this._set + "]" + (this._rest == null ? "" : this._rest.toString());
                    return string;
                }
                case 4: {
                    String string = "[^" + this._set + "]" + (this._rest == null ? "" : this._rest.toString());
                    return string;
                }
            }
            String string = "" + this._code + " " + super.toString();
            return string;
        }
        finally {
            this._printMark = false;
        }
    }

    char charAt(int index) {
        return this._string.charAt(index);
    }
}

