/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.regexp;

import com.caucho.quercus.lib.regexp.Node;
import com.caucho.quercus.lib.regexp.RegexpSet;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;

class RegOptim {
    RegOptim() {
    }

    static void ignoreCase(Node node) {
        while (node != null) {
            switch (node._code) {
                case 3: {
                    node._code = 129;
                    break;
                }
                case 4: {
                    node._code = 130;
                    break;
                }
                case 2: {
                    node._code = 128;
                    break;
                }
                case 7: {
                    node._code = 131;
                }
            }
            RegOptim.ignoreCase(node._branch);
            node = node._rest;
        }
    }

    static int minLength(Node node) {
        if (node == null) {
            return 0;
        }
        switch (node._code) {
            case 3: 
            case 4: 
            case 129: 
            case 130: {
                return 1 + RegOptim.minLength(node._rest);
            }
            case 2: 
            case 128: {
                return node._string.length() + RegOptim.minLength(node._rest);
            }
            case 64: 
            case 65: {
                return Math.min(RegOptim.minLength(node._branch), RegOptim.minLength(node._rest));
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                return node._min * RegOptim.minLength(node._branch) + RegOptim.minLength(node._rest);
            }
        }
        return RegOptim.minLength(node._rest);
    }

    static CharBuffer prefix(Node node) {
        if (node == null) {
            return null;
        }
        switch (node._code) {
            case 5: 
            case 6: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 80: {
                return RegOptim.prefix(node._rest);
            }
            case 66: {
                return RegOptim.prefix(node._branch);
            }
            case 2: 
            case 128: {
                return node._string;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                if (node._min > 0) {
                    return RegOptim.prefix(node._branch);
                }
                return null;
            }
        }
        return null;
    }

    private static CharBuffer findMust(Node node) {
        if (node == null) {
            return null;
        }
        switch (node._code) {
            case 2: {
                CharBuffer string1 = RegOptim.findMust(node._rest);
                return string1 != null ? string1 : node._string;
            }
            case 64: 
            case 65: {
                CharBuffer string1 = RegOptim.findMust(node._branch);
                CharBuffer string2 = RegOptim.findMust(node._rest);
                if (string1 != null && string2 != null && string1.equals((CharSegment)string2)) {
                    return string1;
                }
                return null;
            }
            case 8: 
            case 10: 
            case 11: {
                CharBuffer string1 = RegOptim.findMust(node._rest);
                if (string1 != null) {
                    return string1;
                }
                if (node._min > 0) {
                    return RegOptim.findMust(node._branch);
                }
                return null;
            }
            case 66: {
                CharBuffer string1 = RegOptim.findMust(node._rest);
                if (string1 != null) {
                    return string1;
                }
                return RegOptim.findMust(node._branch);
            }
        }
        return RegOptim.findMust(node._rest);
    }

    private static Node linkLoops(Node node, Node loop, boolean canDeriveNull) {
        if (node == null && loop != null && canDeriveNull) {
            if (loop._min > 0) {
                loop._min = 1;
            }
            return loop;
        }
        if (node == null) {
            return loop;
        }
        switch (node._code) {
            case 0: 
            case 1: {
                return RegOptim.linkLoops(node._rest, loop, canDeriveNull);
            }
            case 64: 
            case 65: {
                if (node._mark) {
                    return node;
                }
                node._mark = true;
                node._branch = RegOptim.linkLoops(node._branch, loop, canDeriveNull);
                node._rest = RegOptim.linkLoops(node._rest, loop, canDeriveNull);
                return node;
            }
            case 8: 
            case 10: 
            case 11: {
                if (node._mark) {
                    if (canDeriveNull && node._min > 0) {
                        node._min = 1;
                    }
                    return node;
                }
                node._mark = true;
                node._branch = RegOptim.linkLoops(node._branch, node, true);
                node._rest = RegOptim.linkLoops(node._rest, loop, canDeriveNull);
                Node init = new Node(9);
                init._rest = node;
                return init;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                node._rest = RegOptim.linkLoops(node._rest, loop, false);
                return node;
            }
            case 68: 
            case 69: {
                node._branch = RegOptim.linkLoops(node._branch, loop, canDeriveNull);
                return node;
            }
        }
        node._rest = RegOptim.linkLoops(node._rest, loop, canDeriveNull);
        return node;
    }

    static Node linkLoops(Node node) {
        return RegOptim.linkLoops(node, null, true);
    }

    static void eliminateBacktrack(Node node, Node rest) {
        if (node == null) {
            return;
        }
        switch (node._code) {
            case 10: {
                RegOptim.eliminateBacktrack(node._branch, node._rest);
                RegOptim.eliminateBacktrack(node._rest, rest);
                if (RegOptim.firstset(node._branch, null) && node._min > 0) {
                    node._min = 1;
                }
                return;
            }
            case 8: {
                break;
            }
            case 64: 
            case 65: {
                RegexpSet right;
                RegOptim.eliminateBacktrack(node._branch, rest);
                RegOptim.eliminateBacktrack(node._rest, rest);
                boolean emptyFirst = false;
                RegexpSet left = new RegexpSet();
                if (RegOptim.firstset(node._branch, left)) {
                    emptyFirst = RegOptim.firstset(rest, left);
                }
                if (RegOptim.firstset(node._rest, right = new RegexpSet())) {
                    RegOptim.firstset(rest, right);
                }
                if (!emptyFirst && right.mergeOverlap(left)) {
                    node._code = 65;
                    node._set = left;
                }
                return;
            }
            case 66: 
            case 67: {
                RegOptim.eliminateBacktrack(node._branch, rest);
                RegOptim.eliminateBacktrack(node._rest, rest);
                return;
            }
            default: {
                RegOptim.eliminateBacktrack(node._rest, rest);
                return;
            }
        }
    }

    private static boolean firstset(Node node, RegexpSet set) {
        if (node == null) {
            return true;
        }
        switch (node._code) {
            case 7: 
            case 131: {
                return false;
            }
            case 2: {
                char ch = node._string.charAt(0);
                if (set != null) {
                    set.setRange(ch, ch);
                }
                return false;
            }
            case 3: {
                if (set != null) {
                    set.mergeOr(node._set);
                }
                return false;
            }
            case 4: {
                if (set != null) {
                    set.mergeOrInv(node._set);
                }
                return false;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                if (RegOptim.firstset(node._branch, set)) {
                    if (node._min > 0) {
                        node._min = 1;
                    }
                    return RegOptim.firstset(node._rest, set);
                }
                if (node._min == 0) {
                    boolean isFirst = RegOptim.firstset(node._rest, set);
                    return isFirst;
                }
                return false;
            }
            case 64: 
            case 65: {
                if (RegOptim.firstset(node._branch, set)) {
                    RegOptim.firstset(node._rest, set);
                    return true;
                }
                return RegOptim.firstset(node._rest, set);
            }
            case 66: {
                RegexpSet lookahead = new RegexpSet();
                boolean result = RegOptim.firstset(node._rest, set);
                if (set != null && RegOptim.firstset(node._branch, lookahead)) {
                    set.mergeOr(lookahead);
                } else {
                    set.mergeOverlap(lookahead);
                }
                return result;
            }
        }
        return RegOptim.firstset(node._rest, set);
    }

    static Node appendLexemeValue(Node node, int lexeme) {
        if (node == null || node._code == 0 || node._code == 256) {
            node = new Node(256, lexeme);
            node._rest = null;
            return node;
        }
        node._rest = RegOptim.appendLexemeValue(node._rest, lexeme);
        if (node._code == 64) {
            node._branch = RegOptim.appendLexemeValue(node._branch, lexeme);
        }
        return node;
    }

    static Node appendLexeme(Node parent, Node child, int lexeme) {
        child = RegOptim.appendLexemeValue(child, lexeme);
        if (parent == null) {
            return child;
        }
        parent = new Node(64, parent);
        parent._rest = child;
        return parent;
    }
}

