/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.regexp;

import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.regexp.IllegalRegexpException;
import com.caucho.quercus.lib.regexp.Node;
import com.caucho.quercus.lib.regexp.PeekStream;
import com.caucho.quercus.lib.regexp.RegexpSet;
import com.caucho.util.CharBuffer;
import java.util.HashMap;

class Regcomp {
    static final int MULTILINE = 1;
    static final int SINGLE_LINE = 2;
    static final int IGNORE_CASE = 4;
    static final int IGNORE_WS = 8;
    static final int GLOBAL = 16;
    static final int ANCHORED = 32;
    static final int END_ONLY = 64;
    static final int UNGREEDY = 128;
    static final int STRICT = 256;
    static final HashMap<String, Integer> _characterClassMap = new HashMap();
    int _nGroup;
    int _maxGroup;
    int _nLoop;
    int _flags;
    HashMap<Integer, StringValue> _groupNameMap = new HashMap();
    HashMap<StringValue, Integer> _groupNameReverseMap = new HashMap();
    boolean _isLookbehind;
    boolean _isOr;

    Regcomp(int flags) {
        this._flags = flags;
    }

    Node parse(PeekStream pattern) throws IllegalRegexpException {
        this._nGroup = 0;
        Node value = this.parseRec(pattern);
        if (this._nGroup > this._maxGroup) {
            this._maxGroup = this._nGroup;
        }
        if ((this._flags & 0x20) != 0) {
            Node node = new Node(77);
            node._rest = value;
            value = node;
        }
        return value;
    }

    private Node parseRec(PeekStream pattern) throws IllegalRegexpException {
        return this.parseRec(pattern, false);
    }

    /*
     * Unable to fully structure code
     */
    private Node parseRec(PeekStream pattern, boolean isConditional) throws IllegalRegexpException {
        head = null;
        last = null;
        lastNonWhitespaceChar = -1;
        block32: while ((ch = pattern.read()) >= 0) {
            if ((this._flags & 8) == 0 || !RegexpSet.SPACE.match(ch) && ch != 35) {
                lastNonWhitespaceChar = ch;
            }
            switch (ch) {
                case 42: {
                    if (last == null) {
                        throw new IllegalRegexpException("`*' must follow content expression");
                    }
                    if (pattern.peek() == 63) {
                        pattern.read();
                        node = (this._flags & 128) != 0 ? new Node(8, this._nLoop++, 0, 0x7FFFFFFF) : new Node(10, this._nLoop++, 0, 0x7FFFFFFF);
                    } else if (pattern.peek() == 43) {
                        pattern.read();
                        node = new Node(13, this._nLoop++, 0, 0x7FFFFFFF);
                    } else {
                        node = (this._flags & 128) != 0 ? new Node(10, this._nLoop++, 0, 0x7FFFFFFF) : new Node(8, this._nLoop++, 0, 0x7FFFFFFF);
                    }
                    node._branch = last;
                    last = node;
                    break;
                }
                case 43: {
                    if (last == null) {
                        throw new IllegalRegexpException("`+' must follow content expression");
                    }
                    if (pattern.peek() == 63) {
                        pattern.read();
                        node = (this._flags & 128) != 0 ? new Node(8, this._nLoop++, 1, 0x7FFFFFFF) : new Node(10, this._nLoop++, 1, 0x7FFFFFFF);
                    } else if (pattern.peek() == 43) {
                        pattern.read();
                        node = new Node(13, this._nLoop++, 1, 0x7FFFFFFF);
                    } else {
                        node = (this._flags & 128) != 0 ? new Node(10, this._nLoop++, 1, 0x7FFFFFFF) : new Node(8, this._nLoop++, 1, 0x7FFFFFFF);
                    }
                    node._branch = last;
                    last = node;
                    break;
                }
                case 63: {
                    if (last == null) {
                        throw new IllegalRegexpException("`?' must follow content expression");
                    }
                    if (pattern.peek() == 63) {
                        pattern.read();
                        node = (this._flags & 128) != 0 ? new Node(8, this._nLoop++, 0, 1) : new Node(10, this._nLoop++, 0, 1);
                    } else if (pattern.peek() == 43) {
                        pattern.read();
                        node = new Node(13, this._nLoop++, 0, 1);
                    } else {
                        node = (this._flags & 128) != 0 ? new Node(10, this._nLoop++, 0, 1) : new Node(8, this._nLoop++, 0, 1);
                    }
                    node._branch = last;
                    last = node;
                    break;
                }
                case 123: {
                    ch = pattern.peek();
                    if (ch < 48 || ch > 57) {
                        next = this.parseString(123, pattern, last);
                        if (next == last) continue block32;
                        head = Node.concat(head, last);
                        last = next;
                        break;
                    }
                    if (last == null) {
                        throw new IllegalRegexpException("`{' must follow content expression");
                    }
                    node = new Node(8);
                    ++this._nLoop;
                    node._index = node._index;
                    node._branch = last;
                    node._length = node._branch._length * node._min;
                    this.parseBrace(pattern, node);
                    ch = pattern.read();
                    if (ch != 125) {
                        throw new IllegalRegexpException("expected `}' at " + this.badChar(ch));
                    }
                    if (pattern.peek() == 63) {
                        pattern.read();
                        node._code = 10;
                    } else if (pattern.peek() == 43) {
                        pattern.read();
                        node._code = 13;
                    }
                    if (this._isLookbehind && node._min != node._max) {
                        throw new IllegalRegexpException("lookbehind strings must be fixed length: " + node._min + " != " + node._max);
                    }
                    node._length = length = node._branch._length * node._min;
                    last = node;
                    break;
                }
                case 124: {
                    if (isConditional) {
                        pattern.ungetc(ch);
                        return last;
                    }
                    if (last == null && head != null) {
                        if (head._code == 64) continue block32;
                        if (head._code == 70) break;
                    }
                    node = Node.concat(head, last);
                    head = new Node(64, node);
                    if (this._isLookbehind) {
                        head._code = 70;
                    }
                    head._length = node._length;
                    last = null;
                    break;
                }
                case 40: {
                    head = Node.concat(head, last);
                    if (pattern.peek() != 63) ** GOTO lbl226
                    pattern.read();
                    ch = pattern.read();
                    switch (ch) {
                        case 35: {
                            while ((ch = pattern.read()) >= 0 && ch != 41) {
                            }
                            pattern.ungetc(ch);
                            last = null;
                            break;
                        }
                        case 58: {
                            last = this.parseRec(pattern);
                            last = Node.replaceTail(last, new Node(1));
                            break;
                        }
                        case 62: {
                            last = this.parseRec(pattern);
                            break;
                        }
                        case 61: {
                            last = new Node(66, this.parseRec(pattern));
                            break;
                        }
                        case 33: {
                            last = new Node(67, this.parseRec(pattern));
                            break;
                        }
                        case 60: {
                            ch = pattern.read();
                            if (ch == 61) {
                                last = new Node(68);
                            } else if (ch == 33) {
                                last = new Node(69);
                            } else {
                                throw new IllegalRegexpException("expected `}' at " + this.badChar(ch));
                            }
                            this._isLookbehind = true;
                            node = this.parseRec(pattern);
                            this._isLookbehind = false;
                            last._branch = node;
                            if (node != null) {
                                last._length = node._length;
                                break;
                            }
                            ** GOTO lbl233
                        }
                        case 80: {
                            name = pattern.createStringBuilder();
                            ch = pattern.read();
                            if (ch == 60) {
                                while ((ch = pattern.read()) != 62 && ch >= 0) {
                                    name.append((char)ch);
                                }
                                groupIndex = ++this._nGroup;
                                last = new Node(5, groupIndex);
                                last._rest = this.parseRec(pattern);
                                last._length = last._rest._length;
                                node = new Node(6, groupIndex);
                                last = Node.replaceTail(last, node);
                                this._groupNameMap.put(groupIndex, name);
                                this._groupNameReverseMap.put(name, groupIndex);
                                break;
                            }
                            if (ch == 61) {
                                while ((ch = pattern.peek()) != 41 && ch >= 0) {
                                    pattern.read();
                                    name.append((char)ch);
                                }
                                groupIndex = this._groupNameReverseMap.get(name);
                                if (groupIndex == null) {
                                    throw new IllegalRegexpException("undeclared group reference '" + name + "'");
                                }
                                last = new Node(7, groupIndex);
                                break;
                            }
                            throw new IllegalRegexpException("expected '<' or '=' at " + this.badChar(ch));
                        }
                        case 40: {
                            condition = null;
                            ch = pattern.peek();
                            condition = 48 <= ch && ch <= 57 ? this.parseBackReference(pattern.read(), pattern, last) : null;
                            ch = pattern.read();
                            if (ch != 41) {
                                throw new IllegalRegexpException("expected `)' at " + this.badChar(ch));
                            }
                            yesPattern = this.parseRec(pattern, true);
                            noPattern = null;
                            if (pattern.peek() == 124) {
                                pattern.read();
                                noPattern = this.parseRec(pattern, true);
                            }
                            last = new Node(81, condition._index);
                            last._condition = condition;
                            last._branch = yesPattern;
                            last._nBranch = noPattern;
                            break;
                        }
                        case 103: 
                        case 105: 
                        case 109: 
                        case 115: 
                        case 120: {
                            do {
                                switch (ch) {
                                    case 109: {
                                        this._flags |= 1;
                                        break;
                                    }
                                    case 105: {
                                        this._flags |= 4;
                                        break;
                                    }
                                    case 115: {
                                        this._flags |= 2;
                                        break;
                                    }
                                    case 120: {
                                        this._flags |= 8;
                                        break;
                                    }
                                    case 103: {
                                        this._flags |= 16;
                                        break;
                                    }
                                    default: {
                                        throw new IllegalRegexpException("expected one of `misxg' at " + this.badChar(ch));
                                    }
                                }
                            } while ((ch = pattern.read()) >= 0 && ch != 41);
                            pattern.ungetc(ch);
                            last = null;
                            break;
                        }
                        default: {
                            throw new IllegalRegexpException("expected `(?' code at " + this.badChar(ch));
                        }
                    }
                    ** GOTO lbl233
lbl226:
                    // 1 sources

                    groupIndex = ++this._nGroup;
                    last = new Node(5, groupIndex);
                    last._rest = this.parseRec(pattern);
                    if (last._rest != null) {
                        last._length = last._rest._length;
                    }
                    node = new Node(6, groupIndex);
                    last = Node.replaceTail(last, node);
lbl233:
                    // 3 sources

                    if ((ch = pattern.read()) == 41) continue block32;
                    throw new IllegalRegexpException("expected `)' at " + this.badChar(ch));
                }
                case 41: {
                    pattern.ungetc(ch);
                    return Node.concat(head, last);
                }
                case 91: {
                    head = Node.concat(head, last);
                    if (pattern.peek() == 58) {
                        throw new IllegalRegexpException("POSIX [::] class outside []");
                    }
                    last = this.parseSet(pattern);
                    ch = pattern.read();
                    if (ch == 93) continue block32;
                    throw new IllegalRegexpException("expected `]' at " + this.badChar(ch));
                }
                case 46: {
                    head = Node.concat(head, last);
                    if ((this._flags & 2) == 0) {
                        last = new Node(4, RegexpSet.DOT);
                        break;
                    }
                    last = new Node(4, new RegexpSet());
                    break;
                }
                case 92: {
                    next = this.parseSlash(pattern, last);
                    if (next != last) {
                        head = Node.concat(head, last);
                    }
                    last = next;
                    break;
                }
                case 94: {
                    head = Node.concat(head, last);
                    if ((this._flags & 1) != 0) {
                        last = new Node(75);
                        break;
                    }
                    last = new Node(77);
                    break;
                }
                case 36: {
                    head = Node.concat(head, last);
                    if ((this._flags & 1) != 0) {
                        last = new Node(76);
                        break;
                    }
                    if ((this._flags & 64) != 0) {
                        last = new Node(78);
                        break;
                    }
                    last = new Node(79);
                    break;
                }
                default: {
                    next = this.parseString(ch, pattern, last);
                    if (next == last) continue block32;
                    head = Node.concat(head, last);
                    last = next;
                }
            }
        }
        return Node.concat(head, last);
    }

    private void parseBrace(PeekStream pattern, Node loop) {
        int ch;
        loop._min = 0;
        while ((ch = pattern.read()) >= 48 && ch <= 57) {
            loop._min = 10 * loop._min + ch - 48;
        }
        if (ch != 44) {
            loop._max = loop._min;
            pattern.ungetc(ch);
            return;
        }
        loop._max = Integer.MAX_VALUE;
        while ((ch = pattern.read()) >= 48 && ch <= 57) {
            loop._max = loop._max == Integer.MAX_VALUE ? 0 : loop._max;
            loop._max = 10 * loop._max + ch - 48;
        }
        pattern.ungetc(ch);
    }

    private String hex(int value) {
        CharBuffer cb = new CharBuffer();
        for (int b = 3; b >= 0; --b) {
            int v = value >> 4 * b & 0xF;
            if (v < 10) {
                cb.append((char)(v + 48));
                continue;
            }
            cb.append((char)(v - 10 + 97));
        }
        return cb.toString();
    }

    private String badChar(int ch) {
        if (ch >= 32 && ch <= 127) {
            return "`" + (char)ch + "'";
        }
        if ((ch & 0xFFFF) == 65535) {
            return "end of expression";
        }
        return "`" + (char)ch + "' (\\u" + this.hex(ch) + ")";
    }

    private Node parseSet(PeekStream pattern) throws IllegalRegexpException {
        int ch;
        RegexpSet set;
        Node node;
        int first = pattern.peek();
        if (first == 94) {
            pattern.read();
            node = new Node(4);
            node._length = 1;
        } else {
            node = new Node(3);
            node._length = 1;
        }
        node._set = set = new RegexpSet();
        int last = -1;
        int lastdash = -1;
        int charRead = 0;
        while ((ch = pattern.read()) >= 0) {
            boolean isDash;
            ++charRead;
            if (ch == 93) {
                if (charRead != 1 || first != 94) break;
                pattern.ungetc(ch);
                ch = 92;
            }
            boolean isChar = true;
            boolean bl = isDash = ch == 45;
            if (ch == 92) {
                isChar = false;
                ch = pattern.read();
                switch (ch) {
                    case 115: {
                        set.mergeOr(RegexpSet.SPACE);
                        break;
                    }
                    case 83: {
                        set.mergeOrInv(RegexpSet.SPACE);
                        break;
                    }
                    case 100: {
                        set.mergeOr(RegexpSet.DIGIT);
                        break;
                    }
                    case 68: {
                        set.mergeOrInv(RegexpSet.DIGIT);
                        break;
                    }
                    case 119: {
                        set.mergeOr(RegexpSet.WORD);
                        break;
                    }
                    case 87: {
                        set.mergeOrInv(RegexpSet.WORD);
                        break;
                    }
                    case 98: {
                        ch = 8;
                        isChar = true;
                        break;
                    }
                    case 110: {
                        ch = 10;
                        isChar = true;
                        break;
                    }
                    case 116: {
                        ch = 9;
                        isChar = true;
                        break;
                    }
                    case 114: {
                        ch = 13;
                        isChar = true;
                        break;
                    }
                    case 102: {
                        ch = 12;
                        isChar = true;
                        break;
                    }
                    case 120: {
                        ch = this.parseHex(pattern);
                        isChar = true;
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        ch = this.parseOctal(ch, pattern);
                        isChar = true;
                        break;
                    }
                    default: {
                        isChar = true;
                        break;
                    }
                }
            } else if (ch == 91 && pattern.peek() == 58) {
                isChar = false;
                pattern.read();
                set.mergeOr(this.parseCharacterClass(pattern));
            }
            if (isDash && last != -1 && lastdash == -1) {
                lastdash = last;
                continue;
            }
            if (isChar && lastdash != -1) {
                if (lastdash > ch) {
                    throw new IllegalRegexpException("expected increasing range at " + this.badChar(ch));
                }
                set.setRange(lastdash, ch);
                last = -1;
                lastdash = -1;
                continue;
            }
            if (lastdash != -1) {
                set.setRange(lastdash, lastdash);
                set.setRange(45, 45);
                last = -1;
                lastdash = -1;
                continue;
            }
            if (last != -1) {
                set.setRange(last, last);
                if (!isChar) continue;
                last = ch;
                continue;
            }
            if (!isChar) continue;
            last = ch;
        }
        if (lastdash != -1) {
            set.setRange(lastdash, lastdash);
            set.setRange(45, 45);
        } else if (last != -1) {
            set.setRange(last, last);
        }
        if (ch == 93) {
            pattern.ungetc(ch);
        }
        return node;
    }

    private Node parseString(int ch, PeekStream pattern, Node last) throws IllegalRegexpException {
        return this.parseString(ch, pattern, last, false);
    }

    private Node parseString(int ch, PeekStream pattern, Node last, boolean isEscaped) throws IllegalRegexpException {
        if ((this._flags & 8) != 0 && !isEscaped) {
            if (RegexpSet.SPACE.match(ch)) {
                return last;
            }
            if (ch == 35) {
                while ((ch = pattern.read()) != 10 && ch >= 0) {
                }
                return last;
            }
        }
        int next = pattern.read();
        if (last == null || last._code != 2 || last._rest != null && last._rest._code != 0 || next == 42 || next == 63 || next == 123 || next == 43) {
            last = new Node(new CharBuffer());
        }
        last._string.append((char)ch);
        ++last._length;
        if (next != -1) {
            pattern.ungetc(next);
        }
        return last;
    }

    private Node parseSlash(PeekStream pattern, Node last) throws IllegalRegexpException {
        int ch = pattern.read();
        switch (ch) {
            case 115: {
                return new Node(3, new RegexpSet(RegexpSet.SPACE));
            }
            case 83: {
                return new Node(4, new RegexpSet(RegexpSet.SPACE));
            }
            case 100: {
                return new Node(3, new RegexpSet(RegexpSet.DIGIT));
            }
            case 68: {
                return new Node(4, new RegexpSet(RegexpSet.DIGIT));
            }
            case 119: {
                return new Node(3, new RegexpSet(RegexpSet.WORD));
            }
            case 87: {
                return new Node(4, new RegexpSet(RegexpSet.WORD));
            }
            case 98: {
                return new Node(73);
            }
            case 66: {
                return new Node(74);
            }
            case 65: {
                return new Node(77);
            }
            case 122: {
                return new Node(78);
            }
            case 90: {
                return new Node(79);
            }
            case 71: {
                return new Node(80);
            }
            case 97: {
                return this.parseString(7, pattern, last);
            }
            case 99: {
                ch = pattern.read();
                ch = Character.toUpperCase(ch);
                return this.parseString(ch ^= 0x40, pattern, last);
            }
            case 101: {
                return this.parseString(27, pattern, last, true);
            }
            case 110: {
                return this.parseString(10, pattern, last, true);
            }
            case 114: {
                return this.parseString(13, pattern, last, true);
            }
            case 102: {
                return this.parseString(12, pattern, last, true);
            }
            case 116: {
                return this.parseString(9, pattern, last, true);
            }
            case 120: {
                int hex = this.parseHex(pattern);
                return this.parseString(hex, pattern, last, true);
            }
            case 48: {
                int oct = this.parseOctal(ch, pattern);
                return this.parseString(oct, pattern, last, true);
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.parseBackReference(ch, pattern, last);
            }
            case 112: {
                return this.parseUnicodeProperty(pattern, last, false);
            }
            case 80: {
                return this.parseUnicodeProperty(pattern, last, true);
            }
            case 81: {
                while ((ch = pattern.read()) >= 0) {
                    if (ch == 92 && pattern.peek() == 69) {
                        pattern.read();
                        break;
                    }
                    last = this.parseString(ch, pattern, last);
                }
                return last;
            }
            case 35: {
                return this.parseString(35, pattern, last, true);
            }
        }
        if ((this._flags & 0x100) != 0) {
            throw new IllegalRegexpException("unrecognized escape at " + this.badChar(ch));
        }
        return this.parseString(ch, pattern, last);
    }

    private RegexpSet parseCharacterClass(PeekStream pattern) throws IllegalRegexpException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = pattern.read()) != 58 && ch >= 0) {
            sb.append((char)ch);
        }
        if (ch != 58) {
            throw new IllegalRegexpException("expected character class closing colon ':' at " + this.badChar(ch));
        }
        ch = pattern.read();
        if (ch != 93) {
            throw new IllegalRegexpException("expected character class closing bracket ']' at " + this.badChar(ch));
        }
        String name = sb.toString();
        RegexpSet set = RegexpSet.CLASS_MAP.get(name);
        if (set == null) {
            throw new IllegalRegexpException("unrecognized POSIX character class " + name);
        }
        return set;
    }

    private int parseHex(PeekStream pattern) throws IllegalRegexpException {
        int ch = pattern.read();
        int hex = 0;
        StringBuilder sb = new StringBuilder();
        if (ch == 123) {
            while ((ch = pattern.read()) != 125) {
                if (ch < 0) {
                    throw new IllegalRegexpException("no more input; expected '}'");
                }
                sb.append((char)ch);
            }
        } else {
            if (ch < 0) {
                throw new IllegalRegexpException("expected hex digit at " + this.badChar(ch));
            }
            sb.append((char)ch);
            ch = pattern.read();
            if (ch < 0) {
                throw new IllegalRegexpException("expected hex digit at " + this.badChar(ch));
            }
            sb.append((char)ch);
        }
        int len = sb.length();
        for (int i = 0; i < len; ++i) {
            ch = sb.charAt(i);
            if (48 <= ch && ch <= 57) {
                hex = hex * 16 + ch - 48;
                continue;
            }
            if (97 <= ch && ch <= 102) {
                hex = hex * 16 + ch - 97 + 10;
                continue;
            }
            if (65 <= ch && ch <= 70) {
                hex = hex * 16 + ch - 65 + 10;
                continue;
            }
            throw new IllegalRegexpException("expected hex digit at " + this.badChar(ch));
        }
        return hex;
    }

    private Node parseBackReference(int ch, PeekStream pattern, Node last) throws IllegalRegexpException {
        int value = ch - 48;
        int ch2 = pattern.peek();
        if (48 <= ch2 && ch2 <= 57) {
            pattern.read();
            value = value * 10 + ch2 - 48;
        }
        int ch3 = pattern.peek();
        if (value < 10 || value <= this._nGroup && (48 > ch3 || ch3 > 55)) {
            return new Node(7, value);
        }
        if (!(48 <= ch2 && ch2 <= 55 || 48 <= ch3 && ch3 <= 55)) {
            throw new IllegalRegexpException("back referencing to a non-existent group: " + value);
        }
        if (value > 10) {
            pattern.ungetc(ch2);
        }
        if (ch == 56 || ch == 57 || 48 <= ch3 && ch3 <= 57 && value * 10 + ch3 - 48 > 255) {
            pattern.ungetc(ch);
            return this.parseString(0, pattern, last);
        }
        int oct = this.parseOctal(ch, pattern);
        return this.parseString(oct, pattern, last, true);
    }

    private int parseOctal(int ch, PeekStream pattern) throws IllegalRegexpException {
        if (48 > ch || ch > 55) {
            throw new IllegalRegexpException("expected octal digit at " + this.badChar(ch));
        }
        int oct = ch - 48;
        int ch2 = pattern.peek();
        if (48 <= ch2 && ch2 <= 55) {
            pattern.read();
            oct = oct * 8 + ch2 - 48;
            ch = pattern.peek();
            if (48 <= ch && ch <= 55) {
                pattern.read();
                oct = oct * 8 + ch - 48;
            }
        }
        return oct;
    }

    private Node parseUnicodeProperty(PeekStream pattern, Node last, boolean isNegated) throws IllegalRegexpException {
        int ch = pattern.read();
        boolean isBraced = false;
        if (ch == 123) {
            isBraced = true;
            ch = pattern.read();
            if (ch == 94) {
                isNegated = !isNegated;
                ch = pattern.read();
            }
        }
        Node node = isBraced ? this.parseBracedUnicodeProperty(ch, pattern, last, isNegated) : this.parseUnbracedUnicodeProperty(ch, pattern, last, isNegated);
        return node;
    }

    private Node parseBracedUnicodeProperty(int ch, PeekStream pattern, Node last, boolean isNegated) throws IllegalRegexpException {
        int category = 0;
        int ch2 = pattern.read();
        block0 : switch (ch) {
            case 67: {
                switch (ch2) {
                    case 99: {
                        category = 15;
                        break block0;
                    }
                    case 102: {
                        category = 16;
                        break block0;
                    }
                    case 110: {
                        category = 0;
                        break block0;
                    }
                    case 111: {
                        category = 18;
                        break block0;
                    }
                    case 115: {
                        category = 19;
                        break block0;
                    }
                    case 125: {
                        if (isNegated) {
                            return new Node(1031);
                        }
                        return new Node(1024);
                    }
                }
                throw new IllegalRegexpException("invalid Unicode category " + this.badChar(ch) + "" + this.badChar(ch2));
            }
            case 76: {
                switch (ch2) {
                    case 108: {
                        category = 2;
                        break block0;
                    }
                    case 109: {
                        category = 4;
                        break block0;
                    }
                    case 111: {
                        category = 5;
                        break block0;
                    }
                    case 116: {
                        category = 3;
                        break block0;
                    }
                    case 117: {
                        category = 1;
                        break block0;
                    }
                    case 125: {
                        if (isNegated) {
                            return new Node(1032);
                        }
                        return new Node(1025);
                    }
                }
                throw new IllegalRegexpException("invalid Unicode category " + this.badChar(ch) + "" + this.badChar(ch2));
            }
            case 77: {
                switch (ch2) {
                    case 99: {
                        category = 8;
                        break block0;
                    }
                    case 101: {
                        category = 7;
                        break block0;
                    }
                    case 110: {
                        category = 6;
                        break block0;
                    }
                    case 125: {
                        if (isNegated) {
                            return new Node(1033);
                        }
                        return new Node(1026);
                    }
                }
                throw new IllegalRegexpException("invalid Unicode category " + this.badChar(ch) + "" + this.badChar(ch2));
            }
            case 78: {
                switch (ch2) {
                    case 100: {
                        category = 9;
                        break block0;
                    }
                    case 108: {
                        category = 10;
                        break block0;
                    }
                    case 111: {
                        category = 11;
                        break block0;
                    }
                    case 125: {
                        if (isNegated) {
                            return new Node(1034);
                        }
                        return new Node(1027);
                    }
                }
                throw new IllegalRegexpException("invalid Unicode category " + this.badChar(ch) + "" + this.badChar(ch2));
            }
            case 80: {
                switch (ch2) {
                    case 99: {
                        category = 23;
                        break block0;
                    }
                    case 100: {
                        category = 20;
                        break block0;
                    }
                    case 101: {
                        category = 22;
                        break block0;
                    }
                    case 102: {
                        category = 30;
                        break block0;
                    }
                    case 105: {
                        category = 29;
                        break block0;
                    }
                    case 111: {
                        category = 24;
                        break block0;
                    }
                    case 115: {
                        category = 21;
                        break block0;
                    }
                    case 125: {
                        if (isNegated) {
                            return new Node(1035);
                        }
                        return new Node(1028);
                    }
                }
                throw new IllegalRegexpException("invalid Unicode category " + this.badChar(ch) + "" + this.badChar(ch2));
            }
            case 83: {
                switch (ch2) {
                    case 99: {
                        category = 26;
                        break block0;
                    }
                    case 107: {
                        category = 27;
                        break block0;
                    }
                    case 109: {
                        category = 25;
                        break block0;
                    }
                    case 111: {
                        category = 28;
                        break block0;
                    }
                    case 125: {
                        if (isNegated) {
                            return new Node(1036);
                        }
                        return new Node(1029);
                    }
                }
                throw new IllegalRegexpException("invalid Unicode category " + this.badChar(ch) + "" + this.badChar(ch2));
            }
            case 90: {
                switch (ch2) {
                    case 108: {
                        category = 13;
                        break block0;
                    }
                    case 112: {
                        category = 14;
                        break block0;
                    }
                    case 115: {
                        category = 12;
                        break block0;
                    }
                    case 125: {
                        if (isNegated) {
                            return new Node(1037);
                        }
                        return new Node(1030);
                    }
                }
                throw new IllegalRegexpException("invalid Unicode category " + this.badChar(ch) + "" + this.badChar(ch2));
            }
        }
        ch = pattern.read();
        if (ch != 125) {
            throw new IllegalRegexpException("expected '}' at " + this.badChar(ch));
        }
        Node node = isNegated ? new Node(513) : new Node(512);
        node._unicodeCategory = (byte)category;
        return node;
    }

    private Node parseUnbracedUnicodeProperty(int ch, PeekStream pattern, Node last, boolean isNegated) throws IllegalRegexpException {
        switch (ch) {
            case 67: {
                if (isNegated) {
                    return new Node(1031);
                }
                return new Node(1024);
            }
            case 76: {
                if (isNegated) {
                    return new Node(1032);
                }
                return new Node(1025);
            }
            case 77: {
                if (isNegated) {
                    return new Node(1033);
                }
                return new Node(1026);
            }
            case 78: {
                if (isNegated) {
                    return new Node(1034);
                }
                return new Node(1027);
            }
            case 80: {
                if (isNegated) {
                    return new Node(1035);
                }
                return new Node(1028);
            }
            case 83: {
                if (isNegated) {
                    return new Node(1036);
                }
                return new Node(1029);
            }
            case 90: {
                if (isNegated) {
                    return new Node(1037);
                }
                return new Node(1030);
            }
        }
        throw new IllegalRegexpException("invalid Unicode property " + this.badChar(ch));
    }
}

