/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.regexp;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.lib.regexp.GroupState;
import com.caucho.quercus.lib.regexp.IllegalRegexpException;
import com.caucho.quercus.lib.regexp.Node;
import com.caucho.quercus.lib.regexp.PeekString;
import com.caucho.quercus.lib.regexp.RegOptim;
import com.caucho.quercus.lib.regexp.Regcomp;
import com.caucho.quercus.lib.regexp.RegexpSet;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharCursor;
import com.caucho.util.L10N;
import com.caucho.util.StringCharCursor;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Regexp {
    private static final Logger log = Logger.getLogger(Regexp.class.getName());
    private static final L10N L = new L10N(Regexp.class);
    public static final int FAIL = -1;
    public static final int SUCCESS = 0;
    StringValue _pattern;
    StringValue _subject;
    Node _prog;
    boolean _ignoreCase;
    boolean _isGlobal;
    int _first;
    int _start;
    StringCharCursor _stringCursor;
    int _nLoop;
    int[] _loopCount;
    int[] _loopTail;
    int _nGroup;
    int[] _groupStart;
    int _match;
    int _lexeme;
    CharBuffer _cb;
    CharBuffer _prefix;
    int _minLength;
    CharCursor _lastCursor;
    int _lastIndex;
    StringValue[] _groupNames;
    boolean _isUnicode;
    boolean _isPHP5String;
    boolean _isUTF8;
    boolean _isEval;
    GroupState _groupState = new GroupState();
    Stack<Node> _parentLoopRestStack = new Stack();

    public Regexp(Env env, StringValue rawRegexp) throws IllegalRegexpException {
        if (rawRegexp.length() < 2) {
            throw new IllegalStateException(L.l("Can't find delimiters in regexp '{0}'.", (Object)rawRegexp));
        }
        char delim = rawRegexp.charAt(0);
        if (delim == '{') {
            delim = '}';
        } else if (delim == '[') {
            delim = ']';
        } else if (delim == '(') {
            delim = ')';
        } else if (delim == '<') {
            delim = '>';
        } else if (delim == '\\' || Character.isLetterOrDigit(delim)) {
            throw new IllegalStateException(L.l("Delimiter {0} in regexp '{1}' must not be backslash or alphanumeric.", (Object)String.valueOf(delim), (Object)rawRegexp));
        }
        int tail = rawRegexp.lastIndexOf(delim);
        if (tail <= 0) {
            throw new IllegalStateException(L.l("Can't find second {0} in regexp '{1}'.", (Object)String.valueOf(delim), (Object)rawRegexp));
        }
        StringValue sflags = rawRegexp.substring(tail);
        StringValue pattern = rawRegexp.substring(1, tail);
        int flags = 0;
        block13: for (int i = 0; sflags != null && i < sflags.length(); ++i) {
            switch (sflags.charAt(i)) {
                case 'm': {
                    flags |= 1;
                    continue block13;
                }
                case 's': {
                    flags |= 2;
                    continue block13;
                }
                case 'i': {
                    flags |= 4;
                    continue block13;
                }
                case 'x': {
                    flags |= 8;
                    continue block13;
                }
                case 'g': {
                    flags |= 0x10;
                    continue block13;
                }
                case 'A': {
                    flags |= 0x20;
                    continue block13;
                }
                case 'D': {
                    flags |= 0x40;
                    continue block13;
                }
                case 'U': {
                    flags |= 0x80;
                    continue block13;
                }
                case 'X': {
                    flags |= 0x100;
                    continue block13;
                }
                case 'u': {
                    this._isUTF8 = true;
                    continue block13;
                }
                case 'e': {
                    this._isEval = true;
                }
            }
        }
        this._pattern = pattern;
        Regcomp comp = new Regcomp(flags);
        this._prog = comp.parse(new PeekString(this._pattern));
        this.compile(env, this._prog, comp);
    }

    protected Regexp(Env env, Node prog, Regcomp comp) {
        this._prog = prog;
        this.compile(env, this._prog, comp);
    }

    private Regexp() {
    }

    public StringValue substring(Env env, int start) {
        StringValue result = this._subject.substring(start);
        return this.encodeResultString(env, result);
    }

    public StringValue substring(Env env, int start, int end) {
        StringValue result = this._subject.substring(start, end);
        return this.encodeResultString(env, result);
    }

    private StringValue encodeResultString(Env env, StringValue str) {
        if (this._isUnicode) {
            return str;
        }
        if (this._isPHP5String) {
            return this.encodePHP5ResultString(env, str);
        }
        if (this._isUTF8) {
            return str.toBinaryValue(env, "UTF-8");
        }
        return str.toBinaryValue(env);
    }

    private StringValue encodePHP5ResultString(Env env, StringValue str) {
        StringBuilderValue sb = new StringBuilderValue();
        try {
            byte[] bytes = this._isUTF8 ? str.toString().getBytes("UTF-8") : str.toBytes();
            sb.append(bytes);
            return sb;
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.error(e);
            return null;
        }
    }

    public StringValue getPattern() {
        return this._pattern;
    }

    public boolean isUTF8() {
        return this._isUTF8;
    }

    public boolean isEval() {
        return this._isEval;
    }

    private void compile(Env env, Node prog, Regcomp comp) {
        this._ignoreCase = (comp._flags & 4) != 0;
        boolean bl = this._isGlobal = (comp._flags & 0x10) != 0;
        if (this._ignoreCase) {
            RegOptim.ignoreCase(prog);
        }
        if (!this._ignoreCase) {
            RegOptim.eliminateBacktrack(prog, null);
        }
        this._minLength = RegOptim.minLength(prog);
        this._prefix = RegOptim.prefix(prog);
        this._nGroup = comp._maxGroup;
        this._nLoop = comp._nLoop;
        this._groupStart = new int[this._nGroup + 1];
        for (int i = 0; i < this._groupStart.length; ++i) {
            this._groupStart[i] = -1;
        }
        this._loopCount = new int[this._nLoop];
        this._loopTail = new int[this._nLoop];
        this._cb = new CharBuffer();
        this._stringCursor = new StringCharCursor((CharSequence)"");
        this._groupNames = new StringValue[this._nGroup + 1];
        for (Map.Entry<Integer, StringValue> entry : comp._groupNameMap.entrySet()) {
            StringValue groupName = entry.getValue();
            if (!this._isUnicode) {
                if (this._isUTF8) {
                    groupName.toBinaryValue(env, "UTF-8");
                } else {
                    groupName.toBinaryValue(env);
                }
            }
            this._groupNames[entry.getKey().intValue()] = groupName;
        }
    }

    public void init(Env env, StringValue subject) {
        int i;
        this._isUnicode = subject.isUnicode();
        this._isPHP5String = subject.isPHP5String();
        this._subject = subject;
        if (!this._isUnicode) {
            if (this._isUTF8) {
                try {
                    String s = new String(subject.toBytes(), "UTF-8");
                    this._subject = new UnicodeBuilderValue(s);
                }
                catch (UnsupportedEncodingException e) {
                    log.log(Level.FINE, e.getMessage(), e);
                    env.error(e);
                }
            } else {
                this._subject = subject.toUnicodeValue(env);
            }
        }
        this._stringCursor.init((CharSequence)this._subject);
        this._lastIndex = 0;
        for (i = 0; i < this._groupStart.length; ++i) {
            this._groupStart[i] = -1;
        }
        for (i = 0; i < this._loopTail.length; ++i) {
            this._loopTail[i] = -1;
        }
    }

    public boolean isGlobal() {
        return this._isGlobal;
    }

    public boolean ignoreCase() {
        return this._ignoreCase;
    }

    public int exec(CharCursor cursor, int start, int first) {
        int pos;
        this._groupState.clear();
        this._parentLoopRestStack.clear();
        this._start = start;
        this._first = first;
        cursor.setIndex(first);
        int begin = cursor.getIndex();
        int value = -1;
        if (begin >= first) {
            while (true) {
                if (cursor.current() == '\uffff') {
                    value = this.match(this._prog, cursor);
                    break;
                }
                this._groupState.setLength(0);
                value = this.match(this._prog, cursor);
                if (value != -1) break;
                cursor.setIndex(begin + 1);
                begin = cursor.getIndex();
            }
        }
        if ((pos = cursor.getIndex()) < begin) {
            begin = pos;
        }
        if (this._groupState.size() < 2) {
            this._groupState.setLength(2);
        }
        this._groupState.set(0, begin);
        this._groupState.set(1, pos);
        this._groupState.setMatched(0);
        return value;
    }

    public int exec(String string, int first) {
        this._stringCursor.init((CharSequence)string);
        return this.exec((CharCursor)this._stringCursor, 0, first);
    }

    public int exec(CharBuffer buffer, int first) {
        this._stringCursor.init((CharSequence)buffer.toString());
        return this.exec((CharCursor)this._stringCursor, 0, first);
    }

    public int exec() {
        return this.exec((CharCursor)this._stringCursor);
    }

    public int exec(int first) {
        this._lastIndex = first;
        return this.exec((CharCursor)this._stringCursor);
    }

    public int exec(CharCursor cursor) {
        int first = 0;
        if (cursor == this._lastCursor) {
            first = this._lastIndex;
        }
        this._lastCursor = cursor;
        int value = this.exec(cursor, 0, first);
        this._lastIndex = value == -1 ? 0 : (this.getBegin(0) == this.getEnd(0) ? this.getEnd(0) + 1 : this.getEnd(0));
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int match(Node prog, CharCursor cursor) {
        while (prog != null) {
            switch (prog._code) {
                case 1: {
                    prog = prog._rest;
                    break;
                }
                case 0: 
                case 256: {
                    this._lexeme = prog._index;
                    return prog._index;
                }
                case 2: {
                    int length = prog._string.length();
                    if (!cursor.regionMatches(prog._string.getBuffer(), 0, length)) return -1;
                    prog = prog._rest;
                    break;
                }
                case 128: {
                    int length = prog._string.length();
                    if (!cursor.regionMatchesIgnoreCase(prog._string.getBuffer(), 0, length)) return -1;
                    prog = prog._rest;
                    break;
                }
                case 3: {
                    char ch = cursor.read();
                    if (ch == '\uffff' || !prog._set.match(ch)) return -1;
                    prog = prog._rest;
                    break;
                }
                case 129: {
                    char ch = cursor.read();
                    if (ch == '\uffff') {
                        return -1;
                    }
                    char lch = Character.toLowerCase(ch);
                    char uch = Character.toUpperCase(lch);
                    if (!prog._set.match(lch) && !prog._set.match(uch)) return -1;
                    prog = prog._rest;
                    break;
                }
                case 4: {
                    char ch = cursor.read();
                    if (ch == '\uffff' || prog._set.match(ch)) return -1;
                    prog = prog._rest;
                    break;
                }
                case 130: {
                    char ch = cursor.read();
                    if (ch == '\uffff') {
                        return -1;
                    }
                    char lch = Character.toLowerCase(ch);
                    char uch = Character.toUpperCase(lch);
                    if (prog._set.match(lch) || prog._set.match(uch)) return -1;
                    prog = prog._rest;
                    break;
                }
                case 5: {
                    this._groupStart[prog._index] = cursor.getIndex();
                    prog = prog._rest;
                    break;
                }
                case 6: {
                    int index = 2 * prog._index;
                    if (this._groupState.size() <= index + 1) {
                        this._groupState.setLength(index + 2);
                    }
                    this._groupState.set(2 * prog._index, this._groupStart[prog._index]);
                    this._groupState.set(2 * prog._index + 1, cursor.getIndex());
                    this._groupState.setMatched(prog._index);
                    prog = prog._rest;
                    break;
                }
                case 7: {
                    if (!this._groupState.isMatched(prog._index)) {
                        return -1;
                    }
                    int begin = this._groupState.get(2 * prog._index);
                    int length = this._groupState.get(2 * prog._index + 1) - this._groupState.get(2 * prog._index);
                    this._cb.setLength(0);
                    cursor.subseq(this._cb, begin, begin + length);
                    if (!cursor.regionMatches(this._cb.getBuffer(), 0, length)) return -1;
                    prog = prog._rest;
                    break;
                }
                case 131: {
                    if (!this._groupState.isMatched(prog._index)) {
                        return -1;
                    }
                    int begin = this._groupState.get(2 * prog._index);
                    int length = this._groupState.get(2 * prog._index + 1) - this._groupState.get(2 * prog._index);
                    this._cb.setLength(0);
                    cursor.subseq(this._cb, begin, begin + length);
                    if (!cursor.regionMatchesIgnoreCase(this._cb.getBuffer(), 0, length)) return -1;
                    cursor.skip(length);
                    prog = prog._rest;
                    break;
                }
                case 9: {
                    this._loopCount[prog._rest._index] = 0;
                    this._loopTail[prog._rest._index] = -1;
                    prog = prog._rest;
                    break;
                }
                case 8: {
                    int value;
                    int i;
                    GroupState oldState = this._groupState.copy();
                    int tail = cursor.getIndex();
                    int matchedCount = -1;
                    int matchedTail = tail;
                    GroupState matchedGroupState = null;
                    int loopTail = -1;
                    boolean isParentRestMatched = false;
                    for (i = 0; i < prog._max; ++i) {
                        if (cursor.current() == '\uffff' || loopTail == cursor.getIndex()) break;
                        loopTail = cursor.getIndex();
                        this._parentLoopRestStack.push(prog._rest);
                        value = this.match(prog._branch, cursor);
                        this._parentLoopRestStack.pop();
                        if (value == -1) break;
                        int lastPos = cursor.getIndex();
                        GroupState innerState = this._groupState.copy();
                        value = this.match(prog._rest, cursor);
                        if (value != -1 && i + 1 >= prog._min) {
                            if (this._parentLoopRestStack.size() == 0) {
                                matchedCount = i + 1;
                                matchedTail = cursor.getIndex();
                                this.freeGroupState(matchedGroupState);
                                matchedGroupState = this._groupState.copy();
                            } else {
                                lastPos = cursor.getIndex();
                                this.freeGroupState(innerState);
                                innerState = this._groupState.copy();
                                Node oldRest = this._parentLoopRestStack.pop();
                                value = this.match(oldRest, cursor);
                                this._parentLoopRestStack.push(oldRest);
                                if (value != -1 || !isParentRestMatched) {
                                    isParentRestMatched = isParentRestMatched || value != -1;
                                    matchedCount = i + 1;
                                    matchedTail = lastPos;
                                    this.freeGroupState(matchedGroupState);
                                    matchedGroupState = innerState.copy();
                                }
                            }
                        }
                        cursor.setIndex(lastPos);
                        this.setGroupState(innerState);
                    }
                    if (prog._min <= matchedCount) {
                        cursor.setIndex(matchedTail);
                        this.freeGroupState(oldState);
                        this.setGroupState(matchedGroupState);
                        return 0;
                    }
                    if (prog._min == 0) {
                        cursor.setIndex(tail);
                        this.setGroupState(oldState);
                        prog = prog._rest;
                        break;
                    }
                    cursor.setIndex(tail);
                    this.setGroupState(oldState);
                    return -1;
                }
                case 13: {
                    int value;
                    int i;
                    GroupState oldState = this._groupState.copy();
                    int tail = cursor.getIndex();
                    for (i = 0; i < prog._max; ++i) {
                        if (cursor.current() == '\uffff') break;
                        int lastPos = cursor.getIndex();
                        GroupState innerState = this._groupState.copy();
                        value = this.match(prog._branch, cursor);
                        if (value == -1) {
                            cursor.setIndex(lastPos);
                            this.setGroupState(innerState);
                            break;
                        }
                        this.freeGroupState(innerState);
                    }
                    if (prog._min <= i) {
                        this.freeGroupState(oldState);
                        prog = prog._rest;
                        break;
                    }
                    cursor.setIndex(tail);
                    this.setGroupState(oldState);
                    return -1;
                }
                case 10: {
                    int value;
                    int i;
                    GroupState oldState = this._groupState.copy();
                    int tail = cursor.getIndex();
                    if (prog._min == 0) {
                        if (this.match(prog._rest, cursor) != -1) {
                            if (this._parentLoopRestStack.size() == 0) {
                                return 0;
                            }
                            Node oldRest = this._parentLoopRestStack.pop();
                            value = this.match(oldRest, cursor);
                            this._parentLoopRestStack.push(oldRest);
                            if (value != -1) {
                                return 0;
                            }
                        }
                        this.setGroupState(oldState);
                        oldState = this._groupState.copy();
                        cursor.setIndex(tail);
                    }
                    for (i = 0; i < prog._max; ++i) {
                        if (cursor.current() == '\uffff') break;
                        this._parentLoopRestStack.push(prog._rest);
                        value = this.match(prog._branch, cursor);
                        this._parentLoopRestStack.pop();
                        if (value == -1) break;
                        int lastPos = cursor.getIndex();
                        GroupState innerState = this._groupState.copy();
                        value = this.match(prog._rest, cursor);
                        if (value != -1 && i + 1 >= prog._min) {
                            if (this._parentLoopRestStack.size() == 0) {
                                this.freeGroupState(oldState);
                                this.freeGroupState(innerState);
                                return 0;
                            }
                            int restPos = cursor.getIndex();
                            GroupState restState = this._groupState.copy();
                            Node oldRest = this._parentLoopRestStack.pop();
                            value = this.match(oldRest, cursor);
                            this._parentLoopRestStack.push(oldRest);
                            if (value != -1) {
                                cursor.setIndex(restPos);
                                this.freeGroupState(oldState);
                                this.freeGroupState(innerState);
                                this.setGroupState(restState);
                                return 0;
                            }
                        }
                        cursor.setIndex(lastPos);
                        this.setGroupState(innerState);
                    }
                    if (prog._min == 0) {
                        cursor.setIndex(tail);
                        this.setGroupState(oldState);
                        prog = prog._rest;
                        break;
                    }
                    cursor.setIndex(tail);
                    this.setGroupState(oldState);
                    return -1;
                }
                case 11: {
                    int n = prog._index;
                    int n2 = this._loopCount[n];
                    this._loopCount[n] = n2 + 1;
                    if (n2 < prog._min) {
                        prog = prog._branch;
                        break;
                    }
                    if (this._loopCount[prog._index] > prog._max) {
                        prog = prog._rest;
                        break;
                    }
                    char ch = cursor.current();
                    if (ch == '\uffff') {
                        prog = prog._rest;
                        break;
                    }
                    if (prog._set.match(ch)) {
                        prog = prog._branch;
                        break;
                    }
                    prog = prog._rest;
                    break;
                }
                case 64: {
                    this._match = this._groupState.size();
                    int tail = cursor.getIndex();
                    int value = this.match(prog._branch, cursor);
                    if (value != -1) {
                        return value;
                    }
                    cursor.setIndex(tail);
                    this._groupState.setLength(this._match);
                    prog = prog._rest;
                    break;
                }
                case 65: {
                    char ch = cursor.current();
                    if (ch == '\uffff') {
                        prog = prog._rest;
                        break;
                    }
                    if (prog._set.match(ch)) {
                        prog = prog._branch;
                        break;
                    }
                    prog = prog._rest;
                    break;
                }
                case 66: {
                    int tail = cursor.getIndex();
                    GroupState oldState = this._groupState.copy();
                    if (this.match(prog._branch, cursor) == -1) {
                        return -1;
                    }
                    cursor.setIndex(tail);
                    this.setGroupState(oldState);
                    prog = prog._rest;
                    break;
                }
                case 67: {
                    int tail = cursor.getIndex();
                    GroupState oldState = this._groupState.copy();
                    if (this.match(prog._branch, cursor) != -1) {
                        return -1;
                    }
                    this.setGroupState(oldState);
                    cursor.setIndex(tail);
                    prog = prog._rest;
                    break;
                }
                case 68: {
                    int tail = cursor.getIndex();
                    GroupState oldState = this._groupState.copy();
                    int length = prog._length;
                    if (tail < length) {
                        return -1;
                    }
                    cursor.setIndex(tail - length);
                    if (this.match(prog._branch, cursor) == -1) {
                        cursor.setIndex(tail);
                        this.setGroupState(oldState);
                        return -1;
                    }
                    cursor.setIndex(tail);
                    this.setGroupState(oldState);
                    prog = prog._rest;
                    break;
                }
                case 69: {
                    int tail = cursor.getIndex();
                    GroupState oldState = this._groupState.copy();
                    int length = prog._branch._length;
                    if (tail >= length) {
                        cursor.setIndex(tail - length);
                        if (this.match(prog._branch, cursor) != -1) {
                            cursor.setIndex(tail);
                            this.setGroupState(oldState);
                            return -1;
                        }
                    }
                    cursor.setIndex(tail);
                    this.setGroupState(oldState);
                    prog = prog._rest;
                    break;
                }
                case 70: {
                    int tail = cursor.getIndex();
                    GroupState oldState = this._groupState.copy();
                    int defaultLength = prog._length;
                    boolean isMatched = false;
                    Node node = prog._branch;
                    int value = this.match(node, cursor);
                    if (value != -1) {
                        return value;
                    }
                    this.setGroupState(oldState);
                    node = prog._rest;
                    while (node != null && node._code != 0) {
                        cursor.setIndex(tail);
                        oldState = this._groupState.copy();
                        cursor.setIndex(tail + defaultLength - node._length);
                        if (this.match(node, cursor) != -1) {
                            isMatched = true;
                            break;
                        }
                        cursor.setIndex(tail);
                        this.setGroupState(oldState);
                        node = node._rest;
                    }
                    if (!isMatched) {
                        return -1;
                    }
                    prog = node._rest;
                    break;
                }
                case 81: {
                    int tail = cursor.getIndex();
                    if (this._groupState.isMatched(prog._index) ? this.match(prog._branch, cursor) == -1 : prog._nBranch != null && this.match(prog._nBranch, cursor) == -1) {
                        return -1;
                    }
                    prog = prog._rest;
                    break;
                }
                case 75: {
                    if (cursor.getIndex() == this._start) {
                        prog = prog._rest;
                        break;
                    }
                    if (cursor.previous() == '\n') {
                        cursor.next();
                        prog = prog._rest;
                        break;
                    }
                    cursor.next();
                    return -1;
                }
                case 76: {
                    if (cursor.current() != '\uffff' && cursor.current() != '\n') return -1;
                    prog = prog._rest;
                    break;
                }
                case 80: {
                    if (cursor.getIndex() != this._first) return -1;
                    prog = prog._rest;
                    break;
                }
                case 77: {
                    if (cursor.getIndex() != this._start) return -1;
                    prog = prog._rest;
                    break;
                }
                case 78: {
                    if (cursor.current() != '\uffff') return -1;
                    prog = prog._rest;
                    break;
                }
                case 79: {
                    char ch = cursor.current();
                    int tail = cursor.getIndex();
                    if (ch != '\n' || tail != cursor.getEndIndex() - 1) {
                        if (ch != '\uffff') return -1;
                    }
                    prog = prog._rest;
                    break;
                }
                case 73: {
                    int tail = cursor.getIndex();
                    if ((tail != this._start && RegexpSet.WORD.match(cursor.prev())) == (cursor.current() != '\uffff' && RegexpSet.WORD.match(cursor.current()))) return -1;
                    prog = prog._rest;
                    break;
                }
                case 74: {
                    int tail = cursor.getIndex();
                    if ((tail != this._start && RegexpSet.WORD.match(cursor.prev())) != (cursor.current() != '\uffff' && RegexpSet.WORD.match(cursor.current()))) return -1;
                    prog = prog._rest;
                    break;
                }
                case 512: {
                    char ch = cursor.read();
                    if (ch == '\uffff') {
                        return -1;
                    }
                    if (Character.getType(ch) != prog._unicodeCategory) return -1;
                    prog = prog._rest;
                    break;
                }
                case 513: {
                    char ch = cursor.read();
                    if (ch == '\uffff') {
                        return -1;
                    }
                    if (Character.getType(ch) == prog._unicodeCategory) return -1;
                    prog = prog._rest;
                    break;
                }
                case 1024: {
                    char ch = cursor.read();
                    if (ch == '\uffff') {
                        return -1;
                    }
                    int value = Character.getType(ch);
                    if (value != 15 && value != 16 && value != 0 && value != 18 && value != 19) return -1;
                    prog = prog._rest;
                    break;
                }
                case 1031: {
                    char ch = cursor.read();
                    if (ch == '\uffff') {
                        return -1;
                    }
                    int value = Character.getType(ch);
                    if (value == 15 || value == 16 || value == 0 || value == 18 || value == 19) return -1;
                    prog = prog._rest;
                    break;
                }
                case 1025: {
                    char ch = cursor.read();
                    if (ch == '\uffff') {
                        return -1;
                    }
                    int value = Character.getType(ch);
                    if (value != 2 && value != 4 && value != 5 && value != 3 && value != 1) return -1;
                    prog = prog._rest;
                    break;
                }
                case 1032: {
                    char ch = cursor.read();
                    if (ch == '\uffff') {
                        return -1;
                    }
                    int value = Character.getType(ch);
                    if (value == 2 || value == 4 || value == 5 || value == 3 || value == 1) return -1;
                    prog = prog._rest;
                    break;
                }
                case 1026: {
                    char ch = cursor.read();
                    if (ch == '\uffff') {
                        return -1;
                    }
                    int value = Character.getType(ch);
                    if (value != 8 && value != 7 && value != 6) return -1;
                    prog = prog._rest;
                    break;
                }
                case 1033: {
                    char ch = cursor.read();
                    if (ch == '\uffff') {
                        return -1;
                    }
                    int value = Character.getType(ch);
                    if (value == 8 || value == 7 || value == 6) return -1;
                    prog = prog._rest;
                    break;
                }
                case 1027: {
                    char ch = cursor.read();
                    if (ch == '\uffff') {
                        return -1;
                    }
                    int value = Character.getType(ch);
                    if (value != 9 && value != 10 && value != 11) return -1;
                    prog = prog._rest;
                    break;
                }
                case 1034: {
                    char ch = cursor.read();
                    if (ch == '\uffff') {
                        return -1;
                    }
                    int value = Character.getType(ch);
                    if (value == 9 || value == 10 || value == 11) return -1;
                    prog = prog._rest;
                    break;
                }
                case 1028: {
                    char ch = cursor.read();
                    if (ch == '\uffff') {
                        return -1;
                    }
                    int value = Character.getType(ch);
                    if (value != 23 && value != 20 && value != 22 && value != 30 && value != 29 && value != 24 && value != 21) return -1;
                    prog = prog._rest;
                    break;
                }
                case 1035: {
                    char ch = cursor.read();
                    if (ch == '\uffff') {
                        return -1;
                    }
                    int value = Character.getType(ch);
                    if (value == 23 || value == 20 || value == 22 || value == 30 || value == 29 || value == 24 || value == 21) return -1;
                    prog = prog._rest;
                    break;
                }
                case 1029: {
                    char ch = cursor.read();
                    if (ch == '\uffff') {
                        return -1;
                    }
                    int value = Character.getType(ch);
                    if (value != 26 && value != 27 && value != 25 && value != 28) return -1;
                    prog = prog._rest;
                    break;
                }
                case 1036: {
                    char ch = cursor.read();
                    if (ch == '\uffff') {
                        return -1;
                    }
                    int value = Character.getType(ch);
                    if (value == 26 || value == 27 || value == 25 || value == 28) return -1;
                    prog = prog._rest;
                    break;
                }
                case 1030: {
                    char ch = cursor.read();
                    if (ch == '\uffff') {
                        return -1;
                    }
                    int value = Character.getType(ch);
                    if (value != 13 && value != 14 && value != 12) return -1;
                    prog = prog._rest;
                    break;
                }
                case 1037: {
                    char ch = cursor.read();
                    if (ch == '\uffff') {
                        return -1;
                    }
                    int value = Character.getType(ch);
                    if (value == 13 || value == 14 || value == 12) return -1;
                    prog = prog._rest;
                    break;
                }
                case 2048: {
                    char ch;
                    switch (prog._branch._code) {
                        case 10: {
                            ch = cursor.read();
                            if (ch != '\uffff') return 0;
                            return -1;
                        }
                    }
                    return 0;
                }
                default: {
                    throw new RuntimeException("Internal error: " + Node.code(prog));
                }
            }
        }
        return 0;
    }

    private void setGroupState(GroupState newState) {
        newState.free(this._groupState);
        this._groupState = newState;
    }

    private void freeGroupState(GroupState oldState) {
        this._groupState.free(oldState);
    }

    private GroupState copyGroupState() {
        return this._groupState.copy();
    }

    public int getBegin(int i) {
        if (this._groupState.size() < 2 * i) {
            return 0;
        }
        return this._groupState.get(2 * i);
    }

    public int getEnd(int i) {
        if (this._groupState.size() < 2 * i + 1) {
            return 0;
        }
        return this._groupState.get(2 * i + 1);
    }

    public int length() {
        return this._groupState.size() / 2;
    }

    public boolean match(String string) {
        return this.exec(string, 0) != -1;
    }

    public boolean find() {
        return this.exec() != -1;
    }

    public boolean find(int first) {
        return this.exec(first) != -1;
    }

    public int start() {
        return this.getBegin(0);
    }

    public int start(int i) {
        return this.getBegin(i);
    }

    public int end() {
        return this.getEnd(0);
    }

    public int end(int i) {
        return this.getEnd(i);
    }

    public int groupCount() {
        return this._nGroup;
    }

    public boolean isMatchedGroup(int i) {
        return this._groupState.isMatched(i);
    }

    public StringValue group(Env env) {
        return this.group(env, 0);
    }

    public StringValue group(Env env, int i) {
        int begin = this.getBegin(i);
        int end = this.getEnd(i);
        StringValue s = this._subject.substring(begin, end);
        return this.encodeResultString(env, s);
    }

    public StringValue getGroupName(int i) {
        if (this._groupNames.length <= i) {
            return null;
        }
        return this._groupNames[i];
    }

    public Regexp clone() {
        Regexp regexp = new Regexp();
        regexp._pattern = this._pattern;
        regexp._prog = this._prog;
        regexp._ignoreCase = this._ignoreCase;
        regexp._isGlobal = this._isGlobal;
        regexp._minLength = this._minLength;
        regexp._prefix = this._prefix;
        regexp._nGroup = this._nGroup;
        regexp._nLoop = this._nLoop;
        regexp._groupStart = new int[this._nGroup + 1];
        regexp._loopCount = new int[this._nLoop];
        regexp._loopTail = new int[this._nLoop];
        regexp._cb = new CharBuffer();
        regexp._stringCursor = new StringCharCursor((CharSequence)"");
        regexp._groupState = new GroupState();
        regexp._groupNames = this._groupNames;
        regexp._isUnicode = this._isUnicode;
        regexp._isUTF8 = this._isUTF8;
        regexp._isEval = this._isEval;
        return regexp;
    }

    public String toString() {
        return "Regexp[" + this._pattern + "]";
    }
}

