/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.simplexml;

import com.caucho.quercus.annotation.Name;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.simplexml.SimpleXMLElementIterator;
import com.caucho.quercus.lib.simplexml.node.SimpleAttribute;
import com.caucho.quercus.lib.simplexml.node.SimpleElement;
import com.caucho.quercus.lib.simplexml.node.SimpleNode;
import com.caucho.quercus.lib.simplexml.node.SimpleResultSet;
import com.caucho.quercus.lib.simplexml.node.SimpleText;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleXMLElement {
    private static final Logger log = Logger.getLogger(SimpleXMLElement.class.getName());
    private static final L10N L = new L10N(SimpleXMLElement.class);
    private SimpleNode _node;
    private boolean _isRoot;

    protected SimpleXMLElement(SimpleNode node) {
        this._node = node;
    }

    protected SimpleXMLElement(SimpleNode node, boolean isRoot) {
        this._node = node;
        this._isRoot = isRoot;
    }

    private SimpleNode getNode() {
        return this._node;
    }

    @ReturnNullAsFalse
    public static SimpleXMLElement __construct(Env env, Value data, @Optional int options, @Optional boolean dataIsUrl, @Optional Value namespaceV, @Optional boolean isPrefix) {
        try {
            Node node;
            String namespace = null;
            if (!namespaceV.isNull()) {
                namespace = namespaceV.toString();
            }
            if ((node = SimpleXMLElement.parse(env, data, options, dataIsUrl, namespace, isPrefix)) == null) {
                return null;
            }
            SimpleNode simpleNode = SimpleXMLElement.buildNode(env, null, node, namespace, isPrefix);
            return new SimpleXMLElement(simpleNode, true);
        }
        catch (IOException e) {
            env.warning(e);
            return null;
        }
        catch (ParserConfigurationException e) {
            env.warning(e);
            return null;
        }
        catch (SAXException e) {
            env.warning(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node parse(Env env, Value data, int options, boolean dataIsUrl, String namespace, boolean isPrefix) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = null;
        if (dataIsUrl) {
            Path path = env.lookup(data.toString());
            if (path == null) {
                log.log(Level.FINE, L.l("Cannot read file/URL '{0}'", (Object)data));
                env.warning(L.l("Cannot read file/URL '{0}'", (Object)data));
                return null;
            }
            ReadStream is = path.openRead();
            try {
                document = builder.parse((InputStream)is);
            }
            finally {
                is.close();
            }
        } else if (data.isUnicode()) {
            StringReader reader = new StringReader(data.toString());
            document = builder.parse(new InputSource(reader));
        } else {
            InputStream in = data.toInputStream();
            document = builder.parse(in);
        }
        NodeList childList = document.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            if (childList.item(i).getNodeType() != 1) continue;
            return childList.item(i);
        }
        return childList.item(0);
    }

    private static SimpleNode buildNode(Env env, SimpleNode parent, Node node, String namespace, boolean isPrefix) {
        if (node.getNodeType() == 3) {
            return new SimpleText(node.getNodeValue());
        }
        SimpleElement simpleNode = new SimpleElement(parent, node.getNodeName(), null);
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            int length = attrs.getLength();
            for (int i = 0; i < length; ++i) {
                Attr attr = (Attr)attrs.item(i);
                simpleNode.addAttribute(attr.getName(), attr.getValue(), namespace);
            }
        }
        NodeList nodeList = node.getChildNodes();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Node childNode = nodeList.item(i);
            SimpleNode child = SimpleXMLElement.buildNode(env, simpleNode, childNode, namespace, isPrefix);
            simpleNode.addChild(child);
        }
        return simpleNode;
    }

    public void addAttribute(String name, String value, @Optional String namespace) {
        this._node.addAttribute(name, value, namespace);
    }

    public SimpleXMLElement addChild(Env env, String name, String value, @Optional Value namespaceV) {
        String namespace = null;
        if (!namespaceV.isNull()) {
            namespace = namespaceV.toString();
        }
        SimpleText text = new SimpleText(value);
        SimpleElement child = new SimpleElement(this.getNode(), name, namespace);
        child.addChild(text);
        this.addChild(child);
        return new SimpleXMLElement(child);
    }

    private void addChild(SimpleNode child) {
        this.getNode().addChild(child);
    }

    public SimpleXMLElement attributes(Env env, @Optional Value namespaceV, @Optional boolean isPrefix) {
        String namespace = null;
        if (!namespaceV.isNull()) {
            namespace = namespaceV.toString();
        }
        SimpleResultSet result = new SimpleResultSet(this.getNode().getName());
        for (SimpleAttribute attr : this.getNode().getAttributes()) {
            if (!attr.isSameNamespace(namespace)) continue;
            result.addAttribute(attr);
        }
        return new SimpleXMLElement(result);
    }

    public SimpleXMLElement children(Env env, @Optional Value namespaceV, @Optional boolean isPrefix) {
        String namespace = null;
        if (!namespaceV.isNull()) {
            namespace = namespaceV.toString();
        }
        SimpleResultSet result = new SimpleResultSet(this.getNode().getName());
        for (SimpleElement child : this.getNode().getElementList()) {
            if (isPrefix) {
                if (!child.isSamePrefix(namespace) && (child.getPrefix() != null || !this.getNode().isSamePrefix(namespace))) continue;
                result.addChild(child);
                continue;
            }
            if (!child.isSameNamespace(namespace) && (child.getNamespace() != null || !this.getNode().isSameNamespace(namespace))) continue;
            result.addChild(child);
        }
        for (SimpleAttribute attr : this.getNode().getAttributes()) {
            if (!attr.isSameNamespace(namespace)) continue;
            result.addAttribute(attr);
        }
        return new SimpleXMLElement(result);
    }

    @ReturnNullAsFalse
    public String asXML() {
        String xml = this.getNode().toXML();
        if (this._isRoot) {
            xml = "<?xml version=\"1.0\"?>\n" + xml + "\n";
        }
        return xml;
    }

    @Name(value="getName")
    public String simplexml_getName() {
        return this.getNode().getName();
    }

    public Value getDocNamespaces(Env env, @Optional boolean isRecursive) {
        return this.getNamespaces(env, isRecursive);
    }

    public Value getNamespaces(Env env, @Optional boolean isRecursive) {
        ArrayValueImpl array = new ArrayValueImpl();
        SimpleXMLElement.getNamespaces(array, this.getNode(), isRecursive);
        return array;
    }

    private static void getNamespaces(ArrayValue array, SimpleNode node, boolean isRecursive) {
        for (Map.Entry<String, SimpleAttribute> entry : node.getNamespaces().entrySet()) {
            SimpleAttribute namespace = entry.getValue();
            String name = namespace.getPrefix() == null ? "" : namespace.getName();
            array.put(name, namespace.getValue());
        }
        if (isRecursive) {
            for (SimpleElement child : node.getElementList()) {
                SimpleXMLElement.getNamespaces(array, child, isRecursive);
            }
        }
    }

    public Value xpath(Env env, String expression) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            InputSource is = new InputSource(new StringReader(this.asXML()));
            NodeList nodes = (NodeList)xpath.evaluate(expression, is, XPathConstants.NODESET);
            int nodeLength = nodes.getLength();
            if (nodeLength == 0) {
                return NullValue.NULL;
            }
            ArrayValueImpl result = new ArrayValueImpl();
            for (int i = 0; i < nodeLength; ++i) {
                Node node = nodes.item(i);
                boolean isPrefix = node.getPrefix() != null;
                SimpleNode simpleNode = SimpleXMLElement.buildNode(env, null, nodes.item(i), node.getNamespaceURI(), isPrefix);
                SimpleXMLElement xml = new SimpleXMLElement(simpleNode);
                ((ArrayValue)result).put(env.wrapJava(xml));
            }
            return result;
        }
        catch (XPathExpressionException e) {
            env.warning(e);
            log.log(Level.FINE, e.getMessage());
            return NullValue.NULL;
        }
    }

    public SimpleXMLElement __get(Env env, Value indexV) {
        if (indexV.isString()) {
            String name = indexV.toString();
            SimpleAttribute attr = this.getNode().getAttribute(name);
            if (attr == null) {
                return null;
            }
            return new SimpleXMLElement(attr);
        }
        if (indexV.isLongConvertible()) {
            int i = indexV.toInt();
            SimpleNode child = this.getNode().get(i);
            if (child != null) {
                return new SimpleXMLElement(child);
            }
            return null;
        }
        return null;
    }

    public void __set(String name, String value) {
        this.addAttribute(name, value, null);
    }

    public SimpleXMLElement __getField(String name) {
        SimpleElement child = this.getNode().getElement(name);
        if (child != null) {
            return new SimpleXMLElement(child);
        }
        return null;
    }

    public void __setField(String name, String value) {
        SimpleText text = new SimpleText(value);
        SimpleElement child = this.getNode().getElement(name);
        if (child == null) {
            child = new SimpleElement(this.getNode(), name, null);
            this.getNode().addChild(child);
        } else {
            child.removeChildren();
        }
        child.addChild(text);
    }

    public Iterator iterator() {
        return new SimpleXMLElementIterator(this.getNode().iterator());
    }

    public Set<String> keySet() {
        return this.getNode().getAttributeMap().keySet();
    }

    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        SimpleNode node = this.getNode();
        this.printDepth(out, 2 * depth);
        out.println("object(SimpleXMLElement) (" + node.getObjectSize() + ") {");
        node.varDumpImpl(env, out, depth + 1, valueSet);
        this.printDepth(out, 2 * depth);
        out.print('}');
    }

    public void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.println("SimpleXMLElement Object");
        this.printDepth(out, 4 * depth);
        out.println('(');
        this.getNode().printRImpl(env, out, depth + 1, valueSet);
        this.printDepth(out, 4 * depth);
        out.println(')');
    }

    void printDepth(WriteStream out, int depth) throws IOException {
        for (int i = 0; i < depth; ++i) {
            out.print(' ');
        }
    }

    public String toString() {
        return this.getNode().toString();
    }
}

