/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.simplexml.node;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.simplexml.node.SimpleNode;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAttribute
extends SimpleNode {
    public SimpleAttribute(String name, String value) {
        this.setQName(name);
        this.setValue(value);
    }

    public SimpleAttribute(String name, String value, String namespace) {
        this.setQName(name);
        this.setValue(value);
        if (namespace != null) {
            this.setNamespace(namespace, this.getPrefix());
        }
    }

    @Override
    public boolean isAttribute() {
        return true;
    }

    @Override
    protected void toXMLImpl(StringBuilder sb) {
        sb.append(' ');
        if (this.getPrefix() != null) {
            sb.append(this.getPrefix());
            sb.append(':');
        }
        sb.append(this.getName());
        sb.append("=\"" + this.getValue() + "\"");
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        this.printDepth(out, 2 * depth);
        out.println("[0]=>");
        this.printDepth(out, 2 * depth);
        out.print("string(" + this.getValue().length() + ") \"");
        out.print(this.getValue());
        out.println('\"');
    }

    @Override
    void varDumpNested(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        this.printDepth(out, 2 * depth);
        out.print("[\"");
        out.print(this.getName());
        out.println("\"]=>");
        this.printDepth(out, 2 * depth);
        out.print("string(" + this.getValue().length() + ") \"");
        out.print(this.getValue());
        out.println('\"');
    }

    @Override
    public void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        this.printDepth(out, 4 * depth);
        out.print("[0] => ");
        out.println(this.getValue());
    }

    @Override
    void printRNested(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        this.printDepth(out, 4 * depth);
        out.print("[" + this.getName() + "] => ");
        out.println(this.getValue());
    }
}

