/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.simplexml.node;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.simplexml.node.SimpleAttribute;
import com.caucho.quercus.lib.simplexml.node.SimpleNode;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleElement
extends SimpleNode {
    public SimpleElement(SimpleNode parent) {
        this._children = new ArrayList();
        this._elementList = new ArrayList();
        this._elementMap = new HashMap();
        this._attributeList = new ArrayList();
        this._attributeMap = new LinkedHashMap();
        this._namespaceMap = new LinkedHashMap();
        this.setParent(parent);
    }

    public SimpleElement(SimpleNode parent, String name, String namespace) {
        this(parent);
        SimpleAttribute attr;
        this.setQName(name);
        if (namespace != null && this.addNamespace(attr = SimpleElement.createNamespaceAttribute(namespace, this.getPrefix()))) {
            this.setNamespace(attr);
        }
    }

    @Override
    public void setQName(String name) {
        super.setQName(name);
        if (this.getParent() == null || this.getPrefix() == null) {
            return;
        }
        String prefix = this.getPrefix();
        String qName = "xmlns:" + prefix;
        SimpleAttribute namespace = this.getParent().getNamespace(qName, true);
        if (namespace != null) {
            this.setNamespace(namespace);
        }
    }

    @Override
    public boolean isElement() {
        return true;
    }

    @Override
    public int getObjectSize() {
        int size = this.getElementMap().size();
        if (size == 0 && this.getChildren().size() > 0) {
            ++size;
        }
        if (this.getAttributes().size() > 0) {
            ++size;
        }
        return size;
    }

    @Override
    public String getQName() {
        if (this.getNamespace() == null) {
            return this.getName();
        }
        return super.getQName();
    }

    @Override
    protected void toXMLImpl(StringBuilder sb) {
        sb.append("<");
        sb.append(this.getQName());
        for (Map.Entry<String, SimpleAttribute> entry : this.getNamespaces().entrySet()) {
            entry.getValue().toXMLImpl(sb);
        }
        for (SimpleAttribute attr : this.getAttributes()) {
            attr.toXMLImpl(sb);
        }
        ArrayList<SimpleNode> children = this.getChildren();
        if (children.size() == 0) {
            sb.append("/>");
            return;
        }
        sb.append(">");
        for (SimpleNode child : children) {
            child.toXMLImpl(sb);
        }
        sb.append("</");
        sb.append(this.getQName());
        sb.append(">");
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        HashMap<String, SimpleElement> elementMap;
        ArrayList<SimpleAttribute> attrList = this.getAttributes();
        int size = attrList.size();
        if (size > 0) {
            this.printDepth(out, 2 * depth);
            out.println("[\"@attributes\"]=>");
            this.printDepth(out, 2 * depth);
            out.println("array(" + size + ") {");
            for (SimpleAttribute attr : attrList) {
                attr.varDumpNested(env, out, depth + 1, valueSet);
            }
            this.printDepth(out, 2 * depth);
            out.println('}');
        }
        if ((size = (elementMap = this.getElementMap()).size()) > 0) {
            for (Map.Entry<String, SimpleElement> entry : elementMap.entrySet()) {
                this.printDepth(out, 2 * depth);
                out.println("[\"" + entry.getKey() + "\"]=>");
                entry.getValue().varDumpNested(env, out, depth, valueSet);
            }
        } else if (this.getChildren().size() > 0) {
            this.printDepth(out, 2 * depth);
            out.println("[0]=>");
            this.getChildren().get(0).varDumpNested(env, out, depth, valueSet);
        }
    }

    @Override
    void varDumpNested(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        if (this.getElementList().size() == 0 && this.getChildren().size() > 0) {
            this.getChildren().get(0).varDumpNested(env, out, depth, valueSet);
            return;
        }
        int size = this.getObjectSize();
        this.printDepth(out, 2 * depth);
        out.println("object(SimpleXMLElement) (" + size + ") {");
        this.varDumpImpl(env, out, depth + 1, valueSet);
        this.printDepth(out, 2 * depth);
        out.println('}');
    }

    @Override
    public void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        HashMap<String, SimpleElement> elementMap;
        ArrayList<SimpleAttribute> attrList = this.getAttributes();
        int size = attrList.size();
        if (size > 0) {
            this.printDepth(out, 4 * depth);
            out.print("[@attributes] => ");
            out.println("Array");
            this.printDepth(out, 4 * (depth + 1));
            out.println('(');
            for (SimpleAttribute attr : attrList) {
                attr.printRNested(env, out, depth + 2, valueSet);
            }
            this.printDepth(out, 4 * (depth + 1));
            out.println(')');
            out.println();
        }
        if ((size = (elementMap = this.getElementMap()).size()) > 0) {
            for (Map.Entry<String, SimpleElement> entry : elementMap.entrySet()) {
                this.printDepth(out, 4 * depth);
                out.print("[" + entry.getKey() + "] => ");
                entry.getValue().printRNested(env, out, depth + 1, valueSet);
            }
        } else if (this.getChildren().size() > 0) {
            this.printDepth(out, 4 * depth);
            out.print("[0] => ");
            this.getChildren().get(0).printRNested(env, out, depth, valueSet);
        }
    }

    @Override
    void printRNested(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        if (this.getElementList().size() == 0 && this.getChildren().size() > 0) {
            this.getChildren().get(0).printRNested(env, out, depth, valueSet);
            return;
        }
        out.println("SimpleXMLElement Object");
        this.printDepth(out, 4 * depth);
        out.println('(');
        this.printRImpl(env, out, depth + 1, valueSet);
        this.printDepth(out, 4 * depth);
        out.println(')');
        out.println();
    }

    @Override
    public String toString() {
        if (this.getElementList().size() == 0 && this.getChildren().size() > 0) {
            return this.getChildren().get(0).toString();
        }
        return "";
    }
}

