/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.simplexml.node;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.simplexml.node.SimpleAttribute;
import com.caucho.quercus.lib.simplexml.node.SimpleElement;
import com.caucho.quercus.lib.simplexml.node.SimpleElementList;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleNode {
    SimpleAttribute _namespace;
    String _prefix;
    String _name;
    String _value;
    ArrayList<SimpleNode> _children;
    ArrayList<SimpleElement> _elementList;
    HashMap<String, SimpleElement> _elementMap;
    ArrayList<SimpleAttribute> _attributeList;
    HashMap<String, SimpleAttribute> _attributeMap;
    LinkedHashMap<String, SimpleAttribute> _namespaceMap;
    SimpleNode _parent;

    public SimpleNode getParent() {
        return this._parent;
    }

    public void setParent(SimpleNode parent) {
        this._parent = parent;
    }

    public String getPrefix() {
        int i = this._name.indexOf(58);
        if (i >= 0) {
            return this._name.substring(0, i);
        }
        return null;
    }

    public void removePrefix() {
        int i = this._name.indexOf(58);
        if (i >= 0) {
            this._name = this._name.substring(i + 1);
        }
    }

    public String getQName() {
        return this._name;
    }

    public String getName() {
        int i = this._name.indexOf(58);
        if (i >= 0) {
            return this._name.substring(i + 1);
        }
        return this._name;
    }

    public void setQName(String name) {
        this._name = name;
    }

    public SimpleAttribute getNamespace() {
        return this._namespace;
    }

    public SimpleAttribute getNamespace(String qName, boolean isRecursive) {
        SimpleAttribute namespace = this._namespaceMap.get(qName);
        if (namespace != null) {
            return namespace;
        }
        if (isRecursive && this.getParent() != null) {
            return this._parent.getNamespace(qName, isRecursive);
        }
        return null;
    }

    public void setNamespace(String namespace, String prefix) {
        SimpleAttribute attr = SimpleNode.createNamespaceAttribute(namespace, prefix);
        this.setNamespace(attr);
    }

    public void setNamespace(SimpleAttribute namespace) {
        if (this._namespace == null) {
            this._namespace = namespace;
        }
    }

    public LinkedHashMap<String, SimpleAttribute> getNamespaces() {
        return this._namespaceMap;
    }

    public String getValue() {
        return this._value;
    }

    public static SimpleAttribute createNamespaceAttribute(String namespace, String prefix) {
        if (prefix != null) {
            return new SimpleAttribute("xmlns:" + prefix, namespace);
        }
        return new SimpleAttribute("xmlns", namespace);
    }

    public void setValue(String value) {
        this._value = value;
    }

    public final void addChild(SimpleNode child) {
        if (child.isElement()) {
            SimpleElement element = (SimpleElement)child;
            this._children.add(element);
            this._elementList.add(element);
            SimpleElement existingChild = this._elementMap.get(element.getName());
            if (existingChild == null) {
                this._elementMap.put(element.getName(), element);
            } else if (existingChild.isElementList()) {
                SimpleElementList list = (SimpleElementList)existingChild;
                list.addSameNameSibling(element);
            } else {
                SimpleElementList list = new SimpleElementList();
                list.addSameNameSibling(existingChild);
                list.addSameNameSibling(element);
                this._elementMap.put(element.getName(), list);
            }
        } else if (child.isText()) {
            this._children.add(child);
        } else if (child.isAttribute()) {
            this.addAttribute((SimpleAttribute)child);
        }
    }

    public SimpleElement getElement(String name) {
        return this._elementMap.get(name);
    }

    public ArrayList<SimpleNode> getChildren() {
        return this._children;
    }

    public SimpleNode get(int index) {
        if (index == 0 && this._elementList.size() == 0 && this._children.size() > 0) {
            return this;
        }
        return null;
    }

    public ArrayList<SimpleElement> getElementList() {
        return this._elementList;
    }

    HashMap<String, SimpleElement> getElementMap() {
        return this._elementMap;
    }

    public void removeChildren() {
        this._children.clear();
        this._elementList.clear();
        this._elementMap.clear();
    }

    public final void addAttribute(String name, String value) {
        this.addAttribute(name, value, null);
    }

    public final void addAttribute(String name, String value, String namespace) {
        SimpleAttribute attr = new SimpleAttribute(name, value, namespace);
        this.addAttribute(attr);
    }

    public void addAttribute(SimpleAttribute attribute) {
        this.addAttributeImpl(attribute);
    }

    private void addAttributeImpl(SimpleAttribute attr) {
        if (this.getNamespace() == null) {
            String name = this.getPrefix() != null ? "xmlns:" + this.getPrefix() : "xmlns";
            if (attr.getQName().equals(name)) {
                this.setNamespace(attr);
                this.addNamespace(attr);
                return;
            }
        }
        if ("xmlns".equals(attr.getPrefix()) || attr.getPrefix() == null && attr.getName().equals("xmlns")) {
            this.addNamespace(attr);
        } else if (this._attributeMap.get(attr.getQName()) == null) {
            this._attributeMap.put(attr.getQName(), attr);
            this._attributeList.add(attr);
            if (attr.getNamespace() != null && !this.addNamespace(attr.getNamespace())) {
                attr.setNamespace(null);
            }
        } else if (attr.getPrefix() != null) {
            attr.removePrefix();
            this.addAttributeImpl(attr);
        }
    }

    public boolean addNamespace(SimpleAttribute namespace) {
        if (namespace.getPrefix() == null) {
            if (this._namespaceMap.get(namespace.getQName()) == null) {
                this._namespaceMap.put(namespace.getQName(), namespace);
                return true;
            }
            return false;
        }
        if (this.getNamespace(namespace.getQName(), true) == null) {
            this._namespaceMap.put(namespace.getQName(), namespace);
            return true;
        }
        return false;
    }

    public SimpleAttribute getAttribute(String name) {
        return this._attributeMap.get(name);
    }

    public ArrayList<SimpleAttribute> getAttributes() {
        return this._attributeList;
    }

    public HashMap<String, SimpleAttribute> getAttributeMap() {
        return this._attributeMap;
    }

    public boolean isSameNamespace(String namespace) {
        if (namespace == null || namespace.length() == 0) {
            return true;
        }
        if (this.getNamespace() == null) {
            return false;
        }
        return namespace.equals(this.getNamespace().getValue());
    }

    public boolean isSamePrefix(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return true;
        }
        return prefix.equals(this.getPrefix());
    }

    public boolean isText() {
        return false;
    }

    public boolean isAttribute() {
        return false;
    }

    public boolean isElement() {
        return false;
    }

    public boolean isElementList() {
        return false;
    }

    public int getObjectSize() {
        return 1;
    }

    public Iterator<SimpleElement> iterator() {
        return this._elementList.iterator();
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder();
        this.toXMLImpl(sb);
        return sb.toString();
    }

    protected abstract void toXMLImpl(StringBuilder var1);

    public String toString() {
        if (this._value != null) {
            return this._value;
        }
        return "";
    }

    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        this.varDumpNested(env, out, depth, valueSet);
    }

    abstract void varDumpNested(Env var1, WriteStream var2, int var3, IdentityHashMap<Value, String> var4) throws IOException;

    public void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        this.printRNested(env, out, depth, valueSet);
    }

    abstract void printRNested(Env var1, WriteStream var2, int var3, IdentityHashMap<Value, String> var4) throws IOException;

    final void printDepth(WriteStream out, int depth) throws IOException {
        for (int i = 0; i < depth; ++i) {
            out.print(' ');
        }
    }
}

