/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.spl;

import com.caucho.quercus.annotation.Name;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.ArrayModule;
import com.caucho.quercus.lib.spl.ArrayAccess;
import com.caucho.quercus.lib.spl.Countable;
import com.caucho.quercus.lib.spl.IteratorAggregate;
import com.caucho.quercus.lib.spl.Traversable;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayObject
implements ArrayAccess,
Countable,
IteratorAggregate,
Traversable {
    private static L10N L = new L10N(ArrayObject.class);
    public static final int STD_PROP_LIST = 1;
    public static final int ARRAY_AS_PROPS = 2;
    private final Env _env;
    private Value _value;
    private int _flags;
    private QuercusClass _iteratorClass;

    @Name(value="__construct")
    public ArrayObject(Env env, @Optional Value value, @Optional int flags, @Optional(value="ArrayIterator") String iteratorClassName) {
        if (value.isNull()) {
            value = new ArrayValueImpl();
        }
        this._env = env;
        this._value = value;
        this._flags = flags;
        QuercusClass iteratorClass = this._env.findClass(iteratorClassName);
        if (iteratorClass == null || !iteratorClass.isA("Iterator")) {
            throw new IllegalArgumentException(L.l("A class that implements Iterator must be specified"));
        }
        this._iteratorClass = iteratorClass;
    }

    public void append(Value value) {
        this._value.put(value);
    }

    public void asort(@Optional long sortFlag) {
        sortFlag = 0L;
        if (this._value instanceof ArrayValue) {
            ArrayModule.asort(this._env, (ArrayValue)this._value, sortFlag);
        }
    }

    @Override
    public int count() {
        return this._value.getCount(this._env);
    }

    public Value exchangeArray(ArrayValue array) {
        Value oldValue = this._value;
        this._value = array;
        return oldValue;
    }

    public Value getArrayCopy() {
        return this._value.copy();
    }

    public int getFlags() {
        return this._flags;
    }

    @Override
    public ObjectValue getIterator() {
        Value[] args = new Value[]{this._value, LongValue.create(this._flags)};
        return (ObjectValue)this._iteratorClass.callNew(this._env, args);
    }

    public String getIteratorClass() {
        return this._iteratorClass.getName();
    }

    public void ksort(@Optional long sortFlag) {
        if (this._value instanceof ArrayValue) {
            ArrayModule.ksort(this._env, (ArrayValue)this._value, sortFlag);
        }
    }

    public void natcasesort() {
        if (this._value instanceof ArrayValue) {
            ArrayModule.natcasesort((ArrayValue)this._value);
        }
    }

    public void natsort() {
        if (this._value instanceof ArrayValue) {
            ArrayModule.natsort((ArrayValue)this._value);
        }
    }

    @Override
    public boolean offsetExists(Value offset) {
        return this._value.get(offset).isset();
    }

    @Override
    public Value offsetGet(Value offset) {
        return this._value.get(offset);
    }

    @Override
    public Value offsetSet(Value offset, Value value) {
        return this._value.put(offset, value);
    }

    @Override
    public Value offsetUnset(Value offset) {
        return this._value.remove(offset);
    }

    public void setFlags(Value flags) {
        this._flags = flags.toInt();
    }

    public void setIteratorClass(String iteratorClass) {
        this._iteratorClass = this._env.findClass(iteratorClass);
    }

    public void uasort(Callback func) {
        if (this._value instanceof ArrayValue) {
            ArrayModule.uasort(this._env, (ArrayValue)this._value, func, 0L);
        }
    }

    public void uksort(Callback func, @Optional long sortFlag) {
        if (this._value instanceof ArrayValue) {
            ArrayModule.uksort(this._env, (ArrayValue)this._value, func, sortFlag);
        }
    }

    public Value __getField(StringValue key) {
        if ((this._flags & 2) != 0) {
            return this._value.get(key);
        }
        return NullValue.NULL;
    }

    private static void printDepth(WriteStream out, int depth) throws IOException {
        for (int i = depth; i > 0; --i) {
            out.print(' ');
        }
    }

    public void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        if ((this._flags & 1) != 0) {
            out.print("ArrayObject");
            out.print(' ');
            out.println("Object");
            ArrayObject.printDepth(out, 4 * depth);
            out.println("(");
            out.print(")");
        } else {
            out.print("ArrayObject");
            out.print(' ');
            out.println("Object");
            ArrayObject.printDepth(out, 4 * depth);
            out.println("(");
            ++depth;
            Iterator<Map.Entry<Value, Value>> iterator = this._value.getIterator(env);
            while (iterator.hasNext()) {
                Map.Entry<Value, Value> entry = iterator.next();
                Value key = entry.getKey();
                Value value = entry.getValue();
                ArrayObject.printDepth(out, 4 * depth);
                out.print("[" + key + "] => ");
                value.printR(env, out, depth + 1, valueSet);
                out.println();
            }
            ArrayObject.printDepth(out, 4 * --depth);
            out.println(")");
        }
    }

    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        if ((this._flags & 1) != 0) {
            out.println("object(ArrayObject) (0) {");
            out.print("}");
        } else {
            out.println("object(ArrayObject) (" + this._value.getSize() + ") {");
            ++depth;
            Iterator<Map.Entry<Value, Value>> iterator = this._value.getIterator(env);
            while (iterator.hasNext()) {
                Map.Entry<Value, Value> entry = iterator.next();
                Value key = entry.getKey();
                Value value = entry.getValue();
                ArrayObject.printDepth(out, 2 * depth);
                out.print("[");
                if (key instanceof StringValue) {
                    out.print("\"" + key + "\"");
                } else {
                    out.print((Object)key);
                }
                out.println("]=>");
                ArrayObject.printDepth(out, 2 * depth);
                value.varDump(env, out, depth, valueSet);
                out.println();
            }
            ArrayObject.printDepth(out, 2 * --depth);
            out.print("}");
        }
    }
}

