/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.spl;

import com.caucho.quercus.annotation.Name;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.spl.OuterIterator;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.EnumSet;

public class RecursiveIteratorIterator
implements OuterIterator {
    private static final L10N L = new L10N(RecursiveIteratorIterator.class);
    public static final int LEAVES_ONLY = 0;
    public static final int SELF_FIRST = 1;
    public static final int CHILD_FIRST = 2;
    public static final int CATCH_GET_CHILD = 16;
    private final Env _env;
    private final Mode _mode;
    private final EnumSet<Flags> _flags;
    private int _maxDepth = -1;
    private Stack _stack = new Stack();
    private static final StringValue _GET_CHILDREN = new StringBuilderValue("getChildren");
    private static final StringValue _HAS_CHILDREN = new StringBuilderValue("hasChildren");
    private static final StringValue _KEY = new StringBuilderValue("next");
    private static final StringValue _NEXT = new StringBuilderValue("next");
    private static final StringValue _CURRENT = new StringBuilderValue("current");
    private static final StringValue _REWIND = new StringBuilderValue("rewind");
    private static final StringValue _VALID = new StringBuilderValue("valid");

    @Name(value="__construct")
    public RecursiveIteratorIterator(Env env, ObjectValue iter, @Optional(value="") int mode, @Optional(value="0") int flags) {
        this._env = env;
        this._stack.add(new StackEntry(iter));
        switch (mode) {
            case 0: {
                this._mode = Mode.LEAVES_ONLY;
                break;
            }
            case 1: {
                this._mode = Mode.SELF_FIRST;
                break;
            }
            case 2: {
                this._mode = Mode.CHILD_FIRST;
                break;
            }
            default: {
                this._mode = Mode.LEAVES_ONLY;
            }
        }
        this._flags = (flags & 0x10) != 0 ? EnumSet.of(Flags.CATCH_GET_CHILD) : EnumSet.noneOf(Flags.class);
    }

    public void beginChildren() {
    }

    public void beginIteration() {
    }

    public Value callGetChildren() {
        return this._stack.getLast().getChildren();
    }

    public boolean callHasChildren() {
        return this._stack.getLast().hasChildren();
    }

    public Value current() {
        return this._stack.getLast().current();
    }

    public void endChildren() {
    }

    public void endIteration() {
    }

    public int getDepth() {
        return this._stack.size() - 1;
    }

    public ObjectValue getInnerIterator() {
        return null;
    }

    public int getMaxDepth() {
        return this._maxDepth;
    }

    public Value getSubIterator(@Optional(value="-1") int depth) {
        if (depth == -1) {
            return this._stack.getLast().getIterator();
        }
        if (this._stack.size() <= depth) {
            return UnsetValue.UNSET;
        }
        return ((StackEntry)this._stack.get(depth)).getIterator();
    }

    public Value key() {
        return this._stack.getLast().key();
    }

    public void next() {
        StackEntry last = this._stack.getLast();
        last.next();
    }

    public void nextElement() {
    }

    public void rewind() {
        while (this._stack.size() > 1) {
            this._stack.removeLast();
            this.endChildren();
        }
        this._stack.getLast().rewind();
    }

    public void setMaxDepth(int maxDepth) {
        this._maxDepth = maxDepth;
    }

    public boolean valid() {
        for (int i = this._stack.size() - 1; i >= 0; --i) {
            if (!((StackEntry)this._stack.get(i)).valid()) continue;
            return true;
        }
        return false;
    }

    private class StackEntry {
        final ObjectValue _iterator;

        public StackEntry(ObjectValue obj) {
            this._iterator = obj;
        }

        public ObjectValue getIterator() {
            return this._iterator;
        }

        public Value current() {
            return this._iterator.callMethod(RecursiveIteratorIterator.this._env, _CURRENT);
        }

        public Value key() {
            return this._iterator.callMethod(RecursiveIteratorIterator.this._env, _KEY);
        }

        public void next() {
            this._iterator.callMethod(RecursiveIteratorIterator.this._env, _NEXT);
        }

        public void rewind() {
            this._iterator.callMethod(RecursiveIteratorIterator.this._env, _REWIND);
        }

        public boolean valid() {
            return this._iterator.callMethod(RecursiveIteratorIterator.this._env, _VALID).toBoolean();
        }

        public boolean hasChildren() {
            return this._iterator.callMethod(RecursiveIteratorIterator.this._env, _HAS_CHILDREN).toBoolean();
        }

        public Value getChildren() {
            return this._iterator.callMethod(RecursiveIteratorIterator.this._env, _GET_CHILDREN);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Stack
    extends ArrayList<StackEntry> {
        private Stack() {
        }

        @Override
        public StackEntry getLast() {
            return (StackEntry)this.get(this.size() - 1);
        }

        @Override
        public StackEntry removeLast() {
            return (StackEntry)this.remove(this.size() - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Flags {
        CATCH_GET_CHILD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        LEAVES_ONLY,
        SELF_FIRST,
        CHILD_FIRST;

    }
}

