/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.string;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.UsesSymbolTable;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DefaultValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LocaleInfo;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.lib.file.BinaryOutput;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.quercus.lib.string.Crypt;
import com.caucho.quercus.lib.string.StringUtility;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import com.caucho.vfs.ByteToChar;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringModule
extends AbstractQuercusModule {
    private static final Logger log = Logger.getLogger(StringModule.class.getName());
    private static final L10N L = new L10N(StringModule.class);
    public static final int CRYPT_SALT_LENGTH = 2;
    public static final int CRYPT_STD_DES = 0;
    public static final int CRYPT_EXT_DES = 0;
    public static final int CRYPT_MD5 = 0;
    public static final int CRYPT_BLOWFISH = 0;
    public static final int CHAR_MAX = 1;
    public static final int LC_CTYPE = 1;
    public static final int LC_NUMERIC = 2;
    public static final int LC_TIME = 3;
    public static final int LC_COLLATE = 4;
    public static final int LC_MONETARY = 5;
    public static final int LC_ALL = 6;
    public static final int LC_MESSAGES = 7;
    public static final int STR_PAD_LEFT = 1;
    public static final int STR_PAD_RIGHT = 0;
    public static final int STR_PAD_BOTH = 2;
    private static final DecimalFormatSymbols DEFAULT_DECIMAL_FORMAT_SYMBOLS;
    private static final boolean[] TRIM_WHITESPACE;
    private static final char[] SOUNDEX_VALUES;

    public static StringValue addcslashes(StringValue source, String characters) {
        if (characters == null) {
            characters = "";
        }
        boolean[] bitmap = StringModule.parseCharsetBitmap(characters);
        int length = source.length();
        StringValue sb = source.createStringBuilder(length * 5 / 4);
        block9: for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (ch >= '\u0100' || !bitmap[ch]) {
                sb.append(ch);
                continue;
            }
            switch (ch) {
                case '\u0007': {
                    sb.append("\\a");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\u000b': {
                    sb.append("\\v");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (ch < ' ' || ch >= '\u007f') {
                        sb.append("\\");
                        sb.append((char)(48 + (ch >> 6 & 7)));
                        sb.append((char)(48 + (ch >> 3 & 7)));
                        sb.append((char)(48 + (ch & 7)));
                        continue block9;
                    }
                    sb.append("\\");
                    sb.append(ch);
                }
            }
        }
        return sb;
    }

    private static boolean[] parseCharsetBitmap(String charset) {
        boolean[] bitmap = new boolean[256];
        int length = charset.length();
        for (int i = 0; i < length; ++i) {
            char ch = charset.charAt(i);
            if (ch >= '\u0100') continue;
            bitmap[ch] = true;
            if (length <= i + 3 || charset.charAt(i + 1) != '.' || charset.charAt(i + 2) != '.') continue;
            char last = charset.charAt(i + 3);
            if (last < ch) {
                throw new RuntimeException(L.l("Invalid range."));
            }
            i += 3;
            while (ch <= last) {
                bitmap[ch] = true;
                ch = (char)(ch + '\u0001');
            }
        }
        return bitmap;
    }

    public static StringValue addslashes(StringValue source) {
        StringValue sb = source.createStringBuilder(source.length() * 5 / 4);
        int length = source.length();
        block6: for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            switch (ch) {
                case '\u0000': {
                    sb.append("\\0");
                    continue block6;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block6;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block6;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb;
    }

    public static StringValue bin2hex(Env env, InputStream is) {
        try {
            int ch;
            StringValue sb = env.createUnicodeBuilder();
            while ((ch = is.read()) >= 0) {
                int d = ch >> 4 & 0xF;
                if (d < 10) {
                    sb.append((char)(d + 48));
                } else {
                    sb.append((char)(d + 97 - 10));
                }
                d = ch & 0xF;
                if (d < 10) {
                    sb.append((char)(d + 48));
                    continue;
                }
                sb.append((char)(d + 97 - 10));
            }
            return sb;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static StringValue chop(Env env, StringValue str, @Optional String charset) {
        return StringModule.rtrim(env, str, charset);
    }

    public static String chr(long value) {
        return String.valueOf((char)value);
    }

    public static String chunk_split(String body, @Optional(value="76") int chunkLen, @Optional(value="\"\\r\\n\"") String end) {
        if (body == null) {
            body = "";
        }
        if (end == null) {
            end = "";
        }
        if (chunkLen < 1) {
            throw new IllegalArgumentException(L.l("bad value {0}", (long)chunkLen));
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i + chunkLen <= body.length()) {
            sb.append(body.substring(i, i + chunkLen));
            sb.append(end);
            i += chunkLen;
        }
        if (i < body.length()) {
            sb.append(body.substring(i));
            sb.append(end);
        }
        return sb.toString();
    }

    public static String convert_cyr_string(Env env, String str, String from, String to) {
        env.stub("convert_cyr_string");
        return str;
    }

    public static Value convert_uudecode(Env env, String source) {
        try {
            char ch1;
            if (source == null || source.length() == 0) {
                return BooleanValue.FALSE;
            }
            ByteToChar byteToChar = env.getByteToChar();
            int length = source.length();
            int i = 0;
            while (i < length && (ch1 = source.charAt(i++)) != '`' && ch1 != ' ') {
                if (ch1 < ' ' || '_' < ch1) continue;
                for (int sublen = ch1 - 32; sublen > 0; sublen -= 3) {
                    int code = (source.charAt(i++) - 32 & 0x3F) << 18;
                    code += (source.charAt(i++) - 32 & 0x3F) << 12;
                    code += (source.charAt(i++) - 32 & 0x3F) << 6;
                    byteToChar.addByte((code += source.charAt(i++) - 32 & 0x3F) >> 16);
                    if (sublen > 1) {
                        byteToChar.addByte(code >> 8);
                    }
                    if (sublen <= 2) continue;
                    byteToChar.addByte(code);
                }
            }
            return env.createString(byteToChar.getConvertedString());
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static Value convert_uuencode(StringValue source) {
        if (source == null || source.length() == 0) {
            return BooleanValue.FALSE;
        }
        StringValue result = source.createStringBuilder();
        int i = 0;
        int length = source.length();
        while (i < length) {
            int sublen = length - i;
            if (45 < sublen) {
                sublen = 45;
            }
            result.append((char)(sublen + 32));
            int end = i + sublen;
            while (i < end) {
                int code = source.charAt(i++) << 16;
                if (i < length) {
                    code += source.charAt(i++) << 8;
                }
                if (i < length) {
                    code += source.charAt(i++);
                }
                result.append(StringModule.toUUChar(code >> 18 & 0x3F));
                result.append(StringModule.toUUChar(code >> 12 & 0x3F));
                result.append(StringModule.toUUChar(code >> 6 & 0x3F));
                result.append(StringModule.toUUChar(code & 0x3F));
            }
            result.append('\n');
        }
        result.append('`');
        result.append('\n');
        return result;
    }

    public static Value count_chars(StringValue data, @Optional(value="0") int mode) {
        if (data == null) {
            data = StringValue.EMPTY;
        }
        int[] count = new int[256];
        int length = data.length();
        for (int i = 0; i < length; ++i) {
            int n = data.charAt(i) & 0xFF;
            count[n] = count[n] + 1;
        }
        switch (mode) {
            case 0: {
                ArrayValueImpl result = new ArrayValueImpl();
                for (int i = 0; i < count.length; ++i) {
                    ((ArrayValue)result).put(LongValue.create(i), LongValue.create(count[i]));
                }
                return result;
            }
            case 1: {
                ArrayValueImpl result = new ArrayValueImpl();
                for (int i = 0; i < count.length; ++i) {
                    if (count[i] <= 0) continue;
                    ((ArrayValue)result).put(LongValue.create(i), new LongValue(count[i]));
                }
                return result;
            }
            case 2: {
                ArrayValueImpl result = new ArrayValueImpl();
                for (int i = 0; i < count.length; ++i) {
                    if (count[i] != 0) continue;
                    ((ArrayValue)result).put(new LongValue(i), new LongValue(count[i]));
                }
                return result;
            }
            case 3: {
                StringValue sb = data.createStringBuilder();
                for (int i = 0; i < count.length; ++i) {
                    if (count[i] <= 0) continue;
                    sb.append((char)i);
                }
                return sb;
            }
            case 4: {
                StringValue sb = data.createStringBuilder();
                for (int i = 0; i < count.length; ++i) {
                    if (count[i] != 0) continue;
                    sb.append((char)i);
                }
                return sb;
            }
        }
        return BooleanValue.FALSE;
    }

    public static long crc32(InputStream is) {
        try {
            int ch;
            CRC32 crc = new CRC32();
            while ((ch = is.read()) >= 0) {
                crc.update((byte)ch);
            }
            return crc.getValue() & 0xFFFFFFFFFFFFFFFFL;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public static String crypt(String string, @Optional String salt) {
        if (string == null) {
            string = "";
        }
        if (salt == null || salt.equals("")) {
            salt = "" + Crypt.resultToChar(RandomUtil.nextInt((int)64)) + Crypt.resultToChar(RandomUtil.nextInt((int)64));
        }
        return Crypt.crypt(string, salt);
    }

    public static Value explode(StringValue separator, StringValue string, @Optional(value="0x7fffffff") long limit) {
        StringValue chunk;
        LongValue key;
        int tail;
        if (separator.length() == 0) {
            return BooleanValue.FALSE;
        }
        ArrayValueImpl array = new ArrayValueImpl();
        int head = 0;
        int i = 0;
        while ((tail = string.indexOf(separator, head)) >= 0 && limit > (long)(i + 1)) {
            key = LongValue.create(i++);
            chunk = string.substring(head, tail);
            ((ArrayValue)array).put(key, chunk);
            head = tail + separator.length();
        }
        key = LongValue.create(i);
        chunk = string.substring(head);
        ((ArrayValue)array).put(key, chunk);
        return array;
    }

    public static Value fprintf(Env env, @NotNull BinaryOutput os, StringValue format, Value[] args) {
        Value value = StringModule.sprintf(format, args);
        return FileModule.fwrite(env, os, value.toInputStream(), Integer.MAX_VALUE);
    }

    public static Value implode(Env env, Value glueV, Value piecesV) {
        StringValue glue;
        ArrayValue pieces;
        if (piecesV instanceof ArrayValue) {
            pieces = (ArrayValue)piecesV;
            glue = glueV.toStringValue();
        } else if (glueV instanceof ArrayValue) {
            pieces = (ArrayValue)glueV;
            glue = piecesV.toStringValue();
        } else {
            env.warning(L.l("neither argument to implode is an array: {0}, {1}", (Object)glueV.getClass().getName(), (Object)piecesV.getClass().getName()));
            return NullValue.NULL;
        }
        StringValue sb = glue.createStringBuilder();
        boolean isFirst = true;
        for (ArrayValue.Entry entry = pieces.getHead(); entry != null; entry = entry.getNext()) {
            if (!isFirst) {
                sb = sb.append(glue);
            }
            isFirst = false;
            sb = sb.append(entry.getValue());
        }
        return sb;
    }

    public static Value join(Env env, Value glueV, Value piecesV) {
        return StringModule.implode(env, glueV, piecesV);
    }

    public static StringValue md5(Env env, InputStream is, @Optional boolean rawOutput) {
        try {
            int ch;
            MessageDigest md = MessageDigest.getInstance("MD5");
            while ((ch = is.read()) >= 0) {
                md.update((byte)ch);
            }
            byte[] digest = md.digest();
            StringValue sb = env.createUnicodeBuilder();
            for (int i = 0; i < digest.length; ++i) {
                int d1 = digest[i] >> 4 & 0xF;
                int d2 = digest[i] & 0xF;
                sb.append(StringModule.toHexChar(d1));
                sb.append(StringModule.toHexChar(d2));
            }
            return sb;
        }
        catch (Exception e) {
            throw new QuercusModuleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Value md5_file(Env env, Path source, @Optional boolean rawOutput) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            ReadStream is = null;
            try {
                int d;
                is = source.openRead();
                while ((d = is.read()) >= 0) {
                    md.update((byte)d);
                }
                StringValue stringValue = StringModule.digestToString(env, md.digest());
                return stringValue;
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
                BooleanValue booleanValue = BooleanValue.FALSE;
                return booleanValue;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e4) {}
            }
        }
        catch (Exception e3) {
            throw new QuercusModuleException(e3);
        }
    }

    private static StringValue digestToString(Env env, byte[] digest) {
        StringValue sb = env.createUnicodeBuilder();
        for (int i = 0; i < digest.length; ++i) {
            int d1 = digest[i] >> 4 & 0xF;
            int d2 = digest[i] & 0xF;
            sb.append(StringModule.toHexChar(d1));
            sb.append(StringModule.toHexChar(d2));
        }
        return sb;
    }

    public static String money_format(Env env, String format, double value) {
        Locale monetaryLocale = env.getLocaleInfo().getMonetary();
        return NumberFormat.getCurrencyInstance(monetaryLocale).format(value);
    }

    public static String metaphone(String string) {
        int index;
        if (string == null) {
            string = "";
        }
        int length = string.length();
        char ch = '\u0000';
        for (index = 0; index < length && ('A' > (ch = StringModule.toUpperCase(string.charAt(index))) || ch > 'Z'); ++index) {
        }
        if (index == length) {
            return "";
        }
        int lastIndex = length - 1;
        StringBuilder result = new StringBuilder(length);
        char nextCh = index < lastIndex ? StringModule.toUpperCase(string.charAt(index + 1)) : (char)'\u0000';
        block0 : switch (ch) {
            case 'A': {
                if (nextCh == 'E') {
                    result.append('E');
                    index += 2;
                    break;
                }
                result.append('A');
                ++index;
                break;
            }
            case 'E': 
            case 'I': 
            case 'O': 
            case 'U': {
                result.append(ch);
                ++index;
                break;
            }
            case 'G': 
            case 'K': 
            case 'P': {
                if (nextCh != 'N') break;
                result.append('N');
                index += 2;
                break;
            }
            case 'W': {
                if (nextCh == 'H' || nextCh == 'R') {
                    result.append(nextCh);
                    index += 2;
                    break;
                }
                switch (nextCh) {
                    case 'A': 
                    case 'E': 
                    case 'I': 
                    case 'O': 
                    case 'U': {
                        result.append('W');
                        index += 2;
                        break block0;
                    }
                }
                break;
            }
            case 'X': {
                result.append('S');
                ++index;
                break;
            }
        }
        while (index < length) {
            char prevCh = index > 0 ? StringModule.toUpperCase(string.charAt(index - 1)) : (char)'\u0000';
            ch = StringModule.toUpperCase(string.charAt(index));
            if (ch >= 'A' && ch <= 'Z' && (ch != prevCh || ch == 'C')) {
                nextCh = index + 1 < length ? StringModule.toUpperCase(string.charAt(index + 1)) : (char)'\u0000';
                char nextnextCh = index + 2 < length ? StringModule.toUpperCase(string.charAt(index + 2)) : (char)'\u0000';
                block10 : switch (ch) {
                    case 'B': {
                        if (prevCh == 'M') break;
                        result.append('B');
                        break;
                    }
                    case 'C': {
                        switch (nextCh) {
                            case 'E': 
                            case 'I': 
                            case 'Y': {
                                if (nextCh == 'I' && nextnextCh == 'A') {
                                    result.append('X');
                                    break;
                                }
                                if (prevCh == 'S') break;
                                result.append('S');
                                break;
                            }
                            default: {
                                if (nextCh == 'H') {
                                    result.append('X');
                                    ++index;
                                    break;
                                }
                                result.append('K');
                                break;
                            }
                        }
                        break;
                    }
                    case 'D': {
                        if (nextCh == 'G') {
                            switch (nextnextCh) {
                                case 'E': 
                                case 'I': 
                                case 'Y': {
                                    result.append('J');
                                    ++index;
                                    break block10;
                                }
                            }
                            result.append('T');
                            break;
                        }
                        result.append('T');
                        break;
                    }
                    case 'G': {
                        if (nextCh == 'H') {
                            boolean isSilent = false;
                            if (index - 3 >= 0) {
                                char prev3Ch = StringModule.toUpperCase(string.charAt(index - 3));
                                switch (prev3Ch) {
                                    case 'B': 
                                    case 'D': 
                                    case 'H': {
                                        isSilent = true;
                                        break;
                                    }
                                }
                            }
                            if (!isSilent && index - 4 >= 0) {
                                char prev4Ch = StringModule.toUpperCase(string.charAt(index - 4));
                                boolean bl = isSilent = prev4Ch == 'H';
                            }
                            if (isSilent) break;
                            result.append('F');
                            ++index;
                            break;
                        }
                        if (nextCh == 'N') {
                            char nextnextnextCh = index + 3 < length ? StringModule.toUpperCase(string.charAt(index + 3)) : (char)'\u0000';
                            if (nextnextCh < 'A' || nextnextCh > 'Z' || nextnextCh == 'E' && nextnextnextCh == 'D') break;
                            result.append('K');
                            break;
                        }
                        if (prevCh == 'G') {
                            result.append('K');
                            break;
                        }
                        switch (nextCh) {
                            case 'E': 
                            case 'I': 
                            case 'Y': {
                                result.append('J');
                                break block10;
                            }
                        }
                        result.append('K');
                        break;
                    }
                    case 'H': 
                    case 'W': 
                    case 'Y': {
                        switch (nextCh) {
                            case 'A': 
                            case 'E': 
                            case 'I': 
                            case 'O': 
                            case 'U': {
                                if (ch == 'H') {
                                    switch (prevCh) {
                                        case 'C': 
                                        case 'G': 
                                        case 'P': 
                                        case 'S': 
                                        case 'T': {
                                            break block10;
                                        }
                                    }
                                    result.append('H');
                                    break block10;
                                }
                                result.append(ch);
                                break block10;
                            }
                        }
                        break;
                    }
                    case 'K': {
                        if (prevCh == 'C') break;
                        result.append('K');
                        break;
                    }
                    case 'P': {
                        if (nextCh == 'H') {
                            result.append('F');
                            break;
                        }
                        result.append('P');
                        break;
                    }
                    case 'Q': {
                        result.append('K');
                        break;
                    }
                    case 'S': {
                        if (nextCh == 'I' && (nextnextCh == 'O' || nextnextCh == 'A')) {
                            result.append('X');
                            break;
                        }
                        if (nextCh == 'H') {
                            result.append('X');
                            ++index;
                            break;
                        }
                        result.append('S');
                        break;
                    }
                    case 'T': {
                        if (nextCh == 'I' && (nextnextCh == 'O' || nextnextCh == 'A')) {
                            result.append('X');
                            break;
                        }
                        if (nextCh == 'H') {
                            result.append('0');
                            ++index;
                            break;
                        }
                        result.append('T');
                        break;
                    }
                    case 'V': {
                        result.append('F');
                        break;
                    }
                    case 'X': {
                        result.append('K');
                        result.append('S');
                        break;
                    }
                    case 'Z': {
                        result.append('S');
                        break;
                    }
                    case 'F': 
                    case 'J': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'R': {
                        result.append(ch);
                        break;
                    }
                }
            }
            ++index;
        }
        return result.toString();
    }

    public static String number_format(Env env, double value, @Optional int decimals, @Optional Value pointValue, @Optional Value groupValue) {
        DecimalFormatSymbols decimalFormatSymbols;
        String pattern;
        boolean isGroupDefault = groupValue instanceof DefaultValue;
        boolean isPointDefault = pointValue instanceof DefaultValue;
        if (!isPointDefault && isGroupDefault) {
            env.warning(L.l("wrong parameter count"));
            return null;
        }
        char point = '.';
        if (!pointValue.isNull()) {
            String pointString = pointValue.toString();
            point = pointString.length() == 0 ? (char)'\u0000' : (char)pointString.charAt(0);
        }
        char group = ',';
        if (!groupValue.isNull()) {
            String groupString = groupValue.toString();
            char c = group = groupString.length() == 0 ? (char)'\u0000' : (char)groupString.charAt(0);
        }
        if (decimals > 0) {
            StringBuilder patternBuilder = new StringBuilder(6 + decimals);
            patternBuilder.append(group == '\u0000' ? "###0." : "#,##0.");
            for (int i = 0; i < decimals; ++i) {
                patternBuilder.append('0');
            }
            pattern = patternBuilder.toString();
        } else {
            String string = pattern = group == '\u0000' ? "###0" : "#,##0";
        }
        if (point == '.' && group == ',') {
            decimalFormatSymbols = DEFAULT_DECIMAL_FORMAT_SYMBOLS;
        } else {
            decimalFormatSymbols = new DecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator(point);
            decimalFormatSymbols.setGroupingSeparator(group);
            decimalFormatSymbols.setZeroDigit('0');
        }
        DecimalFormat format = new DecimalFormat(pattern, decimalFormatSymbols);
        String result = format.format(value);
        if (point == '\u0000' && decimals > 0) {
            int i = result.lastIndexOf(point);
            return result.substring(0, i) + result.substring(i + 1, result.length());
        }
        return result;
    }

    public static long ord(StringValue string) {
        if (string.length() == 0) {
            return 0L;
        }
        return string.charAt(0);
    }

    @UsesSymbolTable
    public static Value parse_str(Env env, String str, @Optional @Reference Value ref) {
        if (str == null) {
            str = "";
        }
        boolean isRef = ref instanceof Var;
        ArrayValue result = null;
        if (isRef) {
            result = new ArrayValueImpl();
            ref.set(result);
        } else if (ref instanceof ArrayValue) {
            result = (ArrayValue)ref;
            isRef = true;
        } else {
            result = new ArrayValueImpl();
        }
        return StringUtility.parseStr(env, str, result, isRef, env.getHttpInputEncoding().toString());
    }

    public static long print(Env env, Value value) {
        value.print(env);
        return 1L;
    }

    public static Value quotemeta(StringValue string) {
        int len = string.length();
        StringValue sb = string.createStringBuilder(len * 5 / 4);
        block3: for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': {
                    sb.append("\\");
                    sb.append(ch);
                    continue block3;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb;
    }

    public static String quoted_printable_decode(String str) {
        if (str == null) {
            str = "";
        }
        StringBuilder sb = new StringBuilder();
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if ('!' <= ch && ch <= '<') {
                sb.append(ch);
                continue;
            }
            if ('>' <= ch && ch <= '~') {
                sb.append(ch);
                continue;
            }
            if (ch == ' ' || ch == '\t') {
                if (i + 1 < str.length() && (str.charAt(i + 1) == '\r' || str.charAt(i + 1) == '\n')) {
                    sb.append('=');
                    sb.append(StringModule.toUpperHexChar(ch >> 4));
                    sb.append(StringModule.toUpperHexChar(ch));
                    continue;
                }
                sb.append(ch);
                continue;
            }
            if (ch == '\r' || ch == '\n') {
                sb.append(ch);
                continue;
            }
            sb.append('=');
            sb.append(StringModule.toUpperHexChar(ch >> 4));
            sb.append(StringModule.toUpperHexChar(ch));
        }
        return sb.toString();
    }

    public static StringValue ltrim(Env env, StringValue string, @Optional String characters) {
        if (characters == null) {
            characters = "";
        }
        boolean[] trim = characters.equals("") ? TRIM_WHITESPACE : StringModule.parseCharsetBitmap(characters);
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (ch < '\u0100' && trim[ch]) continue;
            if (i == 0) {
                return string;
            }
            return string.substring(i);
        }
        return env.createEmptyString();
    }

    public static StringValue rtrim(Env env, StringValue string, @Optional String characters) {
        if (characters == null) {
            characters = "";
        }
        boolean[] trim = characters.equals("") ? TRIM_WHITESPACE : StringModule.parseCharsetBitmap(characters);
        for (int i = string.length() - 1; i >= 0; --i) {
            char ch = string.charAt(i);
            if (ch < '\u0100' && trim[ch]) continue;
            if (i == string.length()) {
                return string;
            }
            return (StringValue)string.subSequence(0, i + 1);
        }
        return env.createEmptyString();
    }

    public static Value setlocale(Env env, int category, Value localeArg, Value[] fallback) {
        LocaleInfo localeInfo = env.getLocaleInfo();
        if (localeArg instanceof ArrayValue) {
            for (Value value : ((ArrayValue)localeArg).values()) {
                Locale locale = StringModule.setLocale(localeInfo, category, value.toString());
                if (locale == null) continue;
                return env.createString(locale.toString());
            }
        } else {
            Locale locale = StringModule.setLocale(localeInfo, category, localeArg.toString());
            if (locale != null) {
                return env.createString(locale.toString());
            }
        }
        for (int i = 0; i < fallback.length; ++i) {
            Locale locale = StringModule.setLocale(localeInfo, category, fallback[i].toString());
            if (locale == null) continue;
            return env.createString(locale.toString());
        }
        return BooleanValue.FALSE;
    }

    private static Locale setLocale(LocaleInfo localeInfo, int category, String localeName) {
        Locale locale;
        int p = localeName.indexOf(95);
        int p1 = localeName.indexOf(45);
        if (p1 > 0 && (p1 < p || p < 0)) {
            p = p1;
        }
        if (p > 0) {
            String language = localeName.substring(0, p);
            int q = localeName.indexOf(45, p + 1);
            int q1 = localeName.indexOf(46, p + 1);
            if (q1 > 0 && (q1 < q || q < 0)) {
                q = q1;
            }
            if ((q1 = localeName.indexOf(64, p + 1)) > 0 && (q1 < q || q < 0)) {
                q = q1;
            }
            if ((q1 = localeName.indexOf(95, p + 1)) > 0 && (q1 < q || q < 0)) {
                q = q1;
            }
            if (q > 0) {
                String country = localeName.substring(p + 1, q);
                String variant = localeName.substring(q + 1);
                locale = new Locale(language, country, variant);
            } else {
                String country = localeName.substring(p + 1);
                locale = new Locale(language, country);
            }
        } else {
            locale = new Locale(localeName);
        }
        if (!StringModule.isValidLocale(locale)) {
            return null;
        }
        switch (category) {
            case 6: {
                localeInfo.setAll(locale);
                return localeInfo.getMessages();
            }
            case 4: {
                localeInfo.setCollate(locale);
                return localeInfo.getCollate();
            }
            case 1: {
                localeInfo.setCtype(locale);
                return localeInfo.getCtype();
            }
            case 5: {
                localeInfo.setMonetary(locale);
                return localeInfo.getMonetary();
            }
            case 2: {
                localeInfo.setNumeric(locale);
                return localeInfo.getNumeric();
            }
            case 3: {
                localeInfo.setTime(locale);
                return localeInfo.getTime();
            }
            case 7: {
                localeInfo.setMessages(locale);
                return localeInfo.getMessages();
            }
        }
        return null;
    }

    private static boolean isValidLocale(Locale locale) {
        Locale[] validLocales = Locale.getAvailableLocales();
        for (int i = 0; i < validLocales.length; ++i) {
            if (!validLocales[i].equals(locale)) continue;
            return true;
        }
        return false;
    }

    public static ArrayValue localeconv(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        Locale money = env.getLocaleInfo().getMonetary();
        DecimalFormatSymbols decimal = new DecimalFormatSymbols(money);
        Currency currency = NumberFormat.getInstance(money).getCurrency();
        array.put(env.createString("decimal_point"), env.createString(decimal.getDecimalSeparator()));
        array.put(env.createString("thousands_sep"), env.createString(decimal.getGroupingSeparator()));
        array.put(env.createString("int_curr_symbol"), env.createString(decimal.getInternationalCurrencySymbol()));
        array.put(env.createString("currency_symbol"), env.createString(decimal.getCurrencySymbol()));
        array.put(env.createString("mon_decimal_point"), env.createString(decimal.getMonetaryDecimalSeparator()));
        array.put(env.createString("mon_thousands_sep"), env.createString(decimal.getGroupingSeparator()));
        array.put(env.createString("positive_sign"), env.createEmptyString());
        array.put(env.createString("negative_sign"), env.createString(decimal.getMinusSign()));
        array.put(env.createString("int_frac_digits"), LongValue.create(currency.getDefaultFractionDigits()));
        array.put(env.createString("frac_digits"), LongValue.create(currency.getDefaultFractionDigits()));
        return array;
    }

    public static String sha1(String source, @Optional boolean rawOutput) {
        if (source == null) {
            source = "";
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            for (int i = 0; i < source.length(); ++i) {
                char ch = source.charAt(i);
                md.update((byte)ch);
            }
            byte[] digest = md.digest();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < digest.length; ++i) {
                int d1 = digest[i] >> 4 & 0xF;
                int d2 = digest[i] & 0xF;
                sb.append(StringModule.toHexChar(d1));
                sb.append(StringModule.toHexChar(d2));
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new QuercusException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Value sha1_file(Env env, Path source, @Optional boolean rawOutput) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            ReadStream is = null;
            try {
                int d;
                is = source.openRead();
                while ((d = is.read()) >= 0) {
                    md.update((byte)d);
                }
                StringValue stringValue = StringModule.digestToString(env, md.digest());
                return stringValue;
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
                BooleanValue booleanValue = BooleanValue.FALSE;
                return booleanValue;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e4) {}
            }
        }
        catch (Exception e3) {
            throw new QuercusException(e3);
        }
    }

    public static Value sscanf(StringValue string, StringValue format, @Optional Value[] args) {
        int fmtLen = format.length();
        int strlen = string.length();
        int sIndex = 0;
        int fIndex = 0;
        ArrayValueImpl array = new ArrayValueImpl();
        block5: while (fIndex < fmtLen && sIndex < strlen) {
            char ch;
            if (StringModule.isWhitespace(ch = format.charAt(fIndex++))) {
                while (fIndex < fmtLen && StringModule.isWhitespace(ch = format.charAt(fIndex))) {
                    ++fIndex;
                }
                ch = string.charAt(sIndex);
                if (!StringModule.isWhitespace(ch)) {
                    return array;
                }
                ++sIndex;
                while (sIndex < strlen && StringModule.isWhitespace(string.charAt(sIndex))) {
                    ++sIndex;
                }
                continue;
            }
            if (ch == '%') {
                int maxLen = -1;
                boolean suppressAssignment = false;
                block8: while (fIndex < fmtLen) {
                    ch = format.charAt(fIndex++);
                    switch (ch) {
                        case '%': {
                            if (string.charAt(sIndex) == '%') continue block5;
                            return array;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            if (maxLen < 0) {
                                maxLen = 0;
                            }
                            maxLen = 10 * maxLen + ch - 48;
                            continue block8;
                        }
                        case 's': {
                            sIndex = StringModule.sscanfString(string, sIndex, maxLen, array);
                            break;
                        }
                        default: {
                            log.fine(L.l("'{0}' is a bad sscanf string.", (Object)format));
                            return array;
                        }
                    }
                    continue block5;
                }
                continue;
            }
            if (ch == string.charAt(sIndex)) {
                ++sIndex;
                continue;
            }
            return array;
        }
        return array;
    }

    private static int sscanfString(StringValue string, int sIndex, int maxLen, ArrayValue array) {
        int strlen = string.length();
        if (maxLen < 0) {
            maxLen = Integer.MAX_VALUE;
        }
        StringValue sb = string.createStringBuilder();
        while (sIndex < strlen && maxLen-- > 0) {
            char ch = string.charAt(sIndex);
            if (StringModule.isWhitespace(ch)) {
                array.append(sb);
                return sIndex;
            }
            sb.append(ch);
            ++sIndex;
        }
        array.append(sb);
        return sIndex;
    }

    public static int printf(Env env, StringValue format, Value[] args) {
        Value str = StringModule.sprintf(format, args);
        str.print(env);
        return str.length();
    }

    public static Value soundex(StringValue string) {
        int length = string.length();
        if (length == 0) {
            return BooleanValue.FALSE;
        }
        StringValue result = string.createStringBuilder();
        int count = 0;
        char lastCode = '\u0000';
        for (int i = 0; i < length && count < 4; ++i) {
            char ch = StringModule.toUpperCase(string.charAt(i));
            if ('A' > ch || ch > 'Z') continue;
            char code = SOUNDEX_VALUES[ch - 65];
            if (count == 0) {
                result.append(ch);
                ++count;
            } else if (code != '0' && code != lastCode) {
                result.append(code);
                ++count;
            }
            lastCode = code;
        }
        while (count < 4) {
            result.append('0');
            ++count;
        }
        return result;
    }

    public static Value sprintf(StringValue format, Value[] args) {
        ArrayList<PrintfSegment> segments = StringModule.parsePrintfFormat(format);
        StringValue sb = format.createStringBuilder();
        for (PrintfSegment segment : segments) {
            segment.apply(sb, args);
        }
        return sb;
    }

    private static ArrayList<PrintfSegment> parsePrintfFormat(StringValue format) {
        ArrayList<PrintfSegment> segments = new ArrayList<PrintfSegment>();
        StringBuilder sb = new StringBuilder();
        StringBuilder flags = new StringBuilder();
        int length = format.length();
        int index = 0;
        block16: for (int i = 0; i < length; ++i) {
            char ch = format.charAt(i);
            if (i + 1 < length && ch == '%') {
                int j;
                sb.append(ch);
                boolean isLeft = false;
                boolean isAlt = false;
                boolean isZero = false;
                flags.setLength(0);
                block17: for (j = i + 1; j < length; ++j) {
                    ch = format.charAt(j);
                    switch (ch) {
                        case '-': {
                            isLeft = true;
                            continue block17;
                        }
                        case '#': {
                            isAlt = true;
                            continue block17;
                        }
                        case '0': {
                            isZero = true;
                            flags.append(ch);
                            continue block17;
                        }
                        case ' ': 
                        case '(': 
                        case '+': 
                        case ',': {
                            flags.append(ch);
                            continue block17;
                        }
                    }
                }
                int head = j;
                while (j < length) {
                    ch = format.charAt(j);
                    switch (ch) {
                        case '%': {
                            i = j;
                            segments.add(new TextPrintfSegment(sb));
                            sb.setLength(0);
                            continue block16;
                        }
                        case '$': 
                        case '.': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break;
                        }
                        case 'B': 
                        case 'b': {
                            if (isLeft) {
                                sb.append('-');
                            }
                            if (isAlt) {
                                sb.append('#');
                            }
                            sb.append(format, head, j);
                            sb.append(ch);
                            i = j;
                            continue block16;
                        }
                        case 'S': 
                        case 's': {
                            sb.setLength(sb.length() - 1);
                            segments.add(new StringPrintfSegment(sb, isLeft || isAlt, isZero, ch == 'S', format.substring(head, j).toString(), index++));
                            sb.setLength(0);
                            i = j;
                            continue block16;
                        }
                        case 'C': 
                        case 'c': {
                            sb.setLength(sb.length() - 1);
                            segments.add(new CharPrintfSegment(sb, isLeft || isAlt, isZero, ch == 'C', format.substring(head, j).toString(), index++));
                            sb.setLength(0);
                            i = j;
                            continue block16;
                        }
                        case 'i': 
                        case 'u': {
                            ch = 'd';
                        }
                        case 'X': 
                        case 'd': 
                        case 'o': 
                        case 'x': {
                            sb.setLength(sb.length() - 1);
                            if (sb.length() > 0) {
                                segments.add(new TextPrintfSegment(sb));
                            }
                            sb.setLength(0);
                            if (isLeft) {
                                sb.append('-');
                            }
                            if (isAlt) {
                                sb.append('#');
                            }
                            sb.append((CharSequence)flags);
                            sb.append(format, head, j);
                            sb.append(ch);
                            segments.add(new LongPrintfSegment(sb.toString(), index++));
                            sb.setLength(0);
                            i = j;
                            continue block16;
                        }
                        case 'E': 
                        case 'G': 
                        case 'e': 
                        case 'f': 
                        case 'g': {
                            sb.setLength(sb.length() - 1);
                            if (sb.length() > 0) {
                                segments.add(new TextPrintfSegment(sb));
                            }
                            sb.setLength(0);
                            if (isLeft) {
                                sb.append('-');
                            }
                            if (isAlt) {
                                sb.append('#');
                            }
                            sb.append((CharSequence)flags);
                            sb.append(format, head, j);
                            sb.append(ch);
                            segments.add(new DoublePrintfSegment(sb.toString(), index++));
                            sb.setLength(0);
                            i = j;
                            continue block16;
                        }
                        default: {
                            if (isLeft) {
                                sb.append('-');
                            }
                            if (isAlt) {
                                sb.append('#');
                            }
                            sb.append((CharSequence)flags);
                            sb.append(format, head, j);
                            sb.append(ch);
                            i = j;
                            continue block16;
                        }
                    }
                    ++j;
                }
                continue;
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            segments.add(new TextPrintfSegment(sb));
        }
        return segments;
    }

    public static Value str_ireplace(Env env, Value search, Value replace, Value subject, @Reference @Optional Value count) {
        return StringModule.strReplace(env, search, replace, subject, count, true);
    }

    public static StringValue str_pad(StringValue string, int length, @Optional(value="' '") String pad, @Optional(value="STR_PAD_RIGHT") int type) {
        int i;
        int strLen = string.length();
        int padLen = length - strLen;
        if (padLen <= 0) {
            return string;
        }
        if (pad == null || pad.length() == 0) {
            pad = " ";
        }
        int leftPad = 0;
        int rightPad = 0;
        switch (type) {
            case 1: {
                leftPad = padLen;
                break;
            }
            default: {
                rightPad = padLen;
                break;
            }
            case 2: {
                leftPad = padLen / 2;
                rightPad = padLen - leftPad;
            }
        }
        int padStringLen = pad.length();
        StringValue sb = string.createStringBuilder(string.length() + padLen);
        for (i = 0; i < leftPad; ++i) {
            sb.append(pad.charAt(i % padStringLen));
        }
        sb = sb.append(string);
        for (i = 0; i < rightPad; ++i) {
            sb.append(pad.charAt(i % padStringLen));
        }
        return sb;
    }

    public static Value str_repeat(StringValue string, int count) {
        StringValue sb = string.createStringBuilder(count * string.length());
        for (int i = 0; i < count; ++i) {
            sb = sb.append(string);
        }
        return sb;
    }

    public static Value str_replace(Env env, Value search, Value replace, Value subject, @Reference @Optional Value count) {
        return StringModule.strReplace(env, search, replace, subject, count, false);
    }

    private static Value strReplace(Env env, Value search, Value replace, Value subject, @Reference @Optional Value count, boolean isInsensitive) {
        count.set(LongValue.ZERO);
        if (subject.isNull()) {
            return env.createEmptyString();
        }
        if (search.isNull()) {
            return subject;
        }
        if (subject instanceof ArrayValue) {
            ArrayValue subjectArray = (ArrayValue)subject;
            ArrayValueImpl resultArray = new ArrayValueImpl();
            for (Map.Entry<Value, Value> entry : subjectArray.entrySet()) {
                Value result = StringModule.strReplaceImpl(env, search, replace, entry.getValue().toStringValue(), count, isInsensitive);
                resultArray.append(entry.getKey(), result);
            }
            return resultArray;
        }
        StringValue subjectString = subject.toStringValue();
        if (subjectString.length() == 0) {
            return env.createEmptyString();
        }
        return StringModule.strReplaceImpl(env, search, replace, subjectString, count, isInsensitive);
    }

    private static Value strReplaceImpl(Env env, Value search, Value replace, StringValue subject, Value count, boolean isInsensitive) {
        if (!search.isArray()) {
            StringValue searchString = search.toStringValue();
            if (searchString.length() == 0) {
                return subject;
            }
            if (replace instanceof ArrayValue) {
                env.warning(L.l("Array to string conversion"));
            }
            subject = StringModule.strReplaceImpl(env, searchString, replace.toStringValue(), subject, count, isInsensitive);
        } else if (replace instanceof ArrayValue) {
            ArrayValue searchArray = (ArrayValue)search;
            ArrayValue replaceArray = (ArrayValue)replace;
            Iterator<Value> searchIter = searchArray.values().iterator();
            Iterator<Value> replaceIter = replaceArray.values().iterator();
            while (searchIter.hasNext()) {
                Value searchItem = searchIter.next();
                Value replaceItem = replaceIter.next();
                if (replaceItem == null) {
                    replaceItem = NullValue.NULL;
                }
                subject = StringModule.strReplaceImpl(env, searchItem.toStringValue(), replaceItem.toStringValue(), subject, count, isInsensitive);
            }
        } else {
            ArrayValue searchArray = (ArrayValue)search;
            for (Value searchItem : searchArray.values()) {
                subject = StringModule.strReplaceImpl(env, searchItem.toStringValue(), replace.toStringValue(), subject, count, isInsensitive);
            }
        }
        return subject;
    }

    private static StringValue strReplaceImpl(Env env, StringValue search, StringValue replace, StringValue subject, Value countV, boolean isInsensitive) {
        int next;
        long count = countV.toLong();
        int head = 0;
        int searchLen = search.length();
        StringValue result = null;
        while ((next = StringModule.indexOf(subject, search, head, isInsensitive)) >= head) {
            if (result == null) {
                result = subject.createStringBuilder();
            }
            result = result.append(subject, head, next);
            result = result.append(replace);
            head = head < next + searchLen ? next + searchLen : ++head;
            ++count;
        }
        if (count != 0L) {
            countV.set(LongValue.create(count));
            if (head > 0 && head < subject.length()) {
                result = result.append(subject, head, subject.length());
            }
            return result;
        }
        return subject;
    }

    private static int indexOf(StringValue subject, StringValue match, int head, boolean isInsensitive) {
        if (!isInsensitive) {
            return subject.indexOf(match, head);
        }
        int length = subject.length();
        int matchLen = match.length();
        if (matchLen <= 0) {
            return -1;
        }
        char ch = Character.toLowerCase(match.charAt(0));
        while (head + matchLen <= length) {
            block6: {
                if (ch == Character.toLowerCase(subject.charAt(head))) {
                    for (int i = 1; i < matchLen; ++i) {
                        if (Character.toLowerCase(subject.charAt(head + i)) == Character.toLowerCase(match.charAt(i))) {
                            continue;
                        }
                        break block6;
                    }
                    return head;
                }
            }
            ++head;
        }
        return -1;
    }

    public static Value str_rot13(StringValue string) {
        if (string == null) {
            return NullValue.NULL;
        }
        StringValue sb = string.createStringBuilder(string.length());
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            int off;
            char ch = string.charAt(i);
            if ('a' <= ch && ch <= 'z') {
                off = ch - 97;
                sb.append((char)(97 + (off + 13) % 26));
                continue;
            }
            if ('A' <= ch && ch <= 'Z') {
                off = ch - 65;
                sb.append((char)(65 + (off + 13) % 26));
                continue;
            }
            sb.append(ch);
        }
        return sb;
    }

    public static String str_shuffle(String string) {
        if (string == null) {
            string = "";
        }
        char[] chars = string.toCharArray();
        int length = chars.length;
        for (int i = 0; i < length; ++i) {
            int rand = RandomUtil.nextInt((int)length);
            char temp = chars[rand];
            chars[rand] = chars[i];
            chars[i] = temp;
        }
        return new String(chars);
    }

    public static Value str_split(StringValue string, @Optional(value="1") int chunk) {
        ArrayValueImpl array = new ArrayValueImpl();
        if (string.length() == 0) {
            ((ArrayValue)array).put(string);
            return array;
        }
        int strLen = string.length();
        for (int i = 0; i < strLen; i += chunk) {
            StringValue value = i + chunk <= strLen ? string.substring(i, i + chunk) : string.substring(i);
            ((ArrayValue)array).put(new LongValue(i), value);
        }
        return array;
    }

    public static Value str_word_count(StringValue string, @Optional int format, @Optional String additionalWordCharacters) {
        if (format < 0 || format > 2) {
            return NullValue.NULL;
        }
        int strlen = string.length();
        boolean isAdditionalWordCharacters = additionalWordCharacters.length() > 0;
        ArrayValueImpl resultArray = null;
        if (format > 0) {
            resultArray = new ArrayValueImpl();
        }
        boolean isBetweenWords = true;
        int wordCount = 0;
        int lastWordStart = 0;
        for (int i = 0; i <= strlen; ++i) {
            char ch;
            boolean isWordCharacter = i < strlen ? Character.isLetter((int)(ch = string.charAt(i))) || ch == '-' || ch == '\'' || isAdditionalWordCharacters && additionalWordCharacters.indexOf(ch) > -1 : false;
            if (isWordCharacter) {
                if (!isBetweenWords) continue;
                isBetweenWords = false;
                lastWordStart = i;
                ++wordCount;
                continue;
            }
            if (isBetweenWords) continue;
            isBetweenWords = true;
            if (format <= 0) continue;
            StringValue word = string.substring(lastWordStart, i);
            if (format == 1) {
                resultArray.append(word);
                continue;
            }
            if (format != 2) continue;
            resultArray.put(new LongValue(lastWordStart), word);
        }
        if (resultArray == null) {
            return LongValue.create(wordCount);
        }
        return resultArray;
    }

    public static int strcasecmp(StringValue a, StringValue b) {
        int aLen = a.length();
        int bLen = b.length();
        for (int i = 0; i < aLen && i < bLen; ++i) {
            char chB;
            char chA = a.charAt(i);
            if (chA == (chB = b.charAt(i))) continue;
            if (Character.isUpperCase(chA)) {
                chA = Character.toLowerCase(chA);
            }
            if (Character.isUpperCase(chB)) {
                chB = Character.toLowerCase(chB);
            }
            if (chA == chB) continue;
            if (chA < chB) {
                return -1;
            }
            return 1;
        }
        if (aLen == bLen) {
            return 0;
        }
        if (aLen < bLen) {
            return -1;
        }
        return 1;
    }

    public static int strcmp(String a, String b) {
        int cmp;
        if (a == null) {
            a = "";
        }
        if (b == null) {
            b = "";
        }
        if ((cmp = a.compareTo(b)) == 0) {
            return 0;
        }
        if (cmp < 0) {
            return -1;
        }
        return 1;
    }

    public static Value strchr(Env env, StringValue haystack, Value needle) {
        return StringModule.strstr(env, haystack, needle);
    }

    public static Value strcoll(String a, String b) {
        int cmp;
        if (a == null) {
            a = "";
        }
        if (b == null) {
            b = "";
        }
        if ((cmp = a.compareTo(b)) == 0) {
            return LongValue.ZERO;
        }
        if (cmp < 0) {
            return LongValue.MINUS_ONE;
        }
        return LongValue.ONE;
    }

    public static Value strcspn(StringValue string, StringValue characters, @Optional(value="0") int offset, @Optional(value="-2147483648") int length) {
        return StringModule.strspnImpl(string, characters, offset, length, false);
    }

    public static StringValue strip_tags(StringValue string, @Optional String allowTags) {
        StringValue result = string.createStringBuilder(string.length());
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            if (ch != '<') {
                result.append(ch);
                continue;
            }
            ++i;
            while (i < len && (ch = string.charAt(i)) != '>') {
                ++i;
            }
        }
        return result;
    }

    public static Value strlen(Value value) {
        return LongValue.create(value.length());
    }

    public static int strnatcasecmp(StringValue a, StringValue b) {
        return StringModule.naturalOrderCompare(a, b, true);
    }

    public static int strnatcmp(StringValue a, StringValue b) {
        return StringModule.naturalOrderCompare(a, b, false);
    }

    private static int naturalOrderCompare(StringValue a, StringValue b, boolean ignoreCase) {
        SimpleStringReader aIn = new SimpleStringReader(a);
        SimpleStringReader bIn = new SimpleStringReader(b);
        int aChar = aIn.read();
        int bChar = bIn.read();
        if (aChar == -1 && bChar >= 0) {
            return -1;
        }
        if (aChar >= 0 && bChar == -1) {
            return 1;
        }
        while (true) {
            if (Character.isWhitespace(aChar)) {
                aChar = aIn.read();
                continue;
            }
            while (Character.isWhitespace(bChar)) {
                bChar = bIn.read();
            }
            if (aChar == -1 && bChar == -1) {
                return 0;
            }
            if (aChar == 48 && bChar == 48) {
                do {
                    aChar = aIn.read();
                    bChar = bIn.read();
                } while (aChar == 48 && bChar == 48);
                if (aChar == 48) {
                    if (49 <= bChar && bChar <= 57) {
                        return -1;
                    }
                    return 1;
                }
                if (bChar == 0) {
                    if (49 <= aChar && aChar <= 57) {
                        return 1;
                    }
                    return -1;
                }
            } else if (48 < aChar && aChar <= 57 && 48 < bChar && bChar <= 57) {
                int bInteger;
                int aInteger = aIn.readInt(aChar);
                if (aInteger > (bInteger = bIn.readInt(bChar))) {
                    return 1;
                }
                if (aInteger < bInteger) {
                    return -1;
                }
                aChar = aIn.read();
                bChar = bIn.read();
            }
            if (ignoreCase) {
                aChar = Character.toUpperCase(aChar);
                bChar = Character.toUpperCase(bChar);
            }
            if (aChar > bChar) {
                return 1;
            }
            if (aChar < bChar) {
                return -1;
            }
            aChar = aIn.read();
            bChar = bIn.read();
            if (aChar >= 0 && bChar == -1) {
                return 1;
            }
            if (aChar == -1 && bChar >= 0) break;
        }
        return -1;
    }

    public static int strncasecmp(StringValue a, StringValue b, int length) {
        int aLen = a.length();
        int bLen = b.length();
        for (int i = 0; i < length; ++i) {
            char bChar;
            if (aLen <= i) {
                return -1;
            }
            if (bLen <= i) {
                return 1;
            }
            char aChar = Character.toUpperCase(a.charAt(i));
            if (aChar < (bChar = Character.toUpperCase(b.charAt(i)))) {
                return -1;
            }
            if (bChar >= aChar) continue;
            return 1;
        }
        return 0;
    }

    public static int strncmp(String a, String b, int length) {
        int cmp;
        if (a == null) {
            a = "";
        }
        if (b == null) {
            b = "";
        }
        if (length < a.length()) {
            a = a.substring(0, length);
        }
        if (length < b.length()) {
            b = b.substring(0, length);
        }
        if ((cmp = a.compareTo(b)) == 0) {
            return 0;
        }
        if (cmp < 0) {
            return -1;
        }
        return 1;
    }

    public static Value strpbrk(StringValue haystack, StringValue charList) {
        int len = haystack.length();
        int sublen = charList.length();
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < sublen; ++j) {
                if (haystack.charAt(i) != charList.charAt(j)) continue;
                return haystack.substring(i);
            }
        }
        return BooleanValue.FALSE;
    }

    public static Value strpos(StringValue haystack, Value needleV, @Optional int offset) {
        StringValue needle = needleV instanceof StringValue ? (StringValue)needleV : StringValue.create((char)needleV.toInt());
        int pos = haystack.indexOf(needle, offset);
        if (pos < 0) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(pos);
    }

    public static Value stripos(StringValue haystack, Value needleV, @Optional int offset) {
        StringValue needle = needleV instanceof StringValue ? (StringValue)needleV : StringValue.create((char)needleV.toInt());
        int pos = (haystack = haystack.toLowerCase()).indexOf(needle = needle.toLowerCase(), offset);
        if (pos < 0) {
            return BooleanValue.FALSE;
        }
        return LongValue.create(pos);
    }

    public static String stripcslashes(String source) {
        if (source == null) {
            source = "";
        }
        StringBuilder result = new StringBuilder(source.length());
        int length = source.length();
        for (int i = 0; i < length; ++i) {
            int ch = source.charAt(i);
            if (ch == 92) {
                if (++i == length) {
                    ch = 92;
                } else {
                    ch = source.charAt(i);
                    switch (ch) {
                        case 97: {
                            ch = 7;
                            break;
                        }
                        case 98: {
                            ch = 8;
                            break;
                        }
                        case 116: {
                            ch = 9;
                            break;
                        }
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 118: {
                            ch = 11;
                            break;
                        }
                        case 102: {
                            ch = 12;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 120: {
                            int digitValue;
                            if (i + 1 == length || (digitValue = StringModule.hexToDigit(source.charAt(i + 1))) < 0) break;
                            ch = digitValue;
                            if (++i + 1 == length || (digitValue = StringModule.hexToDigit(source.charAt(i + 1))) < 0) break;
                            ch = ch << 4 | digitValue;
                            ++i;
                            break;
                        }
                        default: {
                            int digitValue = StringModule.octToDigit((char)ch);
                            if (digitValue < 0) break;
                            ch = digitValue;
                            if (i + 1 == length || (digitValue = StringModule.octToDigit(source.charAt(i + 1))) < 0) break;
                            ch = ch << 3 | digitValue;
                            if (++i + 1 == length || (digitValue = StringModule.octToDigit(source.charAt(i + 1))) < 0) break;
                            ch = ch << 3 | digitValue;
                            ++i;
                        }
                    }
                }
            }
            result.append((char)ch);
        }
        return result.toString();
    }

    public static StringValue stripslashes(StringValue string) {
        StringValue sb = string.createStringBuilder();
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            if (ch == '\\') {
                if (i + 1 >= len) continue;
                sb.append(string.charAt(i + 1));
                ++i;
                continue;
            }
            sb.append(ch);
        }
        return sb;
    }

    public static Value stristr(StringValue haystack, Value needleV) {
        CharSequence needleLower;
        if (needleV instanceof StringValue) {
            needleLower = ((StringValue)needleV).toLowerCase();
        } else {
            char lower = Character.toLowerCase((char)needleV.toLong());
            needleLower = String.valueOf(lower);
        }
        StringValue haystackLower = haystack.toLowerCase();
        int i = haystackLower.indexOf(needleLower);
        if (i >= 0) {
            return haystack.substring(i);
        }
        return BooleanValue.FALSE;
    }

    public static Value strrchr(StringValue haystack, Value needleV) {
        CharSequence needle = needleV instanceof StringValue ? (StringValue)needleV : String.valueOf((char)needleV.toLong());
        int i = haystack.lastIndexOf(needle);
        if (i > 0) {
            return haystack.substring(i);
        }
        return BooleanValue.FALSE;
    }

    public static Value strrev(StringValue string) {
        StringValue sb = string.createStringBuilder(string.length());
        for (int i = string.length() - 1; i >= 0; --i) {
            sb.append(string.charAt(i));
        }
        return sb;
    }

    public static Value strrpos(StringValue haystack, Value needleV, @Optional Value offsetV) {
        int offset;
        StringValue needle = needleV instanceof StringValue ? needleV.toStringValue() : StringValue.create((char)needleV.toInt());
        int pos = haystack.lastIndexOf(needle, offset = offsetV instanceof DefaultValue ? haystack.length() : offsetV.toInt());
        if (pos < 0) {
            return BooleanValue.FALSE;
        }
        return new LongValue(pos);
    }

    public static Value strripos(String haystack, Value needleV, @Optional Value offsetV) {
        if (haystack == null) {
            haystack = "";
        }
        String needle = needleV instanceof StringValue ? needleV.toString() : String.valueOf((char)needleV.toInt());
        int offset = offsetV instanceof DefaultValue ? haystack.length() : offsetV.toInt();
        int pos = (haystack = haystack.toLowerCase()).lastIndexOf(needle = needle.toLowerCase(), offset);
        if (pos < 0) {
            return BooleanValue.FALSE;
        }
        return new LongValue(pos);
    }

    public static Value strspn(StringValue string, StringValue characters, @Optional int offset, @Optional(value="-2147483648") int length) {
        return StringModule.strspnImpl(string, characters, offset, length, true);
    }

    private static Value strspnImpl(StringValue string, StringValue characters, int offset, int length, boolean isMatch) {
        int strlen = string.length();
        if (offset < 0 && (offset += strlen) < 0) {
            offset = 0;
        }
        if (offset > strlen) {
            return BooleanValue.FALSE;
        }
        if (length == Integer.MIN_VALUE) {
            length = strlen;
        } else if (length < 0 && (length += strlen - offset) < 0) {
            length = 0;
        }
        int end = offset + length;
        if (strlen < end) {
            end = strlen;
        }
        int count = 0;
        while (offset < end) {
            boolean isPresent;
            char ch = string.charAt(offset);
            boolean bl = isPresent = characters.indexOf(ch) > -1;
            if (isPresent == isMatch) {
                ++count;
            } else {
                return LongValue.create(count);
            }
            ++offset;
        }
        return LongValue.create(count);
    }

    public static Value strstr(Env env, StringValue haystackV, Value needleV) {
        String needle;
        if (haystackV == null) {
            haystackV = env.createEmptyString();
        }
        if ((needle = needleV instanceof StringValue ? needleV.toString() : String.valueOf((char)needleV.toLong())).length() == 0) {
            env.warning("empty needle");
            return BooleanValue.FALSE;
        }
        int i = haystackV.indexOf(needle);
        if (i >= 0) {
            return haystackV.substring(i);
        }
        return BooleanValue.FALSE;
    }

    public static Value strtok(Env env, StringValue string1, @Optional Value string2) {
        Value result;
        char ch;
        StringValue characters;
        int offset;
        StringValue string;
        if (string2.isNull()) {
            StringValue savedString = (StringValue)env.getSpecialValue("caucho.strtok_string");
            Integer savedOffset = (Integer)env.getSpecialValue("caucho.strtok_offset");
            string = savedString == null ? env.createEmptyString() : savedString;
            offset = savedOffset == null ? 0 : savedOffset;
            characters = string1;
        } else {
            string = string1;
            offset = 0;
            characters = string2.toStringValue();
            env.setSpecialValue("caucho.strtok_string", string);
        }
        int strlen = string.length();
        while (offset < strlen && characters.indexOf(ch = string.charAt(offset)) >= 0) {
            ++offset;
        }
        if (offset == strlen) {
            result = BooleanValue.FALSE;
        } else {
            char ch2;
            int start = offset++;
            while (offset < strlen && characters.indexOf(ch2 = string.charAt(offset)) <= -1) {
                ++offset;
            }
            result = string.substring(start, offset);
        }
        env.setSpecialValue("caucho.strtok_offset", offset);
        return result;
    }

    public static StringValue strtolower(StringValue string) {
        return string.toLowerCase();
    }

    public static StringValue strtoupper(StringValue string) {
        return string.toUpperCase();
    }

    public static StringValue strtr(Env env, StringValue string, Value fromV, @Optional StringValue to) {
        if (fromV instanceof ArrayValue) {
            return StringModule.strtrArray(string, (ArrayValue)fromV);
        }
        StringValue from = fromV.toStringValue();
        int len = from.length();
        if (to.length() < len) {
            len = to.length();
        }
        char[] map = new char[256];
        for (int i = len - 1; i >= 0; --i) {
            map[from.charAt((int)i)] = to.charAt(i);
        }
        StringValue sb = string.createStringBuilder();
        len = string.length();
        for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            if (map[ch] != '\u0000') {
                sb.append(map[ch]);
                continue;
            }
            sb.append(ch);
        }
        return sb;
    }

    private static StringValue strtrArray(StringValue string, ArrayValue map) {
        int size = map.getSize();
        StringValue[] from = new StringValue[size];
        StringValue[] to = new StringValue[size];
        int k = 0;
        for (Map.Entry<Value, Value> entry : map.entrySet()) {
            from[k] = entry.getKey().toStringValue();
            to[k] = entry.getValue().toStringValue();
            ++k;
        }
        StringValue result = string.createStringBuilder();
        int len = string.length();
        int head = 0;
        while (head < len) {
            int bestHead = len;
            int bestI = -1;
            int bestLength = 0;
            for (int i = 0; i < from.length; ++i) {
                int p = string.indexOf(from[i], head);
                if (p < 0 || p >= bestHead && (p != bestHead || bestLength >= from[i].length())) continue;
                bestHead = p;
                bestI = i;
                bestLength = from[i].length();
            }
            if (head != bestHead) {
                result = result.append(string.substring(head, bestHead));
            }
            if (bestI >= 0) {
                result = result.append(to[bestI]);
            }
            head = bestHead + bestLength;
        }
        return result;
    }

    public static Value substr(Env env, StringValue string, int start, @Optional Value lenV) {
        int strLen = string.length();
        if (start < 0) {
            start = strLen + start;
        }
        if (start < 0 || strLen < start) {
            return BooleanValue.FALSE;
        }
        if (lenV instanceof DefaultValue) {
            return string.substring(start);
        }
        int len = lenV.toInt();
        int end = len < 0 ? strLen + len : start + len;
        if (end <= start) {
            return env.createEmptyString();
        }
        if (strLen <= end) {
            return string.substring(start);
        }
        return string.substring(start, end);
    }

    public static Value substr_count(Env env, StringValue haystackV, StringValue needleV, @Optional(value="0") int offset, @Optional(value="-1") int length) {
        String haystack = haystackV.toString();
        String needle = needleV.toString();
        if (needle.length() == 0) {
            env.warning(L.l("empty substr"));
            return BooleanValue.FALSE;
        }
        int haystackLength = haystack.length();
        if (offset < 0 || offset > haystackLength) {
            env.warning(L.l("offset `{0}' out of range", (long)offset));
            return BooleanValue.FALSE;
        }
        if (length > -1) {
            if (offset + length > haystackLength) {
                env.warning(L.l("length `{0}' out of range", (long)length));
                return BooleanValue.FALSE;
            }
            haystackLength = offset + length;
        }
        int needleLength = needle.length();
        int count = 0;
        int end = haystackLength - needleLength + 1;
        for (int i = offset; i < end; ++i) {
            if (!haystack.startsWith(needle, i)) continue;
            ++count;
            i += needleLength;
        }
        return new LongValue(count);
    }

    public static Value substr_replace(Value subjectV, StringValue replacement, Value startV, @Optional Value lengthV) {
        Iterator<Value> lengthIterator;
        int start = 0;
        int length = 0x3FFFFFFF;
        if (!lengthV.isNull() && !lengthV.isArray()) {
            length = lengthV.toInt();
        }
        if (!startV.isNull() && !startV.isArray()) {
            start = startV.toInt();
        }
        Iterator<Value> startIterator = startV.isArray() ? ((ArrayValue)startV).values().iterator() : null;
        Iterator<Value> iterator = lengthIterator = lengthV.isArray() ? ((ArrayValue)lengthV).values().iterator() : null;
        if (subjectV.isArray()) {
            ArrayValueImpl resultArray = new ArrayValueImpl();
            ArrayValue subjectArray = (ArrayValue)subjectV;
            for (Value value : subjectArray.values()) {
                if (lengthIterator != null && lengthIterator.hasNext()) {
                    length = lengthIterator.next().toInt();
                }
                if (startIterator != null && startIterator.hasNext()) {
                    start = startIterator.next().toInt();
                }
                Value result = StringModule.substrReplaceImpl(value.toStringValue(), replacement, start, length);
                resultArray.append(result);
            }
            return resultArray;
        }
        if (lengthIterator != null && lengthIterator.hasNext()) {
            length = lengthIterator.next().toInt();
        }
        if (startIterator != null && startIterator.hasNext()) {
            start = startIterator.next().toInt();
        }
        return StringModule.substrReplaceImpl(subjectV.toStringValue(), replacement, start, length);
    }

    private static Value substrReplaceImpl(StringValue string, StringValue replacement, int start, int len) {
        int strLen = string.length();
        if (start > strLen) {
            start = strLen;
        } else if (start < 0) {
            start = Math.max(strLen + start, 0);
        }
        int end = len < 0 ? Math.max(strLen + len, start) : Math.min(start + len, strLen);
        StringValue result = string.createStringBuilder();
        result = result.append(string.substring(0, start));
        result = result.append(replacement);
        result = result.append(string.substring(end));
        return result;
    }

    public static Value trim(Env env, StringValue string, @Optional String characters) {
        char ch;
        int tail;
        char ch2;
        int head;
        boolean[] trim = characters == null || characters.equals("") ? TRIM_WHITESPACE : StringModule.parseCharsetBitmap(characters.toString());
        int len = string.length();
        for (head = 0; head < len && (ch2 = string.charAt(head)) < '\u0100' && trim[ch2]; ++head) {
        }
        for (tail = len - 1; tail >= 0 && (ch = string.charAt(tail)) < '\u0100' && trim[ch]; --tail) {
        }
        if (tail < head) {
            return env.createEmptyString();
        }
        return (StringValue)string.subSequence(head, tail + 1);
    }

    public static String ucfirst(String string) {
        if (string == null) {
            string = "";
        }
        if (string.length() == 0) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static String ucwords(String string) {
        if (string == null) {
            string = "";
        }
        int strLen = string.length();
        boolean isStart = true;
        StringBuilder sb = new StringBuilder();
        block3: for (int i = 0; i < strLen; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    isStart = true;
                    sb.append(ch);
                    continue block3;
                }
                default: {
                    if (isStart) {
                        sb.append(Character.toUpperCase(ch));
                    } else {
                        sb.append(ch);
                    }
                    isStart = false;
                }
            }
        }
        return sb.toString();
    }

    public static int vprintf(Env env, StringValue format, @NotNull ArrayValue array) {
        Value[] args;
        if (array != null) {
            args = new Value[array.getSize()];
            int i = 0;
            for (Value value : array.values()) {
                args[i++] = value;
            }
        } else {
            args = new Value[]{};
        }
        return StringModule.printf(env, format, args);
    }

    public static Value vsprintf(StringValue format, @NotNull ArrayValue array) {
        Value[] args;
        if (array != null) {
            args = new Value[array.getSize()];
            int i = 0;
            for (Value value : array.values()) {
                args[i++] = value;
            }
        } else {
            args = new Value[]{};
        }
        return StringModule.sprintf(format, args);
    }

    public static String wordwrap(String string, @Optional(value="75") int width, @Optional(value="'\n'") String breakString, @Optional boolean cut) {
        if (string == null) {
            string = "";
        }
        if (breakString == null) {
            breakString = "";
        }
        int len = string.length();
        int head = 0;
        StringBuilder sb = new StringBuilder();
        while (head + width < len) {
            int tail;
            if (!cut) {
                for (tail = head + width; head < tail && !Character.isWhitespace(string.charAt(tail)); --tail) {
                }
                if (head == tail) {
                    tail = head + width;
                }
            }
            if (sb.length() > 0) {
                sb.append(breakString);
            }
            sb.append(string.substring(head, tail));
            head = tail;
            if (cut || head >= len || !Character.isWhitespace(string.charAt(head))) continue;
            ++head;
        }
        if (head < len) {
            if (sb.length() > 0) {
                sb.append(breakString);
            }
            sb.append(string.substring(head));
        }
        return sb.toString();
    }

    protected static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    protected static char toUpperCase(char ch) {
        if (ch >= 'a' && ch <= 'z') {
            return (char)(65 + (ch - 97));
        }
        return ch;
    }

    protected static char toUUChar(int d) {
        if (d == 0) {
            return '`';
        }
        return (char)(32 + (d & 0x3F));
    }

    protected static char toHexChar(int d) {
        if ((d &= 0xF) < 10) {
            return (char)(d + 48);
        }
        return (char)(d - 10 + 97);
    }

    protected static char toUpperHexChar(int d) {
        if ((d &= 0xF) < 10) {
            return (char)(d + 48);
        }
        return (char)(d - 10 + 65);
    }

    protected static int hexToDigit(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        return -1;
    }

    protected static int octToDigit(char ch) {
        if ('0' <= ch && ch <= '7') {
            return ch - 48;
        }
        return -1;
    }

    static {
        TRIM_WHITESPACE = new boolean[256];
        StringModule.TRIM_WHITESPACE[0] = true;
        StringModule.TRIM_WHITESPACE[8] = true;
        StringModule.TRIM_WHITESPACE[32] = true;
        StringModule.TRIM_WHITESPACE[9] = true;
        StringModule.TRIM_WHITESPACE[13] = true;
        StringModule.TRIM_WHITESPACE[10] = true;
        SOUNDEX_VALUES = "01230120022455012623010202".toCharArray();
        DEFAULT_DECIMAL_FORMAT_SYMBOLS = new DecimalFormatSymbols();
        DEFAULT_DECIMAL_FORMAT_SYMBOLS.setDecimalSeparator('.');
        DEFAULT_DECIMAL_FORMAT_SYMBOLS.setGroupingSeparator(',');
        DEFAULT_DECIMAL_FORMAT_SYMBOLS.setZeroDigit('0');
    }

    static class SimpleStringReader {
        StringValue _str;
        int _length;
        int _index;

        SimpleStringReader(StringValue str) {
            this._str = str;
            this._length = str.length();
            this._index = 0;
        }

        int read() {
            if (this._index < this._length) {
                return this._str.charAt(this._index++);
            }
            return -1;
        }

        int peek() {
            if (this._index < this._length) {
                return this._str.charAt(this._index);
            }
            return -1;
        }

        int readInt(int currChar) {
            int number = currChar - 48;
            while (48 <= (currChar = this.peek()) && currChar <= 57) {
                number = number * 10 + currChar - 48;
                ++this._index;
            }
            return number;
        }
    }

    static class CharPrintfSegment
    extends StringPrintfSegment {
        CharPrintfSegment(StringBuilder prefix, boolean isLeft, boolean isZero, boolean isUpper, String format, int index) {
            super(prefix, isLeft, isZero, isUpper, format, index);
        }

        String toValue(Value[] args) {
            if (args.length <= this._index) {
                return "";
            }
            Value v = args[this._index];
            if (v.isLongConvertible()) {
                return String.valueOf((char)v.toLong());
            }
            return v.charValueAt(0L).toString();
        }
    }

    static class StringPrintfSegment
    extends PrintfSegment {
        private final char[] _prefix;
        private final int _min;
        private final int _max;
        private final boolean _isLeft;
        private final boolean _isUpper;
        private final char _pad;
        protected final int _index;

        StringPrintfSegment(StringBuilder prefix, boolean isLeft, boolean isZero, boolean isUpper, String format, int index) {
            int i;
            this._prefix = new char[prefix.length()];
            this._isLeft = isLeft;
            this._isUpper = isUpper;
            this._pad = (char)(isZero ? 48 : 32);
            prefix.getChars(0, this._prefix.length, this._prefix, 0);
            if (StringPrintfSegment.hasIndex(format)) {
                index = StringPrintfSegment.getIndex(format);
                format = StringPrintfSegment.getIndexFormat(format);
            }
            int len = format.length();
            int min = 0;
            int max = Integer.MAX_VALUE;
            int ch = 32;
            for (i = 0; i < len; ++i) {
                char c = format.charAt(i);
                ch = c;
                if ('0' > c || ch > 57) break;
                min = 10 * min + ch - 48;
            }
            if (ch == 46) {
                max = 0;
                ++i;
                while (i < len) {
                    char c = format.charAt(i);
                    ch = c;
                    if ('0' > c || ch > 57) break;
                    max = 10 * max + ch - 48;
                    ++i;
                }
            }
            this._min = min;
            this._max = max;
            this._index = index;
        }

        public void apply(StringValue sb, Value[] args) {
            int i;
            sb.append(this._prefix, 0, this._prefix.length);
            String value = this.toValue(args);
            int len = value.length();
            if (this._max < len) {
                value = value.substring(0, this._max);
                len = this._max;
            }
            if (this._isUpper) {
                value = value.toUpperCase();
            }
            if (!this._isLeft) {
                for (i = len; i < this._min; ++i) {
                    sb.append(this._pad);
                }
            }
            sb.append(value);
            if (this._isLeft) {
                for (i = len; i < this._min; ++i) {
                    sb.append(this._pad);
                }
            }
        }

        String toValue(Value[] args) {
            if (this._index < args.length) {
                return args[this._index].toString();
            }
            return "";
        }
    }

    static class DoublePrintfSegment
    extends PrintfSegment {
        private final String _format;
        private final int _index;

        DoublePrintfSegment(String format, int index) {
            if (DoublePrintfSegment.hasIndex(format)) {
                this._index = DoublePrintfSegment.getIndex(format);
                this._format = DoublePrintfSegment.getIndexFormat(format);
            } else {
                this._format = '%' + format;
                this._index = index;
            }
        }

        public void apply(StringValue sb, Value[] args) {
            double value = this._index < args.length ? args[this._index].toDouble() : 0.0;
            sb.append(String.format(this._format, value));
        }
    }

    static class LongPrintfSegment
    extends PrintfSegment {
        private final String _format;
        private final int _index;

        LongPrintfSegment(String format, int index) {
            if (LongPrintfSegment.hasIndex(format)) {
                this._index = LongPrintfSegment.getIndex(format);
                format = LongPrintfSegment.getIndexFormat(format);
            } else {
                format = '%' + format;
                this._index = index;
            }
            if (format.length() > 1 && format.charAt(1) == '.') {
                char ch;
                int i;
                for (i = 2; i < format.length() && (ch = format.charAt(i)) >= '0' && ch <= '9'; ++i) {
                }
                this._format = '%' + format.substring(i);
            } else {
                this._format = format;
            }
        }

        public void apply(StringValue sb, Value[] args) {
            long value = this._index >= 0 && this._index < args.length ? args[this._index].toLong() : 0L;
            sb.append(String.format(this._format, value));
        }
    }

    static class TextPrintfSegment
    extends PrintfSegment {
        private final char[] _text;

        TextPrintfSegment(StringBuilder text) {
            this._text = new char[text.length()];
            text.getChars(0, this._text.length, this._text, 0);
        }

        public void apply(StringValue sb, Value[] args) {
            sb.append(this._text, 0, this._text.length);
        }
    }

    static abstract class PrintfSegment {
        PrintfSegment() {
        }

        public abstract void apply(StringValue var1, Value[] var2);

        static boolean hasIndex(String format) {
            return format.indexOf(36) >= 0;
        }

        static int getIndex(String format) {
            char ch;
            int value = 0;
            for (int i = 0; i < format.length() && '0' <= (ch = format.charAt(i)) && ch <= '9'; ++i) {
                value = 10 * value + ch - 48;
            }
            return value - 1;
        }

        static String getIndexFormat(String format) {
            int p = format.indexOf(36);
            return '%' + format.substring(p + 1);
        }
    }
}

