/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.zip;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.zip.ZipDirectory;
import com.caucho.quercus.lib.zip.ZipEntryInputStream;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class QuercusZipEntry {
    private static final Logger log = Logger.getLogger(QuercusZipEntry.class.getName());
    private static final L10N L = new L10N(QuercusZipEntry.class);
    private final ZipEntry _entry;
    private final BinaryInput _binaryInput;
    private final long _position;
    private ZipEntryInputStream _in;

    public QuercusZipEntry(ZipEntry zipEntry, BinaryInput binaryInput, long position) {
        this._entry = zipEntry;
        this._binaryInput = binaryInput;
        this._position = position;
    }

    public String zip_entry_name() {
        return this._entry.getName();
    }

    public long zip_entry_filesize() {
        return this._entry.getSize();
    }

    public boolean zip_entry_open(Env env, ZipDirectory directory) {
        try {
            if (this._in != null) {
                return true;
            }
            this._in = new ZipEntryInputStream(this._binaryInput.openCopy(), this._position);
            return true;
        }
        catch (IOException e) {
            env.warning(L.l(e.toString()));
            return false;
        }
    }

    public boolean zip_entry_close() throws IOException {
        if (this._in == null) {
            return false;
        }
        ZipEntryInputStream in = this._in;
        this._in = null;
        in.close();
        return true;
    }

    @ReturnNullAsFalse
    public StringValue zip_entry_read(Env env, @Optional(value="1024") int length) {
        if (this._in == null) {
            return null;
        }
        StringValue bb = env.createBinaryBuilder();
        bb.append(this._in, (long)length);
        return bb;
    }

    public long zip_entry_compressedsize() {
        if (this._entry == null) {
            return -1L;
        }
        return this._entry.getCompressedSize();
    }

    public String zip_entry_compressionmethod() {
        if (this._entry == null) {
            return "";
        }
        Integer method = this._entry.getMethod();
        switch (method) {
            case 8: {
                return "deflated";
            }
            case 0: {
                return "stored";
            }
        }
        return method.toString();
    }

    public String toString() {
        return "QuercusZipEntry[" + this._entry.getName() + "]";
    }
}

