/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.zlib;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.ReadStreamInput;
import com.caucho.quercus.lib.zlib.GZInputStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.VfsStream;
import java.io.IOException;
import java.io.InputStream;

public class ZlibInputStream
extends ReadStreamInput {
    private BinaryInput _in;
    private GZInputStream _gzIn;

    public ZlibInputStream(BinaryInput in) throws IOException {
        super(Env.getInstance());
        this.init(in);
    }

    protected void init(BinaryInput in) throws IOException {
        this._in = in;
        this._gzIn = new GZInputStream(in.getInputStream());
        ReadStream rs = new ReadStream((StreamImpl)new VfsStream((InputStream)this._gzIn, null));
        this.init(rs);
    }

    public BinaryInput openCopy() throws IOException {
        return new ZlibInputStream(this._in.openCopy());
    }

    public boolean setPosition(long offset) {
        try {
            BinaryInput newIn = this._in.openCopy();
            this._gzIn.close();
            this.getInputStream().close();
            this.init(newIn);
            if (offset > 0L) {
                this.skip(offset);
            }
            return true;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public String toString() {
        return "ZlibInputStream[]";
    }
}

