/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.module;

import com.caucho.quercus.Quercus;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.util.L10N;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IniDefinition {
    private L10N L = new L10N(IniDefinition.class);
    public static final int PHP_INI_USER = 1;
    public static final int PHP_INI_PERDIR = 2;
    public static final int PHP_INI_SYSTEM = 4;
    public static final int PHP_INI_ALL = 7;
    public static IniDefinition NULL = new Null();
    private final String _name;
    private final int _scope;
    private final Value _deflt;
    private final Type _type;

    public IniDefinition(String name, Type type, Value deflt, int scope) {
        assert (name != null);
        assert (deflt != null);
        assert (scope == 1 || scope == 2 || scope == 4 || scope == 7);
        this._name = name.intern();
        this._type = type;
        this._scope = scope;
        this._deflt = deflt;
    }

    protected String getName() {
        return this._name;
    }

    protected Value getDefault() {
        return this._deflt;
    }

    public int getScope() {
        return this._scope;
    }

    public boolean isRuntimeDefinition() {
        return false;
    }

    private BooleanValue toBooleanValue(Value value) {
        if (value instanceof BooleanValue) {
            return (BooleanValue)value;
        }
        if (!(value instanceof StringValue)) {
            return BooleanValue.create(value.toBoolean());
        }
        String valueAsString = value.toString().trim();
        if (valueAsString.length() == 0 || valueAsString.equalsIgnoreCase("false") || valueAsString.equalsIgnoreCase("off") || valueAsString.equalsIgnoreCase("0")) {
            return BooleanValue.FALSE;
        }
        return BooleanValue.TRUE;
    }

    public void set(Quercus quercus, Value value) {
        this.set(quercus.getIniMap(true), 4, value);
    }

    public void set(Quercus quercus, String value) {
        this.set(quercus.getIniMap(true), 4, new StringBuilderValue(value));
    }

    public void set(Env env, Value value) {
        this.set(env.getIniMap(true), 1, value);
    }

    public void set(Env env, String value) {
        this.set(env.getIniMap(true), 1, env.createString(value));
    }

    protected void set(IdentityHashMap<String, Value> map, int scope, Value value) {
        if (scope != 1 || this._scope == 1 || this._scope == 7) {
            if (this._type == Type.BOOLEAN) {
                map.put(this._name, this.toBooleanValue(value));
            } else if (this._type == Type.LONG) {
                map.put(this._name, value.toLongValue());
            } else {
                map.put(this._name, value);
            }
        }
    }

    private Value get(IdentityHashMap<String, Value> envMap, IdentityHashMap<String, Value> quercusMap) {
        Value value = null;
        if (envMap != null) {
            value = envMap.get(this._name);
        }
        if (value == null && quercusMap != null) {
            value = quercusMap.get(this._name);
        }
        if (value == null) {
            value = this._deflt;
        }
        if (value == null) {
            value = NullValue.NULL;
        }
        return value;
    }

    public Value getValue(Quercus quercus) {
        return this.get(null, quercus.getIniMap(false));
    }

    public Value getValue(Env env) {
        return this.get(env.getIniMap(false), env.getQuercus().getIniMap(false));
    }

    public StringValue getAsStringValue(Quercus quercus) {
        return this.get(null, quercus.getIniMap(false)).toStringValue();
    }

    public StringValue getAsStringValue(Env env) {
        return this.getValue(env).toStringValue();
    }

    public String getAsString(Env env) {
        StringValue value = this.getAsStringValue(env);
        return value.length() == 0 ? null : value.toString();
    }

    public boolean getAsBoolean(Quercus quercus) {
        return this.getAsBooleanValue(quercus).toBoolean();
    }

    public boolean getAsBoolean(Env env) {
        return this.getAsBooleanValue(env).toBoolean();
    }

    public BooleanValue getAsBooleanValue(Quercus quercus) {
        return this.getAsBooleanValue(null, quercus.getIniMap(false));
    }

    public BooleanValue getAsBooleanValue(Env env) {
        return this.getAsBooleanValue(env.getIniMap(false), env.getQuercus().getIniMap(false));
    }

    private BooleanValue getAsBooleanValue(IdentityHashMap<String, Value> overrideMap, IdentityHashMap<String, Value> iniMap) {
        Value value = this.get(overrideMap, iniMap);
        return this.toBooleanValue(value);
    }

    public LongValue getAsLongValue(Quercus quercus) {
        return this.getAsLongValue(null, quercus.getIniMap(false));
    }

    public LongValue getAsLongValue(Env env) {
        return this.getAsLongValue(env.getIniMap(false), env.getQuercus().getIniMap(false));
    }

    private LongValue getAsLongValue(IdentityHashMap<String, Value> overrideMap, IdentityHashMap<String, Value> iniMap) {
        Value value = this.get(overrideMap, iniMap);
        if (value instanceof LongValue) {
            return (LongValue)value;
        }
        if (value instanceof BooleanValue) {
            return value.toBoolean() ? LongValue.ONE : LongValue.ZERO;
        }
        return new LongValue(value.toLong());
    }

    public long getAsLong(Env env) {
        return this.getAsLongValue(env).toLong();
    }

    public long getAsLongBytes(Env env, long deflt) {
        char ch;
        String bytes = this.getAsString(env);
        if (bytes == null) {
            return deflt;
        }
        long value = 0L;
        long sign = 1L;
        int i = 0;
        int length = bytes.length();
        if (length == 0) {
            return deflt;
        }
        if (bytes.charAt(i) == '-') {
            sign = -1L;
            ++i;
        } else if (bytes.charAt(i) == '+') {
            ++i;
        }
        if (length <= i) {
            return deflt;
        }
        while (i < length && (ch = bytes.charAt(i)) >= '0' && ch <= '9') {
            value = 10L * value + (long)ch - 48L;
            ++i;
        }
        value = sign * value;
        if (bytes.endsWith("gb") || bytes.endsWith("g") || bytes.endsWith("G")) {
            return value * 1024L * 1024L * 1024L;
        }
        if (bytes.endsWith("mb") || bytes.endsWith("m") || bytes.endsWith("M")) {
            return value * 1024L * 1024L;
        }
        if (bytes.endsWith("kb") || bytes.endsWith("k") || bytes.endsWith("K")) {
            return value * 1024L;
        }
        if (bytes.endsWith("b") || bytes.endsWith("B")) {
            return value;
        }
        if (value < 0L) {
            return value;
        }
        env.warning(this.L.l("byte-valued expression '{0}' for ini value '{1}' must have units.  '16B' for bytes, '16K' for kilobytes, '16M' for megabytes, '16G' for gigabytes", (Object)this._name));
        return deflt;
    }

    public static class Runtime
    extends IniDefinition {
        public Runtime(String name) {
            super(name, Type.STRING, NullValue.NULL, 7);
        }

        public boolean isRuntimeDefinition() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Null
    extends Unsupported {
        private L10N L = new L10N(Unsupported.class);

        public Null() {
            super("#null", Type.STRING, NullValue.NULL, 7);
        }

        @Override
        public void set(IdentityHashMap<String, Value> map, int scope, Value value) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Unsupported
    extends IniDefinition {
        private L10N L = new L10N(Unsupported.class);

        public Unsupported(String name, Type type, Value deflt, int scope) {
            super(name, type, deflt, scope);
        }

        @Override
        public void set(IdentityHashMap<String, Value> map, int scope, Value value) {
            if (value.eq(this.getDefault())) {
                return;
            }
            Env.getInstance().warning(this.L.l("ini value `{0}' is not supported", (Object)this.getName()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        BOOLEAN,
        STRING,
        LONG;

    }
}

