/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.module;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.IniDefinition;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IniDefinitions {
    public static final IniDefinitions EMPTY = new IniDefinitions();
    private IdentityHashMap<String, IniDefinition> _defaultMap;

    public IniDefinition add(String name, boolean deflt, int scope) {
        return this.add(name, IniDefinition.Type.BOOLEAN, BooleanValue.create(deflt), scope);
    }

    public IniDefinition add(String name, long deflt, int scope) {
        return this.add(name, IniDefinition.Type.LONG, LongValue.create(deflt), scope);
    }

    public IniDefinition add(String name, String deflt, int scope) {
        return this.add(name, IniDefinition.Type.STRING, StringValue.create(deflt), scope);
    }

    private IniDefinition add(String name, IniDefinition.Type type, Value deflt, int scope) {
        return this.add(new IniDefinition(name, type, deflt, scope));
    }

    private IniDefinition add(IniDefinition iniDefinition) {
        if (this._defaultMap == null) {
            this._defaultMap = new IdentityHashMap();
        }
        this._defaultMap.put(iniDefinition.getName(), iniDefinition);
        return iniDefinition;
    }

    public IniDefinition addUnsupported(String name, boolean deflt, int scope) {
        return this.addUnsupported(name, IniDefinition.Type.BOOLEAN, BooleanValue.create(deflt), scope);
    }

    public IniDefinition addUnsupported(String name, long deflt, int scope) {
        return this.addUnsupported(name, IniDefinition.Type.LONG, LongValue.create(deflt), scope);
    }

    public IniDefinition addUnsupported(String name, String deflt, int scope) {
        return this.addUnsupported(name, IniDefinition.Type.STRING, StringValue.create(deflt), scope);
    }

    private IniDefinition addUnsupported(String name, IniDefinition.Type type, Value deflt, int scope) {
        return this.add(new IniDefinition.Unsupported(name, type, deflt, scope));
    }

    public void addAll(IniDefinitions iniDefinitions) {
        if (iniDefinitions._defaultMap == null) {
            return;
        }
        if (this._defaultMap == null) {
            this._defaultMap = new IdentityHashMap();
        }
        this._defaultMap.putAll(iniDefinitions._defaultMap);
    }

    public Set<String> getNames() {
        if (this._defaultMap == null) {
            return Collections.emptySet();
        }
        return this._defaultMap.keySet();
    }

    public IniDefinition get(String name) {
        IniDefinition iniDefinition;
        name = name.intern();
        IniDefinition iniDefinition2 = iniDefinition = this._defaultMap == null ? null : this._defaultMap.get(name);
        if (iniDefinition == null) {
            iniDefinition = new IniDefinition.Runtime(name);
            this.add(iniDefinition);
        }
        return iniDefinition;
    }
}

