/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.module;

import com.caucho.config.ConfigException;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.function.Marshal;
import com.caucho.quercus.function.MarshalFactory;
import com.caucho.quercus.module.ModuleInfo;
import com.caucho.quercus.module.QuercusModule;
import com.caucho.quercus.module.StaticFunction;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.InterpretedClassDef;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.quercus.program.JavaImplClassDef;
import com.caucho.util.L10N;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleContext {
    private static L10N L = new L10N(ModuleContext.class);
    private static final Logger log = Logger.getLogger(ModuleContext.class.getName());
    private ClassLoader _loader;
    private HashMap<String, QuercusModule> _modules = new HashMap();
    private HashMap<String, ModuleInfo> _moduleInfoMap = new HashMap();
    private HashSet<String> _extensionSet = new HashSet();
    private HashMap<String, Value> _constMap = new HashMap();
    private HashMap<String, StaticFunction> _staticFunctions = new HashMap();
    private ClassDef _stdClassDef;
    private QuercusClass _stdClass;
    private HashMap<String, ClassDef> _staticClasses = new HashMap();
    private HashMap<String, ClassDef> _lowerStaticClasses = new HashMap();
    private HashMap<String, JavaClassDef> _javaClassWrappers = new HashMap();
    private HashMap<String, JavaClassDef> _lowerJavaClassWrappers = new HashMap();
    private HashMap<String, StringValue> _iniMap = new HashMap();
    protected MarshalFactory _marshalFactory;
    protected ExprFactory _exprFactory;

    public ModuleContext() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ModuleContext(ClassLoader loader) {
        this._loader = loader;
        this._marshalFactory = new MarshalFactory(this);
        this._exprFactory = new ExprFactory();
        this._stdClassDef = new InterpretedClassDef("stdClass", null, new String[0]);
        this._stdClass = new QuercusClass(this, this._stdClassDef, null);
        this._staticClasses.put(this._stdClass.getName(), this._stdClassDef);
        this._lowerStaticClasses.put(this._stdClass.getName().toLowerCase(), this._stdClassDef);
    }

    public static ModuleContext getLocalContext(ClassLoader loader) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleInfo addModule(String name, QuercusModule module) throws ConfigException {
        ModuleContext moduleContext = this;
        synchronized (moduleContext) {
            ModuleInfo info = this._moduleInfoMap.get(name);
            if (info == null) {
                info = new ModuleInfo(this, name, module);
                this._moduleInfoMap.put(name, info);
            }
            return info;
        }
    }

    public JavaClassDef addClass(String name, Class type, String extension, Class javaClassDefClass) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        JavaClassDef def = this._javaClassWrappers.get(name);
        if (def == null) {
            if (log.isLoggable(Level.FINEST)) {
                if (extension == null) {
                    log.finest(L.l("PHP loading class {0} with type {1}", (Object)name, (Object)type.getName()));
                } else {
                    log.finest(L.l("PHP loading class {0} with type {1} providing extension {2}", (Object)name, (Object)type.getName(), (Object)extension));
                }
            }
            if (javaClassDefClass != null) {
                Constructor constructor = javaClassDefClass.getConstructor(ModuleContext.class, String.class, Class.class);
                def = (JavaClassDef)constructor.newInstance(this, name, type);
            } else {
                def = JavaClassDef.create(this, name, type);
                if (def == null) {
                    def = this.createDefaultJavaClassDef(name, type);
                }
            }
            this._javaClassWrappers.put(name, def);
            this._lowerJavaClassWrappers.put(name.toLowerCase(), def);
            this._staticClasses.put(name, def);
            this._lowerStaticClasses.put(name.toLowerCase(), def);
            if (extension != null) {
                this._extensionSet.add(extension);
            }
        }
        return def;
    }

    public JavaImplClassDef addClassImpl(String name, Class type, String extension) throws IllegalAccessException, InstantiationException {
        JavaImplClassDef def = (JavaImplClassDef)this._staticClasses.get(name);
        if (def == null) {
            def = this.addJavaImplClass(name, type, extension);
        }
        return def;
    }

    public JavaClassDef getJavaClassDefinition(Class type, String className) {
        JavaClassDef def = this._javaClassWrappers.get(className);
        if (def != null) {
            return def;
        }
        def = JavaClassDef.create(this, className, type);
        if (def == null) {
            def = this.createDefaultJavaClassDef(className, type);
        }
        this._javaClassWrappers.put(className, def);
        return def;
    }

    public JavaClassDef getJavaClassDefinition(String className) {
        JavaClassDef def = this._javaClassWrappers.get(className);
        if (def != null) {
            return def;
        }
        try {
            Class<?> type;
            try {
                type = Class.forName(className, false, this._loader);
            }
            catch (ClassNotFoundException e) {
                throw new ClassNotFoundException(L.l("`{0}' not valid: {1}", (Object)className, (Object)e.toString()), e);
            }
            def = JavaClassDef.create(this, className, type);
            if (def == null) {
                def = this.createDefaultJavaClassDef(className, type);
            }
            this._javaClassWrappers.put(className, def);
            return def;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QuercusRuntimeException(e);
        }
    }

    public JavaClassDef getJavaClassDefinition(Class javaClass) {
        for (JavaClassDef javaClassDef : this._javaClassWrappers.values()) {
            if (javaClassDef.getType() != javaClass) continue;
            return javaClassDef;
        }
        return null;
    }

    protected JavaClassDef createDefaultJavaClassDef(String className, Class type) {
        return new JavaClassDef(this, className, type);
    }

    public ClassDef findJavaClassWrapper(String name) {
        ClassDef def = this._javaClassWrappers.get(name);
        if (def != null) {
            return def;
        }
        return this._lowerJavaClassWrappers.get(name.toLowerCase());
    }

    public MarshalFactory getMarshalFactory() {
        return this._marshalFactory;
    }

    public ExprFactory getExprFactory() {
        return this._exprFactory;
    }

    public Marshal createMarshal(Class type, boolean isNotNull, boolean isNullAsFalse) {
        return this.getMarshalFactory().create(type, isNotNull, isNullAsFalse);
    }

    public ArrayValue getDefinedFunctions() {
        ArrayValueImpl internal = new ArrayValueImpl();
        for (String name : this._staticFunctions.keySet()) {
            internal.put(name);
        }
        return internal;
    }

    public QuercusClass getStdClass() {
        return this._stdClass;
    }

    public ClassDef findClass(String name) {
        ClassDef def = this._staticClasses.get(name);
        if (def == null) {
            def = this._lowerStaticClasses.get(name.toLowerCase());
        }
        return def;
    }

    public HashMap<String, ClassDef> getClassMap() {
        return this._staticClasses;
    }

    public QuercusModule findModule(String name) {
        return this._modules.get(name);
    }

    public boolean isExtensionLoaded(String name) {
        return this._extensionSet.contains(name);
    }

    public HashSet<String> getLoadedExtensions() {
        return this._extensionSet;
    }

    public HashMap<String, Value> getConstMap() {
        return this._constMap;
    }

    public StaticFunction createStaticFunction(QuercusModule module, Method method) {
        return new StaticFunction(this, module, method);
    }

    public Value getConstant(String name) {
        return this._constMap.get(name);
    }

    public static Value objectToValue(Object obj) {
        if (obj == null) {
            return NullValue.NULL;
        }
        if (Byte.class.equals(obj.getClass()) || Short.class.equals(obj.getClass()) || Integer.class.equals(obj.getClass()) || Long.class.equals(obj.getClass())) {
            return LongValue.create(((Number)obj).longValue());
        }
        if (Float.class.equals(obj.getClass()) || Double.class.equals(obj.getClass())) {
            return DoubleValue.create(((Number)obj).doubleValue());
        }
        if (String.class.equals(obj.getClass())) {
            return new StringBuilderValue((String)obj);
        }
        return null;
    }

    private JavaImplClassDef addJavaImplClass(String name, Class type, String extension) throws IllegalAccessException, InstantiationException {
        if (log.isLoggable(Level.FINE)) {
            if (extension == null) {
                log.fine(L.l("Quercus loading class {0} with type {1}", (Object)name, (Object)type.getName()));
            } else {
                log.fine(L.l("Quercus loading class {0} with type {1} providing extension {2}", (Object)name, (Object)type.getName(), (Object)extension));
            }
        }
        JavaImplClassDef def = new JavaImplClassDef(this, name, type);
        this._staticClasses.put(name, def);
        this._lowerStaticClasses.put(name.toLowerCase(), def);
        def.introspect(this);
        if (extension != null) {
            this._extensionSet.add(extension);
        }
        return def;
    }
}

