/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.module;

import com.caucho.config.ConfigException;
import com.caucho.quercus.env.AbstractJavaMethod;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.module.IniDefinitions;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.module.QuercusModule;
import com.caucho.quercus.module.StaticFunction;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.util.L10N;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleInfo {
    private static L10N L = new L10N(ModuleInfo.class);
    private static final Logger log = Logger.getLogger(ModuleInfo.class.getName());
    private ModuleContext _context;
    private String _name;
    private QuercusModule _module;
    private HashSet<String> _extensionSet = new HashSet();
    private HashMap<String, Value> _constMap = new HashMap();
    private HashMap<String, AbstractFunction> _staticFunctions = new HashMap();
    private IniDefinitions _iniDefinitions = new IniDefinitions();

    public ModuleInfo(ModuleContext context, String name, QuercusModule module) throws ConfigException {
        this._context = context;
        this._name = name;
        this._module = module;
        try {
            this.introspectPhpModuleClass(module.getClass());
        }
        catch (Exception e) {
            throw new ConfigException((Throwable)e);
        }
    }

    public String getName() {
        return this._name;
    }

    public QuercusModule getModule() {
        return this._module;
    }

    public HashSet<String> getLoadedExtensions() {
        return this._extensionSet;
    }

    public HashMap<String, Value> getConstMap() {
        return this._constMap;
    }

    public Value getConstant(String name) {
        return this._constMap.get(name);
    }

    public HashMap<String, AbstractFunction> getFunctions() {
        return this._staticFunctions;
    }

    public IniDefinitions getIniDefinitions() {
        return this._iniDefinitions;
    }

    private void introspectPhpModuleClass(Class cl) throws IllegalAccessException, InstantiationException {
        for (String ext : this._module.getLoadedExtensions()) {
            this._extensionSet.add(ext);
        }
        Map<String, Value> map = this._module.getConstMap();
        if (map != null) {
            this._constMap.putAll(map);
        }
        for (Field field : cl.getFields()) {
            Object obj;
            Value value;
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || (value = ModuleInfo.objectToValue(obj = field.get(null))) == null) continue;
            this._constMap.put(field.getName(), value);
        }
        IniDefinitions iniDefinitions = this._module.getIniDefinitions();
        if (map != null) {
            this._iniDefinitions.addAll(iniDefinitions);
        }
        for (Method method : cl.getMethods()) {
            if (method.getDeclaringClass().equals(Object.class) || method.getDeclaringClass().isAssignableFrom(AbstractQuercusModule.class) || !Modifier.isPublic(method.getModifiers())) continue;
            Class<?>[] params = method.getParameterTypes();
            if ("getLoadedExtensions".equals(method.getName())) continue;
            if (ModuleInfo.hasCheckedException(method)) {
                log.warning(L.l("Module method '{0}.{1}' may not throw checked exceptions", (Object)method.getDeclaringClass().getName(), (Object)method.getName()));
                continue;
            }
            try {
                if (method.getName().startsWith("quercus_")) {
                    throw new UnsupportedOperationException(L.l("{0}: use @Name instead", (Object)method));
                }
                StaticFunction function = this._context.createStaticFunction(this._module, method);
                String functionName = function.getName();
                AbstractJavaMethod oldFunction = (AbstractJavaMethod)this._staticFunctions.get(functionName);
                if (oldFunction != null) {
                    this._staticFunctions.put(functionName, oldFunction.overload(function));
                    continue;
                }
                this._staticFunctions.put(functionName, function);
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    private static boolean hasCheckedException(Method method) {
        for (Class<?> exnCl : method.getExceptionTypes()) {
            if (RuntimeException.class.isAssignableFrom(exnCl)) continue;
            return true;
        }
        return false;
    }

    public static Value objectToValue(Object obj) {
        if (obj == null) {
            return NullValue.NULL;
        }
        if (Byte.class.equals(obj.getClass()) || Short.class.equals(obj.getClass()) || Integer.class.equals(obj.getClass()) || Long.class.equals(obj.getClass())) {
            return LongValue.create(((Number)obj).longValue());
        }
        if (Float.class.equals(obj.getClass()) || Double.class.equals(obj.getClass())) {
            return DoubleValue.create(((Number)obj).doubleValue());
        }
        if (String.class.equals(obj.getClass())) {
            return new StringBuilderValue((String)obj);
        }
        return null;
    }
}

