/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.module;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.Name;
import com.caucho.quercus.env.JavaInvoker;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.module.QuercusModule;
import com.caucho.util.L10N;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class StaticFunction
extends JavaInvoker {
    private static final L10N L = new L10N(StaticFunction.class);
    private static final Logger log = Logger.getLogger(StaticFunction.class.getName());
    protected final QuercusModule _quercusModule;
    protected final Method _method;
    private final int _argLength;

    public StaticFunction(ModuleContext moduleContext, QuercusModule quercusModule, Method method) {
        super(moduleContext, StaticFunction.getName(method), method.getParameterTypes(), method.getParameterAnnotations(), method.getAnnotations(), method.getReturnType());
        this._method = method;
        this._argLength = method.getParameterTypes().length;
        this._quercusModule = quercusModule;
    }

    private static String getName(Method method) {
        Name nameAnn = method.getAnnotation(Name.class);
        String name = nameAnn != null ? nameAnn.value() : method.getName();
        return name;
    }

    public QuercusModule getModule() {
        return this._quercusModule;
    }

    public Method getMethod() {
        return this._method;
    }

    public int getArgumentLength() {
        return this._argLength;
    }

    public Object invoke(Object obj, Object[] javaArgs) {
        try {
            return this._method.invoke((Object)this._quercusModule, javaArgs);
        }
        catch (IllegalArgumentException e) {
            StringBuilder sb = new StringBuilder();
            sb.append(this._method.getDeclaringClass().getName());
            sb.append(".");
            sb.append(this._method.getName());
            sb.append("(");
            for (int i = 0; i < javaArgs.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(javaArgs[i]);
            }
            sb.append(")");
            throw new IllegalArgumentException(sb.toString(), e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw QuercusModuleException.create(e.getCause());
        }
        catch (Exception e) {
            throw QuercusModuleException.create(e);
        }
    }

    public String toString() {
        return "StaticFunction[" + this._method + "]";
    }
}

