/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.program.Arg;
import com.caucho.util.L10N;

public abstract class AbstractFunction {
    private static final L10N L = new L10N(AbstractFunction.class);
    private static final Arg[] NULL_ARGS = new Arg[0];
    private static final Value[] NULL_ARG_VALUES = new Value[0];
    private final Location _location;
    private boolean _isGlobal = true;

    public AbstractFunction() {
        this._location = Location.UNKNOWN;
    }

    public AbstractFunction(Location location) {
        this._location = location;
    }

    public String getName() {
        return "unknown";
    }

    public final boolean isGlobal() {
        return this._isGlobal;
    }

    public boolean isAbstract() {
        return false;
    }

    public final Location getLocation() {
        return this._location;
    }

    public final void setGlobal(boolean isGlobal) {
        this._isGlobal = isGlobal;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isCallUsesVariableArgs() {
        return false;
    }

    public boolean isCallUsesSymbolTable() {
        return false;
    }

    public boolean isReturnsReference() {
        return true;
    }

    public Arg[] getArgs() {
        return NULL_ARGS;
    }

    public Value[] evalArguments(Env env, Expr fun, Expr[] args) {
        Value[] values = new Value[args.length];
        for (int i = 0; i < args.length; ++i) {
            values[i] = args[i].evalArg(env);
        }
        return values;
    }

    public abstract Value call(Env var1, Value[] var2);

    public Value callRef(Env env, Value[] args) {
        return this.call(env, args);
    }

    public Value callCopy(Env env, Value[] args) {
        return this.call(env, args).copyReturn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethod(Env env, Value obj, Value[] args) {
        Value oldThis = env.getThis();
        try {
            if (obj != null) {
                env.setThis(obj);
            }
            Value value = this.call(env, args);
            return value;
        }
        finally {
            env.setThis(oldThis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value callMethodRef(Env env, Value obj, Value[] args) {
        Value oldThis = env.getThis();
        try {
            env.setThis(obj);
            Value value = this.callRef(env, args);
            return value;
        }
        finally {
            env.setThis(oldThis);
        }
    }

    public Value call(Env env) {
        return this.call(env, NULL_ARG_VALUES);
    }

    public Value call(Env env, Value a1) {
        return this.call(env, new Value[]{a1});
    }

    public Value call(Env env, Value a1, Value a2) {
        return this.call(env, new Value[]{a1, a2});
    }

    public Value call(Env env, Value a1, Value a2, Value a3) {
        return this.call(env, new Value[]{a1, a2, a3});
    }

    public Value call(Env env, Value a1, Value a2, Value a3, Value a4) {
        return this.call(env, new Value[]{a1, a2, a3, a4});
    }

    public Value call(Env env, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.call(env, new Value[]{a1, a2, a3, a4, a5});
    }

    public Value call(Env env, Expr[] exprs) {
        Value[] argValues = new Value[exprs.length];
        Arg[] args = this.getArgs();
        for (int i = 0; i < exprs.length; ++i) {
            argValues[i] = i < args.length && args[i].isReference() ? exprs[i].evalArg(env) : exprs[i].eval(env);
        }
        return this.call(env, argValues);
    }

    public Value callCopy(Env env, Expr[] exprs) {
        return this.call(env, exprs).copy();
    }

    public Value callRef(Env env) {
        return this.callRef(env, NULL_ARG_VALUES);
    }

    public Value callRef(Env env, Value a1) {
        return this.callRef(env, new Value[]{a1});
    }

    public Value callRef(Env env, Value a1, Value a2) {
        return this.callRef(env, new Value[]{a1, a2});
    }

    public Value callRef(Env env, Value a1, Value a2, Value a3) {
        return this.callRef(env, new Value[]{a1, a2, a3});
    }

    public Value callRef(Env env, Value a1, Value a2, Value a3, Value a4) {
        return this.callRef(env, new Value[]{a1, a2, a3, a4});
    }

    public Value callRef(Env env, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.callRef(env, new Value[]{a1, a2, a3, a4, a5});
    }

    public Value callRef(Env env, Expr[] exprs) {
        Value[] argValues = new Value[exprs.length];
        Arg[] args = this.getArgs();
        for (int i = 0; i < exprs.length; ++i) {
            argValues[i] = i < args.length && args[i].isReference() ? exprs[i].evalArg(env) : exprs[i].eval(env);
        }
        return this.callRef(env, argValues);
    }

    public Value callMethod(Env env, Value obj) {
        return this.callMethod(env, obj, NULL_ARG_VALUES);
    }

    public Value callMethod(Env env, Value obj, Value a1) {
        return this.callMethod(env, obj, new Value[]{a1});
    }

    public Value callMethod(Env env, Value obj, Value a1, Value a2) {
        return this.callMethod(env, obj, new Value[]{a1, a2});
    }

    public Value callMethod(Env env, Value obj, Value a1, Value a2, Value a3) {
        return this.callMethod(env, obj, new Value[]{a1, a2, a3});
    }

    public Value callMethod(Env env, Value obj, Value a1, Value a2, Value a3, Value a4) {
        return this.callMethod(env, obj, new Value[]{a1, a2, a3, a4});
    }

    public Value callMethod(Env env, Value obj, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.callMethod(env, obj, new Value[]{a1, a2, a3, a4, a5});
    }

    public Value callMethod(Env env, Value obj, Expr[] exprs) {
        Value[] argValues = new Value[exprs.length];
        Arg[] args = this.getArgs();
        for (int i = 0; i < exprs.length; ++i) {
            argValues[i] = i < args.length && args[i].isReference() ? exprs[i].evalArg(env) : exprs[i].eval(env);
        }
        return this.callMethod(env, obj, argValues);
    }

    public Value callMethodRef(Env env, Value obj) {
        return this.callMethodRef(env, obj, NULL_ARG_VALUES);
    }

    public Value callMethodRef(Env env, Value obj, Value a1) {
        return this.callMethodRef(env, obj, new Value[]{a1});
    }

    public Value callMethodRef(Env env, Value obj, Value a1, Value a2) {
        return this.callMethodRef(env, obj, new Value[]{a1, a2});
    }

    public Value callMethodRef(Env env, Value obj, Value a1, Value a2, Value a3) {
        return this.callMethodRef(env, obj, new Value[]{a1, a2, a3});
    }

    public Value callMethodRef(Env env, Value obj, Value a1, Value a2, Value a3, Value a4) {
        return this.callMethodRef(env, obj, new Value[]{a1, a2, a3, a4});
    }

    public Value callMethodRef(Env env, Value obj, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.callMethodRef(env, obj, new Value[]{a1, a2, a3, a4, a5});
    }

    public Value callMethodRef(Env env, Value obj, Expr[] exprs) {
        Value[] argValues = new Value[exprs.length];
        Arg[] args = this.getArgs();
        for (int i = 0; i < exprs.length; ++i) {
            argValues[i] = i < args.length && args[i].isReference() ? exprs[i].evalArg(env) : exprs[i].eval(env);
        }
        return this.callMethodRef(env, obj, argValues);
    }
}

