/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.ObjectExtValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.util.L10N;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassDef {
    private static final L10N L = new L10N(ClassDef.class);
    private final Location _location;
    private final String _name;
    private final String _parentName;
    private String[] _ifaceList;

    protected ClassDef(Location location, String name, String parentName, String[] ifaceList) {
        this._location = location;
        this._name = name;
        this._parentName = parentName;
        this._ifaceList = ifaceList;
    }

    public Location getLocation() {
        return this._location;
    }

    public String getName() {
        return this._name;
    }

    public String getParentName() {
        return this._parentName;
    }

    protected void addInterface(String iface) {
        for (int i = 0; i < this._ifaceList.length; ++i) {
            if (!this._ifaceList[i].equals(iface)) continue;
            return;
        }
        String[] ifaceList = new String[this._ifaceList.length + 1];
        System.arraycopy(this._ifaceList, 0, ifaceList, 0, this._ifaceList.length);
        ifaceList[ifaceList.length - 1] = iface;
        this._ifaceList = ifaceList;
    }

    public void init() {
    }

    public String[] getInterfaces() {
        return this._ifaceList;
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public void initClass(QuercusClass cl) {
    }

    public ObjectValue newInstance(Env env, QuercusClass qcl) {
        if (this.isAbstract()) {
            throw env.createErrorException(L.l("abstract class '{0}' cannot be instantiated.", (Object)this.getName()));
        }
        if (this.isInterface()) {
            throw env.createErrorException(L.l("interface '{0}' cannot be instantiated.", (Object)this.getName()));
        }
        return new ObjectExtValue(qcl);
    }

    public Value callNew(Env env, Expr[] args) {
        return null;
    }

    public Value callNew(Env env, Value[] args) {
        return null;
    }

    public boolean isA(String name) {
        if (this._name.equalsIgnoreCase(name)) {
            return true;
        }
        for (int i = 0; i < this._ifaceList.length; ++i) {
            if (!this._ifaceList[i].equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public abstract AbstractFunction findConstructor();

    public Expr findConstant(String name) {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this) + "[" + this._name + "]";
    }

    public Set<Map.Entry<String, Expr>> fieldSet() {
        return null;
    }

    public Set<Map.Entry<String, AbstractFunction>> functionSet() {
        return null;
    }
}

