/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.BreakValue;
import com.caucho.quercus.env.ContinueValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.program.Statement;

public class ForStatement
extends Statement {
    protected final Expr _init;
    protected final Expr _test;
    protected final Expr _incr;
    protected final Statement _block;

    public ForStatement(Location location, Expr init, Expr test, Expr incr, Statement block) {
        super(location);
        this._init = init;
        this._test = test;
        this._incr = incr;
        this._block = block;
    }

    public Value execute(Env env) {
        try {
            if (this._init != null) {
                this._init.eval(env);
            }
            while (this._test == null || this._test.evalBoolean(env)) {
                env.checkTimeout();
                Value value = this._block.execute(env);
                if (value != null && !(value instanceof ContinueValue)) {
                    if (value instanceof BreakValue) {
                        return null;
                    }
                    return value;
                }
                if (this._incr == null) continue;
                this._incr.eval(env);
            }
        }
        catch (RuntimeException t) {
            this.rethrow(t, RuntimeException.class);
        }
        return null;
    }
}

