/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.program.Statement;

public class IfStatement
extends Statement {
    private final Expr _test;
    private final Statement _trueBlock;
    private final Statement _falseBlock;

    public IfStatement(Location location, Expr test, Statement trueBlock, Statement falseBlock) {
        super(location);
        this._test = test;
        this._trueBlock = trueBlock;
        this._falseBlock = falseBlock;
    }

    protected Expr getTest() {
        return this._test;
    }

    protected Statement getTrueBlock() {
        return this._trueBlock;
    }

    protected Statement getFalseBlock() {
        return this._falseBlock;
    }

    public Value execute(Env env) {
        if (this._test.evalBoolean(env)) {
            return this._trueBlock.execute(env);
        }
        if (this._falseBlock != null) {
            return this._falseBlock.execute(env);
        }
        return null;
    }
}

