/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.Function;
import com.caucho.quercus.program.InstanceInitializer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpretedClassDef
extends ClassDef
implements InstanceInitializer {
    protected boolean _isAbstract;
    protected boolean _isInterface;
    protected final HashMap<String, AbstractFunction> _functionMap = new HashMap();
    protected final HashMap<String, Expr> _fieldMap = new LinkedHashMap<String, Expr>();
    protected final HashMap<String, Expr> _staticFieldMap = new LinkedHashMap<String, Expr>();
    protected final HashMap<String, Expr> _constMap = new HashMap();
    protected AbstractFunction _constructor;
    protected AbstractFunction _destructor;
    protected AbstractFunction _getField;
    protected AbstractFunction _setField;
    protected AbstractFunction _call;

    public InterpretedClassDef(Location location, String name, String parentName, String[] ifaceList) {
        super(location, name, parentName, ifaceList);
    }

    public InterpretedClassDef(String name, String parentName, String[] ifaceList) {
        super(null, name, parentName, ifaceList);
    }

    public void setAbstract(boolean isAbstract) {
        this._isAbstract = isAbstract;
    }

    @Override
    public boolean isAbstract() {
        return this._isAbstract;
    }

    public void setInterface(boolean isInterface) {
        this._isInterface = isInterface;
    }

    @Override
    public boolean isInterface() {
        return this._isInterface;
    }

    @Override
    public void initClass(QuercusClass cl) {
        if (this._constructor != null) {
            cl.setConstructor(this._constructor);
            cl.addMethod("__construct", this._constructor);
        }
        if (this._getField != null) {
            cl.setGet(this._getField);
        }
        if (this._setField != null) {
            cl.setSet(this._setField);
        }
        if (this._call != null) {
            cl.setCall(this._call);
        }
        cl.addInitializer(this);
        for (Map.Entry<String, AbstractFunction> entry : this._functionMap.entrySet()) {
            cl.addMethod(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this._fieldMap.entrySet()) {
            cl.addField(entry.getKey(), 0, (Expr)entry.getValue());
        }
        String className = this.getName();
        for (Map.Entry<String, Expr> entry : this._staticFieldMap.entrySet()) {
            cl.addStaticFieldExpr(className, entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Expr> entry : this._constMap.entrySet()) {
            cl.addConstant(entry.getKey(), entry.getValue());
        }
    }

    public void setConstructor(AbstractFunction fun) {
        this._constructor = fun;
    }

    public void addFunction(String name, Function fun) {
        this._functionMap.put(name.intern(), fun);
        if (name.equals("__construct")) {
            this._constructor = fun;
        } else if (name.equals("__destruct")) {
            this._destructor = fun;
        } else if (name.equals("__get")) {
            this._getField = fun;
        } else if (name.equals("__set")) {
            this._setField = fun;
        } else if (name.equals("__call")) {
            this._call = fun;
        } else if (name.equalsIgnoreCase(this.getName()) && this._constructor == null) {
            this._constructor = fun;
        }
    }

    public void addStaticValue(Value name, Expr value) {
        this._staticFieldMap.put(name.toString(), value);
    }

    public void addConstant(String name, Expr value) {
        this._constMap.put(name.intern(), value);
    }

    @Override
    public Expr findConstant(String name) {
        return this._constMap.get(name);
    }

    public void addValue(Value name, Expr value) {
        this._fieldMap.put(name.toString().intern(), value);
    }

    public Expr get(Value name) {
        return this._fieldMap.get(name.toString().intern());
    }

    public boolean isDeclaredField(String name) {
        return this._fieldMap.get(name) != null;
    }

    public void init(Env env) {
        for (Map.Entry<String, Expr> var : this._staticFieldMap.entrySet()) {
            String name = this.getName() + "::" + var.getKey();
            env.setGlobalValue(name.intern(), var.getValue().eval(env).copy());
        }
    }

    @Override
    public void initInstance(Env env, Value value) {
        ObjectValue object = (ObjectValue)value;
        for (Map.Entry<String, Expr> entry : this._fieldMap.entrySet()) {
            object.initField(env, entry.getKey(), entry.getValue().eval(env).copy());
        }
    }

    @Override
    public AbstractFunction findConstructor() {
        return this._constructor;
    }

    @Override
    public Set<Map.Entry<String, Expr>> fieldSet() {
        return this._fieldMap.entrySet();
    }

    @Override
    public Set<Map.Entry<String, AbstractFunction>> functionSet() {
        return this._functionMap.entrySet();
    }
}

