/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.Quercus;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.Construct;
import com.caucho.quercus.annotation.Delegates;
import com.caucho.quercus.env.AbstractJavaMethod;
import com.caucho.quercus.env.ArrayDelegate;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaCalendarValue;
import com.caucho.quercus.env.JavaConstructor;
import com.caucho.quercus.env.JavaDateValue;
import com.caucho.quercus.env.JavaMethod;
import com.caucho.quercus.env.JavaURLValue;
import com.caucho.quercus.env.JavaValue;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.MethodMap;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.LiteralExpr;
import com.caucho.quercus.function.JavaMarshal;
import com.caucho.quercus.function.Marshal;
import com.caucho.quercus.function.MarshalFactory;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.JavaCollectionClassDef;
import com.caucho.quercus.program.JavaListClassDef;
import com.caucho.quercus.program.JavaMapClassDef;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassDef
extends ClassDef {
    private static final Logger log = Logger.getLogger(JavaClassDef.class.getName());
    private static final L10N L = new L10N(JavaClassDef.class);
    private final ModuleContext _moduleContext;
    private final String _name;
    private final Class _type;
    private final boolean _isAbstract;
    private final boolean _isArray;
    private final boolean _isInterface;
    private JavaClassDef _componentDef;
    protected volatile boolean _isInit;
    private final HashMap<String, Value> _constMap = new HashMap();
    private final MethodMap<AbstractJavaMethod> _functionMap = new MethodMap();
    private final HashMap<String, AbstractJavaMethod> _getMap = new HashMap();
    private final HashMap<String, AbstractJavaMethod> _setMap = new HashMap();
    private final HashMap<String, FieldMarshalPair> _fieldMap = new HashMap();
    private JavaMethod __get = null;
    private JavaMethod __getField = null;
    private JavaMethod __set = null;
    private JavaMethod __setField = null;
    private JavaMethod __call = null;
    private Method _printRImpl = null;
    private Method _varDumpImpl = null;
    private ArrayList<ArrayDelegate> _arrayDelegates = new ArrayList();
    private AbstractJavaMethod _cons;
    private Method _iteratorMethod;
    private Method _keySetMethod;
    private Marshal _marshal;

    public JavaClassDef(ModuleContext moduleContext, String name, Class type) {
        super(null, name, null, new String[0]);
        this._moduleContext = moduleContext;
        this._name = name;
        this._type = type;
        this._isAbstract = Modifier.isAbstract(type.getModifiers());
        this._isArray = type.isArray();
        this._isInterface = type.isInterface();
        this._arrayDelegates.add(new DefaultArrayDelegate());
    }

    public static JavaClassDef create(ModuleContext moduleContext, String name, Class type) {
        if (Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type)) {
            return new DoubleClassDef(moduleContext);
        }
        if (Number.class.isAssignableFrom(type)) {
            return new LongClassDef(moduleContext);
        }
        if (String.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type)) {
            return new StringClassDef(moduleContext);
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return new BooleanClassDef(moduleContext);
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return new CalendarClassDef(moduleContext);
        }
        if (Date.class.isAssignableFrom(type)) {
            return new DateClassDef(moduleContext);
        }
        if (URL.class.isAssignableFrom(type)) {
            return new URLClassDef(moduleContext);
        }
        if (Map.class.isAssignableFrom(type)) {
            return new JavaMapClassDef(moduleContext, name, type);
        }
        if (List.class.isAssignableFrom(type)) {
            return new JavaListClassDef(moduleContext, name, type);
        }
        if (Collection.class.isAssignableFrom(type)) {
            return new JavaCollectionClassDef(moduleContext, name, type);
        }
        return null;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public Class getType() {
        return this._type;
    }

    @Override
    public boolean isA(String name) {
        for (Class type = this._type; type != null; type = type.getSuperclass()) {
            if (type.getSimpleName().equalsIgnoreCase(name)) {
                return true;
            }
            if (!this.hasInterface(name, type)) continue;
            return true;
        }
        return false;
    }

    private boolean hasInterface(String name, Class type) {
        Class<?>[] interfaces = type.getInterfaces();
        if (interfaces != null) {
            for (Class<?> intfc : interfaces) {
                if (intfc.getSimpleName().equalsIgnoreCase(name)) {
                    return true;
                }
                if (!this.hasInterface(name, intfc)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAbstract() {
        return this._isAbstract;
    }

    public boolean isArray() {
        return this._isArray;
    }

    @Override
    public boolean isInterface() {
        return this._isInterface;
    }

    public JavaClassDef getComponentDef() {
        if (this._componentDef == null) {
            Class<?> compType = this.getType().getComponentType();
            this._componentDef = this._moduleContext.getJavaClassDefinition(compType.getName());
        }
        return this._componentDef;
    }

    public Value wrap(Env env, Object obj) {
        if (!this._isInit) {
            this.init();
        }
        return new JavaValue(env, obj, this);
    }

    private int cmpObject(Object lValue, Object rValue) {
        if (lValue == rValue) {
            return 0;
        }
        if (lValue == null) {
            return -1;
        }
        if (rValue == null) {
            return 1;
        }
        if (lValue instanceof Comparable) {
            if (!(rValue instanceof Comparable)) {
                return -1;
            }
            return ((Comparable)lValue).compareTo(rValue);
        }
        if (rValue instanceof Comparable) {
            return 1;
        }
        if (lValue.equals(rValue)) {
            return 0;
        }
        String lName = lValue.getClass().getName();
        String rName = rValue.getClass().getName();
        return lName.compareTo(rName);
    }

    public int cmpObject(Object lValue, Object rValue, JavaClassDef rClassDef) {
        int cmp = this.cmpObject(lValue, rValue);
        if (cmp != 0) {
            return cmp;
        }
        for (Map.Entry<String, FieldMarshalPair> lEntry : this._fieldMap.entrySet()) {
            String lFieldName = lEntry.getKey();
            FieldMarshalPair rFieldPair = rClassDef._fieldMap.get(lFieldName);
            if (rFieldPair == null) {
                return 1;
            }
            FieldMarshalPair lFieldPair = lEntry.getValue();
            try {
                Object rResult;
                Object lResult = lFieldPair._field.get(lValue);
                int resultCmp = this.cmpObject(lResult, rResult = rFieldPair._field.get(lValue));
                if (resultCmp == 0) continue;
                return resultCmp;
            }
            catch (IllegalAccessException e) {
                log.log(Level.FINE, L.l(e.getMessage()), e);
                return 0;
            }
        }
        return 0;
    }

    public Value getField(Env env, Object obj, String name, boolean create) {
        AbstractJavaMethod get = this._getMap.get(name);
        if (get != null) {
            try {
                return get.call(env, obj);
            }
            catch (Throwable e) {
                log.log(Level.FINE, L.l(e.getMessage()), e);
                return NullValue.NULL;
            }
        }
        FieldMarshalPair fieldPair = this._fieldMap.get(name);
        if (fieldPair != null) {
            try {
                Object result = fieldPair._field.get(obj);
                return fieldPair._marshal.unmarshal(env, result);
            }
            catch (Throwable e) {
                log.log(Level.FINE, L.l(e.getMessage()), e);
                return NullValue.NULL;
            }
        }
        if (this.__getField != null) {
            try {
                return this.__getField.call(env, obj, (Value)env.createString(name));
            }
            catch (Throwable e) {
                log.log(Level.FINE, L.l(e.getMessage()), e);
                return NullValue.NULL;
            }
        }
        if (create) {
            env.warning(L.l("field '{0}' is invalid"));
        }
        return NullValue.NULL;
    }

    public Value putField(Env env, Object obj, String name, Value value) {
        AbstractJavaMethod setter = this._setMap.get(name);
        if (setter != null) {
            try {
                return setter.call(env, obj, value);
            }
            catch (Throwable e) {
                log.log(Level.FINE, L.l(e.getMessage()), e);
                return NullValue.NULL;
            }
        }
        FieldMarshalPair fieldPair = this._fieldMap.get(name);
        if (fieldPair != null) {
            try {
                Class<?> type = fieldPair._field.getType();
                Object marshaledValue = fieldPair._marshal.marshal(env, value, type);
                fieldPair._field.set(obj, marshaledValue);
                return value;
            }
            catch (Throwable e) {
                log.log(Level.FINE, L.l(e.getMessage()), e);
                return NullValue.NULL;
            }
        }
        if (this.__setField != null) {
            try {
                return this.__setField.call(env, obj, (Value)env.createString(name), value);
            }
            catch (Throwable e) {
                log.log(Level.FINE, L.l(e.getMessage()), e);
                return NullValue.NULL;
            }
        }
        return NullValue.NULL;
    }

    public Marshal getMarshal() {
        return this._marshal;
    }

    @Override
    public ObjectValue newInstance(Env env, QuercusClass qClass) {
        return null;
    }

    public Value newInstance() {
        return null;
    }

    @Override
    public Value callNew(Env env, Expr[] args) {
        return this._cons.call(env, (Object)null, args);
    }

    @Override
    public Value callNew(Env env, Value[] args) {
        if (this._cons != null) {
            return this._cons.call(env, (Object)null, args);
        }
        return NullValue.NULL;
    }

    public AbstractFunction findFunction(String name) {
        return this._functionMap.get(name);
    }

    public AbstractFunction getCallMethod() {
        return this.__call;
    }

    public Value callMethod(Env env, Object obj, int hash, char[] name, int nameLen, Expr[] args) {
        AbstractJavaMethod method = this._functionMap.get(hash, name, nameLen);
        if (method == null) {
            env.warning(L.l("{0}::{1} is an unknown method.", (Object)this._name, (Object)this.toMethod(name, nameLen)));
            return NullValue.NULL;
        }
        return method.call(env, obj, args);
    }

    public Value callMethod(Env env, Value value, int hash, char[] name, int nameLen, Expr[] args) {
        return this.callMethod(env, value.toJavaObject(), hash, name, nameLen, args);
    }

    public Value callMethod(Env env, Value value, int hash, char[] name, int nameLen, Value[] args) {
        return this.callMethod(env, value.toJavaObject(), hash, name, nameLen, args);
    }

    public Value callMethod(Env env, Object obj, int hash, char[] name, int nameLen, Value[] args) {
        AbstractJavaMethod method = this._functionMap.get(hash, name, nameLen);
        if (method != null) {
            return method.call(env, obj, args);
        }
        if (this.__call != null) {
            Value[] extArgs = new Value[args.length + 1];
            extArgs[0] = env.createString(name, nameLen);
            System.arraycopy(args, 0, extArgs, 1, args.length);
            return this.__call.call(env, obj, extArgs);
        }
        env.error(L.l("'{0}::{1}' is an unknown method", (Object)this._name, (Object)this.toMethod(name, nameLen)));
        return NullValue.NULL;
    }

    public Value callMethod(Env env, Object obj, int hash, char[] name, int nameLen) {
        AbstractJavaMethod method = this._functionMap.get(hash, name, nameLen);
        if (method != null) {
            return method.call(env, obj);
        }
        if (this.__call != null) {
            return this.__call.call(env, obj, (Value)env.createString(name, nameLen));
        }
        env.error(L.l("'{0}::{1}' is an unknown method", (Object)this._name, (Object)this.toMethod(name, nameLen)));
        return NullValue.NULL;
    }

    public Value callMethod(Env env, Object obj, int hash, char[] name, int nameLen, Value a1) {
        AbstractJavaMethod method = this._functionMap.get(hash, name, nameLen);
        if (method != null) {
            return method.call(env, obj, a1);
        }
        if (this.__call != null) {
            return this.__call.call(env, obj, (Value)env.createString(name, nameLen), a1);
        }
        env.error(L.l("'{0}::{1}' is an unknown method", (Object)this._name, (Object)this.toMethod(name, nameLen)));
        return NullValue.NULL;
    }

    public Value callMethod(Env env, Object obj, int hash, char[] name, int nameLen, Value a1, Value a2) {
        AbstractJavaMethod method = this._functionMap.get(hash, name, nameLen);
        if (method != null) {
            return method.call(env, obj, a1, a2);
        }
        if (this.__call != null) {
            return this.__call.call(env, obj, (Value)env.createString(name, nameLen), a1, a2);
        }
        env.error(L.l("'{0}::{1}' is an unknown method", (Object)this._name, (Object)this.toMethod(name, nameLen)));
        return NullValue.NULL;
    }

    public Value callMethod(Env env, Object obj, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3) {
        AbstractJavaMethod method = this._functionMap.get(hash, name, nameLen);
        if (method != null) {
            return method.call(env, obj, a1, a2, a3);
        }
        if (this.__call != null) {
            return this.__call.call(env, obj, (Value)env.createString(name, nameLen), a1, a2, a3);
        }
        env.error(L.l("'{0}::{1}' is an unknown method", (Object)this._name, (Object)this.toMethod(name, nameLen)));
        return NullValue.NULL;
    }

    public Value callMethod(Env env, Object obj, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4) {
        AbstractJavaMethod method = this._functionMap.get(hash, name, nameLen);
        if (method != null) {
            return method.call(env, obj, a1, a2, a3, a4);
        }
        if (this.__call != null) {
            return this.__call.call(env, obj, env.createString(name, nameLen), a1, a2, a3, a4);
        }
        env.error(L.l("'{0}::{1}' is an unknown method", (Object)this._name, (Object)this.toMethod(name, nameLen)));
        return NullValue.NULL;
    }

    public Value callMethod(Env env, Object obj, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4, Value a5) {
        AbstractJavaMethod method = this._functionMap.get(hash, name, nameLen);
        if (method != null) {
            return method.call(env, obj, a1, a2, a3, a4, a5);
        }
        if (this.__call != null) {
            return this.__call.call(env, obj, new Value[]{env.createString(name, nameLen), a1, a2, a3, a4, a5});
        }
        env.error(L.l("'{0}::{1}' is an unknown method", (Object)this._name, (Object)this.toMethod(name, nameLen)));
        return NullValue.NULL;
    }

    private String toMethod(char[] name, int nameLen) {
        return new String(name, 0, nameLen);
    }

    @Override
    public void initClass(QuercusClass cl) {
        this.init();
        if (this._cons != null) {
            cl.setConstructor(this._cons);
            cl.addMethod("__construct", this._cons);
        }
        if (this.__get != null) {
            cl.setGet(this.__get);
        }
        for (AbstractJavaMethod abstractJavaMethod : this._functionMap.values()) {
            cl.addMethod(abstractJavaMethod.getName(), abstractJavaMethod);
        }
        if (this.__call != null) {
            cl.setCall(this.__call);
        }
        for (ArrayDelegate arrayDelegate : this._arrayDelegates) {
            cl.addArrayDelegate(arrayDelegate);
        }
        for (Map.Entry entry : this._constMap.entrySet()) {
            cl.addConstant((String)entry.getKey(), new LiteralExpr((Value)entry.getValue()));
        }
    }

    public Value findConstant(Env env, String name) {
        return this._constMap.get(name);
    }

    public void initInstance(Env env, Value value) {
    }

    @Override
    public AbstractFunction findConstructor() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        if (this._isInit) {
            return;
        }
        try {
            this.initInterfaceList(this._type);
            this.introspect();
        }
        finally {
            this._isInit = true;
        }
    }

    private void initInterfaceList(Class type) {
        Class<?>[] ifaces = type.getInterfaces();
        if (ifaces == null) {
            return;
        }
        for (Class<?> iface : ifaces) {
            JavaClassDef javaClassDef = this._moduleContext.getJavaClassDefinition(iface);
            if (javaClassDef != null) {
                this.addInterface(javaClassDef.getName());
            }
            this.initInterfaceList(iface);
        }
    }

    private void introspect() {
        Method method;
        this.introspectConstants(this._type);
        this.introspectMethods(this._moduleContext, this._type);
        this.introspectFields(this._moduleContext, this._type);
        this._marshal = new JavaMarshal(this, false);
        Method consMethod = this.getConsMethod(this._type);
        if (consMethod != null) {
            this._cons = new JavaMethod(this._moduleContext, consMethod);
        } else {
            Constructor<?>[] cons = this._type.getConstructors();
            if (cons.length > 0) {
                int i;
                for (i = 0; i < cons.length && !cons[i].isAnnotationPresent(Construct.class); ++i) {
                }
                if (i < cons.length) {
                    this._cons = new JavaConstructor(this._moduleContext, cons[i]);
                } else {
                    this._cons = new JavaConstructor(this._moduleContext, cons[0]);
                    for (i = 1; i < cons.length; ++i) {
                        this._cons = this._cons.overload(new JavaConstructor(this._moduleContext, cons[i]));
                    }
                }
            } else {
                this._cons = null;
            }
        }
        this.introspectAnnotations(this._type);
        try {
            method = this._type.getMethod("iterator", new Class[0]);
            if (method != null && Iterator.class.isAssignableFrom(method.getReturnType())) {
                this._iteratorMethod = method;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            method = this._type.getMethod("keySet", new Class[0]);
            if (method != null && Set.class.isAssignableFrom(method.getReturnType())) {
                this._keySetMethod = method;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void introspectAnnotations(Class type) {
        if (type == null || type == Object.class) {
            return;
        }
        for (Class<?> iface : type.getInterfaces()) {
            this.introspectAnnotations(iface);
        }
        this.introspectAnnotations(type.getSuperclass());
        for (Annotation annotation : type.getAnnotations()) {
            Class<?>[] delegateClasses;
            if (annotation.annotationType() != Delegates.class) continue;
            for (Class<?> delegateClass : delegateClasses = ((Delegates)annotation).value()) {
                if (this.addDelegate(ArrayDelegate.class, this._arrayDelegates, delegateClass)) continue;
                throw new IllegalArgumentException(L.l("unknown @Delegate class '{0}'", delegateClass));
            }
        }
    }

    private <T> boolean addDelegate(Class<T> cl, ArrayList<T> delegates, Class<? extends Object> delegateClass) {
        if (!cl.isAssignableFrom(delegateClass)) {
            return false;
        }
        for (T delegate : delegates) {
            if (delegate.getClass() != delegateClass) continue;
            return true;
        }
        try {
            delegates.add(delegateClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new QuercusModuleException(e);
        }
        catch (IllegalAccessException e) {
            throw new QuercusModuleException(e);
        }
        return true;
    }

    private Method getConsMethod(Class type) {
        Method[] methods = type.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals("__construct") || !Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) continue;
            return method;
        }
        return null;
    }

    protected void setCons(Method method) {
        this._cons = new JavaMethod(this._moduleContext, method);
    }

    private void introspectFields(ModuleContext moduleContext, Class type) {
        Field[] fields;
        Method[] methods;
        if (type == null || type.equals(Object.class)) {
            return;
        }
        if (!Modifier.isPublic(type.getModifiers())) {
            return;
        }
        for (Method method : methods = type.getMethods()) {
            AbstractJavaMethod newGetter;
            AbstractJavaMethod existingGetter;
            String quercusName;
            String methodName;
            int length;
            if (Modifier.isStatic(method.getModifiers()) || (length = (methodName = method.getName()).length()) <= 3) continue;
            if (methodName.startsWith("get")) {
                quercusName = this.javaToQuercusConvert(methodName.substring(3, length));
                existingGetter = this._getMap.get(quercusName);
                newGetter = new JavaMethod(moduleContext, method);
                if (existingGetter != null) {
                    newGetter = existingGetter.overload(newGetter);
                }
                this._getMap.put(quercusName, newGetter);
                continue;
            }
            if (methodName.startsWith("is")) {
                quercusName = this.javaToQuercusConvert(methodName.substring(2, length));
                existingGetter = this._getMap.get(quercusName);
                newGetter = new JavaMethod(moduleContext, method);
                if (existingGetter != null) {
                    newGetter = existingGetter.overload(newGetter);
                }
                this._getMap.put(quercusName, newGetter);
                continue;
            }
            if (methodName.startsWith("set")) {
                quercusName = this.javaToQuercusConvert(methodName.substring(3, length));
                AbstractJavaMethod existingSetter = this._setMap.get(quercusName);
                AbstractJavaMethod newSetter = new JavaMethod(moduleContext, method);
                if (existingSetter != null) {
                    newSetter = existingSetter.overload(newSetter);
                }
                this._setMap.put(quercusName, newSetter);
                continue;
            }
            if ("__get".equals(methodName)) {
                this.__get = new JavaMethod(moduleContext, method);
                continue;
            }
            if ("__getField".equals(methodName)) {
                this.__getField = new JavaMethod(moduleContext, method);
                continue;
            }
            if ("__set".equals(methodName)) {
                this.__set = new JavaMethod(moduleContext, method);
                continue;
            }
            if (!"__setField".equals(methodName)) continue;
            this.__setField = new JavaMethod(moduleContext, method);
        }
        for (Field field : fields = type.getFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            MarshalFactory factory = moduleContext.getMarshalFactory();
            Marshal marshal = factory.create(field.getType(), false);
            this._fieldMap.put(field.getName(), new FieldMarshalPair(field, marshal));
        }
    }

    private String javaToQuercusConvert(String s) {
        if (s.length() == 1) {
            return new String(new char[]{Character.toLowerCase(s.charAt(0))});
        }
        if (Character.isUpperCase(s.charAt(1))) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Character.toLowerCase(s.charAt(0)));
        int length = s.length();
        for (int i = 1; i < length; ++i) {
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    private void introspectConstants(Class type) {
        Field[] fields;
        Class<?>[] ifcs;
        if (type == null || type.equals(Object.class)) {
            return;
        }
        if (!Modifier.isPublic(type.getModifiers())) {
            return;
        }
        for (Class<?> ifc : ifcs = type.getInterfaces()) {
            this.introspectConstants(ifc);
        }
        for (Field field : fields = type.getDeclaredFields()) {
            if (this._constMap.get(field.getName()) != null || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
            try {
                Value value = Quercus.objectToValue(field.get(null));
                if (value == null) continue;
                this._constMap.put(field.getName().intern(), value);
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        this.introspectConstants(type.getSuperclass());
    }

    private void introspectMethods(ModuleContext moduleContext, Class type) {
        Class<?>[] ifcs;
        Method[] methods;
        if (type == null || type.equals(Object.class)) {
            return;
        }
        for (Method method : methods = type.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || method.getDeclaringClass() == Object.class) continue;
            if ("printRImpl".equals(method.getName())) {
                this._printRImpl = method;
                continue;
            }
            if ("varDumpImpl".equals(method.getName())) {
                this._varDumpImpl = method;
                continue;
            }
            if ("__call".equals(method.getName())) {
                this.__call = new JavaMethod(moduleContext, method);
                continue;
            }
            if (method.getName().startsWith("quercus_")) {
                throw new UnsupportedOperationException(L.l("{0}: use @Name instead", (Object)method.getName()));
            }
            JavaMethod newFun = new JavaMethod(moduleContext, method);
            AbstractJavaMethod fun = this._functionMap.get(newFun.getName());
            fun = fun != null ? fun.overload(newFun) : newFun;
            this._functionMap.put(fun.getName(), fun);
        }
        this.introspectMethods(moduleContext, type.getSuperclass());
        for (Class<?> ifc : ifcs = type.getInterfaces()) {
            this.introspectMethods(moduleContext, ifc);
        }
    }

    public boolean printRImpl(Env env, Object obj, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        try {
            if (this._printRImpl == null) {
                return false;
            }
            this._printRImpl.invoke(obj, env, out, depth, valueSet);
            return true;
        }
        catch (Exception e) {
            throw new QuercusException(e);
        }
    }

    public boolean varDumpImpl(Env env, Object obj, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        try {
            if (this._varDumpImpl == null) {
                return false;
            }
            this._varDumpImpl.invoke(obj, env, out, depth, valueSet);
            return true;
        }
        catch (Exception e) {
            throw new QuercusException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValueIterator
    implements Iterator<Value> {
        private final Env _env;
        private final Iterator<?> _iterator;

        private ValueIterator(Env env, ObjectValue obj, Method iteratorMethod) {
            this._env = env;
            try {
                this._iterator = (Iterator)iteratorMethod.invoke(obj.toJavaObject(), new Object[0]);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public Value next() {
            return this._env.wrapJava(this._iterator.next());
        }

        @Override
        public void remove() {
            this._iterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyIterator
    implements Iterator<Value> {
        private final Env _env;
        private final Iterator<?> _iterator;

        private KeyIterator(Env env, ObjectValue obj, Method keySetMethod) {
            this._env = env;
            try {
                this._iterator = ((Set)keySetMethod.invoke(obj.toJavaObject(), new Object[0])).iterator();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public Value next() {
            return this._env.wrapJava(this._iterator.next());
        }

        @Override
        public void remove() {
            this._iterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EntryIterator
    implements Iterator<Map.Entry<Value, Value>> {
        private final Value _obj;
        private final KeyIterator _keyIterator;

        private EntryIterator(Env env, ObjectValue obj, Method keySetMethod) {
            this._obj = obj;
            this._keyIterator = new KeyIterator(env, obj, keySetMethod);
        }

        @Override
        public boolean hasNext() {
            return this._keyIterator.hasNext();
        }

        @Override
        public Map.Entry<Value, Value> next() {
            final Value key = this._keyIterator.next();
            final Value value = this._obj.get(key);
            return new Map.Entry<Value, Value>(){

                @Override
                public Value getKey() {
                    return key;
                }

                @Override
                public Value getValue() {
                    return value;
                }

                @Override
                public Value setValue(Value value2) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public void remove() {
            this._keyIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DefaultArrayDelegate
    extends ArrayDelegate {
        @Override
        public Iterator<Map.Entry<Value, Value>> getIterator(Env env, ObjectValue obj) {
            EntryIterator iter = super.getIterator(env, obj);
            if (iter == null && JavaClassDef.this._keySetMethod != null) {
                iter = new EntryIterator(env, obj, JavaClassDef.this._keySetMethod);
            }
            return iter;
        }

        @Override
        public Iterator<Value> getKeyIterator(Env env, ObjectValue obj) {
            KeyIterator iter = super.getKeyIterator(env, obj);
            if (iter == null && JavaClassDef.this._keySetMethod != null) {
                iter = new KeyIterator(env, obj, JavaClassDef.this._keySetMethod);
            }
            return iter;
        }

        @Override
        public Iterator<Value> getValueIterator(Env env, ObjectValue obj) {
            ValueIterator iter = super.getKeyIterator(env, obj);
            if (iter == null && JavaClassDef.this._iteratorMethod != null) {
                iter = new ValueIterator(env, obj, JavaClassDef.this._iteratorMethod);
            }
            return iter;
        }

        @Override
        public Value get(Env env, ObjectValue obj, Value name) {
            if (JavaClassDef.this.__get != null) {
                try {
                    return JavaClassDef.this.__get.call(env, obj.toJavaObject(), name);
                }
                catch (Throwable e) {
                    log.log(Level.FINE, L.l(e.getMessage()), e);
                    return NullValue.NULL;
                }
            }
            return NullValue.NULL;
        }

        @Override
        public Value put(Env env, ObjectValue obj, Value name, Value value) {
            if (JavaClassDef.this.__set != null) {
                try {
                    return JavaClassDef.this.__set.call(env, obj.toJavaObject(), name, value);
                }
                catch (Throwable e) {
                    log.log(Level.FINE, L.l(e.getMessage()), e);
                    return NullValue.NULL;
                }
            }
            return NullValue.NULL;
        }
    }

    private static class URLClassDef
    extends JavaClassDef {
        URLClassDef(ModuleContext module) {
            super(module, "URL", URL.class);
        }

        public Value wrap(Env env, Object obj) {
            return new JavaURLValue(env, (URL)obj, (JavaClassDef)this);
        }
    }

    private static class DateClassDef
    extends JavaClassDef {
        DateClassDef(ModuleContext module) {
            super(module, "Date", Date.class);
        }

        public Value wrap(Env env, Object obj) {
            return new JavaDateValue(env, (Date)obj, (JavaClassDef)this);
        }
    }

    private static class CalendarClassDef
    extends JavaClassDef {
        CalendarClassDef(ModuleContext module) {
            super(module, "Calendar", Calendar.class);
        }

        public Value wrap(Env env, Object obj) {
            return new JavaCalendarValue(env, (Calendar)obj, (JavaClassDef)this);
        }
    }

    private static class BooleanClassDef
    extends JavaClassDef {
        BooleanClassDef(ModuleContext module) {
            super(module, "Boolean", Boolean.class);
        }

        public Value wrap(Env env, Object obj) {
            if (Boolean.TRUE.equals(obj)) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }

    private static class StringClassDef
    extends JavaClassDef {
        StringClassDef(ModuleContext module) {
            super(module, "String", String.class);
        }

        public Value wrap(Env env, Object obj) {
            return env.createString((String)obj);
        }
    }

    private static class DoubleClassDef
    extends JavaClassDef {
        DoubleClassDef(ModuleContext module) {
            super(module, "Double", Double.class);
        }

        public Value wrap(Env env, Object obj) {
            return new DoubleValue(((Number)obj).doubleValue());
        }
    }

    private static class LongClassDef
    extends JavaClassDef {
        LongClassDef(ModuleContext module) {
            super(module, "Long", Long.class);
        }

        public Value wrap(Env env, Object obj) {
            return LongValue.create(((Number)obj).longValue());
        }
    }

    private class FieldMarshalPair {
        public Field _field;
        public Marshal _marshal;

        public FieldMarshalPair(Field field, Marshal marshal) {
            this._field = field;
            this._marshal = marshal;
        }
    }

    private class MethodMarshalPair {
        public Method _method;
        public Marshal _marshal;

        public MethodMarshalPair(Method method, Marshal marshal) {
            this._method = method;
            this._marshal = marshal;
        }
    }
}

