/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.Quercus;
import com.caucho.quercus.env.AbstractJavaMethod;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.FunctionMap;
import com.caucho.quercus.env.JavaMethod;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectExtValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.LiteralExpr;
import com.caucho.quercus.function.Marshal;
import com.caucho.quercus.function.MarshalFactory;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.quercus.program.ClassDef;
import com.caucho.util.L10N;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaImplClassDef
extends ClassDef {
    private static final Logger log = Logger.getLogger(JavaImplClassDef.class.getName());
    private static final L10N L = new L10N(JavaImplClassDef.class);
    private final ModuleContext _moduleContext;
    private final String _name;
    private final Class _type;
    private final HashMap<String, Expr> _constMap = new HashMap();
    private final FunctionMap _functionMap = new FunctionMap();
    private JavaMethod _cons;

    public JavaImplClassDef(ModuleContext moduleContext, String name, Class type) {
        super(null, name, null, new String[0]);
        this._moduleContext = moduleContext;
        this._name = name;
        this._type = type;
    }

    public String getName() {
        return this._name;
    }

    public Class getType() {
        return this._type;
    }

    public ObjectValue newInstance(Env env, QuercusClass qClass) {
        return new ObjectExtValue(qClass);
    }

    public Value callMethod(Env env, Value obj, String name, Expr[] args) {
        AbstractJavaMethod method = this._functionMap.getFunction(name);
        if (method == null) {
            env.warning(env.getLocation(), L.l("{0}::{1} is an unknown method.", (Object)this._name, (Object)name));
            return NullValue.NULL;
        }
        return method.call(env, (Object)obj, args);
    }

    public Value callMethod(Env env, Value obj, String name, Value[] args) {
        return this.getMethod(env, name).call(env, obj, args);
    }

    public Value callMethod(Env env, Object obj, String name) {
        return this.getMethod(env, name).call(env, obj);
    }

    public Value callMethod(Env env, Object obj, String name, Value a1) {
        return this.getMethod(env, name).call(env, obj, a1);
    }

    public Value callMethod(Env env, Object obj, String name, Value a1, Value a2) {
        return this.getMethod(env, name).call(env, obj, a1, a2);
    }

    public Value callMethod(Env env, Object obj, String name, Value a1, Value a2, Value a3) {
        return this.getMethod(env, name).call(env, obj, a1, a2, a3);
    }

    public Value callMethod(Env env, Object obj, String name, Value a1, Value a2, Value a3, Value a4) {
        return this.getMethod(env, name).call(env, obj, a1, a2, a3, a4);
    }

    public Value callMethod(Env env, Object obj, String name, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.getMethod(env, name).call(env, obj, a1, a2, a3, a4, a5);
    }

    private AbstractJavaMethod getMethod(Env env, String name) {
        AbstractJavaMethod method = this._functionMap.getFunction(name);
        if (method == null) {
            env.error(env.getLocation(), "'" + name + "' is an unknown method.");
        }
        return method;
    }

    public void initClass(QuercusClass cl) {
        if (this._cons != null) {
            cl.setConstructor(this._cons);
            cl.addMethod("__construct", this._cons);
        }
        for (Map.Entry<String, AbstractJavaMethod> entry : this._functionMap.entrySet()) {
            cl.addMethod(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this._constMap.entrySet()) {
            cl.addConstant(entry.getKey(), (Expr)entry.getValue());
        }
    }

    public void initInstance(Env env, Value value) {
    }

    public Value callNew(Env env, Expr[] args) {
        return null;
    }

    public Value callNew(Env env, Value[] args) {
        return null;
    }

    public AbstractFunction findConstructor() {
        return null;
    }

    public void introspect(ModuleContext moduleContext) {
        this.introspectConstants(this._type);
        this.introspectMethods(moduleContext, this._type);
        this.introspectFields(moduleContext, this._type);
    }

    private Method getConsMethod(Class type) {
        Method[] methods = type.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals("__construct") || !Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) continue;
            return method;
        }
        return null;
    }

    private void introspectFields(ModuleContext moduleContext, Class type) {
        Field[] fields;
        MarshalFactory marshalFactory = moduleContext.getMarshalFactory();
        for (Field field : fields = type.getFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            Marshal marshal = marshalFactory.create(field.getType(), false);
        }
    }

    private void introspectConstants(Class type) {
        Field[] fields;
        Class<?>[] ifcs;
        if (type == null || type.equals(Object.class)) {
            return;
        }
        if (!Modifier.isPublic(type.getModifiers())) {
            return;
        }
        for (Class<?> ifc : ifcs = type.getInterfaces()) {
            this.introspectConstants(ifc);
        }
        for (Field field : fields = type.getDeclaredFields()) {
            if (this._constMap.get(field.getName()) != null || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
            try {
                Value value = Quercus.objectToValue(field.get(null));
                if (value == null) continue;
                this._constMap.put(field.getName().intern(), new LiteralExpr(value));
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        this.introspectConstants(type.getSuperclass());
    }

    private void introspectMethods(ModuleContext moduleContext, Class type) {
        Method[] methods;
        Class<?>[] ifcs;
        if (type == null || type.equals(Object.class)) {
            return;
        }
        for (Class<?> ifc : ifcs = type.getInterfaces()) {
            this.introspectMethods(moduleContext, ifc);
        }
        for (Method method : methods = type.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) continue;
            JavaMethod javaMethod = new JavaMethod(moduleContext, method);
            if (method.getName().equals("__construct")) {
                this._cons = javaMethod;
            }
            this._functionMap.addFunction(method.getName(), javaMethod);
        }
        this.introspectMethods(moduleContext, type.getSuperclass());
    }

    private class FieldMarshalPair {
        public final Field _field;
        public final Marshal _marshal;

        public FieldMarshalPair(Field field, Marshal marshal) {
            this._field = field;
            this._marshal = marshal;
        }
    }
}

