/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.Quercus;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.quercus.program.BlockStatement;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.ExprStatement;
import com.caucho.quercus.program.Function;
import com.caucho.quercus.program.FunctionInfo;
import com.caucho.quercus.program.InterpretedClassDef;
import com.caucho.quercus.program.ReturnStatement;
import com.caucho.quercus.program.Statement;
import com.caucho.vfs.BasicDependencyContainer;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuercusProgram {
    private Quercus _quercus;
    private QuercusPage _compiledPage;
    private Path _sourceFile;
    private HashMap<String, Function> _functionMap;
    private HashMap<String, Function> _functionMapLowerCase = new HashMap();
    private HashMap<String, InterpretedClassDef> _classMap;
    private FunctionInfo _functionInfo;
    private Statement _statement;
    private ArrayList<PersistentDependency> _dependList = new ArrayList();
    private BasicDependencyContainer _depend = new BasicDependencyContainer();

    public QuercusProgram(Quercus quercus, Path sourceFile, HashMap<String, Function> functionMap, HashMap<String, InterpretedClassDef> classMap, FunctionInfo functionInfo, Statement statement) {
        this._quercus = quercus;
        this._sourceFile = sourceFile;
        if (sourceFile != null) {
            this.addDepend(sourceFile);
        }
        this._functionMap = functionMap;
        for (Map.Entry<String, Function> entry : functionMap.entrySet()) {
            this._functionMapLowerCase.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        this._classMap = classMap;
        this._functionInfo = functionInfo;
        this._statement = statement;
    }

    public Quercus getPhp() {
        return this._quercus;
    }

    public Path getSourcePath() {
        return this._sourceFile;
    }

    public FunctionInfo getFunctionInfo() {
        return this._functionInfo;
    }

    public Statement getStatement() {
        return this._statement;
    }

    public void addDepend(Path path) {
        Depend depend = new Depend(path);
        this._dependList.add((PersistentDependency)depend);
        this._depend.add((Dependency)depend);
    }

    public ArrayList<PersistentDependency> getDependencyList() {
        return this._dependList;
    }

    public boolean isModified() {
        return this._depend.isModified();
    }

    public QuercusPage getCompiledPage() {
        return this._compiledPage;
    }

    public void setCompiledPage(QuercusPage page) {
        this._compiledPage = page;
    }

    public AbstractFunction findFunction(String name) {
        AbstractFunction fun = this._functionMap.get(name);
        if (fun != null) {
            return fun;
        }
        if (!this._quercus.isStrict()) {
            fun = this._functionMapLowerCase.get(name.toLowerCase());
        }
        return fun;
    }

    public Collection<Function> getFunctions() {
        return this._functionMap.values();
    }

    public Collection<InterpretedClassDef> getClasses() {
        return this._classMap.values();
    }

    public QuercusProgram createExprReturn() {
        BlockStatement blockStmt;
        Statement[] statements;
        if (this._statement instanceof ExprStatement) {
            ExprStatement exprStmt = (ExprStatement)this._statement;
            this._statement = new ReturnStatement(exprStmt.getExpr());
        } else if (this._statement instanceof BlockStatement && (statements = (blockStmt = (BlockStatement)this._statement).getStatements()).length > 0 && statements[0] instanceof ExprStatement) {
            ExprStatement exprStmt = (ExprStatement)statements[0];
            this._statement = new ReturnStatement(exprStmt.getExpr());
        }
        return this;
    }

    public Value execute(Env env) {
        Value value = this._statement.execute(env);
        if (value != null) {
            return value;
        }
        return LongValue.ONE;
    }

    public void init(Env env) {
    }

    public void importDefinitions(Env env) {
        for (Map.Entry<String, Function> entry : this._functionMap.entrySet()) {
            Function fun = entry.getValue();
            if (!fun.isGlobal()) continue;
            env.addFunction(entry.getKey(), fun);
        }
        for (Map.Entry<String, Object> entry : this._classMap.entrySet()) {
            env.addClassDef(entry.getKey(), (ClassDef)entry.getValue());
        }
    }

    public String toString() {
        return "QuercusProgram[" + this._sourceFile + "]";
    }
}

