/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.BreakValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.program.BlockStatement;
import com.caucho.quercus.program.Statement;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchStatement
extends Statement {
    protected final Expr _value;
    protected final Expr[][] _cases;
    protected final BlockStatement[] _blocks;
    protected final Statement _defaultBlock;

    public SwitchStatement(Location location, Expr value, ArrayList<Expr[]> caseList, ArrayList<BlockStatement> blockList, Statement defaultBlock) {
        super(location);
        this._value = value;
        this._cases = new Expr[caseList.size()][];
        caseList.toArray((T[])this._cases);
        this._blocks = new BlockStatement[blockList.size()];
        blockList.toArray(this._blocks);
        this._defaultBlock = defaultBlock;
    }

    @Override
    public Value execute(Env env) {
        try {
            Value testValue = this._value.eval(env);
            int len = this._cases.length;
            for (int i = 0; i < len; ++i) {
                Expr[] values = this._cases[i];
                for (int j = 0; j < values.length; ++j) {
                    Value caseValue = values[j].eval(env);
                    if (!testValue.eq(caseValue)) continue;
                    Value retValue = this._blocks[i].execute(env);
                    if (retValue instanceof BreakValue) {
                        return null;
                    }
                    return retValue;
                }
            }
            if (this._defaultBlock != null) {
                Value retValue = this._defaultBlock.execute(env);
                if (retValue instanceof BreakValue) {
                    return null;
                }
                return retValue;
            }
        }
        catch (RuntimeException e) {
            this.rethrow(e, RuntimeException.class);
        }
        return null;
    }

    @Override
    public int fallThrough() {
        return 0;
    }
}

