/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.Location;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusLanguageException;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.program.Statement;
import java.util.ArrayList;

public class TryStatement
extends Statement {
    protected final Statement _block;
    protected final ArrayList<Catch> _catchList = new ArrayList();

    public TryStatement(Location location, Statement block) {
        super(location);
        this._block = block;
    }

    public void addCatch(String id, AbstractVarExpr lhs, Statement block) {
        this._catchList.add(new Catch(id, lhs, block));
    }

    public Value execute(Env env) {
        try {
            return this._block.execute(env);
        }
        catch (QuercusLanguageException e) {
            Value value = e.getValue();
            for (int i = 0; i < this._catchList.size(); ++i) {
                Catch item = this._catchList.get(i);
                if ((value == null || !value.isA(item.getId())) && (value != null || !item.getId().equals("Exception"))) continue;
                if (value != null) {
                    item.getExpr().evalAssign(env, value);
                } else {
                    item.getExpr().evalAssign(env, NullValue.NULL);
                }
                return item.getBlock().execute(env);
            }
            throw e;
        }
        catch (Exception e) {
            for (int i = 0; i < this._catchList.size(); ++i) {
                Catch item = this._catchList.get(i);
                if (!item.getId().equals("Exception")) continue;
                item.getExpr().evalAssign(env, env.createException(e));
                return item.getBlock().execute(env);
            }
            throw new QuercusException(e);
        }
    }

    public static class Catch {
        private final String _id;
        private final AbstractVarExpr _lhs;
        private final Statement _block;

        Catch(String id, AbstractVarExpr lhs, Statement block) {
            this._id = id;
            this._lhs = lhs;
            this._block = block;
            if (id == null) {
                throw new NullPointerException();
            }
        }

        public String getId() {
            return this._id;
        }

        public AbstractVarExpr getExpr() {
            return this._lhs;
        }

        public Statement getBlock() {
            return this._block;
        }
    }
}

