/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.BreakValue;
import com.caucho.quercus.env.ContinueValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.program.Statement;

public class WhileStatement
extends Statement {
    protected final Expr _test;
    protected final Statement _block;

    public WhileStatement(Location location, Expr test, Statement block) {
        super(location);
        this._test = test;
        this._block = block;
    }

    public Value execute(Env env) {
        try {
            while (this._test.evalBoolean(env)) {
                env.checkTimeout();
                Value value = this._block.execute(env);
                if (value == null) continue;
                if (value == BreakValue.BREAK) {
                    return null;
                }
                if (value == ContinueValue.CONTINUE) continue;
                return value;
            }
        }
        catch (RuntimeException e) {
            this.rethrow(e, RuntimeException.class);
        }
        return null;
    }
}

