/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.script;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.page.InterpretedPage;
import com.caucho.quercus.program.QuercusProgram;
import com.caucho.quercus.script.QuercusScriptEngine;
import com.caucho.vfs.NullWriteStream;
import com.caucho.vfs.ReaderWriterStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.Writer;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class QuercusCompiledScript
extends CompiledScript {
    private final QuercusScriptEngine _engine;
    private final QuercusProgram _program;

    QuercusCompiledScript(QuercusScriptEngine engine, QuercusProgram program) {
        this._engine = engine;
        this._program = program;
    }

    public Object eval(ScriptContext cxt) throws ScriptException {
        try {
            NullWriteStream out;
            Writer writer = cxt.getWriter();
            if (writer != null) {
                ReaderWriterStream s = new ReaderWriterStream(null, writer);
                WriteStream os = new WriteStream((StreamImpl)s);
                try {
                    os.setEncoding("utf-8");
                }
                catch (Exception e) {
                    // empty catch block
                }
                out = os;
            } else {
                out = new NullWriteStream();
            }
            InterpretedPage page = new InterpretedPage(this._program);
            Env env = new Env(this._engine.getQuercus(), page, (WriteStream)out, null, null);
            env.setScriptContext(cxt);
            Object value = this._program.execute(env).toJavaObject();
            out.flushBuffer();
            out.free();
            return value;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public ScriptEngine getEngine() {
        return this._engine;
    }

    public String toString() {
        return "QuercusCompiledScript[]";
    }
}

