/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.servlet;

import com.caucho.config.ConfigException;
import com.caucho.quercus.Quercus;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.module.QuercusModule;
import com.caucho.quercus.servlet.PhpClassConfig;
import com.caucho.quercus.servlet.QuercusServletImpl;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

public class QuercusServlet
extends HttpServlet {
    private static final L10N L = new L10N(QuercusServlet.class);
    private static final Logger log = Logger.getLogger(QuercusServlet.class.getName());
    private Quercus _quercus;
    private QuercusServletImpl _impl;
    private boolean _isCompileSet;

    public QuercusServlet() {
        Class<?> cl;
        QuercusServlet.checkJavaVersion();
        if (this._impl == null) {
            try {
                cl = Class.forName("com.caucho.quercus.servlet.ProQuercusServlet");
                this._impl = (QuercusServletImpl)cl.newInstance();
            }
            catch (Exception e) {
                log.log(Level.FINEST, e.toString(), e);
            }
        }
        if (this._impl == null) {
            try {
                cl = Class.forName("com.caucho.quercus.servlet.ResinQuercusServlet");
                this._impl = (QuercusServletImpl)cl.newInstance();
            }
            catch (Exception e) {
                log.log(Level.FINEST, e.toString(), e);
            }
        }
        if (this._impl == null) {
            this._impl = new QuercusServletImpl();
        }
    }

    private static void checkJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.3.") || version.startsWith("1.4.")) {
            throw new QuercusRuntimeException(L.l("Quercus requires JDK 1.5 or newer."));
        }
    }

    public void setCompile(String isCompile) throws ConfigException {
        this._isCompileSet = true;
        Quercus quercus = this.getQuercus();
        if ("true".equals(isCompile) || "".equals(isCompile)) {
            quercus.setCompile(true);
            quercus.setLazyCompile(false);
        } else if ("false".equals(isCompile)) {
            quercus.setCompile(false);
            quercus.setLazyCompile(false);
        } else if ("lazy".equals(isCompile)) {
            quercus.setLazyCompile(true);
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown compile value.  Values are 'true', 'false', or 'lazy'.", (Object)isCompile));
        }
    }

    public void setDatabase(DataSource database) throws ConfigException {
        if (database == null) {
            throw new ConfigException(L.l("invalid database"));
        }
        this.getQuercus().setDatabase(database);
    }

    public void setStrict(boolean isStrict) {
        this.getQuercus().setStrict(isStrict);
    }

    public void addModule(QuercusModule module) throws ConfigException {
        this.getQuercus().addModule(module);
    }

    public void addClass(PhpClassConfig classConfig) throws ConfigException {
        this.getQuercus().addJavaClass(classConfig.getName(), classConfig.getType());
    }

    public void addImplClass(PhpClassConfig classConfig) throws ConfigException {
        this.getQuercus().addImplClass(classConfig.getName(), classConfig.getType());
    }

    public PhpIni createPhpIni() throws ConfigException {
        return new PhpIni(this.getQuercus());
    }

    public ServerEnv createServerEnv() throws ConfigException {
        return new ServerEnv(this.getQuercus());
    }

    public void setIniFile(Path path) {
        this.getQuercus().setIniFile(path);
    }

    public void setScriptEncoding(String encoding) throws ConfigException {
        this.getQuercus().setScriptEncoding(encoding);
    }

    public void setMysqlVersion(String version) {
        this.getQuercus().setMysqlVersion(version);
    }

    public void setPhpVersion(String version) {
        this.getQuercus().setPhpVersion(version);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Enumeration paramNames = config.getInitParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = String.valueOf(paramNames.nextElement());
            String paramValue = config.getInitParameter(paramName);
            this.setInitParam(paramName, paramValue);
        }
        this.initImpl(config);
    }

    protected void setInitParam(String paramName, String paramValue) throws ServletException {
        if ("compile".equals(paramName)) {
            this.setCompile(paramValue);
        } else if ("database".equals(paramName)) {
            try {
                DataSource ds;
                InitialContext ic = new InitialContext();
                if (!paramValue.startsWith("java:comp")) {
                    try {
                        ds = (DataSource)ic.lookup("java:comp/env/" + paramValue);
                    }
                    catch (Exception e) {
                        ds = (DataSource)ic.lookup(paramValue);
                    }
                } else {
                    ds = (DataSource)ic.lookup(paramValue);
                }
                if (ds == null) {
                    throw new ServletException(L.l("database '{0}' is not valid", (Object)paramValue));
                }
                this.getQuercus().setDatabase(ds);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        } else if ("ini-file".equals(paramName)) {
            Quercus quercus = this.getQuercus();
            Path path = quercus.getPwd().lookup(paramValue);
            this.setIniFile(path);
        } else if ("mysql-version".equals(paramName)) {
            this.setMysqlVersion(paramValue);
        } else if ("php-version".equals(paramName)) {
            this.setPhpVersion(paramValue);
        } else if ("script-encoding".equals(paramName)) {
            this.setScriptEncoding(paramValue);
        } else if ("strict".equals(paramName)) {
            this.setStrict("true".equals(paramValue));
        } else {
            throw new ServletException(L.l("'{0}' is not a recognized init-param", (Object)paramName));
        }
    }

    private void initImpl(ServletConfig config) throws ServletException {
        this.getQuercus();
        if (!this._isCompileSet) {
            this.getQuercus().setLazyCompile(true);
        }
        this._impl.init(config);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this._impl.service(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Quercus getQuercus() {
        QuercusServlet quercusServlet = this;
        synchronized (quercusServlet) {
            if (this._quercus == null) {
                this._quercus = this._impl.getQuercus();
            }
        }
        return this._quercus;
    }

    public void destroy() {
        this._quercus.close();
        this._impl.destroy();
    }

    public static class ServerEnv {
        private Quercus _quercus;

        ServerEnv(Quercus quercus) {
            this._quercus = quercus;
        }

        public void put(String key, String value) {
            this._quercus.setServerEnv(key, value);
        }
    }

    public static class PhpIni {
        private Quercus _quercus;

        PhpIni(Quercus quercus) {
            this._quercus = quercus;
        }

        public void put(String key, String value) {
            this._quercus.setIni(key, value);
        }
    }
}

