/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.joni.encoding.Encoding;
import org.joni.encoding.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;
import org.jruby.util.Sprintf;
import org.jruby.util.string.JavaCrypt;

@JRubyClass(name={"String"}, include={"Enumerable", "Comparable"})
public class RubyString
extends RubyObject {
    private static final ASCIIEncoding ASCII = ASCIIEncoding.INSTANCE;
    private static final int SHARE_LEVEL_NONE = 0;
    private static final int SHARE_LEVEL_BUFFER = 1;
    private static final int SHARE_LEVEL_BYTELIST = 2;
    private volatile int shareLevel = 0;
    private ByteList value;
    private static ObjectAllocator STRING_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyString newString = runtime.newStringShared(ByteList.EMPTY_BYTELIST);
            newString.setMetaClass(klass);
            return newString;
        }
    };
    private static final ByteList SPACE_BYTELIST = new ByteList(ByteList.plain(" "));
    private static final int TRANS_SIZE = 256;

    public static RubyClass createStringClass(Ruby runtime) {
        RubyClass stringClass = runtime.defineClass("String", runtime.getObject(), STRING_ALLOCATOR);
        runtime.setString(stringClass);
        stringClass.index = 4;
        stringClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyString;
            }
        };
        stringClass.includeModule(runtime.getComparable());
        stringClass.includeModule(runtime.getEnumerable());
        stringClass.defineAnnotatedMethods(RubyString.class);
        return stringClass;
    }

    public final boolean eql(IRubyObject other) {
        if (other.getMetaClass() == this.getRuntime().getString()) {
            return this.value.equal(((RubyString)other).value);
        }
        return super.eql(other);
    }

    private RubyString(Ruby runtime, RubyClass rubyClass, CharSequence value) {
        super(runtime, rubyClass);
        assert (value != null);
        this.value = new ByteList(ByteList.plain(value), false);
    }

    private RubyString(Ruby runtime, RubyClass rubyClass, byte[] value) {
        super(runtime, rubyClass);
        assert (value != null);
        this.value = new ByteList(value);
    }

    private RubyString(Ruby runtime, RubyClass rubyClass, ByteList value) {
        super(runtime, rubyClass);
        assert (value != null);
        this.value = value;
    }

    private RubyString(Ruby runtime, RubyClass rubyClass, ByteList value, boolean objectSpace) {
        super(runtime, rubyClass, objectSpace);
        assert (value != null);
        this.value = value;
    }

    public int getNativeTypeIndex() {
        return 4;
    }

    public Class getJavaClass() {
        return String.class;
    }

    public RubyString convertToString() {
        return this;
    }

    public String toString() {
        return this.value.toString();
    }

    public final RubyString strDup() {
        return this.strDup(this.getMetaClass());
    }

    final RubyString strDup(RubyClass clazz) {
        this.shareLevel = 2;
        RubyString dup = new RubyString(this.getRuntime(), clazz, this.value);
        dup.shareLevel = 2;
        dup.infectBy(this);
        return dup;
    }

    public final RubyString makeShared(int index, int len) {
        if (len == 0) {
            RubyString s = RubyString.newEmptyString(this.getRuntime(), this.getMetaClass());
            s.infectBy(this);
            return s;
        }
        if (this.shareLevel == 0) {
            this.shareLevel = 1;
        }
        RubyString shared = new RubyString(this.getRuntime(), this.getMetaClass(), this.value.makeShared(index, len));
        shared.shareLevel = 1;
        shared.infectBy(this);
        return shared;
    }

    private final void modifyCheck() {
        if ((this.flags & 4) != 0) {
            throw this.getRuntime().newFrozenError("string" + this.getMetaClass().getName());
        }
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify string");
        }
    }

    private final void modifyCheck(byte[] b, int len) {
        if (this.value.bytes != b || this.value.realSize != len) {
            throw this.getRuntime().newRuntimeError("string modified");
        }
    }

    private final void frozenCheck() {
        if (this.isFrozen()) {
            throw this.getRuntime().newRuntimeError("string frozen");
        }
    }

    public final void modify() {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.dup();
            } else {
                this.value.unshare();
            }
            this.shareLevel = 0;
        }
        this.value.invalidate();
    }

    public final void modify(int length) {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.dup(length);
            } else {
                this.value.unshare(length);
            }
            this.shareLevel = 0;
        } else {
            this.value.ensure(length);
        }
        this.value.invalidate();
    }

    private final void view(ByteList bytes) {
        this.modifyCheck();
        this.value = bytes;
        this.shareLevel = 0;
    }

    private final void view(byte[] bytes) {
        this.modifyCheck();
        this.value.replace(bytes);
        this.shareLevel = 0;
        this.value.invalidate();
    }

    private final void view(int index, int len) {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.makeShared(index, len);
                this.shareLevel = 1;
            } else {
                this.value.view(index, len);
            }
        } else {
            this.value.view(index, len);
            this.shareLevel = 1;
        }
        this.value.invalidate();
    }

    public static String bytesToString(byte[] bytes, int beg, int len) {
        return new String(ByteList.plain(bytes, beg, len));
    }

    public static String byteListToString(ByteList bytes) {
        return RubyString.bytesToString(bytes.unsafeBytes(), bytes.begin(), bytes.length());
    }

    public static String bytesToString(byte[] bytes) {
        return RubyString.bytesToString(bytes, 0, bytes.length);
    }

    public static byte[] stringToBytes(String string) {
        return ByteList.plain(string);
    }

    public static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    public static boolean isUpper(int c) {
        return c >= 65 && c <= 90;
    }

    public static boolean isLower(int c) {
        return c >= 97 && c <= 122;
    }

    public static boolean isLetter(int c) {
        return RubyString.isUpper(c) || RubyString.isLower(c);
    }

    public static boolean isAlnum(int c) {
        return RubyString.isUpper(c) || RubyString.isLower(c) || RubyString.isDigit(c);
    }

    public static boolean isPrint(int c) {
        return c >= 32 && c <= 126;
    }

    public RubyString asString() {
        return this;
    }

    public IRubyObject checkStringType() {
        return this;
    }

    @JRubyMethod(name={"to_s", "to_str"})
    public IRubyObject to_s() {
        if (this.getMetaClass().getRealClass() != this.getRuntime().getString()) {
            return this.strDup(this.getRuntime().getString());
        }
        return this;
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        IRubyObject result;
        if (other instanceof RubyString) {
            return this.getRuntime().newFixnum(this.op_cmp((RubyString)other));
        }
        if (other.respondsTo("to_str") && other.respondsTo("<=>") && (result = other.callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", this)) instanceof RubyNumeric) {
            return ((RubyNumeric)result).op_uminus(context);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyString)) {
            if (!other.respondsTo("to_str")) {
                return this.getRuntime().getFalse();
            }
            Ruby runtime = this.getRuntime();
            return other.callMethod(context, MethodIndex.EQUALEQUAL, "==", this).isTrue() ? runtime.getTrue() : runtime.getFalse();
        }
        return this.value.equal(((RubyString)other).value) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(IRubyObject other) {
        RubyString str = other.convertToString();
        ByteList result = new ByteList(this.value.realSize + str.value.realSize);
        result.realSize = this.value.realSize + str.value.realSize;
        System.arraycopy(this.value.bytes, this.value.begin, result.bytes, 0, this.value.realSize);
        System.arraycopy(str.value.bytes, str.value.begin, result.bytes, this.value.realSize, str.value.realSize);
        RubyString resultStr = RubyString.newString(this.getRuntime(), result);
        if (this.isTaint() || str.isTaint()) {
            resultStr.setTaint(true);
        }
        return resultStr;
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul(IRubyObject other) {
        RubyInteger otherInteger = other.convertToInteger();
        long len = otherInteger.getLongValue();
        if (len < 0L) {
            throw this.getRuntime().newArgumentError("negative argument");
        }
        if (len > 0L && Integer.MAX_VALUE / len < (long)this.value.length()) {
            throw this.getRuntime().newArgumentError("argument too big");
        }
        ByteList newBytes = new ByteList(this.value.length() * (int)len);
        int i = 0;
        while ((long)i < len) {
            newBytes.append(this.value);
            ++i;
        }
        RubyString newString = new RubyString(this.getRuntime(), this.getMetaClass(), newBytes);
        newString.setTaint(this.isTaint());
        return newString;
    }

    @JRubyMethod(name={"%"}, required=1)
    public IRubyObject op_format(IRubyObject arg) {
        RubyString s = Sprintf.sprintf(this.getRuntime(), Locale.US, this.value, arg);
        s.infectBy(this);
        return s;
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.value.hashCode());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RubyString) {
            RubyString string = (RubyString)other;
            if (string.value.equal(this.value)) {
                return true;
            }
        }
        return false;
    }

    public static RubyString objAsString(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyString) {
            return (RubyString)obj;
        }
        IRubyObject str = obj.callMethod(context, MethodIndex.TO_S, "to_s");
        if (!(str instanceof RubyString)) {
            return (RubyString)obj.anyToString();
        }
        if (obj.isTaint()) {
            str.setTaint(true);
        }
        return (RubyString)str;
    }

    public int op_cmp(RubyString other) {
        return this.value.cmp(other.value);
    }

    public String asJavaString() {
        return this.toString();
    }

    public RubyString newString(CharSequence s) {
        return new RubyString(this.getRuntime(), this.getType(), s);
    }

    public RubyString newString(ByteList s) {
        return new RubyString(this.getRuntime(), this.getMetaClass(), s);
    }

    public static RubyString newString(Ruby runtime, CharSequence str) {
        return new RubyString(runtime, runtime.getString(), str);
    }

    public static RubyString newEmptyString(Ruby runtime) {
        return RubyString.newEmptyString(runtime, runtime.getString());
    }

    public static RubyString newEmptyString(Ruby runtime, RubyClass metaClass) {
        RubyString empty = new RubyString(runtime, metaClass, ByteList.EMPTY_BYTELIST);
        empty.shareLevel = 2;
        return empty;
    }

    public static RubyString newUnicodeString(Ruby runtime, String str) {
        try {
            return new RubyString(runtime, runtime.getString(), new ByteList(str.getBytes("UTF8"), false));
        }
        catch (UnsupportedEncodingException uee) {
            return new RubyString(runtime, runtime.getString(), str);
        }
    }

    public static RubyString newString(Ruby runtime, RubyClass clazz, CharSequence str) {
        return new RubyString(runtime, clazz, str);
    }

    public static RubyString newString(Ruby runtime, byte[] bytes) {
        return new RubyString(runtime, runtime.getString(), bytes);
    }

    public static RubyString newString(Ruby runtime, ByteList bytes) {
        return new RubyString(runtime, runtime.getString(), bytes);
    }

    public static RubyString newStringLight(Ruby runtime, ByteList bytes) {
        return new RubyString(runtime, runtime.getString(), bytes, false);
    }

    public static RubyString newStringShared(Ruby runtime, RubyString orig) {
        orig.shareLevel = 2;
        RubyString str = new RubyString(runtime, runtime.getString(), orig.value);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newStringShared(Ruby runtime, ByteList bytes) {
        return RubyString.newStringShared(runtime, runtime.getString(), bytes);
    }

    public static RubyString newStringShared(Ruby runtime, RubyClass clazz, ByteList bytes) {
        RubyString str = new RubyString(runtime, clazz, bytes);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newString(Ruby runtime, byte[] bytes, int start, int length) {
        byte[] bytes2 = new byte[length];
        System.arraycopy(bytes, start, bytes2, 0, length);
        return new RubyString(runtime, runtime.getString(), new ByteList(bytes2, false));
    }

    public IRubyObject doClone() {
        return RubyString.newString(this.getRuntime(), this.value.dup());
    }

    public RubyString cat(byte[] str) {
        this.modify(this.value.realSize + str.length);
        System.arraycopy(str, 0, this.value.bytes, this.value.begin + this.value.realSize, str.length);
        this.value.realSize += str.length;
        return this;
    }

    public RubyString cat(byte[] str, int beg, int len) {
        this.modify(this.value.realSize + len);
        System.arraycopy(str, beg, this.value.bytes, this.value.begin + this.value.realSize, len);
        this.value.realSize += len;
        return this;
    }

    public RubyString cat(ByteList str) {
        this.modify(this.value.realSize + str.realSize);
        System.arraycopy(str.bytes, str.begin, this.value.bytes, this.value.begin + this.value.realSize, str.realSize);
        this.value.realSize += str.realSize;
        return this;
    }

    public RubyString cat(byte ch) {
        this.modify(this.value.realSize + 1);
        this.value.bytes[this.value.begin + this.value.realSize] = ch;
        ++this.value.realSize;
        return this;
    }

    @JRubyMethod(name={"replace", "initialize_copy"}, required=1)
    public RubyString replace(IRubyObject other) {
        if (this == other) {
            return this;
        }
        this.modifyCheck();
        RubyString otherStr = RubyString.stringValue(other);
        this.shareLevel = 2;
        otherStr.shareLevel = 2;
        this.value = otherStr.value;
        this.infectBy(other);
        return this;
    }

    @JRubyMethod(name={"reverse"})
    public RubyString reverse() {
        if (this.value.length() <= 1) {
            return this.strDup();
        }
        ByteList buf = new ByteList(this.value.length() + 2);
        buf.realSize = this.value.length();
        int src = this.value.length() - 1;
        int dst = 0;
        while (src >= 0) {
            buf.set(dst++, this.value.get(src--));
        }
        RubyString rev = new RubyString(this.getRuntime(), this.getMetaClass(), buf);
        rev.infectBy(this);
        return rev;
    }

    @JRubyMethod(name={"reverse!"})
    public RubyString reverse_bang() {
        if (this.value.length() > 1) {
            this.modify();
            for (int i = 0; i < this.value.length() / 2; ++i) {
                byte b = (byte)this.value.get(i);
                this.value.set(i, this.value.get(this.value.length() - i - 1));
                this.value.set(this.value.length() - i - 1, b);
            }
        }
        return this;
    }

    public static RubyString newInstance(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyString newString = RubyString.newStringShared(recv.getRuntime(), ByteList.EMPTY_BYTELIST);
        newString.setMetaClass((RubyClass)recv);
        newString.callInit(args, block);
        return newString;
    }

    public IRubyObject initialize(IRubyObject[] args, Block unusedBlock) {
        switch (args.length) {
            case 0: {
                return this;
            }
            case 1: {
                return this.initialize(args[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args.length, 0, 1);
        return null;
    }

    @JRubyMethod(frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize() {
        return this;
    }

    @JRubyMethod(frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject arg0) {
        this.replace(arg0);
        return this;
    }

    @JRubyMethod
    public IRubyObject casecmp(IRubyObject other) {
        int compare = this.value.caseInsensitiveCmp(RubyString.stringValue((IRubyObject)other).value);
        return RubyFixnum.newFixnum(this.getRuntime(), compare);
    }

    @JRubyMethod(name={"=~"})
    public IRubyObject op_match(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyRegexp) {
            return ((RubyRegexp)other).op_match(context, this);
        }
        if (other instanceof RubyString) {
            throw this.getRuntime().newTypeError("type mismatch: String given");
        }
        return other.callMethod(context, "=~", this);
    }

    @JRubyMethod(name={"~"})
    public IRubyObject op_match2(ThreadContext context) {
        return RubyRegexp.newRegexp(this.getRuntime(), this.value, 0, false).op_match2(context);
    }

    @JRubyMethod
    public IRubyObject match(ThreadContext context, IRubyObject pattern) {
        return this.getPattern(pattern, false).callMethod(context, "match", this);
    }

    @JRubyMethod
    public IRubyObject capitalize() {
        RubyString str = this.strDup();
        str.capitalize_bang();
        return str;
    }

    @JRubyMethod(name={"capitalize!"})
    public IRubyObject capitalize_bang() {
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return this.getRuntime().getNil();
        }
        this.modify();
        int s = this.value.begin;
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        boolean modify = false;
        int c = buf[s] & 0xFF;
        if (ASCII.isLower(c)) {
            buf[s] = (byte)ASCIIEncoding.asciiToUpper(c);
            modify = true;
        }
        while (++s < send) {
            c = (char)(buf[s] & 0xFF);
            if (!ASCII.isUpper(c)) continue;
            buf[s] = (byte)ASCIIEncoding.asciiToLower(c);
            modify = true;
        }
        if (modify) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={">="})
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return this.getRuntime().newBoolean(this.op_cmp((RubyString)other) >= 0);
        }
        return RubyComparable.op_ge(context, this, other);
    }

    @JRubyMethod(name={">"})
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return this.getRuntime().newBoolean(this.op_cmp((RubyString)other) > 0);
        }
        return RubyComparable.op_gt(context, this, other);
    }

    @JRubyMethod(name={"<="})
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return this.getRuntime().newBoolean(this.op_cmp((RubyString)other) <= 0);
        }
        return RubyComparable.op_le(context, this, other);
    }

    @JRubyMethod(name={"<"})
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return this.getRuntime().newBoolean(this.op_cmp((RubyString)other) < 0);
        }
        return RubyComparable.op_lt(context, this, other);
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject str_eql_p(IRubyObject other) {
        if (!(other instanceof RubyString)) {
            return this.getRuntime().getFalse();
        }
        RubyString otherString = (RubyString)other;
        return this.value.equal(otherString.value) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod
    public RubyString upcase() {
        RubyString str = this.strDup();
        str.upcase_bang();
        return str;
    }

    @JRubyMethod(name={"upcase!"})
    public IRubyObject upcase_bang() {
        int s;
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return this.getRuntime().getNil();
        }
        this.modify();
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        boolean modify = false;
        for (s = this.value.begin; s < send; ++s) {
            int c = buf[s] & 0xFF;
            if (!ASCII.isLower(c)) continue;
            buf[s] = (byte)ASCIIEncoding.asciiToUpper(c);
            modify = true;
        }
        if (modify) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public RubyString downcase() {
        RubyString str = this.strDup();
        str.downcase_bang();
        return str;
    }

    @JRubyMethod(name={"downcase!"})
    public IRubyObject downcase_bang() {
        int s;
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return this.getRuntime().getNil();
        }
        this.modify();
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        boolean modify = false;
        for (s = this.value.begin; s < send; ++s) {
            int c = buf[s] & 0xFF;
            if (!ASCII.isUpper(c)) continue;
            buf[s] = (byte)ASCIIEncoding.asciiToLower(c);
            modify = true;
        }
        if (modify) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public RubyString swapcase() {
        RubyString str = this.strDup();
        str.swapcase_bang();
        return str;
    }

    @JRubyMethod(name={"swapcase!"})
    public IRubyObject swapcase_bang() {
        int s;
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return this.getRuntime().getNil();
        }
        this.modify();
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        boolean modify = false;
        for (s = this.value.begin; s < send; ++s) {
            int c = buf[s] & 0xFF;
            if (ASCII.isUpper(c)) {
                buf[s] = (byte)ASCIIEncoding.asciiToLower(c);
                modify = true;
                continue;
            }
            if (!ASCII.isLower(c)) continue;
            buf[s] = (byte)ASCIIEncoding.asciiToUpper(c);
            modify = true;
        }
        if (modify) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject dump() {
        RubyString s = new RubyString(this.getRuntime(), this.getMetaClass(), this.inspectIntoByteList(true));
        s.infectBy(this);
        return s;
    }

    @JRubyMethod
    public IRubyObject insert(IRubyObject indexArg, IRubyObject stringArg) {
        RubyString s = stringArg.convertToString();
        ByteList insert = s.value;
        int index = (int)indexArg.convertToInteger().getLongValue();
        if (index < 0) {
            index += this.value.length() + 1;
        }
        if (index < 0 || index > this.value.length()) {
            throw this.getRuntime().newIndexError("index " + index + " out of range");
        }
        this.modify();
        this.value.unsafeReplace(index, 0, insert);
        this.infectBy(s);
        return this;
    }

    @JRubyMethod
    public IRubyObject inspect() {
        RubyString s = this.getRuntime().newString(this.inspectIntoByteList(false));
        s.infectBy(this);
        return s;
    }

    private ByteList inspectIntoByteList(boolean ignoreKCode) {
        Ruby runtime = this.getRuntime();
        Encoding enc = runtime.getKCode().getEncoding();
        int length = this.value.length();
        ByteList sb = new ByteList(length + 2 + length / 100);
        sb.append(34);
        for (int i = 0; i < length; ++i) {
            int seqLength;
            int c = this.value.get(i) & 0xFF;
            if (!ignoreKCode && (seqLength = enc.length((byte)c)) > 1 && i + seqLength - 1 < length) {
                sb.append(this.value, i, seqLength);
                i += seqLength - 1;
                continue;
            }
            if (RubyString.isAlnum(c)) {
                sb.append((char)c);
                continue;
            }
            if (c == 34 || c == 92) {
                sb.append(92).append((char)c);
                continue;
            }
            if (c == 35 && this.isEVStr(i, length)) {
                sb.append(92).append((char)c);
                continue;
            }
            if (RubyString.isPrint(c)) {
                sb.append((char)c);
                continue;
            }
            if (c == 10) {
                sb.append(92).append(110);
                continue;
            }
            if (c == 13) {
                sb.append(92).append(114);
                continue;
            }
            if (c == 9) {
                sb.append(92).append(116);
                continue;
            }
            if (c == 12) {
                sb.append(92).append(102);
                continue;
            }
            if (c == 11) {
                sb.append(92).append(118);
                continue;
            }
            if (c == 7) {
                sb.append(92).append(97);
                continue;
            }
            if (c == 8) {
                sb.append(92).append(98);
                continue;
            }
            if (c == 27) {
                sb.append(92).append(101);
                continue;
            }
            sb.append(ByteList.plain(Sprintf.sprintf(runtime, (CharSequence)"\\%03o", c)));
        }
        sb.append(34);
        return sb;
    }

    private boolean isEVStr(int i, int length) {
        if (i + 1 >= length) {
            return false;
        }
        int c = this.value.get(i + 1) & 0xFF;
        return c == 36 || c == 64 || c == 123;
    }

    @JRubyMethod(name={"length", "size"})
    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.value.length());
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p() {
        return this.isEmpty() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public boolean isEmpty() {
        return this.value.length() == 0;
    }

    public RubyString append(IRubyObject other) {
        this.infectBy(other);
        return this.cat(RubyString.stringValue((IRubyObject)other).value);
    }

    @JRubyMethod(name={"concat", "<<"})
    public RubyString concat(IRubyObject other) {
        long value;
        if (other instanceof RubyFixnum && (value = ((RubyFixnum)other).getLongValue()) >= 0L && value < 256L) {
            return this.cat((byte)value);
        }
        return this.append(other);
    }

    @JRubyMethod(name={"crypt"})
    public RubyString crypt(IRubyObject other) {
        ByteList salt = RubyString.stringValue(other).getByteList();
        if (salt.realSize < 2) {
            throw this.getRuntime().newArgumentError("salt too short(need >=2 bytes)");
        }
        salt = salt.makeShared(0, 2);
        RubyString s = RubyString.newStringShared(this.getRuntime(), JavaCrypt.crypt(salt, this.getByteList()));
        s.infectBy(this);
        s.infectBy(other);
        return s;
    }

    public static RubyString stringValue(IRubyObject object) {
        return (RubyString)(object instanceof RubyString ? object : object.convertToString());
    }

    public IRubyObject sub(ThreadContext context, IRubyObject[] args, Block block) {
        RubyString str = this.strDup();
        str.sub_bang(context, args, block);
        return str;
    }

    @JRubyMethod(name={"sub"}, frame=true)
    public IRubyObject sub(ThreadContext context, IRubyObject arg0, Block block) {
        RubyString str = this.strDup();
        str.sub_bang(context, arg0, block);
        return str;
    }

    @JRubyMethod(name={"sub"}, frame=true)
    public IRubyObject sub(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyString str = this.strDup();
        str.sub_bang(context, arg0, arg1, block);
        return str;
    }

    public IRubyObject sub_bang(ThreadContext context, IRubyObject[] args, Block block) {
        switch (args.length) {
            case 1: {
                return this.sub_bang(context, args[0], block);
            }
            case 2: {
                return this.sub_bang(context, args[0], args[1], block);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"sub!"}, frame=true)
    public IRubyObject sub_bang(ThreadContext context, IRubyObject arg0, Block block) {
        RubyString repl = null;
        boolean tainted = false;
        if (!block.isGiven()) {
            throw this.getRuntime().newArgumentError("wrong number of arguments (1 for 2)");
        }
        boolean iter = true;
        tainted = false;
        RubyRegexp rubyRegex = this.getPattern(arg0, true);
        Regex regex = rubyRegex.getPattern();
        return this.subBangCommon(regex, context, iter, rubyRegex, block, repl, tainted);
    }

    @JRubyMethod(name={"sub!"}, frame=true)
    public IRubyObject sub_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyString repl = null;
        boolean tainted = false;
        repl = arg1.convertToString();
        boolean iter = false;
        if (repl.isTaint()) {
            tainted = true;
        }
        RubyRegexp rubyRegex = this.getPattern(arg0, true);
        Regex regex = rubyRegex.getPattern();
        return this.subBangCommon(regex, context, iter, rubyRegex, block, repl, tainted);
    }

    private IRubyObject subBangCommon(Regex regex, ThreadContext context, boolean iter, RubyRegexp rubyRegex, Block block, RubyString repl, boolean tainted) {
        int range = this.value.begin + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, this.value.begin, range);
        Frame frame = context.getPreviousFrame();
        if (matcher.search(this.value.begin, range, 0) >= 0) {
            int plen;
            int beg;
            if (iter) {
                byte[] bytes = this.value.bytes;
                int size = this.value.realSize;
                RubyMatchData match = rubyRegex.updateBackRef(this, frame, matcher);
                match.use();
                if (regex.numberOfCaptures() == 0) {
                    repl = RubyString.objAsString(context, block.yield(context, this.substr(matcher.getBegin(), matcher.getEnd() - matcher.getBegin())));
                } else {
                    Region region = matcher.getRegion();
                    repl = RubyString.objAsString(context, block.yield(context, this.substr(region.beg[0], region.end[0] - region.beg[0])));
                }
                this.modifyCheck(bytes, size);
                this.frozenCheck();
                frame.setBackRef(match);
            } else {
                repl = rubyRegex.regsub(repl, this, matcher);
                rubyRegex.updateBackRef(this, frame, matcher);
            }
            if (regex.numberOfCaptures() == 0) {
                beg = matcher.getBegin();
                plen = matcher.getEnd() - beg;
            } else {
                Region region = matcher.getRegion();
                beg = region.beg[0];
                plen = region.end[0] - beg;
            }
            ByteList replValue = repl.value;
            if (replValue.realSize > plen) {
                this.modify(this.value.realSize + replValue.realSize - plen);
            } else {
                this.modify();
            }
            if (repl.isTaint()) {
                tainted = true;
            }
            if (replValue.realSize != plen) {
                int src = this.value.begin + beg + plen;
                int dst = this.value.begin + beg + replValue.realSize;
                int length = this.value.realSize - beg - plen;
                System.arraycopy(this.value.bytes, src, this.value.bytes, dst, length);
            }
            System.arraycopy(replValue.bytes, replValue.begin, this.value.bytes, this.value.begin + beg, replValue.realSize);
            this.value.realSize += replValue.realSize - plen;
            if (tainted) {
                this.setTaint(true);
            }
            return this;
        }
        frame.setBackRef(this.getRuntime().getNil());
        return this.getRuntime().getNil();
    }

    public IRubyObject gsub(ThreadContext context, IRubyObject[] args, Block block) {
        switch (args.length) {
            case 1: {
                return this.gsub(context, args[0], block);
            }
            case 2: {
                return this.gsub(context, args[0], args[1], block);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"gsub"}, frame=true)
    public IRubyObject gsub(ThreadContext context, IRubyObject arg0, Block block) {
        return this.gsub(context, arg0, block, false);
    }

    @JRubyMethod(name={"gsub"}, frame=true)
    public IRubyObject gsub(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.gsub(context, arg0, arg1, block, false);
    }

    public IRubyObject gsub_bang(ThreadContext context, IRubyObject[] args, Block block) {
        switch (args.length) {
            case 1: {
                return this.gsub_bang(context, args[0], block);
            }
            case 2: {
                return this.gsub_bang(context, args[0], args[1], block);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"gsub!"}, frame=true)
    public IRubyObject gsub_bang(ThreadContext context, IRubyObject arg0, Block block) {
        return this.gsub(context, arg0, block, true);
    }

    @JRubyMethod(name={"gsub!"}, frame=true)
    public IRubyObject gsub_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.gsub(context, arg0, arg1, block, true);
    }

    private final IRubyObject gsub(ThreadContext context, IRubyObject arg0, Block block, boolean bang) {
        boolean tainted = false;
        if (!block.isGiven()) {
            throw this.getRuntime().newArgumentError("wrong number of arguments (1 for 2)");
        }
        boolean iter = true;
        IRubyObject repl = null;
        RubyRegexp rubyRegex = this.getPattern(arg0, true);
        Regex regex = rubyRegex.getPattern();
        return this.gsubCommon(regex, context, bang, iter, rubyRegex, block, repl, tainted);
    }

    private final IRubyObject gsub(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block, boolean bang) {
        boolean tainted = false;
        boolean iter = false;
        RubyString repl = arg1.convertToString();
        if (repl.isTaint()) {
            tainted = true;
        }
        RubyRegexp rubyRegex = this.getPattern(arg0, true);
        Regex regex = rubyRegex.getPattern();
        return this.gsubCommon(regex, context, bang, iter, rubyRegex, block, repl, tainted);
    }

    private IRubyObject gsubCommon(Regex regex, ThreadContext context, boolean bang, boolean iter, RubyRegexp rubyRegex, Block block, IRubyObject repl, boolean tainted) {
        int begin = this.value.begin;
        int range = begin + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, begin, range);
        int beg = matcher.search(begin, range, 0);
        Frame frame = context.getPreviousFrame();
        if (beg < 0) {
            frame.setBackRef(this.getRuntime().getNil());
            return bang ? this.getRuntime().getNil() : this.strDup();
        }
        int blen = this.value.realSize + 30;
        ByteList dest = new ByteList(blen);
        dest.realSize = blen;
        int buf = 0;
        int bp = 0;
        int cp = this.value.begin;
        int offset = 0;
        RubyMatchData match = null;
        while (beg >= 0) {
            RubyString val;
            int endz;
            int begz;
            if (iter) {
                byte[] bytes = this.value.bytes;
                int size = this.value.realSize;
                match = rubyRegex.updateBackRef(this, frame, matcher);
                match.use();
                if (regex.numberOfCaptures() == 0) {
                    begz = matcher.getBegin();
                    endz = matcher.getEnd();
                    val = RubyString.objAsString(context, block.yield(context, this.substr(begz, endz - begz)));
                } else {
                    Region region = matcher.getRegion();
                    begz = region.beg[0];
                    endz = region.end[0];
                    val = RubyString.objAsString(context, block.yield(context, this.substr(begz, endz - begz)));
                }
                this.modifyCheck(bytes, size);
                if (bang) {
                    this.frozenCheck();
                }
            } else {
                val = rubyRegex.regsub((RubyString)repl, this, matcher);
                if (regex.numberOfCaptures() == 0) {
                    begz = matcher.getBegin();
                    endz = matcher.getEnd();
                } else {
                    Region region = matcher.getRegion();
                    begz = region.beg[0];
                    endz = region.end[0];
                }
            }
            if (val.isTaint()) {
                tainted = true;
            }
            ByteList vbuf = val.value;
            int len = bp - buf + (beg - offset) + vbuf.realSize + 3;
            if (blen < len) {
                while (blen < len) {
                    blen <<= 1;
                }
                len = bp - buf;
                dest.realloc(blen);
                dest.realSize = blen;
                bp = buf + len;
            }
            len = beg - offset;
            System.arraycopy(this.value.bytes, cp, dest.bytes, bp, len);
            System.arraycopy(vbuf.bytes, vbuf.begin, dest.bytes, bp += len, vbuf.realSize);
            bp += vbuf.realSize;
            offset = endz;
            if (begz == endz) {
                if (this.value.realSize <= endz) break;
                len = regex.getEncoding().length(this.value.bytes[begin + endz]);
                System.arraycopy(this.value.bytes, begin + endz, dest.bytes, bp, len);
                bp += len;
                offset = endz + len;
            }
            cp = begin + offset;
            if (offset > this.value.realSize) break;
            beg = matcher.search(cp, range, 0);
        }
        if (this.value.realSize > offset) {
            int len = bp - buf;
            if (blen - len < this.value.realSize - offset) {
                blen = len + this.value.realSize - offset;
                dest.realloc(blen);
                bp = buf + len;
            }
            System.arraycopy(this.value.bytes, cp, dest.bytes, bp, this.value.realSize - offset);
            bp += this.value.realSize - offset;
        }
        if (match != null) {
            frame.setBackRef(match);
        } else {
            rubyRegex.updateBackRef(this, frame, matcher);
        }
        dest.realSize = bp - buf;
        if (bang) {
            this.view(dest);
            if (tainted) {
                this.setTaint(true);
            }
            return this;
        }
        RubyString destStr = new RubyString(this.getRuntime(), this.getMetaClass(), dest);
        destStr.infectBy(this);
        if (tainted) {
            destStr.setTaint(true);
        }
        return destStr;
    }

    public IRubyObject index(ThreadContext context, IRubyObject[] args) {
        switch (args.length) {
            case 1: {
                return this.index(context, args[0]);
            }
            case 2: {
                return this.index(context, args[0], args[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args.length, 1, 2);
        return null;
    }

    @JRubyMethod
    public IRubyObject index(ThreadContext context, IRubyObject arg0) {
        int pos = 0;
        IRubyObject sub = arg0;
        return this.indexCommon(pos, sub, context);
    }

    @JRubyMethod
    public IRubyObject index(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int pos = RubyNumeric.num2int(arg1);
        IRubyObject sub = arg0;
        return this.indexCommon(pos, sub, context);
    }

    private IRubyObject indexCommon(int pos, IRubyObject sub, ThreadContext context) throws RaiseException {
        if (pos < 0 && (pos += this.value.realSize) < 0) {
            if (sub instanceof RubyRegexp) {
                context.getPreviousFrame().setBackRef(this.getRuntime().getNil());
            }
            return this.getRuntime().getNil();
        }
        if (sub instanceof RubyRegexp) {
            RubyRegexp regSub = (RubyRegexp)sub;
            pos = regSub.adjustStartPos(this, pos, false);
            pos = regSub.search(context, this, pos, false);
        } else {
            if (sub instanceof RubyFixnum) {
                int c_int = RubyNumeric.fix2int(sub);
                if (c_int < 0 || c_int > 255) {
                    return this.getRuntime().getNil();
                }
                byte c = (byte)c_int;
                byte[] bytes = this.value.bytes;
                int end = this.value.begin + this.value.realSize;
                pos += this.value.begin;
                while (pos < end) {
                    if (bytes[pos] == c) {
                        return RubyFixnum.newFixnum(this.getRuntime(), pos - this.value.begin);
                    }
                    ++pos;
                }
                return this.getRuntime().getNil();
            }
            if (sub instanceof RubyString) {
                pos = this.strIndex((RubyString)sub, pos);
            } else {
                IRubyObject tmp = sub.checkStringType();
                if (tmp.isNil()) {
                    throw this.getRuntime().newTypeError("type mismatch: " + sub.getMetaClass().getName() + " given");
                }
                pos = this.strIndex((RubyString)tmp, pos);
            }
        }
        return pos == -1 ? this.getRuntime().getNil() : RubyFixnum.newFixnum(this.getRuntime(), pos);
    }

    private int strIndex(RubyString sub, int offset) {
        if (offset < 0 && (offset += this.value.realSize) < 0) {
            return -1;
        }
        if (this.value.realSize - offset < sub.value.realSize) {
            return -1;
        }
        if (sub.value.realSize == 0) {
            return offset;
        }
        return this.value.indexOf(sub.value, offset);
    }

    public IRubyObject rindex(ThreadContext context, IRubyObject[] args) {
        switch (args.length) {
            case 1: {
                return this.rindex(context, args[0]);
            }
            case 2: {
                return this.rindex(context, args[0], args[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args.length, 1, 2);
        return null;
    }

    @JRubyMethod
    public IRubyObject rindex(ThreadContext context, IRubyObject arg0) {
        IRubyObject sub = arg0;
        int pos = this.value.realSize;
        return this.rindexCommon(sub, pos, context);
    }

    @JRubyMethod
    public IRubyObject rindex(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject sub = arg0;
        int pos = RubyNumeric.num2int(arg1);
        if (pos < 0 && (pos += this.value.realSize) < 0) {
            if (sub instanceof RubyRegexp) {
                context.getPreviousFrame().setBackRef(this.getRuntime().getNil());
            }
            return this.getRuntime().getNil();
        }
        if (pos > this.value.realSize) {
            pos = this.value.realSize;
        }
        return this.rindexCommon(sub, pos, context);
    }

    private IRubyObject rindexCommon(IRubyObject sub, int pos, ThreadContext context) throws RaiseException {
        if (sub instanceof RubyRegexp) {
            RubyRegexp regSub = (RubyRegexp)sub;
            if (regSub.length() > 0) {
                pos = regSub.adjustStartPos(this, pos, true);
                pos = regSub.search(context, this, pos, true);
            }
            if (pos >= 0) {
                return RubyFixnum.newFixnum(this.getRuntime(), pos);
            }
        } else if (sub instanceof RubyString) {
            if ((pos = this.strRindex((RubyString)sub, pos)) >= 0) {
                return RubyFixnum.newFixnum(this.getRuntime(), pos);
            }
        } else {
            if (sub instanceof RubyFixnum) {
                int c_int = RubyNumeric.fix2int(sub);
                if (c_int < 0 || c_int > 255) {
                    return this.getRuntime().getNil();
                }
                byte c = (byte)c_int;
                byte[] bytes = this.value.bytes;
                int pbeg = this.value.begin;
                int p = pbeg + pos;
                if (pos == this.value.realSize) {
                    if (pos == 0) {
                        return this.getRuntime().getNil();
                    }
                    --p;
                }
                while (pbeg <= p) {
                    if (bytes[p] == c) {
                        return RubyFixnum.newFixnum(this.getRuntime(), p - this.value.begin);
                    }
                    --p;
                }
                return this.getRuntime().getNil();
            }
            throw this.getRuntime().newTypeError("type mismatch: " + sub.getMetaClass().getName() + " given");
        }
        return this.getRuntime().getNil();
    }

    private int strRindex(RubyString sub, int pos) {
        int subLength = sub.value.realSize;
        if (this.value.realSize < subLength) {
            return -1;
        }
        if (this.value.realSize - pos < subLength) {
            pos = this.value.realSize - subLength;
        }
        return this.value.lastIndexOf(sub.value, pos);
    }

    public IRubyObject substr(int beg, int len) {
        int length = this.value.length();
        if (len < 0 || beg > length) {
            return this.getRuntime().getNil();
        }
        if (beg < 0 && (beg += length) < 0) {
            return this.getRuntime().getNil();
        }
        int end = Math.min(length, beg + len);
        return this.makeShared(beg, end - beg);
    }

    public IRubyObject replace(int beg, int len, RubyString replaceWith) {
        if (beg + len >= this.value.length()) {
            len = this.value.length() - beg;
        }
        this.modify();
        this.value.unsafeReplace(beg, len, replaceWith.value);
        return this.infectBy(replaceWith);
    }

    public IRubyObject op_aref(ThreadContext context, IRubyObject[] args) {
        switch (args.length) {
            case 1: {
                return this.op_aref(context, args[0]);
            }
            case 2: {
                return this.op_aref(context, args[0], args[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        if (arg1 instanceof RubyRegexp) {
            if (((RubyRegexp)arg1).search(context, this, 0, false) >= 0) {
                return RubyRegexp.nth_match(RubyNumeric.fix2int(arg2), context.getCurrentFrame().getBackRef());
            }
            return this.getRuntime().getNil();
        }
        return this.substr(RubyNumeric.fix2int(arg1), RubyNumeric.fix2int(arg2));
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject arg) {
        if (arg instanceof RubyRegexp) {
            if (((RubyRegexp)arg).search(context, this, 0, false) >= 0) {
                return RubyRegexp.nth_match(0, context.getCurrentFrame().getBackRef());
            }
            return this.getRuntime().getNil();
        }
        if (arg instanceof RubyString) {
            return this.value.indexOf(RubyString.stringValue((IRubyObject)arg).value) != -1 ? arg : this.getRuntime().getNil();
        }
        if (arg instanceof RubyRange) {
            long[] begLen = ((RubyRange)arg).begLen(this.value.length(), 0);
            return begLen == null ? this.getRuntime().getNil() : this.substr((int)begLen[0], (int)begLen[1]);
        }
        int idx = (int)arg.convertToInteger().getLongValue();
        if (idx < 0) {
            idx += this.value.length();
        }
        if (idx < 0 || idx >= this.value.length()) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.value.get(idx) & 0xFF);
    }

    private void subpatSet(ThreadContext context, RubyRegexp regexp, int nth, IRubyObject repl) {
        int end;
        int start;
        if (regexp.search(context, this, 0, false) < 0) {
            throw this.getRuntime().newIndexError("regexp not matched");
        }
        RubyMatchData match = (RubyMatchData)context.getCurrentFrame().getBackRef();
        if (match.regs == null) {
            if (nth >= 1) {
                throw this.getRuntime().newIndexError("index " + nth + " out of regexp");
            }
            if (nth < 0) {
                if (-nth >= 1) {
                    throw this.getRuntime().newIndexError("index " + nth + " out of regexp");
                }
                ++nth;
            }
            if ((start = match.begin) == -1) {
                throw this.getRuntime().newIndexError("regexp group " + nth + " not matched");
            }
            end = match.end;
        } else {
            if (nth >= match.regs.numRegs) {
                throw this.getRuntime().newIndexError("index " + nth + " out of regexp");
            }
            if (nth < 0) {
                if (-nth >= match.regs.numRegs) {
                    throw this.getRuntime().newIndexError("index " + nth + " out of regexp");
                }
                nth += match.regs.numRegs;
            }
            if ((start = match.regs.beg[nth]) == -1) {
                throw this.getRuntime().newIndexError("regexp group " + nth + " not matched");
            }
            end = match.regs.end[nth];
        }
        int len = end - start;
        this.replace(start, len, RubyString.stringValue(repl));
    }

    public IRubyObject op_aset(ThreadContext context, IRubyObject[] args) {
        switch (args.length) {
            case 2: {
                return this.op_aset(context, args[0], args[1]);
            }
            case 3: {
                return this.op_aset(context, args[0], args[1], args[2]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args.length, 2, 3);
        return null;
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject op_aset(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int strLen = this.value.length();
        if (arg0 instanceof RubyFixnum || arg0.respondsTo("to_int")) {
            int idx = RubyNumeric.fix2int(arg0);
            if (idx < 0) {
                idx += this.value.length();
            }
            if (idx < 0 || idx >= this.value.length()) {
                throw this.getRuntime().newIndexError("string index out of bounds");
            }
            if (arg1 instanceof RubyFixnum) {
                this.modify();
                this.value.set(idx, (byte)RubyNumeric.fix2int(arg1));
            } else {
                this.replace(idx, 1, RubyString.stringValue(arg1));
            }
            return arg1;
        }
        if (arg0 instanceof RubyRegexp) {
            RubyString repl = RubyString.stringValue(arg1);
            this.subpatSet(context, (RubyRegexp)arg0, 0, repl);
            return repl;
        }
        if (arg0 instanceof RubyString) {
            RubyString orig = RubyString.stringValue(arg0);
            int beg = this.value.indexOf(orig.value);
            if (beg < 0) {
                throw this.getRuntime().newIndexError("string not matched");
            }
            this.replace(beg, orig.value.length(), RubyString.stringValue(arg1));
            return arg1;
        }
        if (arg0 instanceof RubyRange) {
            long[] begLen = ((RubyRange)arg0).begLen(this.value.realSize, 2);
            this.replace((int)begLen[0], (int)begLen[1], RubyString.stringValue(arg1));
            return arg1;
        }
        throw this.getRuntime().newTypeError("wrong argument type");
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject op_aset(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        int strLen = this.value.length();
        if (arg0 instanceof RubyRegexp) {
            RubyString repl = RubyString.stringValue(arg2);
            int nth = RubyNumeric.fix2int(arg1);
            this.subpatSet(context, (RubyRegexp)arg0, nth, repl);
            return repl;
        }
        RubyString repl = RubyString.stringValue(arg2);
        int beg = RubyNumeric.fix2int(arg0);
        int len = RubyNumeric.fix2int(arg1);
        if (len < 0) {
            throw this.getRuntime().newIndexError("negative length");
        }
        if (beg < 0) {
            beg += strLen;
        }
        if (beg < 0 || beg > 0 && beg > strLen) {
            throw this.getRuntime().newIndexError("string index out of bounds");
        }
        if (beg + len > strLen) {
            len = strLen - beg;
        }
        this.replace(beg, len, repl);
        return repl;
    }

    public IRubyObject slice_bang(ThreadContext context, IRubyObject[] args) {
        switch (args.length) {
            case 1: {
                return this.slice_bang(context, args[0]);
            }
            case 2: {
                return this.slice_bang(context, args[0], args[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"slice!"})
    public IRubyObject slice_bang(ThreadContext context, IRubyObject arg0) {
        IRubyObject result = this.op_aref(context, arg0);
        if (result.isNil()) {
            return result;
        }
        this.op_aset(context, arg0, this.newString(""));
        return result;
    }

    @JRubyMethod(name={"slice!"})
    public IRubyObject slice_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject result = this.op_aref(context, arg0, arg1);
        if (result.isNil()) {
            return result;
        }
        this.op_aset(context, arg0, arg1, this.newString(""));
        return result;
    }

    @JRubyMethod(name={"succ", "next"})
    public IRubyObject succ() {
        return this.strDup().succ_bang();
    }

    @JRubyMethod(name={"succ!", "next!"})
    public IRubyObject succ_bang() {
        int i;
        if (this.value.length() == 0) {
            this.modifyCheck();
            return this;
        }
        this.modify();
        boolean alnumSeen = false;
        int pos = -1;
        int c = 0;
        int n = 0;
        for (i = this.value.length() - 1; i >= 0; --i) {
            c = this.value.get(i) & 0xFF;
            if (!RubyString.isAlnum(c)) continue;
            alnumSeen = true;
            if (RubyString.isDigit(c) && c < 57 || RubyString.isLower(c) && c < 122 || RubyString.isUpper(c) && c < 90) {
                this.value.set(i, (byte)(c + 1));
                pos = -1;
                break;
            }
            pos = i;
            int n2 = RubyString.isDigit(c) ? 49 : (n = RubyString.isLower(c) ? 97 : 65);
            this.value.set(i, (byte)(RubyString.isDigit(c) ? 48 : (RubyString.isLower(c) ? 97 : 65)));
        }
        if (!alnumSeen) {
            for (i = this.value.length() - 1; i >= 0; --i) {
                c = this.value.get(i) & 0xFF;
                if (c < 255) {
                    this.value.set(i, (byte)(c + 1));
                    pos = -1;
                    break;
                }
                pos = i;
                n = 1;
                this.value.set(i, 0);
            }
        }
        if (pos > -1) {
            this.value.insert(pos, (byte)n);
        }
        return this;
    }

    @JRubyMethod(name={"upto"}, required=1, frame=true)
    public IRubyObject upto(ThreadContext context, IRubyObject str, Block block) {
        return this.upto(context, str, false, block);
    }

    public IRubyObject upto(ThreadContext context, IRubyObject str, boolean excl, Block block) {
        RubyString end = str.convertToString();
        int n = this.value.cmp(end.value);
        if (n > 0 || excl && n == 0) {
            return this;
        }
        IRubyObject afterEnd = end.callMethod(context, "succ");
        RubyString current = this;
        while (!current.op_equal(context, afterEnd).isTrue()) {
            block.yield(context, current);
            if (!excl && current.op_equal(context, end).isTrue()) break;
            current = current.callMethod(context, "succ").convertToString();
            if ((!excl || !current.op_equal(context, end).isTrue()) && current.value.realSize <= end.value.realSize && current.value.realSize != 0) continue;
            break;
        }
        return this;
    }

    @JRubyMethod(name={"include?"}, required=1)
    public RubyBoolean include_p(IRubyObject obj) {
        if (obj instanceof RubyFixnum) {
            int c = RubyNumeric.fix2int(obj);
            for (int i = 0; i < this.value.length(); ++i) {
                if (this.value.get(i) != (byte)c) continue;
                return this.getRuntime().getTrue();
            }
            return this.getRuntime().getFalse();
        }
        ByteList str = RubyString.stringValue((IRubyObject)obj).value;
        return this.getRuntime().newBoolean(this.value.indexOf(str) != -1);
    }

    public IRubyObject to_i(IRubyObject[] args) {
        switch (args.length) {
            case 0: {
                return this.to_i();
            }
            case 1: {
                return this.to_i(args[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args.length, 0, 1);
        return null;
    }

    @JRubyMethod(name={"to_i"})
    public IRubyObject to_i() {
        return RubyNumeric.str2inum(this.getRuntime(), this, 10);
    }

    @JRubyMethod(name={"to_i"})
    public IRubyObject to_i(IRubyObject arg0) {
        long base = arg0.convertToInteger().getLongValue();
        return RubyNumeric.str2inum(this.getRuntime(), this, (int)base);
    }

    @JRubyMethod(name={"oct"})
    public IRubyObject oct() {
        int pos;
        int ix;
        if (this.isEmpty()) {
            return this.getRuntime().newFixnum(0L);
        }
        int base = 8;
        for (ix = this.value.begin; ix < this.value.begin + this.value.realSize && ASCII.isSpace(this.value.bytes[ix] & 0xFF); ++ix) {
        }
        int n = pos = this.value.bytes[ix] == 45 || this.value.bytes[ix] == 43 ? ix + 1 : ix;
        if (pos + 1 < this.value.begin + this.value.realSize && this.value.bytes[pos] == 48) {
            if (this.value.bytes[pos + 1] == 120 || this.value.bytes[pos + 1] == 88) {
                base = 16;
            } else if (this.value.bytes[pos + 1] == 98 || this.value.bytes[pos + 1] == 66) {
                base = 2;
            } else if (this.value.bytes[pos + 1] == 100 || this.value.bytes[pos + 1] == 68) {
                base = 10;
            }
        }
        return RubyNumeric.str2inum(this.getRuntime(), this, base);
    }

    @JRubyMethod(name={"hex"})
    public IRubyObject hex() {
        return RubyNumeric.str2inum(this.getRuntime(), this, 16);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        return RubyNumeric.str2fnum(this.getRuntime(), this);
    }

    public RubyArray split(ThreadContext context, IRubyObject[] args) {
        switch (args.length) {
            case 0: {
                return this.split(context);
            }
            case 1: {
                return this.split(context, args[0]);
            }
            case 2: {
                return this.split(context, args[0], args[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args.length, 0, 2);
        return null;
    }

    @JRubyMethod
    public RubyArray split(ThreadContext context) {
        return this.split(context, (IRubyObject)null);
    }

    @JRubyMethod
    public RubyArray split(ThreadContext context, IRubyObject arg0) {
        int i = 0;
        int lim = 0;
        boolean limit = false;
        return this.splitCommon(arg0, limit, lim, i, context);
    }

    @JRubyMethod
    public RubyArray split(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        boolean limit;
        int lim = RubyNumeric.fix2int(arg1);
        if (lim <= 0) {
            limit = false;
        } else {
            if (lim == 1) {
                return this.value.realSize == 0 ? this.getRuntime().newArray() : this.getRuntime().newArray(this);
            }
            limit = true;
        }
        int i = 1;
        return this.splitCommon(arg0, limit, lim, i, context);
    }

    private RubyArray splitCommon(IRubyObject spat, boolean limit, int lim, int i, ThreadContext context) {
        RubyArray result;
        if ((spat == null || spat.isNil()) && (spat = this.getRuntime().getGlobalVariables().get("$;")).isNil()) {
            result = this.awkSplit(limit, lim, i);
        } else if (spat instanceof RubyString && ((RubyString)spat).value.realSize == 1) {
            RubyString strSpat = (RubyString)spat;
            result = strSpat.value.bytes[strSpat.value.begin] == 32 ? this.awkSplit(limit, lim, i) : this.split(context, spat, limit, lim, i);
        } else {
            result = this.split(context, spat, limit, lim, i);
        }
        if (!limit && lim == 0) {
            while (result.size() > 0 && ((RubyString)result.eltInternal((int)(result.size() - 1))).value.realSize == 0) {
                result.pop();
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private RubyArray split(ThreadContext context, IRubyObject pat, boolean limit, int lim, int i) {
        int begin;
        Ruby runtime = this.getRuntime();
        Regex regex = this.getPattern(pat, true).getPattern();
        int start = begin = this.value.begin;
        int beg = 0;
        int range = this.value.begin + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, this.value.begin, range);
        boolean lastNull = false;
        RubyArray result = runtime.newArray();
        if (regex.numberOfCaptures() == 0) {
            int end;
            while ((end = matcher.search(start, range, 0)) >= 0) {
                block17: {
                    if (start == end + begin && matcher.getBegin() == matcher.getEnd()) {
                        if (this.value.realSize == 0) {
                            result.append(RubyString.newEmptyString(runtime, this.getMetaClass()));
                            break;
                        }
                        if (lastNull) {
                            result.append(this.substr(beg, regex.getEncoding().length(this.value.bytes[begin + beg])));
                            beg = start - begin;
                            break block17;
                        } else {
                            start = start == range ? ++start : (start += regex.getEncoding().length(this.value.bytes[start]));
                            lastNull = true;
                            continue;
                        }
                    }
                    result.append(this.substr(beg, end - beg));
                    beg = matcher.getEnd();
                    start = begin + matcher.getEnd();
                }
                lastNull = false;
                if (!limit || lim > ++i) continue;
                break;
            }
        } else {
            int end;
            while ((end = matcher.search(start, range, 0)) >= 0) {
                Region region;
                block18: {
                    region = matcher.getRegion();
                    if (start == end + begin && region.beg[0] == region.end[0]) {
                        if (this.value.realSize == 0) {
                            result.append(RubyString.newEmptyString(runtime, this.getMetaClass()));
                            break;
                        }
                        if (lastNull) {
                            result.append(this.substr(beg, regex.getEncoding().length(this.value.bytes[begin + beg])));
                            beg = start - begin;
                            break block18;
                        } else {
                            start = start == range ? ++start : (start += regex.getEncoding().length(this.value.bytes[start]));
                            lastNull = true;
                            continue;
                        }
                    }
                    result.append(this.substr(beg, end - beg));
                    beg = start = region.end[0];
                    start += begin;
                }
                lastNull = false;
                for (int idx = 1; idx < region.numRegs; ++idx) {
                    if (region.beg[idx] == -1) continue;
                    if (region.beg[idx] == region.end[idx]) {
                        result.append(RubyString.newEmptyString(runtime, this.getMetaClass()));
                        continue;
                    }
                    result.append(this.substr(region.beg[idx], region.end[idx] - region.beg[idx]));
                }
                if (!limit || lim > ++i) continue;
            }
        }
        context.getCurrentFrame().setBackRef(runtime.getNil());
        if (this.value.realSize <= 0) return result;
        if (!limit && this.value.realSize <= beg) {
            if (lim >= 0) return result;
        }
        if (this.value.realSize == beg) {
            result.append(RubyString.newEmptyString(runtime, this.getMetaClass()));
            return result;
        }
        result.append(this.substr(beg, this.value.realSize - beg));
        return result;
    }

    private RubyArray awkSplit(boolean limit, int lim, int i) {
        int p;
        RubyArray result = this.getRuntime().newArray();
        byte[] bytes = this.value.bytes;
        int endp = p + this.value.realSize;
        boolean skip = true;
        int beg = 0;
        beg = 0;
        int end = 0;
        for (p = this.value.begin; p < endp; ++p) {
            if (skip) {
                if (ASCII.isSpace(bytes[p] & 0xFF)) {
                    ++beg;
                    continue;
                }
                end = beg + 1;
                skip = false;
                if (!limit || lim > i) continue;
                break;
            }
            if (ASCII.isSpace(bytes[p] & 0xFF)) {
                result.append(this.makeShared(beg, end - beg));
                skip = true;
                beg = end + 1;
                if (!limit) continue;
                ++i;
                continue;
            }
            ++end;
        }
        if (this.value.realSize > 0 && (limit || this.value.realSize > beg || lim < 0)) {
            if (this.value.realSize == beg) {
                result.append(RubyString.newEmptyString(this.getRuntime(), this.getMetaClass()));
            } else {
                result.append(this.makeShared(beg, this.value.realSize - beg));
            }
        }
        return result;
    }

    private final RubyRegexp getPattern(IRubyObject obj, boolean quote) {
        if (obj instanceof RubyRegexp) {
            return (RubyRegexp)obj;
        }
        if (!(obj instanceof RubyString)) {
            IRubyObject val = obj.checkStringType();
            if (val.isNil()) {
                throw this.getRuntime().newTypeError("wrong argument type " + obj.getMetaClass() + " (expected Regexp)");
            }
            obj = val;
        }
        return RubyRegexp.newRegexp(this.getRuntime(), ((RubyString)obj).value, 0, quote);
    }

    @JRubyMethod(name={"scan"}, required=1, frame=true)
    public IRubyObject scan(ThreadContext context, IRubyObject arg, Block block) {
        Ruby runtime = this.getRuntime();
        Frame frame = context.getPreviousFrame();
        RubyRegexp rubyRegex = this.getPattern(arg, true);
        Regex regex = rubyRegex.getPattern();
        int range = this.value.begin + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, this.value.begin, range);
        matcher.value = 0;
        if (!block.isGiven()) {
            RubyArray ary = runtime.newArray();
            if (regex.numberOfCaptures() == 0) {
                IRubyObject result;
                while ((result = this.scanOnceNG(rubyRegex, matcher, range)) != null) {
                    ary.append(result);
                }
            } else {
                IRubyObject result;
                while ((result = this.scanOnce(rubyRegex, matcher, range)) != null) {
                    ary.append(result);
                }
            }
            if (ary.size() > 0) {
                rubyRegex.updateBackRef(this, frame, matcher);
            } else {
                frame.setBackRef(runtime.getNil());
            }
            return ary;
        }
        byte[] bytes = this.value.bytes;
        int size = this.value.realSize;
        IRubyObject match = null;
        if (regex.numberOfCaptures() == 0) {
            IRubyObject result;
            while ((result = this.scanOnceNG(rubyRegex, matcher, range)) != null) {
                match = rubyRegex.updateBackRef(this, frame, matcher);
                ((RubyMatchData)match).use();
                block.yield(context, result);
                this.modifyCheck(bytes, size);
            }
        } else {
            IRubyObject result;
            while ((result = this.scanOnce(rubyRegex, matcher, range)) != null) {
                match = rubyRegex.updateBackRef(this, frame, matcher);
                ((RubyMatchData)match).use();
                block.yield(context, result);
                this.modifyCheck(bytes, size);
            }
        }
        frame.setBackRef(match == null ? runtime.getNil() : match);
        return this;
    }

    private Encoding encodingCheck(RubyRegexp pattern) {
        return pattern.getKCode().getEncoding();
    }

    private IRubyObject scanOnceNG(RubyRegexp regex, Matcher matcher, int range) {
        if (matcher.search(matcher.value + this.value.begin, range, 0) >= 0) {
            int end = matcher.getEnd();
            matcher.value = matcher.getBegin() == end ? (this.value.realSize > end ? end + regex.getPattern().getEncoding().length(this.value.bytes[this.value.begin + end]) : end + 1) : end;
            return this.substr(matcher.getBegin(), end - matcher.getBegin()).infectBy(regex);
        }
        return null;
    }

    private IRubyObject scanOnce(RubyRegexp regex, Matcher matcher, int range) {
        if (matcher.search(matcher.value + this.value.begin, range, 0) >= 0) {
            Region region = matcher.getRegion();
            int end = region.end[0];
            matcher.value = region.beg[0] == end ? (this.value.realSize > end ? end + regex.getPattern().getEncoding().length(this.value.bytes[this.value.begin + end]) : end + 1) : end;
            RubyArray result = this.getRuntime().newArray(region.numRegs);
            for (int i = 1; i < region.numRegs; ++i) {
                int beg = region.beg[i];
                if (beg == -1) {
                    result.append(this.getRuntime().getNil());
                    continue;
                }
                result.append(this.substr(beg, region.end[i] - beg).infectBy(regex));
            }
            return result;
        }
        return null;
    }

    private final IRubyObject justify(IRubyObject arg0, char jflag) {
        Ruby runtime = this.getRuntime();
        int width = RubyFixnum.num2int(arg0);
        int flen = 0;
        int f = RubyString.SPACE_BYTELIST.begin;
        flen = RubyString.SPACE_BYTELIST.realSize;
        byte[] fbuf = RubyString.SPACE_BYTELIST.bytes;
        IRubyObject pad = runtime.getNil();
        return this.justifyCommon(width, jflag, flen, fbuf, f, runtime, pad);
    }

    private final IRubyObject justify(IRubyObject arg0, IRubyObject arg1, char jflag) {
        Ruby runtime = this.getRuntime();
        int width = RubyFixnum.num2int(arg0);
        int flen = 0;
        RubyString pad = arg1.convertToString();
        ByteList fList = pad.value;
        int f = fList.begin;
        flen = fList.realSize;
        if (flen == 0) {
            throw this.getRuntime().newArgumentError("zero width padding");
        }
        byte[] fbuf = fList.bytes;
        return this.justifyCommon(width, jflag, flen, fbuf, f, runtime, pad);
    }

    private IRubyObject justifyCommon(int width, char jflag, int flen, byte[] fbuf, int f, Ruby runtime, IRubyObject pad) {
        int pend;
        if (width < 0 || this.value.realSize >= width) {
            return this.strDup();
        }
        ByteList res = new ByteList(width);
        res.realSize = width;
        int p = res.begin;
        byte[] pbuf = res.bytes;
        if (jflag != 'l') {
            int n = width - this.value.realSize;
            pend = p + (jflag == 'r' ? n : n / 2);
            if (flen <= 1) {
                while (p < pend) {
                    pbuf[p++] = fbuf[f];
                }
            } else {
                int q = f;
                while (p + flen <= pend) {
                    System.arraycopy(fbuf, f, pbuf, p, flen);
                    p += flen;
                }
                while (p < pend) {
                    pbuf[p++] = fbuf[q++];
                }
            }
        }
        System.arraycopy(this.value.bytes, this.value.begin, pbuf, p, this.value.realSize);
        if (jflag != 'r') {
            p += this.value.realSize;
            pend = res.begin + width;
            if (flen <= 1) {
                while (p < pend) {
                    pbuf[p++] = fbuf[f];
                }
            } else {
                while (p + flen <= pend) {
                    System.arraycopy(fbuf, f, pbuf, p, flen);
                    p += flen;
                }
                while (p < pend) {
                    pbuf[p++] = fbuf[f++];
                }
            }
        }
        RubyString resStr = new RubyString(runtime, this.getMetaClass(), res);
        resStr.infectBy(this);
        if (flen > 0) {
            resStr.infectBy(pad);
        }
        return resStr;
    }

    public IRubyObject ljust(IRubyObject[] args) {
        switch (args.length) {
            case 1: {
                return this.ljust(args[0]);
            }
            case 2: {
                return this.ljust(args[0], args[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args.length, 1, 2);
        return null;
    }

    @JRubyMethod
    public IRubyObject ljust(IRubyObject arg0) {
        return this.justify(arg0, 'l');
    }

    @JRubyMethod
    public IRubyObject ljust(IRubyObject arg0, IRubyObject arg1) {
        return this.justify(arg0, arg1, 'l');
    }

    public IRubyObject rjust(IRubyObject[] args) {
        switch (args.length) {
            case 1: {
                return this.rjust(args[0]);
            }
            case 2: {
                return this.rjust(args[0], args[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args.length, 1, 2);
        return null;
    }

    @JRubyMethod
    public IRubyObject rjust(IRubyObject arg0) {
        return this.justify(arg0, 'r');
    }

    @JRubyMethod
    public IRubyObject rjust(IRubyObject arg0, IRubyObject arg1) {
        return this.justify(arg0, arg1, 'r');
    }

    public IRubyObject center(IRubyObject[] args) {
        switch (args.length) {
            case 1: {
                return this.center(args[0]);
            }
            case 2: {
                return this.center(args[0], args[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args.length, 1, 2);
        return null;
    }

    @JRubyMethod
    public IRubyObject center(IRubyObject arg0) {
        return this.justify(arg0, 'c');
    }

    @JRubyMethod
    public IRubyObject center(IRubyObject arg0, IRubyObject arg1) {
        return this.justify(arg0, arg1, 'c');
    }

    @JRubyMethod(name={"chop"})
    public IRubyObject chop() {
        RubyString str = this.strDup();
        str.chop_bang();
        return str;
    }

    @JRubyMethod(name={"chop!"})
    public IRubyObject chop_bang() {
        int end = this.value.realSize - 1;
        if (end < 0) {
            return this.getRuntime().getNil();
        }
        if (this.value.bytes[this.value.begin + end] == 10 && end > 0 && this.value.bytes[this.value.begin + end - 1] == 13) {
            --end;
        }
        this.view(0, end);
        return this;
    }

    public RubyString chomp(IRubyObject[] args) {
        switch (args.length) {
            case 0: {
                return this.chomp();
            }
            case 1: {
                return this.chomp(args[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args.length, 0, 1);
        return null;
    }

    @JRubyMethod
    public RubyString chomp() {
        RubyString str = this.strDup();
        str.chomp_bang();
        return str;
    }

    @JRubyMethod
    public RubyString chomp(IRubyObject arg0) {
        RubyString str = this.strDup();
        str.chomp_bang(arg0);
        return str;
    }

    public IRubyObject chomp_bang(IRubyObject[] args) {
        switch (args.length) {
            case 0: {
                return this.chomp_bang();
            }
            case 1: {
                return this.chomp_bang(args[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args.length, 0, 1);
        return null;
    }

    @JRubyMethod(name={"chomp!"})
    public IRubyObject chomp_bang() {
        int len = this.value.length();
        if (len == 0) {
            return this.getRuntime().getNil();
        }
        byte[] buff = this.value.bytes;
        IRubyObject rsObj = this.getRuntime().getGlobalVariables().get("$/");
        if (rsObj == this.getRuntime().getGlobalVariables().getDefaultSeparator()) {
            int realSize = this.value.realSize;
            int begin = this.value.begin;
            if (buff[begin + len - 1] == 10) {
                if (--realSize > 0 && buff[begin + realSize - 1] == 13) {
                    --realSize;
                }
                this.view(0, realSize);
            } else if (buff[begin + len - 1] == 13) {
                this.view(0, --realSize);
            } else {
                this.modifyCheck();
                return this.getRuntime().getNil();
            }
            return this;
        }
        return this.chompBangCommon(rsObj);
    }

    @JRubyMethod(name={"chomp!"})
    public IRubyObject chomp_bang(IRubyObject arg0) {
        return this.chompBangCommon(arg0);
    }

    private IRubyObject chompBangCommon(IRubyObject rsObj) {
        if (rsObj.isNil()) {
            return this.getRuntime().getNil();
        }
        RubyString rs = rsObj.convertToString();
        int len = this.value.realSize;
        int begin = this.value.begin;
        if (len == 0) {
            return this.getRuntime().getNil();
        }
        byte[] buff = this.value.bytes;
        int rslen = rs.value.realSize;
        if (rslen == 0) {
            while (len > 0 && buff[begin + len - 1] == 10) {
                if (--len <= 0 || buff[begin + len - 1] != 13) continue;
                --len;
            }
            if (len < this.value.realSize) {
                this.view(0, len);
                return this;
            }
            return this.getRuntime().getNil();
        }
        if (rslen > len) {
            return this.getRuntime().getNil();
        }
        byte newline = rs.value.bytes[rslen - 1];
        if (rslen == 1 && newline == 10) {
            buff = this.value.bytes;
            int realSize = this.value.realSize;
            if (buff[begin + len - 1] == 10) {
                if (--realSize > 0 && buff[begin + realSize - 1] == 13) {
                    --realSize;
                }
                this.view(0, realSize);
            } else if (buff[begin + len - 1] == 13) {
                this.view(0, --realSize);
            } else {
                this.modifyCheck();
                return this.getRuntime().getNil();
            }
            return this;
        }
        if (buff[begin + len - 1] == newline && rslen <= 1 || this.value.endsWith(rs.value)) {
            this.view(0, this.value.realSize - rslen);
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject lstrip() {
        RubyString str = this.strDup();
        str.lstrip_bang();
        return str;
    }

    @JRubyMethod(name={"lstrip!"})
    public IRubyObject lstrip_bang() {
        int i;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        for (i = 0; i < this.value.realSize && ASCII.isSpace(this.value.bytes[this.value.begin + i] & 0xFF); ++i) {
        }
        if (i > 0) {
            this.view(i, this.value.realSize - i);
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject rstrip() {
        RubyString str = this.strDup();
        str.rstrip_bang();
        return str;
    }

    @JRubyMethod(name={"rstrip!"})
    public IRubyObject rstrip_bang() {
        int i;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        for (i = this.value.realSize - 1; i >= 0 && this.value.bytes[this.value.begin + i] == 0; --i) {
        }
        while (i >= 0 && ASCII.isSpace(this.value.bytes[this.value.begin + i] & 0xFF)) {
            --i;
        }
        if (i < this.value.realSize - 1) {
            this.view(0, i + 1);
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject strip() {
        RubyString str = this.strDup();
        str.strip_bang();
        return str;
    }

    @JRubyMethod(name={"strip!"})
    public IRubyObject strip_bang() {
        IRubyObject l = this.lstrip_bang();
        IRubyObject r = this.rstrip_bang();
        if (l.isNil() && r.isNil()) {
            return l;
        }
        return this;
    }

    @JRubyMethod(name={"count"}, required=1, rest=true)
    public IRubyObject count(IRubyObject[] args) {
        if (args.length < 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments");
        }
        if (this.value.realSize == 0) {
            return this.getRuntime().newFixnum(0L);
        }
        boolean[] table = new boolean[256];
        boolean init = true;
        for (int i = 0; i < args.length; ++i) {
            RubyString s = args[i].convertToString();
            s.setup_table(table, init);
            init = false;
        }
        int s = this.value.begin;
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        int i = 0;
        while (s < send) {
            if (!table[buf[s++] & 0xFF]) continue;
            ++i;
        }
        return this.getRuntime().newFixnum(i);
    }

    @JRubyMethod(name={"delete"}, required=1, rest=true)
    public IRubyObject delete(IRubyObject[] args) {
        RubyString str = this.strDup();
        str.delete_bang(args);
        return str;
    }

    @JRubyMethod(name={"delete!"}, required=1, rest=true)
    public IRubyObject delete_bang(IRubyObject[] args) {
        int s;
        if (args.length < 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments");
        }
        boolean[] squeeze = new boolean[256];
        boolean init = true;
        for (int i = 0; i < args.length; ++i) {
            RubyString s2 = args[i].convertToString();
            s2.setup_table(squeeze, init);
            init = false;
        }
        this.modify();
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        int t = s = this.value.begin;
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        boolean modify = false;
        while (s < send) {
            if (squeeze[buf[s] & 0xFF]) {
                modify = true;
            } else {
                buf[t++] = buf[s];
            }
            ++s;
        }
        this.value.realSize = t - this.value.begin;
        if (modify) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"squeeze"}, rest=true)
    public IRubyObject squeeze(IRubyObject[] args) {
        RubyString str = this.strDup();
        str.squeeze_bang(args);
        return str;
    }

    @JRubyMethod(name={"squeeze!"}, rest=true)
    public IRubyObject squeeze_bang(IRubyObject[] args) {
        int s;
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return this.getRuntime().getNil();
        }
        boolean[] squeeze = new boolean[256];
        if (args.length == 0) {
            for (int i = 0; i < 256; ++i) {
                squeeze[i] = true;
            }
        } else {
            boolean init = true;
            for (int i = 0; i < args.length; ++i) {
                RubyString s2 = args[i].convertToString();
                s2.setup_table(squeeze, init);
                init = false;
            }
        }
        this.modify();
        int t = s = this.value.begin;
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        int save = -1;
        while (s < send) {
            int c;
            if ((c = buf[s++] & 0xFF) == save && squeeze[c]) continue;
            int n = t++;
            save = c;
            buf[n] = (byte)save;
        }
        if (t - this.value.begin != this.value.realSize) {
            this.value.realSize = t - this.value.begin;
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject tr(IRubyObject src, IRubyObject repl) {
        RubyString str = this.strDup();
        str.tr_trans(src, repl, false);
        return str;
    }

    @JRubyMethod(name={"tr!"})
    public IRubyObject tr_bang(IRubyObject src, IRubyObject repl) {
        return this.tr_trans(src, repl, false);
    }

    private final void setup_table(boolean[] table, boolean init) {
        int c;
        int i;
        boolean[] buf = new boolean[256];
        TR tr = new TR();
        boolean cflag = false;
        tr.p = this.value.begin;
        tr.pend = this.value.begin + this.value.realSize;
        tr.buf = this.value.bytes;
        tr.max = 0;
        tr.now = 0;
        tr.gen = 0;
        if (this.value.realSize > 1 && this.value.bytes[this.value.begin] == 94) {
            cflag = true;
            ++tr.p;
        }
        if (init) {
            for (i = 0; i < 256; ++i) {
                table[i] = true;
            }
        }
        for (i = 0; i < 256; ++i) {
            buf[i] = cflag;
        }
        while ((c = this.trnext(tr)) >= 0) {
            buf[c & 0xFF] = !cflag;
        }
        for (i = 0; i < 256; ++i) {
            table[i] = table[i] && buf[i];
        }
    }

    private final IRubyObject tr_trans(IRubyObject src, IRubyObject repl, boolean sflag) {
        int s;
        int c;
        int i;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        ByteList replList = repl.convertToString().value;
        if (replList.realSize == 0) {
            return this.delete_bang(new IRubyObject[]{src});
        }
        ByteList srcList = src.convertToString().value;
        TR trsrc = new TR();
        TR trrepl = new TR();
        boolean cflag = false;
        boolean modify = false;
        trsrc.p = srcList.begin;
        trsrc.pend = srcList.begin + srcList.realSize;
        trsrc.buf = srcList.bytes;
        if (srcList.realSize >= 2 && srcList.bytes[srcList.begin] == 94) {
            cflag = true;
            ++trsrc.p;
        }
        trrepl.p = replList.begin;
        trrepl.pend = replList.begin + replList.realSize;
        trrepl.buf = replList.bytes;
        trrepl.gen = 0;
        trsrc.gen = 0;
        trrepl.now = 0;
        trsrc.now = 0;
        trrepl.max = 0;
        trsrc.max = 0;
        int[] trans = new int[256];
        if (cflag) {
            for (i = 0; i < 256; ++i) {
                trans[i] = 1;
            }
            while ((c = this.trnext(trsrc)) >= 0) {
                trans[c & 0xFF] = -1;
            }
            while ((c = this.trnext(trrepl)) >= 0) {
            }
            for (i = 0; i < 256; ++i) {
                if (trans[i] < 0) continue;
                trans[i] = trrepl.now;
            }
        } else {
            for (i = 0; i < 256; ++i) {
                trans[i] = -1;
            }
            while ((c = this.trnext(trsrc)) >= 0) {
                int r = this.trnext(trrepl);
                if (r == -1) {
                    r = trrepl.now;
                }
                trans[c & 0xFF] = r;
            }
        }
        this.modify();
        int send = s + this.value.realSize;
        byte[] sbuf = this.value.bytes;
        if (sflag) {
            int t = s;
            int last = -1;
            while (s < send) {
                byte c0;
                if ((c = trans[(c0 = sbuf[s++]) & 0xFF]) >= 0) {
                    if (last == c) continue;
                    last = c;
                    sbuf[t++] = (byte)(c & 0xFF);
                    modify = true;
                    continue;
                }
                last = -1;
                sbuf[t++] = c0;
            }
            if (this.value.realSize > t - this.value.begin) {
                this.value.realSize = t - this.value.begin;
                modify = true;
            }
        } else {
            for (s = this.value.begin; s < send; ++s) {
                c = trans[sbuf[s] & 0xFF];
                if (c < 0) continue;
                sbuf[s] = (byte)(c & 0xFF);
                modify = true;
            }
        }
        if (modify) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    private final int trnext(TR t) {
        byte[] buf = t.buf;
        while (t.gen == 0) {
            if (t.p == t.pend) {
                return -1;
            }
            if (t.p < t.pend - 1 && buf[t.p] == 92) {
                ++t.p;
            }
            t.now = buf[t.p++];
            if (t.p < t.pend - 1 && buf[t.p] == 45) {
                ++t.p;
                if (t.p < t.pend) {
                    if (t.now > (buf[t.p] & 0xFF)) {
                        ++t.p;
                        continue;
                    }
                    t.gen = 1;
                    t.max = buf[t.p++] & 0xFF;
                }
            }
            return t.now & 0xFF;
        }
        if (++t.now < t.max) {
            return t.now & 0xFF;
        }
        t.gen = 0;
        return t.max & 0xFF;
    }

    @JRubyMethod
    public IRubyObject tr_s(IRubyObject src, IRubyObject repl) {
        RubyString str = this.strDup();
        str.tr_trans(src, repl, true);
        return str;
    }

    @JRubyMethod(name={"tr_s!"})
    public IRubyObject tr_s_bang(IRubyObject src, IRubyObject repl) {
        return this.tr_trans(src, repl, true);
    }

    @JRubyMethod(name={"each_line", "each"}, required=0, optional=1, frame=true)
    public IRubyObject each_line(ThreadContext context, IRubyObject[] args, Block block) {
        RubyString line;
        int p = this.value.begin;
        int pend = p + this.value.realSize;
        int ptr = p;
        int len = this.value.realSize;
        IRubyObject _rsep = args.length == 0 ? this.getRuntime().getGlobalVariables().get("$/") : args[0];
        if (_rsep.isNil()) {
            block.yield(context, this);
            return this;
        }
        RubyString rsep = RubyString.stringValue(_rsep);
        ByteList rsepValue = rsep.value;
        byte[] strBytes = this.value.bytes;
        int rslen = rsepValue.realSize;
        byte newline = rslen == 0 ? (byte)10 : rsepValue.bytes[rsepValue.begin + rslen - 1];
        int s = p;
        p += rslen;
        while (p < pend) {
            if (rslen == 0 && strBytes[p] == 10) {
                if (strBytes[++p] == 10) {
                    while (p < pend && strBytes[p] == 10) {
                        ++p;
                    }
                }
            } else if (ptr < p && strBytes[p - 1] == newline && (rslen <= 1 || ByteList.memcmp(rsepValue.bytes, rsepValue.begin, rslen, strBytes, p - rslen, rslen) == 0)) {
                line = RubyString.newStringShared(this.getRuntime(), this.getMetaClass(), this.value.makeShared(s - ptr, p - s));
                line.infectBy(this);
                block.yield(context, line);
                this.modifyCheck(strBytes, len);
                s = p;
            }
            ++p;
        }
        if (s != pend) {
            if (p > pend) {
                p = pend;
            }
            line = RubyString.newStringShared(this.getRuntime(), this.getMetaClass(), this.value.makeShared(s - ptr, p - s));
            line.infectBy(this);
            block.yield(context, line);
        }
        return this;
    }

    @JRubyMethod(name={"each_byte"}, frame=true)
    public RubyString each_byte(ThreadContext context, Block block) {
        Ruby runtime = this.getRuntime();
        for (int i = 0; i < this.value.length(); ++i) {
            block.yield(context, runtime.newFixnum(this.value.get(i) & 0xFF));
        }
        return this;
    }

    public RubySymbol intern() {
        String s = this.toString();
        if (s.length() == 0) {
            throw this.getRuntime().newArgumentError("interning empty string");
        }
        if (s.indexOf(0) >= 0) {
            throw this.getRuntime().newArgumentError("symbol string may not contain '\\0'");
        }
        return this.getRuntime().newSymbol(s);
    }

    @JRubyMethod(name={"to_sym", "intern"})
    public RubySymbol to_sym() {
        return this.intern();
    }

    @JRubyMethod(name={"sum"}, optional=1)
    public RubyInteger sum(IRubyObject[] args) {
        long bitSizeArg;
        if (args.length > 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments (" + args.length + " for 1)");
        }
        long bitSize = 16L;
        if (args.length == 1 && (bitSizeArg = args[0].convertToInteger().getLongValue()) > 0L) {
            bitSize = bitSizeArg;
        }
        long result = 0L;
        for (int i = 0; i < this.value.length(); ++i) {
            result += (long)(this.value.get(i) & 0xFF);
        }
        return this.getRuntime().newFixnum(bitSize == 0L ? result : result % (long)Math.pow(2.0, bitSize));
    }

    public static RubyString unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyString result = RubyString.newString(input.getRuntime(), input.unmarshalString());
        input.registerLinkTarget(result);
        return result;
    }

    @JRubyMethod
    public RubyArray unpack(IRubyObject obj) {
        return Pack.unpack(this.getRuntime(), this.value, RubyString.stringValue((IRubyObject)obj).value);
    }

    public void setValue(CharSequence value) {
        this.view(ByteList.plain(value));
    }

    public void setValue(ByteList value) {
        this.view(value);
    }

    public CharSequence getValue() {
        return this.toString();
    }

    public byte[] getBytes() {
        return this.value.bytes();
    }

    public ByteList getByteList() {
        return this.value;
    }

    public String getUnicodeValue() {
        try {
            return new String(this.value.bytes, this.value.begin, this.value.realSize, "UTF8");
        }
        catch (Exception e) {
            throw new RuntimeException("Something's seriously broken with encodings", e);
        }
    }

    private static final class TR {
        int gen;
        int now;
        int max;
        int p;
        int pend;
        byte[] buf;

        private TR() {
        }
    }
}

