/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.DeclarationVisitors;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.CompatVersion;
import org.jruby.anno.JRubyMethod;
import org.jruby.util.CodegenUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationBinder
implements AnnotationProcessorFactory {
    private static final Collection<String> supportedAnnotations = Collections.unmodifiableCollection(Arrays.asList("org.jruby.anno.JRubyMethod", "org.jruby.anno.JRubyClass"));
    private static final Collection<String> supportedOptions = Collections.emptySet();

    public Collection<String> supportedAnnotationTypes() {
        return supportedAnnotations;
    }

    public Collection<String> supportedOptions() {
        return supportedOptions;
    }

    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment env) {
        return new AnnotationBindingProcessor(env);
    }

    private static class AnnotationBindingProcessor
    implements AnnotationProcessor {
        private final AnnotationProcessorEnvironment env;
        private final List<String> classNames = new ArrayList<String>();

        AnnotationBindingProcessor(AnnotationProcessorEnvironment env) {
            this.env = env;
        }

        public void process() {
            for (TypeDeclaration typeDecl : this.env.getSpecifiedTypeDeclarations()) {
                typeDecl.accept(DeclarationVisitors.getDeclarationScanner((DeclarationVisitor)new RubyClassVisitor(), (DeclarationVisitor)DeclarationVisitors.NO_OP));
            }
            try {
                FileWriter fw = new FileWriter("src_gen/annotated_classes.txt");
                for (String name : this.classNames) {
                    fw.write(name);
                    fw.write(10);
                }
                fw.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public static int getArityValue(JRubyMethod anno, int actualRequired) {
            if (anno.optional() > 0 || anno.rest()) {
                return -(actualRequired + 1);
            }
            return actualRequired;
        }

        public static String getCallConfigNameByAnno(JRubyMethod anno) {
            return AnnotationBindingProcessor.getCallConfigName(anno.frame(), anno.scope(), anno.backtrace());
        }

        public static String getCallConfigName(boolean frame, boolean scope, boolean backtrace) {
            if (frame) {
                if (scope) {
                    return "FRAME_AND_SCOPE";
                }
                return "FRAME_ONLY";
            }
            if (scope) {
                if (backtrace) {
                    return "BACKTRACE_AND_SCOPE";
                }
                return "SCOPE_ONLY";
            }
            if (backtrace) {
                return "BACKTRACE_ONLY";
            }
            return "NO_FRAME_NO_SCOPE";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class RubyClassVisitor
        extends SimpleDeclarationVisitor {
            private PrintStream out;
            private static final boolean DEBUG = false;

            private RubyClassVisitor() {
            }

            public void visitClassDeclaration(ClassDeclaration cd) {
                try {
                    String qualifiedName = cd.getQualifiedName().replace('.', '$');
                    if (!qualifiedName.contains("org$jruby")) {
                        return;
                    }
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream(1024);
                    this.out = new PrintStream(bytes);
                    this.out.println("/* THIS FILE IS GENERATED. DO NOT EDIT */");
                    this.out.println("import org.jruby.RubyModule;");
                    this.out.println("import org.jruby.CompatVersion;");
                    this.out.println("import org.jruby.anno.TypePopulator;");
                    this.out.println("import org.jruby.internal.runtime.methods.CallConfiguration;");
                    this.out.println("import org.jruby.internal.runtime.methods.JavaMethod;");
                    this.out.println("import org.jruby.internal.runtime.methods.DynamicMethod;");
                    this.out.println("import org.jruby.runtime.Arity;");
                    this.out.println("import org.jruby.runtime.Visibility;");
                    this.out.println("public class " + qualifiedName + "$Populator implements TypePopulator {");
                    this.out.println("    public void populate(RubyModule cls) {");
                    this.out.println("        JavaMethod javaMethod;");
                    this.out.println("        DynamicMethod moduleMethod;");
                    this.out.println("        CompatVersion compatVersion = cls.getRuntime().getInstanceConfig().getCompatVersion();");
                    HashMap<String, List<MethodDeclaration>> annotatedMethods = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> staticAnnotatedMethods = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> annotatedMethods1_8 = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> staticAnnotatedMethods1_8 = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> annotatedMethods1_9 = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> staticAnnotatedMethods1_9 = new HashMap<String, List<MethodDeclaration>>();
                    int methodCount = 0;
                    for (MethodDeclaration md : cd.getMethods()) {
                        JRubyMethod anno = (JRubyMethod)md.getAnnotation(JRubyMethod.class);
                        if (anno == null) continue;
                        ++methodCount;
                        String name = anno.name().length == 0 ? md.getSimpleName() : anno.name()[0];
                        HashMap<String, List<Object>> methodsHash = null;
                        methodsHash = md.getModifiers().contains(Modifier.STATIC) ? (anno.compat() == CompatVersion.RUBY1_8 ? staticAnnotatedMethods1_8 : (anno.compat() == CompatVersion.RUBY1_9 ? staticAnnotatedMethods1_9 : staticAnnotatedMethods)) : (anno.compat() == CompatVersion.RUBY1_8 ? annotatedMethods1_8 : (anno.compat() == CompatVersion.RUBY1_9 ? annotatedMethods1_9 : annotatedMethods));
                        ArrayList<MethodDeclaration> methodDescs = (ArrayList<MethodDeclaration>)methodsHash.get(name);
                        if (methodDescs == null) {
                            methodDescs = new ArrayList<MethodDeclaration>();
                            methodsHash.put(name, methodDescs);
                        }
                        methodDescs.add(md);
                    }
                    if (methodCount == 0) {
                        return;
                    }
                    AnnotationBindingProcessor.this.classNames.add(this.getActualQualifiedName((TypeDeclaration)cd));
                    this.processMethodDeclarations(staticAnnotatedMethods);
                    this.out.println("        if (compatVersion == CompatVersion.RUBY1_8 || compatVersion == CompatVersion.BOTH) {");
                    this.processMethodDeclarations(staticAnnotatedMethods1_8);
                    this.out.println("        }");
                    this.out.println("        if (compatVersion == CompatVersion.RUBY1_9 || compatVersion == CompatVersion.BOTH) {");
                    this.processMethodDeclarations(staticAnnotatedMethods1_9);
                    this.out.println("        }");
                    this.processMethodDeclarations(annotatedMethods);
                    this.out.println("        if (compatVersion == CompatVersion.RUBY1_8 || compatVersion == CompatVersion.BOTH) {");
                    this.processMethodDeclarations(annotatedMethods1_8);
                    this.out.println("        }");
                    this.out.println("        if (compatVersion == CompatVersion.RUBY1_9 || compatVersion == CompatVersion.BOTH) {");
                    this.processMethodDeclarations(annotatedMethods1_9);
                    this.out.println("        }");
                    this.out.println("    }");
                    this.out.println("}");
                    this.out.close();
                    this.out = null;
                    FileOutputStream fos = new FileOutputStream("src_gen/" + qualifiedName + "$Populator.java");
                    fos.write(bytes.toByteArray());
                    fos.close();
                }
                catch (IOException ioe) {
                    System.err.println("FAILED TO GENERATE:");
                    ioe.printStackTrace();
                    System.exit(1);
                }
            }

            public void processMethodDeclarations(Map<String, List<MethodDeclaration>> declarations) {
                for (Map.Entry<String, List<MethodDeclaration>> entry : declarations.entrySet()) {
                    List<MethodDeclaration> list = entry.getValue();
                    if (list.size() == 1) {
                        this.processMethodDeclaration(list.get(0));
                        continue;
                    }
                    this.processMethodDeclarationMulti(list.get(0));
                }
            }

            public void processMethodDeclaration(MethodDeclaration md) {
                JRubyMethod anno = (JRubyMethod)md.getAnnotation(JRubyMethod.class);
                if (anno != null && this.out != null) {
                    boolean isStatic = md.getModifiers().contains(Modifier.STATIC);
                    String qualifiedName = this.getActualQualifiedName(md.getDeclaringType());
                    boolean hasContext = false;
                    boolean hasBlock = false;
                    for (ParameterDeclaration pd : md.getParameters()) {
                        hasContext |= pd.getType().toString().equals("org.jruby.runtime.ThreadContext");
                        hasBlock |= pd.getType().toString().equals("org.jruby.runtime.Block");
                    }
                    int actualRequired = this.calculateActualRequired(md.getParameters().size(), anno.optional(), anno.rest(), isStatic, hasContext, hasBlock);
                    String annotatedBindingName = CodegenUtils.getAnnotatedBindingClassName(md.getSimpleName(), qualifiedName, isStatic, actualRequired, anno.optional(), false);
                    this.out.println("        javaMethod = new " + annotatedBindingName + "(cls, Visibility." + (Object)((Object)anno.visibility()) + ");");
                    this.out.println("        javaMethod.setArity(Arity.createArity(" + AnnotationBindingProcessor.getArityValue(anno, actualRequired) + "));");
                    this.out.println("        javaMethod.setJavaName(\"" + md.getSimpleName() + "\");");
                    this.out.println("        javaMethod.setSingleton(" + isStatic + ");");
                    this.out.println("        javaMethod.setCallConfig(CallConfiguration." + AnnotationBindingProcessor.getCallConfigNameByAnno(anno) + ");");
                    this.generateMethodAddCalls(md, anno);
                }
            }

            public void processMethodDeclarationMulti(MethodDeclaration md) {
                JRubyMethod anno = (JRubyMethod)md.getAnnotation(JRubyMethod.class);
                if (anno != null && this.out != null) {
                    boolean isStatic = md.getModifiers().contains(Modifier.STATIC);
                    String qualifiedName = this.getActualQualifiedName(md.getDeclaringType());
                    boolean hasContext = false;
                    boolean hasBlock = false;
                    for (ParameterDeclaration pd : md.getParameters()) {
                        hasContext |= pd.getType().toString().equals("org.jruby.runtime.ThreadContext");
                        hasBlock |= pd.getType().toString().equals("org.jruby.runtime.Block");
                    }
                    int actualRequired = this.calculateActualRequired(md.getParameters().size(), anno.optional(), anno.rest(), isStatic, hasContext, hasBlock);
                    String annotatedBindingName = CodegenUtils.getAnnotatedBindingClassName(md.getSimpleName(), qualifiedName, isStatic, actualRequired, anno.optional(), true);
                    this.out.println("        javaMethod = new " + annotatedBindingName + "(cls, Visibility." + (Object)((Object)anno.visibility()) + ");");
                    this.out.println("        javaMethod.setArity(Arity.OPTIONAL);");
                    this.out.println("        javaMethod.setJavaName(\"" + md.getSimpleName() + "\");");
                    this.out.println("        javaMethod.setSingleton(" + isStatic + ");");
                    this.out.println("        javaMethod.setCallConfig(CallConfiguration." + AnnotationBindingProcessor.getCallConfigNameByAnno(anno) + ");");
                    this.generateMethodAddCalls(md, anno);
                }
            }

            private String getActualQualifiedName(TypeDeclaration td) {
                String qualifiedName = td.getDeclaringType() != null ? (td.getDeclaringType().getDeclaringType() != null ? td.getDeclaringType().getDeclaringType().getQualifiedName() + "$" + td.getDeclaringType().getSimpleName() + "$" + td.getSimpleName() : td.getDeclaringType().getQualifiedName() + "$" + td.getSimpleName()) : td.getQualifiedName();
                return qualifiedName;
            }

            private boolean tryClass(String className) {
                Class<?> tryClass = null;
                try {
                    tryClass = Class.forName(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return tryClass != null;
            }

            private int calculateActualRequired(int paramsLength, int optional, boolean rest, boolean isStatic, boolean hasContext, boolean hasBlock) {
                int actualRequired;
                if (optional == 0 && !rest) {
                    int args = paramsLength;
                    if (args == 0) {
                        actualRequired = 0;
                    } else {
                        if (isStatic) {
                            --args;
                        }
                        if (hasContext) {
                            --args;
                        }
                        if (hasBlock) {
                            --args;
                        }
                        actualRequired = args;
                    }
                } else {
                    int args = paramsLength;
                    if (args == 0) {
                        actualRequired = 0;
                    } else {
                        if (isStatic) {
                            --args;
                        }
                        if (hasContext) {
                            --args;
                        }
                        if (hasBlock) {
                            --args;
                        }
                        actualRequired = --args;
                    }
                    if (actualRequired != 0) {
                        throw new RuntimeException("Combining specific args with IRubyObject[] is not yet supported");
                    }
                }
                return actualRequired;
            }

            public void generateMethodAddCalls(MethodDeclaration md, JRubyMethod jrubyMethod) {
                block18: {
                    String baseName;
                    block17: {
                        if (jrubyMethod.frame()) {
                            for (String name : jrubyMethod.name()) {
                                this.out.println("        org.jruby.compiler.ASTInspector.FRAME_AWARE_METHODS.add(\"" + name + "\");");
                            }
                        }
                        if (!jrubyMethod.meta()) break block17;
                        if (jrubyMethod.name().length == 0) {
                            baseName = md.getSimpleName();
                            this.out.println("        cls.getMetaClass().addMethod(\"" + baseName + "\", javaMethod);");
                        } else {
                            baseName = jrubyMethod.name()[0];
                            for (String name : jrubyMethod.name()) {
                                this.out.println("        cls.getMetaClass().addMethod(\"" + name + "\", javaMethod);");
                            }
                        }
                        if (jrubyMethod.alias().length <= 0) break block18;
                        for (String alias : jrubyMethod.alias()) {
                            this.out.println("        cls.getMetaClass().defineAlias(\"" + alias + "\", \"" + baseName + "\");");
                        }
                        break block18;
                    }
                    if (jrubyMethod.name().length == 0) {
                        baseName = md.getSimpleName();
                        this.out.println("        cls.addMethod(\"" + baseName + "\", javaMethod);");
                    } else {
                        baseName = jrubyMethod.name()[0];
                        for (String name : jrubyMethod.name()) {
                            this.out.println("        cls.addMethod(\"" + name + "\", javaMethod);");
                        }
                    }
                    if (jrubyMethod.alias().length > 0) {
                        for (String alias : jrubyMethod.alias()) {
                            this.out.println("        cls.defineAlias(\"" + alias + "\", \"" + baseName + "\");");
                        }
                    }
                    if (jrubyMethod.module()) {
                        this.out.println("        moduleMethod = javaMethod.dup();");
                        this.out.println("        moduleMethod.setVisibility(Visibility.PUBLIC);");
                        if (jrubyMethod.name().length == 0) {
                            baseName = md.getSimpleName();
                            this.out.println("        cls.getSingletonClass().addMethod(\"" + baseName + "\", moduleMethod);");
                        } else {
                            baseName = jrubyMethod.name()[0];
                            for (String name : jrubyMethod.name()) {
                                this.out.println("        cls.getSingletonClass().addMethod(\"" + name + "\", moduleMethod);");
                            }
                        }
                        if (jrubyMethod.alias().length > 0) {
                            for (String alias : jrubyMethod.alias()) {
                                this.out.println("        cls.getSingletonClass().defineAlias(\"" + alias + "\", \"" + baseName + "\");");
                            }
                        }
                    }
                }
            }
        }
    }
}

