/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import org.jruby.compiler.impl.FieldBasedCacheCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.util.CodegenUtils;

public class InheritedCacheCompiler
extends FieldBasedCacheCompiler {
    public static final int MAX_INHERITED_CALL_SITES = 50;
    int callSiteCount = 0;

    public InheritedCacheCompiler(StandardASMCompiler scriptCompiler) {
        super(scriptCompiler);
    }

    public void cacheCallSite(SkinnyMethodAdapter method, String name, CallType callType) {
        String fieldName = "site" + this.callSiteCount;
        SkinnyMethodAdapter initMethod = this.scriptCompiler.getInitMethod();
        initMethod.aload(0);
        method.aload(0);
        initMethod.ldc(name);
        if (callType.equals(CallType.NORMAL)) {
            initMethod.invokestatic(CodegenUtils.p(MethodIndex.class), "getCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        } else if (callType.equals(CallType.FUNCTIONAL)) {
            initMethod.invokestatic(CodegenUtils.p(MethodIndex.class), "getFunctionalCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        } else if (callType.equals(CallType.VARIABLE)) {
            initMethod.invokestatic(CodegenUtils.p(MethodIndex.class), "getVariableCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        }
        if (this.callSiteCount >= 50) {
            this.scriptCompiler.getNewField(CodegenUtils.ci(CallSite.class), fieldName, null);
            initMethod.putfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(CallSite.class));
            method.getfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(CallSite.class));
        } else {
            initMethod.putfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(CallSite.class));
            method.getfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(CallSite.class));
        }
        ++this.callSiteCount;
    }
}

