/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import com.sun.jna.FromNativeContext;
import com.sun.jna.NativeMapped;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class HeapStruct
implements NativeMapped {
    private static final String arch = System.getProperty("os.arch").toLowerCase();
    private static final boolean isSPARC = "sparc".equals(arch);
    private static final int LONG_SIZE = (Platform.isWindows() ? 4 : Pointer.SIZE) * 8;
    private static final int LONG_ALIGN = isSPARC ? 64 : LONG_SIZE;
    private static final int DOUBLE_ALIGN = isSPARC ? 64 : LONG_SIZE;
    private static final int FLOAT_ALIGN = isSPARC ? 64 : 32;
    private ByteBuffer buffer;
    private int size = 0;

    public Object fromNative(Object arg0, FromNativeContext arg1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object toNative() {
        return this.getByteBuffer();
    }

    public Class nativeType() {
        return ByteBuffer.class;
    }

    protected final ByteBuffer getByteBuffer() {
        if (this.buffer == null) {
            this.buffer = ByteBuffer.allocate(this.size).order(ByteOrder.nativeOrder());
        }
        return this.buffer;
    }

    public final int getStructSize() {
        return this.size;
    }

    protected final int addField(int size, int align) {
        int mask = align / 8 - 1;
        if ((this.size & mask) != 0) {
            this.size = (this.size & ~mask) + align / 8;
        }
        int off = this.size;
        this.size += size / 8;
        return off;
    }

    protected class LongLong
    extends Int64 {
        public LongLong() {
        }

        public LongLong(long value) {
            super(value);
        }
    }

    protected class Long
    extends Field {
        public Long() {
            super(LONG_SIZE, LONG_ALIGN);
        }

        public Long(long value) {
            this();
            this.set(value);
        }

        public final long get() {
            return LONG_SIZE == 32 ? (long)HeapStruct.this.getByteBuffer().getInt(this.offset) : HeapStruct.this.getByteBuffer().getLong(this.offset);
        }

        public final void set(long value) {
            if (LONG_SIZE == 32) {
                HeapStruct.this.getByteBuffer().putInt(this.offset, (int)value);
            } else {
                HeapStruct.this.getByteBuffer().putLong(this.offset, value);
            }
        }
    }

    protected class Int64
    extends Field {
        public Int64() {
            super(64, LONG_ALIGN);
        }

        public Int64(long value) {
            this();
            this.set(value);
        }

        public final long get() {
            return HeapStruct.this.getByteBuffer().getLong(this.offset);
        }

        public final void set(long value) {
            HeapStruct.this.getByteBuffer().putLong(this.offset, value);
        }
    }

    protected class Integer
    extends Int32 {
        public Integer() {
        }

        public Integer(int value) {
            super(value);
        }
    }

    protected class Int32
    extends Field {
        public Int32() {
            super(32);
        }

        public Int32(int value) {
            this();
            this.set(value);
        }

        public final int get() {
            return HeapStruct.this.getByteBuffer().getInt(this.offset);
        }

        public final void set(int value) {
            HeapStruct.this.getByteBuffer().putInt(this.offset, value);
        }
    }

    protected class Short
    extends Int16 {
        public Short() {
        }

        public Short(short value) {
            super(value);
        }
    }

    protected class Int16
    extends Field {
        public Int16() {
            super(16);
        }

        public Int16(short value) {
            this();
            this.set(value);
        }

        public final short get() {
            return HeapStruct.this.getByteBuffer().getShort(this.offset);
        }

        public final void set(short value) {
            HeapStruct.this.getByteBuffer().putShort(this.offset, value);
        }
    }

    protected final class Byte
    extends Int8 {
        public Byte() {
        }

        public Byte(byte value) {
            super(value);
        }
    }

    protected class Int8
    extends Field {
        public Int8() {
            super(8);
        }

        public Int8(byte value) {
            this();
            this.set(value);
        }

        public final byte get() {
            return HeapStruct.this.getByteBuffer().get(this.offset);
        }

        public final void set(byte value) {
            HeapStruct.this.getByteBuffer().put(this.offset, value);
        }
    }

    protected abstract class Field {
        public final int size;
        public final int align;
        public final int offset;

        public Field(int size) {
            this(size, size);
        }

        public Field(int size, int align) {
            this.size = size;
            this.align = align;
            this.offset = HeapStruct.this.addField(size, align);
        }
    }
}

