/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.joni.encoding.Encoding;
import org.joni.encoding.specific.ASCIIEncoding;
import org.joni.encoding.specific.EUCJPEncoding;
import org.joni.encoding.specific.SJISEncoding;
import org.joni.encoding.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.runtime.builtin.IRubyObject;

public final class KCode {
    public static final KCode NIL = new KCode(null, 0, ASCIIEncoding.INSTANCE);
    public static final KCode NONE = new KCode("NONE", 0, ASCIIEncoding.INSTANCE);
    public static final KCode UTF8 = new KCode("UTF8", 64, UTF8Encoding.INSTANCE);
    public static final KCode SJIS = new KCode("SJIS", 48, SJISEncoding.INSTANCE);
    public static final KCode EUC = new KCode("EUC", 32, EUCJPEncoding.INSTANCE);
    private String kcode;
    private Encoding encoding;
    private int code;

    private KCode(String kcode, int code, Encoding encoding) {
        this.kcode = kcode;
        this.code = code;
        this.encoding = encoding;
    }

    public static KCode create(Ruby runtime, String lang) {
        if (lang == null) {
            return NIL;
        }
        switch (lang.charAt(0)) {
            case 'E': 
            case 'e': {
                return EUC;
            }
            case 'S': 
            case 's': {
                return SJIS;
            }
            case 'U': 
            case 'u': {
                return UTF8;
            }
            case 'A': 
            case 'N': 
            case 'a': 
            case 'n': {
                return NONE;
            }
        }
        return NIL;
    }

    public IRubyObject kcode(Ruby runtime) {
        return this.kcode == null ? runtime.getNil() : runtime.newString(this.kcode);
    }

    public String getKCode() {
        return this.kcode;
    }

    public int bits() {
        return this.code;
    }

    public String name() {
        if (this.kcode != null) {
            return this.kcode.toLowerCase();
        }
        return null;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }
}

