/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class ZlibDeflate {
    private Deflater flater;
    private ByteList collected;
    private Ruby runtime;
    public static final int BASE_SIZE = 100;
    public static final int DEF_MEM_LEVEL = 8;
    public static final int MAX_MEM_LEVEL = 9;
    public static final int MAX_WBITS = 15;
    public static final int NO_FLUSH = 0;
    public static final int SYNC_FLUSH = 2;
    public static final int FULL_FLUSH = 3;
    public static final int FINISH = 4;

    public ZlibDeflate(IRubyObject caller, int level, int win_bits, int memlevel, int strategy) {
        this.flater = new Deflater(level, win_bits < 0);
        this.flater.setStrategy(strategy);
        this.collected = new ByteList(100);
        this.runtime = caller.getRuntime();
    }

    public static IRubyObject s_deflate(IRubyObject caller, ByteList str, int level) throws DataFormatException, IOException {
        ZlibDeflate zstream = new ZlibDeflate(caller, level, 15, 8, 0);
        IRubyObject result = zstream.deflate(str, 4);
        zstream.close();
        return result;
    }

    public Deflater getDeflater() {
        return this.flater;
    }

    public void append(IRubyObject obj) throws IOException, UnsupportedEncodingException {
        this.append(obj.convertToString().getByteList());
    }

    public void append(ByteList obj) throws IOException {
        this.collected.append(obj);
    }

    public void params(int level, int strategy) {
        this.flater.setLevel(level);
        this.flater.setStrategy(strategy);
    }

    public IRubyObject set_dictionary(IRubyObject str) throws UnsupportedEncodingException {
        this.flater.setDictionary(str.convertToString().getBytes());
        return str;
    }

    public IRubyObject flush(int flush) throws IOException {
        return this.deflate(new ByteList(0), flush);
    }

    public IRubyObject deflate(ByteList str, int flush) throws IOException {
        if (null == str) {
            return this.finish();
        }
        this.append(str);
        if (flush == 4) {
            return this.finish();
        }
        return this.runtime.newString("");
    }

    public IRubyObject finish() throws IOException {
        ByteList result = new ByteList(this.collected.realSize);
        byte[] outp = new byte[65536];
        ByteList buf = this.collected;
        this.collected = new ByteList(100);
        this.flater.setInput(buf.bytes, buf.begin, buf.realSize);
        this.flater.finish();
        int resultLength = -1;
        while (!this.flater.finished() && resultLength != 0) {
            resultLength = this.flater.deflate(outp);
            result.append(outp, 0, resultLength);
            if (resultLength != outp.length) continue;
            outp = new byte[outp.length * 2];
        }
        return RubyString.newString(this.runtime, result);
    }

    public void close() {
    }
}

