/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.media.jai.InterpolationNearest;
import org.geotools.coverage.AbstractCoverage;
import org.geotools.coverage.OrdinateOutsideCoverageException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.Interpolator2D;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.image.io.IIOListeners;
import org.geotools.image.io.IIOReadProgressAdapter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultTemporalCRS;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.Classes;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.FrequencySortedSet;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.coverage.grid.GridRange;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageStack
extends AbstractCoverage {
    private static final long serialVersionUID = -7100201963376146053L;
    private final Element[] elements;
    private final SampleDimension[] sampleDimensions;
    private final int numSampleDimensions;
    private final GeneralEnvelope envelope;
    private transient GeneralDirectPosition reducedPosition;
    public final int zDimension;
    private final CoordinateReferenceSystem zCRS;
    private boolean interpolationEnabled = true;
    private final double lagTolerance = 0.0;
    private final IIOListeners listeners = new IIOListeners();
    private transient Listeners readListener;
    private transient Coverage lower;
    private transient Coverage upper;
    private transient double lowerZ = Double.POSITIVE_INFINITY;
    private transient double upperZ = Double.NEGATIVE_INFINITY;
    private transient NumberRange lowerRange;
    private transient NumberRange upperRange;
    private transient byte[] byteBuffer;
    private transient int[] intBuffer;
    private transient float[] floatBuffer;
    private transient double[] doubleBuffer;
    private static final Comparator<Object> COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object entry1, Object entry2) {
            try {
                return Double.compare(CoverageStack.zFromObject(entry1), CoverageStack.zFromObject(entry2));
            }
            catch (IOException exception) {
                throw new UndeclaredThrowableException(exception);
            }
        }
    };

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.lowerZ = Double.POSITIVE_INFINITY;
        this.upperZ = Double.NEGATIVE_INFINITY;
    }

    public CoverageStack(CharSequence name, Collection<? extends Coverage> coverages) throws IOException {
        this(name, (CoordinateReferenceSystem)null, CoverageStack.toElements(coverages));
    }

    private static Element[] toElements(Collection<? extends Coverage> coverages) {
        Element[] elements = new Element[coverages.size()];
        int count = 0;
        for (Coverage coverage : coverages) {
            elements[count++] = new Adapter(coverage, null);
        }
        return elements;
    }

    public CoverageStack(CharSequence name, CoordinateReferenceSystem crs, Collection<? extends Element> elements) throws IOException {
        this(name, crs, elements.toArray(new Element[elements.size()]));
    }

    private CoverageStack(CharSequence name, CoordinateReferenceSystem crs, Element[] elements) throws IOException {
        this(name, CoverageStack.getEnvelope(crs, elements), elements);
    }

    private CoverageStack(CharSequence name, GeneralEnvelope envelope, Element[] elements) throws IOException {
        super(name, envelope.getCoordinateReferenceSystem(), null, null);
        assert (XArray.isSorted((Object[])elements, COMPARATOR));
        this.elements = elements;
        this.envelope = envelope;
        this.zDimension = envelope.getDimension() - 1;
        boolean sampleDimensionMismatch = false;
        Object[] sampleDimensions = null;
        for (int j = 0; j < elements.length; ++j) {
            Element element = elements[j];
            Object[] candidate = element.getSampleDimensions();
            if (candidate == null) continue;
            if (sampleDimensions == null) {
                sampleDimensions = candidate;
                continue;
            }
            if (sampleDimensions.length != candidate.length) {
                throw new IllegalArgumentException("Inconsistent number of sample dimensions.");
            }
            if (Arrays.equals(sampleDimensions, candidate)) continue;
            sampleDimensionMismatch = true;
        }
        this.numSampleDimensions = sampleDimensions != null ? sampleDimensions.length : 0;
        this.sampleDimensions = sampleDimensionMismatch ? null : sampleDimensions;
        this.zCRS = CRSUtilities.getSubCRS((CoordinateReferenceSystem)this.crs, (int)this.zDimension, (int)(this.zDimension + 1));
    }

    protected CoverageStack(CharSequence name, CoverageStack source) {
        super(name, source);
        this.elements = source.elements;
        this.sampleDimensions = source.sampleDimensions;
        this.numSampleDimensions = source.numSampleDimensions;
        this.envelope = source.envelope;
        this.zDimension = source.zDimension;
        this.zCRS = source.zCRS;
        this.interpolationEnabled = source.interpolationEnabled;
    }

    private static GeneralEnvelope getEnvelope(CoordinateReferenceSystem crs, Element[] elements) throws IOException {
        try {
            Arrays.sort(elements, COMPARATOR);
        }
        catch (UndeclaredThrowableException exception) {
            throw CoverageStack.rethrow(exception);
        }
        Envelope[] envelopes = null;
        int zDimension = 0;
        int errorCode = 46;
        if (crs == null) {
            errorCode = 197;
            FrequencySortedSet frequency = null;
            for (int i = 0; i < elements.length; ++i) {
                int dimension;
                Envelope envelope = elements[i].getEnvelope();
                if (envelope == null) continue;
                if (envelopes == null) {
                    envelopes = new Envelope[elements.length];
                }
                envelopes[i] = envelope;
                CoordinateReferenceSystem candidate = envelope.getCoordinateReferenceSystem();
                if (candidate != null) {
                    if (frequency == null) {
                        frequency = new FrequencySortedSet(true);
                    }
                    frequency.add((Object)candidate);
                }
                if ((dimension = envelope.getDimension()) <= zDimension) continue;
                zDimension = dimension - 1;
            }
            if (frequency != null) {
                int size = frequency.size();
                switch (size) {
                    default: {
                        int[] f = frequency.frequencies();
                        LogRecord record = Loggings.format((Level)Level.WARNING, (int)48, (Object)size, (Object)elements.length, (Object)f[0], (Object)f[size - 1]);
                        record.setSourceClassName(CoverageStack.class.getName());
                        record.setSourceMethodName("<init>");
                        Logger logger = Logging.getLogger(CoverageStack.class);
                        record.setLoggerName(logger.getName());
                        logger.log(record);
                    }
                    case 1: {
                        crs = (CoordinateReferenceSystem)frequency.first();
                    }
                    case 0: 
                }
            }
        }
        if (crs != null) {
            zDimension = crs.getCoordinateSystem().getDimension() - 1;
        }
        if (zDimension <= 0) {
            throw new IllegalArgumentException(Errors.format((int)180, (Object)(crs == null ? "null" : crs.getName().getCode())));
        }
        GeneralEnvelope envelope = crs != null ? new GeneralEnvelope(crs) : new GeneralEnvelope(zDimension + 1);
        envelope.setToNull();
        CoordinateReferenceSystem reducedCRS = CRSUtilities.getSubCRS((CoordinateReferenceSystem)crs, (int)0, (int)zDimension);
        CoordinateOperation operation = null;
        for (int j = 0; j < elements.length; ++j) {
            Envelope candidate;
            Element element = elements[j];
            Envelope envelope2 = candidate = envelopes != null ? envelopes[j] : element.getEnvelope();
            if (candidate == null) continue;
            CoordinateReferenceSystem sourceCRS = candidate.getCoordinateReferenceSystem();
            if (sourceCRS != null && !CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)crs) && !CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)reducedCRS)) {
                if (operation == null || !CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)operation.getSourceCRS())) {
                    CoordinateOperationFactory factory = CRS.getCoordinateOperationFactory((boolean)true);
                    try {
                        try {
                            operation = factory.createOperation(sourceCRS, crs);
                        }
                        catch (OperationNotFoundException e) {
                            assert (!CRS.equalsIgnoreMetadata((Object)reducedCRS, (Object)crs)) : reducedCRS;
                            operation = factory.createOperation(sourceCRS, reducedCRS);
                        }
                    }
                    catch (FactoryException e) {
                        throw new MismatchedReferenceSystemException(Errors.format((int)errorCode, (Object)((Object)e)));
                    }
                }
                try {
                    candidate = CRS.transform(operation, (Envelope)candidate);
                }
                catch (TransformException exception) {
                    throw new MismatchedReferenceSystemException(Errors.format((int)errorCode, (Object)((Object)exception)));
                }
            }
            int dim = candidate.getDimension();
            for (int i = 0; i <= zDimension; ++i) {
                double maximum;
                double minimum;
                double min = envelope.getMinimum(i);
                double max = envelope.getMaximum(i);
                if (i < dim) {
                    minimum = candidate.getMinimum(i);
                    maximum = candidate.getMaximum(i);
                } else if (i == zDimension) {
                    NumberRange range = element.getZRange();
                    minimum = range.getMinimum();
                    maximum = range.getMaximum();
                } else {
                    minimum = Double.NEGATIVE_INFINITY;
                    maximum = Double.POSITIVE_INFINITY;
                }
                boolean changed = false;
                if (Double.isNaN(min) || minimum < min) {
                    min = minimum;
                    changed = true;
                }
                if (Double.isNaN(max) || maximum > max) {
                    max = maximum;
                    changed = true;
                }
                if (!changed) continue;
                envelope.setRange(i, min, max);
            }
        }
        return envelope;
    }

    private static IOException rethrow(UndeclaredThrowableException exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof IOException) {
            return (IOException)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw exception;
    }

    private static double zFromObject(Object object) throws IOException, ClassCastException {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return CoverageStack.getZ((Element)object);
    }

    private static double getZ(Element entry) throws IOException {
        return CoverageStack.getZ(entry.getZRange());
    }

    private static double getZ(NumberRange range) {
        if (range != null) {
            Number lower = (Number)((Object)range.getMinValue());
            Number upper = (Number)((Object)range.getMaxValue());
            if (lower != null) {
                if (upper != null) {
                    return 0.5 * (lower.doubleValue() + upper.doubleValue());
                }
                return lower.doubleValue();
            }
            if (upper != null) {
                return upper.doubleValue();
            }
        }
        return Double.NaN;
    }

    private static boolean contains(NumberRange range, double z) {
        return z >= range.getMinimum() && z <= range.getMaximum();
    }

    @Override
    public Envelope getEnvelope() {
        return this.envelope.clone();
    }

    public int getNumSampleDimensions() {
        if (this.numSampleDimensions != 0) {
            return this.numSampleDimensions;
        }
        throw new IllegalStateException("Sample dimensions are undetermined.");
    }

    public SampleDimension getSampleDimension(int index) {
        if (this.sampleDimensions != null) {
            return this.sampleDimensions[index];
        }
        throw new IllegalStateException("Sample dimensions are undetermined.");
    }

    public void snap(DirectPosition point) throws IOException {
        Element element;
        GridGeometry geometry;
        int index;
        double z = point.getOrdinate(this.zDimension);
        try {
            index = Arrays.binarySearch(this.elements, z, COMPARATOR);
        }
        catch (UndeclaredThrowableException exception) {
            throw CoverageStack.rethrow(exception);
        }
        if (index < 0) {
            if ((index ^= 0xFFFFFFFF) == this.elements.length) {
                if (index == 0) {
                    return;
                }
                z = CoverageStack.getZ(this.elements[--index]);
            } else if (index == 0) {
                z = CoverageStack.getZ(this.elements[index]);
            } else {
                double lowerZ = CoverageStack.getZ(this.elements[index - 1]);
                double upperZ = CoverageStack.getZ(this.elements[index]);
                assert (!(z <= lowerZ) && !(z >= upperZ)) : z;
                if (Double.isNaN(upperZ) || z - lowerZ < upperZ - z) {
                    --index;
                    z = lowerZ;
                } else {
                    z = upperZ;
                }
            }
            point.setOrdinate(this.zDimension, z);
        }
        if ((geometry = (element = this.elements[index]).getGridGeometry()) != null) {
            GridRange range = geometry.getGridRange();
            MathTransform transform = geometry.getGridToCRS();
            int dimension = transform.getSourceDimensions();
            GeneralDirectPosition position = new GeneralDirectPosition(dimension);
            int i = dimension;
            while (--i >= 0) {
                position.setOrdinate(i, point.getOrdinate(i));
            }
            try {
                position = transform.inverse().transform((DirectPosition)position, (DirectPosition)position);
                i = dimension;
                while (--i >= 0) {
                    position.setOrdinate(i, (double)Math.max(range.getLower(i), Math.min(range.getUpper(i) - 1, (int)Math.rint(position.getOrdinate(i)))));
                }
                position = transform.transform((DirectPosition)position, (DirectPosition)position);
                i = Math.min(dimension, this.zDimension);
                while (--i >= 0) {
                    point.setOrdinate(i, position.getOrdinate(i));
                }
            }
            catch (TransformException exception) {
                throw new CannotEvaluateException(CoverageStack.cannotEvaluate(point), (Throwable)exception);
            }
        }
    }

    private static String cannotEvaluate(DirectPosition point) {
        return Errors.format((int)23, (Object)point);
    }

    private Coverage load(Element element) throws IOException {
        CoordinateReferenceSystem sourceCRS;
        Coverage coverage = element.getCoverage(this.listeners);
        if (coverage instanceof GridCoverage2D) {
            GridCoverage2D coverage2D = (GridCoverage2D)coverage;
            if (this.interpolationEnabled && coverage2D.getInterpolation() instanceof InterpolationNearest) {
                coverage = Interpolator2D.create(coverage2D);
            }
        }
        assert (CRS.equalsIgnoreMetadata((Object)(sourceCRS = coverage.getCoordinateReferenceSystem()), (Object)CRSUtilities.getSubCRS((CoordinateReferenceSystem)this.crs, (int)0, (int)sourceCRS.getCoordinateSystem().getDimension()))) : sourceCRS + "\n\n" + this.crs;
        assert (coverage.getNumSampleDimensions() == this.numSampleDimensions) : coverage;
        return coverage;
    }

    private void load(int index) throws IOException {
        Element element = this.elements[index];
        NumberRange zRange = element.getZRange();
        this.logLoading(94, new String[]{element.getName()});
        this.lower = this.upper = this.load(element);
        this.lowerZ = this.upperZ = CoverageStack.getZ(zRange);
        this.lowerRange = this.upperRange = zRange;
    }

    private void load(Element lowerElement, Element upperElement) throws IOException {
        this.logLoading(93, new String[]{lowerElement.getName(), upperElement.getName()});
        NumberRange lowerRange = lowerElement.getZRange();
        NumberRange upperRange = upperElement.getZRange();
        Coverage lower = this.load(lowerElement);
        Coverage upper = this.load(upperElement);
        this.lower = lower;
        this.upper = upper;
        this.lowerZ = CoverageStack.getZ(lowerRange);
        this.upperZ = CoverageStack.getZ(upperRange);
        this.lowerRange = lowerRange;
        this.upperRange = upperRange;
    }

    private boolean seek(double z) throws CannotEvaluateException {
        Double Z;
        block18: {
            int index;
            assert (Thread.holdsLock((Object)this));
            if (z >= this.lowerZ && z <= this.upperZ || Double.isNaN(z) && Double.isNaN(this.lowerZ) && Double.isNaN(this.upperZ)) {
                return true;
            }
            Z = z;
            try {
                index = Arrays.binarySearch(this.elements, Z, COMPARATOR);
            }
            catch (UndeclaredThrowableException exception) {
                throw new CannotEvaluateException("Can't fetch coverage properties.", (Throwable)CoverageStack.rethrow(exception));
            }
            try {
                double upperStart;
                if (index >= 0) {
                    this.load(index);
                    return true;
                }
                if ((index ^= 0xFFFFFFFF) == this.elements.length) {
                    if (--index >= 0 && this.elements[index].getZRange().contains((Number)Z)) {
                        this.load(index);
                        return true;
                    }
                    break block18;
                }
                if (index == 0) {
                    if (this.elements[index].getZRange().contains((Number)Z)) {
                        this.load(index);
                        return true;
                    }
                    break block18;
                }
                Element lowerElement = this.elements[index - 1];
                Element upperElement = this.elements[index];
                NumberRange lowerRange = lowerElement.getZRange();
                NumberRange upperRange = upperElement.getZRange();
                double lowerEnd = lowerRange.getMaximum();
                if (lowerEnd + 0.0 >= (upperStart = upperRange.getMinimum())) {
                    if (this.interpolationEnabled) {
                        this.load(lowerElement, upperElement);
                    } else {
                        if (Math.abs(CoverageStack.getZ(upperRange) - z) > Math.abs(z - CoverageStack.getZ(lowerRange))) {
                            --index;
                        }
                        this.load(index);
                    }
                    return true;
                }
                if (lowerRange.contains((Number)Z)) {
                    this.load(index - 1);
                    return true;
                }
                if (upperRange.contains((Number)Z)) {
                    this.load(index);
                    return true;
                }
                return false;
            }
            catch (IOException exception) {
                String message = exception.getLocalizedMessage();
                if (message == null) {
                    message = Classes.getShortClassName((Object)exception);
                }
                throw new CannotEvaluateException(message, (Throwable)exception);
            }
        }
        Comparable<Double> Zp = this.zCRS instanceof TemporalCRS ? DefaultTemporalCRS.wrap((TemporalCRS)((TemporalCRS)this.zCRS)).toDate(z) : Z;
        throw new OrdinateOutsideCoverageException(Errors.format((int)148, (Object)this.getName(), (Object)Zp), this.zDimension, this.getEnvelope());
    }

    private final DirectPosition reduce(DirectPosition coord, Coverage coverage) {
        CoordinateReferenceSystem targetCRS = coverage.getCoordinateReferenceSystem();
        int dimension = targetCRS.getCoordinateSystem().getDimension();
        if (dimension == this.zDimension) {
            if (this.reducedPosition == null) {
                this.reducedPosition = new GeneralDirectPosition(this.zDimension);
            }
            for (int i = 0; i < dimension; ++i) {
                this.reducedPosition.ordinates[i] = coord.getOrdinate(i);
            }
            coord = this.reducedPosition;
        } else assert (CRS.equalsIgnoreMetadata((Object)this.crs, (Object)targetCRS)) : targetCRS;
        return coord;
    }

    public Object evaluate(DirectPosition coord) throws CannotEvaluateException {
        return this.evaluate(coord, (double[])null);
    }

    @Override
    public synchronized boolean[] evaluate(DirectPosition coord, boolean[] dest) throws CannotEvaluateException {
        double z = coord.getOrdinate(this.zDimension);
        if (!this.seek(z)) {
            if (dest == null) {
                dest = new boolean[this.numSampleDimensions];
            } else {
                Arrays.fill(dest, 0, this.numSampleDimensions, false);
            }
            return dest;
        }
        if (this.lower == this.upper) {
            return this.lower.evaluate(this.reduce(coord, this.lower), dest);
        }
        assert (!(z < this.lowerZ) && !(z > this.upperZ)) : z;
        Coverage coverage = z >= 0.5 * (this.lowerZ + this.upperZ) ? this.upper : this.lower;
        return coverage.evaluate(this.reduce(coord, coverage), dest);
    }

    @Override
    public synchronized byte[] evaluate(DirectPosition coord, byte[] dest) throws CannotEvaluateException {
        double z = coord.getOrdinate(this.zDimension);
        if (!this.seek(z)) {
            if (dest == null) {
                dest = new byte[this.numSampleDimensions];
            } else {
                Arrays.fill(dest, 0, this.numSampleDimensions, (byte)0);
            }
            return dest;
        }
        if (this.lower == this.upper) {
            return this.lower.evaluate(this.reduce(coord, this.lower), dest);
        }
        this.byteBuffer = this.upper.evaluate(this.reduce(coord, this.upper), this.byteBuffer);
        dest = this.lower.evaluate(this.reduce(coord, this.lower), dest);
        assert (!(z < this.lowerZ) && !(z > this.upperZ)) : z;
        double ratio = (z - this.lowerZ) / (this.upperZ - this.lowerZ);
        for (int i = 0; i < this.byteBuffer.length; ++i) {
            dest[i] = (byte)Math.round((double)dest[i] + ratio * (double)(this.byteBuffer[i] - dest[i]));
        }
        return dest;
    }

    @Override
    public synchronized int[] evaluate(DirectPosition coord, int[] dest) throws CannotEvaluateException {
        double z = coord.getOrdinate(this.zDimension);
        if (!this.seek(z)) {
            if (dest == null) {
                dest = new int[this.numSampleDimensions];
            } else {
                Arrays.fill(dest, 0, this.numSampleDimensions, 0);
            }
            return dest;
        }
        if (this.lower == this.upper) {
            return this.lower.evaluate(this.reduce(coord, this.lower), dest);
        }
        this.intBuffer = this.upper.evaluate(this.reduce(coord, this.upper), this.intBuffer);
        dest = this.lower.evaluate(this.reduce(coord, this.lower), dest);
        assert (!(z < this.lowerZ) && !(z > this.upperZ)) : z;
        double ratio = (z - this.lowerZ) / (this.upperZ - this.lowerZ);
        for (int i = 0; i < this.intBuffer.length; ++i) {
            dest[i] = (int)Math.round((double)dest[i] + ratio * (double)(this.intBuffer[i] - dest[i]));
        }
        return dest;
    }

    @Override
    public synchronized float[] evaluate(DirectPosition coord, float[] dest) throws CannotEvaluateException {
        double z = coord.getOrdinate(this.zDimension);
        if (!this.seek(z)) {
            if (dest == null) {
                dest = new float[this.numSampleDimensions];
            }
            Arrays.fill(dest, 0, this.numSampleDimensions, Float.NaN);
            return dest;
        }
        if (this.lower == this.upper) {
            return this.lower.evaluate(this.reduce(coord, this.lower), dest);
        }
        this.floatBuffer = this.upper.evaluate(this.reduce(coord, this.upper), this.floatBuffer);
        dest = this.lower.evaluate(this.reduce(coord, this.lower), dest);
        assert (!(z < this.lowerZ) && !(z > this.upperZ)) : z;
        double ratio = (z - this.lowerZ) / (this.upperZ - this.lowerZ);
        for (int i = 0; i < this.floatBuffer.length; ++i) {
            float lower = dest[i];
            float upper = this.floatBuffer[i];
            float value = (float)((double)lower + ratio * (double)(upper - lower));
            if (Float.isNaN(value)) {
                if (!Float.isNaN(lower)) {
                    assert (Float.isNaN(upper)) : upper;
                    if (CoverageStack.contains(this.lowerRange, z)) {
                        value = lower;
                    }
                } else if (!Float.isNaN(upper)) {
                    assert (Float.isNaN(lower)) : lower;
                    if (CoverageStack.contains(this.upperRange, z)) {
                        value = upper;
                    }
                }
            }
            dest[i] = value;
        }
        return dest;
    }

    @Override
    public synchronized double[] evaluate(DirectPosition coord, double[] dest) throws CannotEvaluateException {
        double z = coord.getOrdinate(this.zDimension);
        if (!this.seek(z)) {
            if (dest == null) {
                dest = new double[this.numSampleDimensions];
            }
            Arrays.fill(dest, 0, this.numSampleDimensions, Double.NaN);
            return dest;
        }
        if (this.lower == this.upper) {
            return this.lower.evaluate(this.reduce(coord, this.lower), dest);
        }
        this.doubleBuffer = this.upper.evaluate(this.reduce(coord, this.upper), this.doubleBuffer);
        dest = this.lower.evaluate(this.reduce(coord, this.lower), dest);
        assert (!(z < this.lowerZ) && !(z > this.upperZ)) : z;
        double ratio = (z - this.lowerZ) / (this.upperZ - this.lowerZ);
        for (int i = 0; i < this.doubleBuffer.length; ++i) {
            double lower = dest[i];
            double upper = this.doubleBuffer[i];
            double value = lower + ratio * (upper - lower);
            if (Double.isNaN(value)) {
                if (!Double.isNaN(lower)) {
                    assert (Double.isNaN(upper)) : upper;
                    if (CoverageStack.contains(this.lowerRange, z)) {
                        value = lower;
                    }
                } else if (!Double.isNaN(upper)) {
                    assert (Double.isNaN(lower)) : lower;
                    if (CoverageStack.contains(this.upperRange, z)) {
                        value = upper;
                    }
                }
            }
            dest[i] = value;
        }
        return dest;
    }

    public synchronized List<Coverage> coveragesAt(double z) {
        if (!this.seek(z)) {
            return Collections.emptyList();
        }
        if (this.lower == this.upper) {
            return Collections.singletonList(this.lower);
        }
        return Arrays.asList(this.lower, this.upper);
    }

    public boolean isInterpolationEnabled() {
        return this.interpolationEnabled;
    }

    public synchronized void setInterpolationEnabled(boolean flag) {
        this.lower = null;
        this.upper = null;
        this.lowerZ = Double.POSITIVE_INFINITY;
        this.upperZ = Double.NEGATIVE_INFINITY;
        this.interpolationEnabled = flag;
    }

    public void addIIOReadWarningListener(IIOReadWarningListener listener) {
        this.listeners.addIIOReadWarningListener(listener);
    }

    public void removeIIOReadWarningListener(IIOReadWarningListener listener) {
        this.listeners.removeIIOReadWarningListener(listener);
    }

    public void addIIOReadProgressListener(IIOReadProgressListener listener) {
        this.listeners.addIIOReadProgressListener(listener);
    }

    public void removeIIOReadProgressListener(IIOReadProgressListener listener) {
        this.listeners.removeIIOReadProgressListener(listener);
    }

    protected void logLoading(LogRecord record) {
        Logger logger = Logging.getLogger(CoverageStack.class);
        record.setLoggerName(logger.getName());
        logger.log(record);
    }

    private void logLoading(int key, Object[] parameters) {
        Locale locale = null;
        LogRecord record = Vocabulary.getResources(locale).getLogRecord(Level.INFO, key);
        record.setSourceClassName(CoverageStack.class.getName());
        record.setSourceMethodName("evaluate");
        record.setParameters(parameters);
        if (this.readListener == null) {
            this.readListener = new Listeners();
            this.addIIOReadProgressListener(this.readListener);
        }
        this.readListener.record = record;
    }

    private final class Listeners
    extends IIOReadProgressAdapter {
        public LogRecord record;

        private Listeners() {
        }

        public void imageStarted(ImageReader source, int imageIndex) {
            if (this.record != null) {
                CoverageStack.this.logLoading(this.record);
                source.removeIIOReadProgressListener(this);
                this.record = null;
            }
        }
    }

    public static class Adapter
    implements Element {
        protected Coverage coverage;
        protected NumberRange range;

        public Adapter(Coverage coverage, NumberRange range) {
            this.coverage = coverage;
            this.range = range;
            if (this.getClass() == Adapter.class && coverage == null) {
                throw new IllegalArgumentException(Errors.format((int)105, (Object)"coverage"));
            }
        }

        public String getName() throws IOException {
            Coverage coverage = this.getCoverage(null);
            if (coverage instanceof AbstractCoverage) {
                coverage = ((AbstractCoverage)coverage).getName();
            }
            return coverage.toString();
        }

        public NumberRange getZRange() throws IOException {
            if (this.range == null) {
                Envelope envelope = this.getEnvelope();
                int zDimension = envelope.getDimension() - 1;
                this.range = new NumberRange(envelope.getMinimum(zDimension), envelope.getMaximum(zDimension));
            }
            return this.range;
        }

        public Envelope getEnvelope() throws IOException {
            return this.getCoverage(null).getEnvelope();
        }

        public GridGeometry getGridGeometry() throws IOException {
            Coverage coverage = this.getCoverage(null);
            return coverage instanceof GridCoverage ? ((GridCoverage)coverage).getGridGeometry() : null;
        }

        public SampleDimension[] getSampleDimensions() throws IOException {
            Coverage coverage = this.getCoverage(null);
            SampleDimension[] sd = new SampleDimension[coverage.getNumSampleDimensions()];
            for (int i = 0; i < sd.length; ++i) {
                sd[i] = coverage.getSampleDimension(i);
            }
            return sd;
        }

        public Coverage getCoverage(IIOListeners listeners) throws IOException {
            return this.coverage;
        }
    }

    public static interface Element {
        public String getName() throws IOException;

        public NumberRange getZRange() throws IOException;

        public Envelope getEnvelope() throws IOException;

        public GridGeometry getGridGeometry() throws IOException;

        public SampleDimension[] getSampleDimensions() throws IOException;

        public Coverage getCoverage(IIOListeners var1) throws IOException;
    }
}

