/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.collections.map.ReferenceMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizationUtil {
    private static final String _AVAILABLE_LOCALES = "available-locales";
    private static final String _DEFAULT_LOCALE = "default-locale";
    private static final String _EMPTY_ROOT_NODE = "<root />";
    private static final String _LANGUAGE_ID = "language-id";
    private static final String _ROOT = "root";
    private static Log _log = LogFactoryUtil.getLog(LocalizationUtil.class);
    private static Map<String, Map<Tuple, String>> _cache = new ReferenceMap(1, 0);

    public static String[] getAvailableLocales(String xml) {
        String attributeValue = LocalizationUtil._getRootAttribute(xml, _AVAILABLE_LOCALES, "");
        return StringUtil.split((String)attributeValue);
    }

    public static String getDefaultLocale(String xml) {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        return LocalizationUtil._getRootAttribute(xml, _DEFAULT_LOCALE, defaultLanguageId);
    }

    public static String getLocalization(String xml, String requestedLanguageId) {
        return LocalizationUtil.getLocalization(xml, requestedLanguageId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLocalization(String xml, String requestedLanguageId, boolean useDefault) {
        String value = LocalizationUtil._getCachedValue(xml, requestedLanguageId, useDefault);
        if (value != null) {
            return value;
        }
        value = "";
        String systemDefaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        String defaultValue = "";
        if (!Validator.isXml((String)xml)) {
            value = requestedLanguageId.equals(systemDefaultLanguageId) ? xml : defaultValue;
            LocalizationUtil._setCachedValue(xml, requestedLanguageId, useDefault, value);
            return value;
        }
        XMLStreamReader reader = null;
        ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != portalClassLoader) {
                currentThread.setContextClassLoader(portalClassLoader);
            }
            XMLInputFactory factory = XMLInputFactory.newInstance();
            reader = factory.createXMLStreamReader((Reader)new UnsyncStringReader(xml));
            String defaultLanguageId = "";
            if (reader.hasNext()) {
                reader.nextTag();
                defaultLanguageId = reader.getAttributeValue(null, _DEFAULT_LOCALE);
                if (Validator.isNull((String)defaultLanguageId)) {
                    defaultLanguageId = systemDefaultLanguageId;
                }
            }
            while (reader.hasNext()) {
                int event = reader.next();
                if (event == 1) {
                    String languageId = reader.getAttributeValue(null, _LANGUAGE_ID);
                    if (Validator.isNull((String)languageId)) {
                        languageId = defaultLanguageId;
                    }
                    if (!languageId.equals(defaultLanguageId) && !languageId.equals(requestedLanguageId)) continue;
                    while (reader.hasNext()) {
                        event = reader.next();
                        if (event == 4 || event == 12) {
                            String text = reader.getText();
                            if (languageId.equals(defaultLanguageId)) {
                                defaultValue = text;
                            }
                            if (!languageId.equals(requestedLanguageId)) break;
                            value = text;
                            break;
                        }
                        if (event != 2) continue;
                    }
                    if (!Validator.isNotNull((String)value)) continue;
                    break;
                }
                if (event != 8) continue;
                break;
            }
            if (useDefault && Validator.isNull((String)value)) {
                value = defaultValue;
            }
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
        }
        finally {
            if (contextClassLoader != portalClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        LocalizationUtil._setCachedValue(xml, requestedLanguageId, useDefault, value);
        return value;
    }

    public static Map<Locale, String> getLocalizationMap(PortletRequest portletRequest, String parameter) {
        Locale[] locales = LanguageUtil.getAvailableLocales();
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        for (Locale locale : locales) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String localeParameter = parameter + "_" + languageId;
            map.put(locale, ParamUtil.getString((PortletRequest)portletRequest, (String)localeParameter));
        }
        return map;
    }

    public static Map<Locale, String> getLocalizationMap(String xml) {
        Locale[] locales = LanguageUtil.getAvailableLocales();
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        for (Locale locale : locales) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            map.put(locale, LocalizationUtil.getLocalization(xml, languageId));
        }
        return map;
    }

    public static Map<Locale, String> getLocalizedParameter(PortletRequest portletRequest, String parameter) {
        return LocalizationUtil.getLocalizationMap(portletRequest, parameter);
    }

    public static String getPreferencesValue(PortletPreferences preferences, String key, String languageId) {
        return LocalizationUtil.getPreferencesValue(preferences, key, languageId, true);
    }

    public static String getPreferencesValue(PortletPreferences preferences, String key, String languageId, boolean useDefault) {
        String localizedKey = LocalizationUtil._getPreferencesKey(key, languageId);
        String value = preferences.getValue(localizedKey, "");
        if (useDefault && Validator.isNull((String)value)) {
            value = preferences.getValue(key, "");
        }
        return value;
    }

    public static String[] getPreferencesValues(PortletPreferences preferences, String key, String languageId) {
        return LocalizationUtil.getPreferencesValues(preferences, key, languageId, true);
    }

    public static String[] getPreferencesValues(PortletPreferences preferences, String key, String languageId, boolean useDefault) {
        String localizedKey = LocalizationUtil._getPreferencesKey(key, languageId);
        Object[] values = preferences.getValues(localizedKey, new String[0]);
        if (useDefault && Validator.isNull((Object[])values)) {
            values = preferences.getValues(key, new String[0]);
        }
        return values;
    }

    public static String removeLocalization(String xml, String key, String requestedLanguageId) {
        return LocalizationUtil.removeLocalization(xml, key, requestedLanguageId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeLocalization(String xml, String key, String requestedLanguageId, boolean cdata) {
        if (Validator.isNull((String)xml)) {
            return "";
        }
        xml = LocalizationUtil._sanitizeXML(xml);
        String systemDefaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        XMLStreamReader reader = null;
        XMLStreamWriter writer = null;
        ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != portalClassLoader) {
                currentThread.setContextClassLoader(portalClassLoader);
            }
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            reader = inputFactory.createXMLStreamReader((Reader)new UnsyncStringReader(xml));
            String availableLocales = "";
            String defaultLanguageId = "";
            if (reader.hasNext()) {
                reader.nextTag();
                availableLocales = reader.getAttributeValue(null, _AVAILABLE_LOCALES);
                defaultLanguageId = reader.getAttributeValue(null, _DEFAULT_LOCALE);
                if (Validator.isNull((String)defaultLanguageId)) {
                    defaultLanguageId = systemDefaultLanguageId;
                }
            }
            if (availableLocales != null && availableLocales.indexOf(requestedLanguageId) != -1) {
                availableLocales = StringUtil.remove((String)availableLocales, (String)requestedLanguageId, (String)",");
                UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter(true);
                XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
                writer = outputFactory.createXMLStreamWriter((Writer)unsyncStringWriter);
                writer.writeStartDocument();
                writer.writeStartElement(_ROOT);
                writer.writeAttribute(_AVAILABLE_LOCALES, availableLocales);
                writer.writeAttribute(_DEFAULT_LOCALE, defaultLanguageId);
                LocalizationUtil._copyNonExempt(reader, writer, requestedLanguageId, defaultLanguageId, cdata);
                writer.writeEndElement();
                writer.writeEndDocument();
                writer.close();
                writer = null;
                xml = unsyncStringWriter.toString();
            }
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
        }
        finally {
            if (contextClassLoader != portalClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {}
            }
        }
        return xml;
    }

    public static void setLocalizedPreferencesValues(ActionRequest actionRequest, PortletPreferences preferences, String parameter) throws Exception {
        Map<Locale, String> map = LocalizationUtil.getLocalizedParameter((PortletRequest)actionRequest, parameter);
        for (Locale locale : map.keySet()) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String key = parameter + "_" + languageId;
            String value = map.get(locale);
            preferences.setValue(key, value);
        }
    }

    public static void setPreferencesValue(PortletPreferences preferences, String key, String languageId, String value) throws Exception {
        preferences.setValue(LocalizationUtil._getPreferencesKey(key, languageId), value);
    }

    public static void setPreferencesValues(PortletPreferences preferences, String key, String languageId, String[] values) throws Exception {
        preferences.setValues(LocalizationUtil._getPreferencesKey(key, languageId), values);
    }

    public static String updateLocalization(String xml, String key, String value) {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        return LocalizationUtil.updateLocalization(xml, key, value, defaultLanguageId, defaultLanguageId);
    }

    public static String updateLocalization(String xml, String key, String value, String requestedLanguageId) {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        return LocalizationUtil.updateLocalization(xml, key, value, requestedLanguageId, defaultLanguageId);
    }

    public static String updateLocalization(String xml, String key, String value, String requestedLanguageId, String defaultLanguageId) {
        return LocalizationUtil.updateLocalization(xml, key, value, requestedLanguageId, defaultLanguageId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String updateLocalization(String xml, String key, String value, String requestedLanguageId, String defaultLanguageId, boolean cdata) {
        xml = LocalizationUtil._sanitizeXML(xml);
        XMLStreamReader reader = null;
        XMLStreamWriter writer = null;
        ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != portalClassLoader) {
                currentThread.setContextClassLoader(portalClassLoader);
            }
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            reader = inputFactory.createXMLStreamReader((Reader)new UnsyncStringReader(xml));
            String availableLocales = "";
            if (reader.hasNext()) {
                reader.nextTag();
                availableLocales = reader.getAttributeValue(null, _AVAILABLE_LOCALES);
                if (Validator.isNull((String)availableLocales)) {
                    availableLocales = defaultLanguageId;
                }
                if (availableLocales.indexOf(requestedLanguageId) == -1) {
                    availableLocales = StringUtil.add((String)availableLocales, (String)requestedLanguageId, (String)",");
                }
            }
            UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter(true);
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            writer = outputFactory.createXMLStreamWriter((Writer)unsyncStringWriter);
            writer.writeStartDocument();
            writer.writeStartElement(_ROOT);
            writer.writeAttribute(_AVAILABLE_LOCALES, availableLocales);
            writer.writeAttribute(_DEFAULT_LOCALE, defaultLanguageId);
            LocalizationUtil._copyNonExempt(reader, writer, requestedLanguageId, defaultLanguageId, cdata);
            if (cdata) {
                writer.writeStartElement(key);
                writer.writeAttribute(_LANGUAGE_ID, requestedLanguageId);
                writer.writeCData(value);
                writer.writeEndElement();
            } else {
                writer.writeStartElement(key);
                writer.writeAttribute(_LANGUAGE_ID, requestedLanguageId);
                writer.writeCharacters(value);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
            writer = null;
            xml = unsyncStringWriter.toString();
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
        }
        finally {
            if (contextClassLoader != portalClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {}
            }
        }
        return xml;
    }

    private static void _copyNonExempt(XMLStreamReader reader, XMLStreamWriter writer, String exemptLanguageId, String defaultLanguageId, boolean cdata) throws XMLStreamException {
        while (reader.hasNext()) {
            int event = reader.next();
            if (event == 1) {
                String languageId = reader.getAttributeValue(null, _LANGUAGE_ID);
                if (Validator.isNull((String)languageId)) {
                    languageId = defaultLanguageId;
                }
                if (languageId.equals(exemptLanguageId)) continue;
                writer.writeStartElement(reader.getLocalName());
                writer.writeAttribute(_LANGUAGE_ID, languageId);
                while (reader.hasNext()) {
                    event = reader.next();
                    if (event == 4 || event == 12) {
                        String text = reader.getText();
                        if (cdata) {
                            writer.writeCData(text);
                            break;
                        }
                        writer.writeCharacters(reader.getText());
                        break;
                    }
                    if (event != 2) continue;
                }
                writer.writeEndElement();
                continue;
            }
            if (event != 8) continue;
            break;
        }
    }

    private static String _getCachedValue(String xml, String requestedLanguageId, boolean useDefault) {
        String value = null;
        Map<Tuple, String> valueMap = _cache.get(xml);
        if (valueMap != null) {
            Tuple subkey = new Tuple((Object)useDefault, (Object)requestedLanguageId);
            value = valueMap.get(subkey);
        }
        return value;
    }

    private static String _getPreferencesKey(String key, String languageId) {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        if (!languageId.equals(defaultLanguageId)) {
            key = key + "_" + languageId;
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _getRootAttribute(String xml, String name, String defaultValue) {
        String value = null;
        XMLStreamReader reader = null;
        ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            XMLInputFactory factory;
            if (contextClassLoader != portalClassLoader) {
                currentThread.setContextClassLoader(portalClassLoader);
            }
            if ((reader = (factory = XMLInputFactory.newInstance()).createXMLStreamReader((Reader)new UnsyncStringReader(xml))).hasNext()) {
                reader.nextTag();
                value = reader.getAttributeValue(null, name);
            }
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
        }
        finally {
            if (contextClassLoader != portalClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        if (Validator.isNull(value)) {
            value = defaultValue;
        }
        return value;
    }

    private static String _sanitizeXML(String xml) {
        if (Validator.isNull((String)xml) || xml.indexOf("<root") == -1) {
            xml = _EMPTY_ROOT_NODE;
        }
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _setCachedValue(String xml, String requestedLanguageId, boolean useDefault, String value) {
        if (Validator.isNotNull((String)xml) && !xml.equals(_EMPTY_ROOT_NODE)) {
            Map<String, Map<Tuple, String>> map = _cache;
            synchronized (map) {
                Map<Tuple, String> map2 = _cache.get(xml);
                if (map2 == null) {
                    map2 = new HashMap<Tuple, String>();
                }
                Tuple subkey = new Tuple((Object)useDefault, (Object)requestedLanguageId);
                map2.put(subkey, value);
                _cache.put(xml, map2);
            }
        }
    }
}

