/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemEnv;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class SystemProperties {
    public static final String SYSTEM_PROPERTIES_LOAD = "system.properties.load";
    public static final String SYSTEM_PROPERTIES_FINAL = "system.properties.final";
    public static final String TMP_DIR = "java.io.tmpdir";
    private static SystemProperties _instance = new SystemProperties();
    private Map<String, String> _props;

    public static String get(String key) {
        String value = SystemProperties._instance._props.get(key);
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    public static void set(String key, String value) {
        System.setProperty(key, value);
        SystemProperties._instance._props.put(key, value);
    }

    public static String[] getArray(String key) {
        String value = SystemProperties.get(key);
        if (value == null) {
            return new String[0];
        }
        return StringUtil.split((String)value);
    }

    public static Properties getProperties() {
        return PropertiesUtil.fromMap(SystemProperties._instance._props);
    }

    private SystemProperties() {
        InputStream is;
        URL url;
        Properties p = new Properties();
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            url = classLoader.getResource("system.properties");
            if (url != null) {
                is = url.openStream();
                p.load(is);
                is.close();
                System.out.println("Loading " + url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            url = classLoader.getResource("system-ext.properties");
            if (url != null) {
                is = url.openStream();
                p.load(is);
                is.close();
                System.out.println("Loading " + url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SystemEnv.setProperties((Properties)p);
        boolean systemPropertiesLoad = GetterUtil.getBoolean((String)System.getProperty(SYSTEM_PROPERTIES_LOAD), (boolean)true);
        boolean systemPropertiesFinal = GetterUtil.getBoolean((String)System.getProperty(SYSTEM_PROPERTIES_FINAL), (boolean)true);
        if (systemPropertiesLoad) {
            Enumeration<?> enu = p.propertyNames();
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                if (!systemPropertiesFinal && !Validator.isNull((String)System.getProperty(key))) continue;
                System.setProperty(key, p.getProperty(key));
            }
        }
        this._props = new ConcurrentHashMap<String, String>();
        PropertiesUtil.fromProperties((Properties)p, this._props);
    }
}

