/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.ldap;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class LDAPUtil {
    public static String getAttributeValue(Attributes attrs, String id) throws NamingException {
        return LDAPUtil.getAttributeValue(attrs, id, "");
    }

    public static String getAttributeValue(Attributes attrs, String id, String defaultValue) throws NamingException {
        try {
            Attribute attr = attrs.get(id);
            Object obj = attr.get();
            return obj.toString();
        }
        catch (NullPointerException npe) {
            return defaultValue;
        }
    }

    public static String getFullProviderURL(String baseURL, String baseDN) {
        return baseURL + "/" + baseDN;
    }

    public static String[] splitFullName(String fullName) {
        String firstName = "";
        String lastName = "";
        String middleName = "";
        if (Validator.isNotNull((String)fullName)) {
            String[] name = StringUtil.split((String)fullName, (String)" ");
            firstName = name[0];
            lastName = name[name.length - 1];
            middleName = "";
            if (name.length > 2) {
                for (int i = 1; i < name.length - 1; ++i) {
                    if (Validator.isNull((String)name[i].trim())) continue;
                    if (i != 1) {
                        middleName = middleName + " ";
                    }
                    middleName = middleName + name[i].trim();
                }
            }
        } else {
            lastName = firstName = GetterUtil.getString((String)firstName, (String)lastName);
        }
        return new String[]{firstName, middleName, lastName};
    }
}

