/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.mail;

import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import javax.mail.Address;
import javax.mail.internet.InternetAddress;
import org.apache.commons.validator.EmailValidator;

public class InternetAddressUtil {
    public static boolean contains(InternetAddress[] internetAddresses, String emailAddress) {
        if (internetAddresses != null && Validator.isNotNull((String)emailAddress)) {
            for (int i = 0; i < internetAddresses.length; ++i) {
                if (!emailAddress.equals(internetAddresses[i].getAddress())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValid(String emailAddress) {
        return EmailValidator.getInstance().isValid(emailAddress);
    }

    public static InternetAddress[] removeEntry(Address[] addresses, String emailAddress) {
        InternetAddress[] internetAddresses = (InternetAddress[])addresses;
        ArrayList<InternetAddress> list = new ArrayList<InternetAddress>();
        if (internetAddresses == null || Validator.isNull((String)emailAddress)) {
            return internetAddresses;
        }
        for (int i = 0; i < internetAddresses.length; ++i) {
            if (emailAddress.equals(internetAddresses[i].getAddress())) continue;
            list.add(internetAddresses[i]);
        }
        return list.toArray(new InternetAddress[list.size()]);
    }

    public static String toString(Address address) {
        InternetAddress internetAddress = (InternetAddress)address;
        if (internetAddress != null) {
            StringBuilder sb = new StringBuilder();
            String personal = internetAddress.getPersonal();
            String emailAddress = internetAddress.getAddress();
            if (Validator.isNotNull((String)personal)) {
                sb.append(personal + " ");
                sb.append("<");
                sb.append(emailAddress);
                sb.append(">");
            } else {
                sb.append(emailAddress);
            }
            return sb.toString();
        }
        return "";
    }

    public static String toString(Address[] addresses) {
        StringBuilder sb = new StringBuilder();
        if (addresses != null) {
            for (int i = 0; i < addresses.length; ++i) {
                sb.append(InternetAddressUtil.toString(addresses[i]));
                if (i >= addresses.length - 1) continue;
                sb.append(",");
                sb.append("&nbsp;");
            }
        }
        return sb.toString();
    }
}

